/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.core.startup.layers.SystemFileSystem;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleLayeredFileSystem
extends MultiFileSystem {
    private static final long serialVersionUID = 782910986724201983L;
    private static final String LAYER_STAMP = "layer-stamp.txt";
    static final Logger err = Logger.getLogger("org.netbeans.core.projects");
    private List<URL> urls;
    private LayerCacheManager manager;
    private final FileSystem writableLayer;
    private FileSystem cacheLayer;
    private final FileSystem[] otherLayers;

    ModuleLayeredFileSystem(FileSystem writableLayer, FileSystem[] otherLayers, File cacheDir) throws IOException {
        this(writableLayer, otherLayers, ModuleLayeredFileSystem.manager(cacheDir));
    }

    private ModuleLayeredFileSystem(FileSystem writableLayer, FileSystem[] otherLayers, LayerCacheManager mgr) throws IOException {
        this(writableLayer, otherLayers, mgr, ModuleLayeredFileSystem.loadCache(mgr));
    }

    private ModuleLayeredFileSystem(FileSystem writableLayer, FileSystem[] otherLayers, LayerCacheManager mgr, FileSystem cacheLayer) throws IOException {
        super(ModuleLayeredFileSystem.appendLayers(writableLayer, otherLayers, cacheLayer));
        this.manager = mgr;
        this.writableLayer = writableLayer;
        this.otherLayers = otherLayers;
        this.cacheLayer = cacheLayer;
        this.setPropagateMasks(true);
        this.urls = null;
    }

    private static LayerCacheManager manager(File cacheDir) throws IOException {
        if (cacheDir != null) {
            if (!cacheDir.isDirectory() && !cacheDir.mkdirs()) {
                throw new IOException("Could not make dir: " + cacheDir);
            }
            String defaultManager = "org.netbeans.core.startup.layers.BinaryCacheManager";
            String managerName = System.getProperty("netbeans.cache.layers", defaultManager);
            if (managerName.equals("-")) {
                err.fine("Cache manager disabled");
                return LayerCacheManager.emptyManager();
            }
            try {
                Class<?> c = Class.forName(managerName);
                Constructor<?> ctor = c.getConstructor(File.class);
                LayerCacheManager mgr = (LayerCacheManager)ctor.newInstance(cacheDir);
                err.fine("Using cache manager of type " + managerName + " in " + cacheDir);
                return mgr;
            }
            catch (Exception e) {
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
        }
        err.fine("No cache manager");
        return LayerCacheManager.emptyManager();
    }

    private static FileSystem loadCache(LayerCacheManager mgr) throws IOException {
        if (mgr.cacheExists()) {
            FileSystem fs;
            ModuleLayeredFileSystem.setStatusText(NbBundle.getMessage(ModuleLayeredFileSystem.class, (String)"MSG_start_load_cache"));
            String msg = "Loading layers from " + mgr.getCacheDirectory();
            StartLog.logStart(msg);
            try {
                fs = mgr.createLoadedFileSystem();
            }
            catch (IOException ioe) {
                err.log(Level.WARNING, null, ioe);
                mgr.cleanupCache();
                ModuleLayeredFileSystem.cleanStamp(mgr.getCacheDirectory());
                fs = mgr.createEmptyFileSystem();
            }
            ModuleLayeredFileSystem.setStatusText(NbBundle.getMessage(ModuleLayeredFileSystem.class, (String)"MSG_end_load_cache"));
            StartLog.logEnd(msg);
            return fs;
        }
        return mgr.createEmptyFileSystem();
    }

    private static FileSystem[] appendLayers(FileSystem fs1, FileSystem[] fs2s, FileSystem fs3) {
        ArrayList<FileSystem> l = new ArrayList<FileSystem>(fs2s.length + 2);
        l.add(fs1);
        l.addAll(Arrays.asList(fs2s));
        l.add(fs3);
        return l.toArray(new FileSystem[l.size()]);
    }

    private static void cleanStamp(File cacheDir) throws IOException {
        File stampFile = new File(cacheDir, LAYER_STAMP);
        if (stampFile.exists() && !stampFile.delete()) {
            throw new IOException("Could not delete: " + stampFile);
        }
    }

    public final FileSystem[] getLayers() {
        return this.getDelegates();
    }

    final FileSystem getWritableLayer() {
        return this.writableLayer;
    }

    public static ModuleLayeredFileSystem getInstallationModuleLayer() {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        SystemFileSystem sfs = (SystemFileSystem)fs;
        ModuleLayeredFileSystem home = sfs.getInstallationLayer();
        if (home != null) {
            return home;
        }
        return sfs.getUserLayer();
    }

    public static ModuleLayeredFileSystem getUserModuleLayer() {
        SystemFileSystem sfs = (SystemFileSystem)Repository.getDefault().getDefaultFileSystem();
        return sfs.getUserLayer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURLs(final List<URL> urls) throws Exception {
        Stamp stamp;
        File stampFile;
        if (urls.contains(null)) {
            throw new NullPointerException("urls=" + urls);
        }
        if (err.isLoggable(Level.FINE)) {
            err.fine("setURLs: " + urls);
        }
        if (this.urls != null && ((Object)urls).equals(this.urls)) {
            err.fine("no-op");
            return;
        }
        StartLog.logStart("setURLs");
        final File cacheDir = this.manager.getCacheDirectory();
        if (cacheDir != null) {
            stampFile = new File(cacheDir, LAYER_STAMP);
            stamp = new Stamp(this.manager.getClass().getName(), urls);
        } else {
            stampFile = null;
            stamp = null;
        }
        if (cacheDir != null && stampFile.isFile()) {
            err.fine("Stamp of new URLs: " + stamp.getHash());
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(stampFile), "UTF-8"));
            try {
                long hash;
                String line = r.readLine();
                try {
                    hash = Long.parseLong(line);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException(nfe.toString());
                }
                err.fine("Stamp in the cache: " + hash);
                if (hash == stamp.getHash()) {
                    err.fine("Cache hit!");
                    this.urls = urls;
                    StartLog.logEnd("setURLs");
                    return;
                }
            }
            finally {
                r.close();
            }
        }
        this.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                ModuleLayeredFileSystem moduleLayeredFileSystem = ModuleLayeredFileSystem.this;
                synchronized (moduleLayeredFileSystem) {
                    if (cacheDir != null) {
                        ModuleLayeredFileSystem.setStatusText(NbBundle.getMessage(ModuleLayeredFileSystem.class, (String)"MSG_start_rewrite_cache"));
                        err.fine("Rewriting cache in " + cacheDir);
                    }
                    try {
                        if (ModuleLayeredFileSystem.this.manager.supportsLoad()) {
                            ModuleLayeredFileSystem.this.manager.store(ModuleLayeredFileSystem.this.cacheLayer, urls);
                        } else {
                            ModuleLayeredFileSystem.this.cacheLayer = ModuleLayeredFileSystem.this.manager.store(urls);
                            ModuleLayeredFileSystem.this.setDelegates(ModuleLayeredFileSystem.appendLayers(ModuleLayeredFileSystem.this.writableLayer, ModuleLayeredFileSystem.this.otherLayers, ModuleLayeredFileSystem.this.cacheLayer));
                        }
                    }
                    catch (IOException ioe) {
                        err.log(Level.WARNING, null, ioe);
                        err.fine("Abandoning cache manager");
                        ModuleLayeredFileSystem.this.manager.cleanupCache();
                        ModuleLayeredFileSystem.cleanStamp(cacheDir);
                        ModuleLayeredFileSystem.this.manager = LayerCacheManager.emptyManager();
                        try {
                            if (ModuleLayeredFileSystem.this.manager.supportsLoad()) {
                                ModuleLayeredFileSystem.this.cacheLayer = ModuleLayeredFileSystem.this.manager.createEmptyFileSystem();
                                ModuleLayeredFileSystem.this.manager.store(ModuleLayeredFileSystem.this.cacheLayer, urls);
                            } else {
                                ModuleLayeredFileSystem.this.cacheLayer = ModuleLayeredFileSystem.this.manager.store(urls);
                            }
                            ModuleLayeredFileSystem.this.setDelegates(ModuleLayeredFileSystem.appendLayers(ModuleLayeredFileSystem.this.writableLayer, ModuleLayeredFileSystem.this.otherLayers, ModuleLayeredFileSystem.this.cacheLayer));
                        }
                        catch (IOException ioe2) {
                            err.log(Level.WARNING, null, ioe2);
                        }
                        return;
                    }
                    if (stampFile != null) {
                        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(stampFile), "UTF-8");
                        try {
                            wr.write(Long.toString(stamp.getHash()));
                            wr.write("\nLine above is identifying hash key, do not edit!\nBelow is metadata about layer cache, for debugging purposes.\n");
                            wr.write(stamp.toString());
                        }
                        finally {
                            ((Writer)wr).close();
                        }
                    }
                    if (cacheDir != null) {
                        ModuleLayeredFileSystem.setStatusText(NbBundle.getMessage(ModuleLayeredFileSystem.class, (String)"MSG_end_rewrite_cache"));
                        err.fine("Finished rewriting cache in " + cacheDir);
                    }
                }
            }
        });
        this.urls = urls;
        this.firePropertyChange("layers", null, null);
        StartLog.logEnd("setURLs");
    }

    public void addURLs(Collection<URL> urls) throws Exception {
        if (urls.contains(null)) {
            throw new NullPointerException("urls=" + urls);
        }
        ArrayList<URL> arr = new ArrayList<URL>(urls);
        if (this.urls != null) {
            arr.addAll(this.urls);
        }
        this.setURLs(arr);
    }

    public void removeURLs(Collection<URL> urls) throws Exception {
        if (urls.contains(null)) {
            throw new NullPointerException("urls=" + urls);
        }
        ArrayList<URL> arr = new ArrayList<URL>();
        if (this.urls != null) {
            arr.addAll(this.urls);
        }
        arr.removeAll(urls);
        this.setURLs(arr);
    }

    private static void setStatusText(String msg) {
        Main.setStatusText(msg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Stamp
    implements Comparator<URL> {
        private final String managerName;
        private final List<URL> urls;
        private final long[] times;
        private final long hash;

        public Stamp(String name, List<URL> urls) throws IOException {
            this.managerName = name;
            this.urls = new ArrayList<URL>(urls);
            Collections.sort(this.urls, this);
            this.times = new long[this.urls.size()];
            long x = 0x11L ^ (long)this.managerName.hashCode();
            Iterator<URL> it = this.urls.iterator();
            int i = 0;
            while (it.hasNext()) {
                URL u2;
                URL u = it.next();
                String s = u.toExternalForm();
                x += 3199876987199633L;
                x ^= (long)s.hashCode();
                if (s.startsWith("jar:")) {
                    int bangSlash = s.lastIndexOf("!/");
                    if (bangSlash != -1) {
                        u2 = new URL(s.substring(4, bangSlash));
                    } else {
                        err.warning("Weird JAR URL: " + u);
                        u2 = u;
                    }
                } else {
                    u2 = u;
                }
                File extracted = new File(URI.create(u2.toExternalForm()));
                if (extracted != null) {
                    int n = i++;
                    long l = extracted.lastModified();
                    this.times[n] = l;
                    x ^= l;
                    continue;
                }
                this.times[i++] = 0L;
            }
            this.hash = x;
        }

        public long getHash() {
            return this.hash;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.managerName);
            buf.append('\n');
            Iterator<URL> it = this.urls.iterator();
            int i = 0;
            while (it.hasNext()) {
                long t;
                if ((t = this.times[i++]) == 0L) {
                    buf.append("<file not found>");
                } else {
                    buf.append(new Date(t));
                }
                buf.append('\t').append(it.next()).append('\n');
            }
            return buf.toString();
        }

        @Override
        public int compare(URL o1, URL o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

