/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.preferences;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.netbeans.core.startup.preferences.NbPreferences;
import org.netbeans.core.startup.preferences.Statistics;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;

class PropertiesStorage
implements NbPreferences.FileStorage {
    private static final String USERROOT_PREFIX = "/Preferences";
    private static final String SYSTEMROOT_PREFIX = "/SystemPreferences";
    private static final FileObject SFS_ROOT = Repository.getDefault().getDefaultFileSystem().getRoot();
    private final String folderPath;
    private String filePath;
    private boolean isModified;

    static NbPreferences.FileStorage instance(String absolutePath) {
        return new PropertiesStorage(absolutePath, true);
    }

    FileObject preferencesRoot() throws IOException {
        return FileUtil.createFolder((FileObject)SFS_ROOT, (String)USERROOT_PREFIX);
    }

    static NbPreferences.FileStorage instanceReadOnly(String absolutePath) {
        return new PropertiesStorage(absolutePath, false){

            public boolean isReadOnly() {
                return true;
            }

            public final String[] childrenNames() {
                return new String[0];
            }

            public final Properties load() throws IOException {
                return new Properties();
            }

            protected FileObject toPropertiesFile(boolean create) throws IOException {
                if (create) {
                    throw new IOException();
                }
                return null;
            }

            protected FileObject toFolder(boolean create) throws IOException {
                if (create) {
                    throw new IOException();
                }
                return null;
            }

            protected FileObject toPropertiesFile() {
                return null;
            }

            protected FileObject toFolder() {
                return null;
            }

            FileObject preferencesRoot() throws IOException {
                return FileUtil.createFolder((FileObject)SFS_ROOT, (String)PropertiesStorage.SYSTEMROOT_PREFIX);
            }
        };
    }

    private PropertiesStorage(String absolutePath, boolean userRoot) {
        StringBuffer sb = new StringBuffer();
        String prefix = userRoot ? USERROOT_PREFIX : SYSTEMROOT_PREFIX;
        sb.append(prefix).append(absolutePath);
        this.folderPath = sb.toString();
    }

    public boolean isReadOnly() {
        return false;
    }

    public void markModified() {
        this.isModified = true;
    }

    public final boolean existsNode() {
        return this.toPropertiesFile() != null || this.toFolder() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] childrenNames() {
        Statistics.StopWatch sw = Statistics.getStopWatch(Statistics.CHILDREN_NAMES, true);
        try {
            FileObject folder = this.toFolder();
            ArrayList<String> folderNames = new ArrayList<String>();
            if (folder != null) {
                for (FileObject fo : Collections.list(folder.getFolders(false))) {
                    folderNames.add(fo.getNameExt());
                }
                for (FileObject fo : Collections.list(folder.getData(false))) {
                    if (!fo.hasExt("properties")) continue;
                    folderNames.add(fo.getName());
                }
            }
            String[] stringArray = folderNames.toArray(new String[folderNames.size()]);
            return stringArray;
        }
        finally {
            sw.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNode() throws IOException {
        Statistics.StopWatch sw = Statistics.getStopWatch(Statistics.REMOVE_NODE, true);
        try {
            FileObject propertiesFile = this.toPropertiesFile();
            if (propertiesFile != null && propertiesFile.isValid()) {
                propertiesFile.delete();
                for (FileObject folder = propertiesFile.getParent(); folder != null && folder != this.preferencesRoot() && folder.getChildren().length == 0; folder = folder.getParent()) {
                    folder.delete();
                }
            }
        }
        finally {
            sw.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties load() throws IOException {
        Statistics.StopWatch sw = Statistics.getStopWatch(Statistics.LOAD, true);
        try {
            Properties retval = new Properties();
            InputStream is = this.inputStream();
            if (is != null) {
                try {
                    retval.load(is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            Properties properties = retval;
            return properties;
        }
        finally {
            sw.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Properties properties) throws IOException {
        block11: {
            if (this.isModified) {
                Statistics.StopWatch sw = Statistics.getStopWatch(Statistics.FLUSH, true);
                try {
                    this.isModified = false;
                    if (!properties.isEmpty()) {
                        OutputStream os = null;
                        try {
                            os = this.outputStream();
                            properties.store(os, null);
                            break block11;
                        }
                        finally {
                            if (os != null) {
                                os.close();
                            }
                        }
                    }
                    FileObject file = this.toPropertiesFile();
                    if (file != null) {
                        file.delete();
                    }
                    for (FileObject folder = this.toFolder(); folder != null && folder != this.preferencesRoot() && folder.getChildren().length == 0; folder = folder.getParent()) {
                        folder.delete();
                    }
                }
                finally {
                    sw.stop();
                }
            }
        }
    }

    private InputStream inputStream() throws IOException {
        FileObject file = this.toPropertiesFile(false);
        return file == null ? null : file.getInputStream();
    }

    private OutputStream outputStream() throws IOException {
        FileObject fo = this.toPropertiesFile(true);
        final FileLock lock = fo.lock();
        OutputStream os = fo.getOutputStream(lock);
        return new FilterOutputStream(os){

            public void close() throws IOException {
                super.close();
                lock.releaseLock();
            }
        };
    }

    private String folderPath() {
        return this.folderPath;
    }

    private String filePath() {
        if (this.filePath == null) {
            String[] all = this.folderPath().split("/");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < all.length - 1; ++i) {
                sb.append(all[i]).append("/");
            }
            if (all.length > 0) {
                sb.append(all[all.length - 1]).append(".properties");
            } else {
                sb.append("root.properties");
            }
            this.filePath = sb.toString();
        }
        return this.filePath;
    }

    protected FileObject toFolder() {
        return SFS_ROOT.getFileObject(this.folderPath());
    }

    protected FileObject toPropertiesFile() {
        return SFS_ROOT.getFileObject(this.filePath());
    }

    protected FileObject toFolder(boolean create) throws IOException {
        FileObject retval = this.toFolder();
        if (retval == null && create) {
            retval = FileUtil.createFolder((FileObject)SFS_ROOT, (String)this.folderPath);
        }
        assert (retval == null && !create || retval != null && retval.isFolder());
        return retval;
    }

    protected FileObject toPropertiesFile(boolean create) throws IOException {
        FileObject retval = this.toPropertiesFile();
        if (retval == null && create) {
            retval = FileUtil.createData((FileObject)SFS_ROOT, (String)this.filePath());
        }
        assert (retval == null && !create || retval != null && retval.isData());
        return retval;
    }
}

