/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.lib2.DocUtils;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;

public abstract class CaretBasedBlockHighlighting
extends AbstractHighlightsContainer
implements ChangeListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(CaretBasedBlockHighlighting.class.getName());
    private final MimePath mimePath;
    private final JTextComponent component;
    private Caret caret;
    private ChangeListener caretListener;
    private final String coloringName;
    private final boolean extendsEOL;
    private final boolean extendsEmptyLine;
    private Position currentLineStart;
    private Position currentLineEnd;

    protected CaretBasedBlockHighlighting(JTextComponent component, String coloringName, boolean extendsEOL, boolean extendsEmptyLine) {
        EditorKit kit = component.getUI().getEditorKit(component);
        String mimeType = kit == null ? null : kit.getContentType();
        this.mimePath = mimeType == null ? MimePath.EMPTY : MimePath.parse((String)mimeType);
        this.coloringName = coloringName;
        this.extendsEOL = extendsEOL;
        this.extendsEmptyLine = extendsEmptyLine;
        this.component = component;
        this.component.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.component));
        this.caret = component.getCaret();
        if (this.caret != null) {
            this.caretListener = WeakListeners.change((ChangeListener)this, (Object)this.caret);
            this.caret.addChangeListener(this.caretListener);
        }
        this.updateLineInfo(false);
    }

    public final HighlightsSequence getHighlights(int startOffset, int endOffset) {
        if (this.currentLineStart != null && this.currentLineEnd != null && endOffset >= this.currentLineStart.getOffset() && startOffset <= this.currentLineEnd.getOffset()) {
            return new SimpleHighlightsSequence(Math.max(this.currentLineStart.getOffset(), startOffset), Math.min(this.currentLineEnd.getOffset(), endOffset), this.getAttribs());
        }
        return HighlightsSequence.EMPTY;
    }

    public final void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null || "caret".equals(evt.getPropertyName())) {
            if (this.caret != null) {
                this.caret.removeChangeListener(this.caretListener);
                this.caretListener = null;
            }
            this.caret = this.component.getCaret();
            if (this.caret != null) {
                this.caretListener = WeakListeners.change((ChangeListener)this, (Object)this.caret);
                this.caret.addChangeListener(this.caretListener);
            }
            this.updateLineInfo(true);
        }
    }

    public final void stateChanged(ChangeEvent e) {
        this.updateLineInfo(true);
    }

    protected abstract Position[] getCurrentBlockPositions(Document var1, Caret var2);

    private final void updateLineInfo(boolean fire) {
        Position[] currentLine = this.getCurrentBlockPositions(this.component.getDocument(), this.caret);
        if (!CaretBasedBlockHighlighting.comparePositions(currentLine[0], this.currentLineStart) || !CaretBasedBlockHighlighting.comparePositions(currentLine[1], this.currentLineEnd)) {
            Position changeStart = CaretBasedBlockHighlighting.getLowerPosition(currentLine[0], this.currentLineStart);
            Position changeEnd = CaretBasedBlockHighlighting.getHigherPosition(currentLine[1], this.currentLineEnd);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Current row changed from [" + CaretBasedBlockHighlighting.positionToString(this.currentLineStart) + ", " + CaretBasedBlockHighlighting.positionToString(this.currentLineEnd) + "] to [" + CaretBasedBlockHighlighting.positionToString(currentLine[0]) + ", " + CaretBasedBlockHighlighting.positionToString(currentLine[1]) + "]");
            }
            this.currentLineStart = currentLine[0];
            this.currentLineEnd = currentLine[1];
            if (fire) {
                this.fireHighlightsChange(changeStart == null ? 0 : changeStart.getOffset(), changeEnd == null ? Integer.MAX_VALUE : changeEnd.getOffset());
            }
        }
    }

    private AttributeSet getAttribs() {
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)this.mimePath).lookup(FontColorSettings.class);
        AttributeSet attribs = fcs.getFontColors(this.coloringName);
        if (attribs == null) {
            attribs = SimpleAttributeSet.EMPTY;
        } else if (this.extendsEOL || this.extendsEmptyLine) {
            attribs = AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{attribs, AttributesUtilities.createImmutable((Object[])new Object[]{ATTR_EXTENDS_EOL, this.extendsEOL, ATTR_EXTENDS_EMPTY_LINE, this.extendsEmptyLine})});
        }
        return attribs;
    }

    private static boolean comparePositions(Position p1, Position p2) {
        return p1 == null && p2 == null || p1 != null && p2 != null && p1.getOffset() == p2.getOffset();
    }

    private static Position getLowerPosition(Position p1, Position p2) {
        if (p1 != null && p2 != null) {
            return p1.getOffset() < p2.getOffset() ? p1 : p2;
        }
        if (p1 != null) {
            return p1;
        }
        if (p2 != null) {
            return p2;
        }
        return null;
    }

    private static Position getHigherPosition(Position p1, Position p2) {
        if (p1 != null && p2 != null) {
            return p1.getOffset() > p2.getOffset() ? p1 : p2;
        }
        if (p1 != null) {
            return p1;
        }
        if (p2 != null) {
            return p2;
        }
        return null;
    }

    private static String positionToString(Position p) {
        return p == null ? "null" : Integer.toString(p.getOffset());
    }

    public static final class CaretRowHighlighting
    extends CaretBasedBlockHighlighting {
        public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.CaretRowHighlighting";

        public CaretRowHighlighting(JTextComponent component) {
            super(component, "highlight-caret-row", true, false);
        }

        protected Position[] getCurrentBlockPositions(Document document, Caret caret) {
            if (document != null && caret != null) {
                int caretOffset = caret.getDot();
                try {
                    int startOffset = DocUtils.getRowStart(document, caretOffset, 0);
                    int endOffset = DocUtils.getRowEnd(document, caretOffset);
                    if (endOffset < document.getLength()) {
                        ++endOffset;
                    }
                    return new Position[]{document.createPosition(startOffset), document.createPosition(endOffset)};
                }
                catch (BadLocationException e) {
                    LOG.log(Level.WARNING, e.getMessage(), e);
                }
            }
            return new Position[]{null, null};
        }
    }

    private static final class SimpleHighlightsSequence
    implements HighlightsSequence {
        private int startOffset;
        private int endOffset;
        private AttributeSet attribs;
        private boolean end = false;

        public SimpleHighlightsSequence(int startOffset, int endOffset, AttributeSet attribs) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.attribs = attribs;
        }

        public boolean moveNext() {
            if (!this.end) {
                this.end = true;
                return true;
            }
            return false;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public AttributeSet getAttributes() {
            return this.attribs;
        }
    }

    public static final class TextSelectionHighlighting
    extends CaretBasedBlockHighlighting {
        public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.TextSelectionHighlighting";

        public TextSelectionHighlighting(JTextComponent component) {
            super(component, "selection", false, true);
        }

        protected Position[] getCurrentBlockPositions(Document document, Caret caret) {
            int markOffset;
            int caretOffset;
            if (document != null && caret != null && (caretOffset = caret.getDot()) != (markOffset = caret.getMark())) {
                try {
                    return new Position[]{document.createPosition(Math.min(caretOffset, markOffset)), document.createPosition(Math.max(caretOffset, markOffset))};
                }
                catch (BadLocationException e) {
                    LOG.log(Level.WARNING, e.getMessage(), e);
                }
            }
            return new Position[]{null, null};
        }
    }
}

