/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.lang.ref.WeakReference;
import java.util.ConcurrentModificationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;

public final class CompoundHighlightsContainer
extends AbstractHighlightsContainer {
    private static final Logger LOG = Logger.getLogger(CompoundHighlightsContainer.class.getName());
    private static final Position MAX_POSITION = new Position(){

        public int getOffset() {
            return Integer.MAX_VALUE;
        }
    };
    private static final int MIN_CACHE_SIZE = 128;
    private Document doc;
    private HighlightsContainer[] layers;
    private long version = 0L;
    private Throwable lastUpdater = null;
    private final String LOCK = new String("CompoundHighlightsContainer.LOCK");
    private final LayerListener listener = new LayerListener(this);
    private OffsetsBag cache;
    private Position cacheLowestPos;
    private Position cacheHighestPos;

    public CompoundHighlightsContainer() {
        this(null, null);
    }

    public CompoundHighlightsContainer(Document doc, HighlightsContainer[] layers) {
        this.setLayers(doc, layers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        assert (0 <= startOffset) : "offsets must be greater than or equal to zero";
        assert (startOffset <= endOffset) : "startOffset must be less than or equal to endOffset; startOffset = " + startOffset + " endOffset = " + endOffset;
        String string = this.LOCK;
        synchronized (string) {
            int highest;
            if (this.doc == null || this.layers == null || this.layers.length == 0 || startOffset == endOffset) {
                return HighlightsSequence.EMPTY;
            }
            int[] update = null;
            int lowest = this.cacheLowestPos == null ? -1 : this.cacheLowestPos.getOffset();
            int n = highest = this.cacheHighestPos == null ? -1 : this.cacheHighestPos.getOffset();
            if (lowest == -1 || highest == -1) {
                this.cache = null;
            } else {
                int maxDistance = Math.max(128, highest - lowest);
                if (endOffset > lowest - maxDistance && endOffset <= highest && startOffset < lowest) {
                    update = new int[]{startOffset, lowest};
                } else if (startOffset < highest + maxDistance && startOffset >= lowest && endOffset > highest) {
                    update = new int[]{highest, endOffset};
                } else if (startOffset < lowest && endOffset > highest) {
                    update = new int[]{startOffset, lowest, highest, endOffset};
                } else if (startOffset < lowest || endOffset > highest) {
                    this.cache = null;
                }
            }
            if (this.cache == null) {
                this.cache = new OffsetsBag(this.doc, true);
                highest = -1;
                lowest = -1;
                update = new int[]{startOffset, endOffset};
            }
            if (update != null) {
                for (int i = 0; i < update.length / 2; ++i) {
                    if (update[2 * i + 1] - update[2 * i] < 128) {
                        update[2 * i + 1] = update[2 * i] + 128;
                        if (update[2 * i + 1] >= this.doc.getLength()) {
                            update[2 * i + 1] = Integer.MAX_VALUE;
                        }
                    }
                    this.updateCache(update[2 * i], update[2 * i + 1]);
                    if (update[2 * i + 1] == Integer.MAX_VALUE) break;
                }
                if (lowest == -1 || highest == -1) {
                    this.cacheLowestPos = this.createPosition((int)update[0]);
                    this.cacheHighestPos = this.createPosition(update[update.length - 1]);
                } else {
                    this.cacheLowestPos = this.createPosition(Math.min(lowest, (int)update[0]));
                    this.cacheHighestPos = this.createPosition(Math.max(highest, update[update.length - 1]));
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Cache boundaries: <" + (this.cacheLowestPos == null ? "-" : Integer.valueOf(this.cacheLowestPos.getOffset())) + ", " + (this.cacheHighestPos == null ? "-" : Integer.valueOf(this.cacheHighestPos.getOffset())) + "> " + "when asked for <" + startOffset + ", " + endOffset + ">");
                }
            }
            return new Seq(this.version, this.cache.getHighlights(startOffset, endOffset));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsContainer[] getLayers() {
        String string = this.LOCK;
        synchronized (string) {
            return this.layers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayers(Document doc, HighlightsContainer[] layers) {
        Document docForEvents = null;
        String string = this.LOCK;
        synchronized (string) {
            int i;
            if (doc == null) assert (layers == null) : "If doc is null the layers must be null too.";
            Document document = docForEvents = doc != null ? doc : this.doc;
            if (this.layers != null) {
                for (i = 0; i < this.layers.length; ++i) {
                    this.layers[i].removeHighlightsChangeListener(this.listener);
                }
            }
            this.doc = doc;
            this.layers = layers;
            this.cache = null;
            this.increaseVersion();
            if (this.layers != null) {
                for (i = 0; i < this.layers.length; ++i) {
                    this.layers[i].addHighlightsChangeListener(this.listener);
                }
            }
        }
        if (docForEvents != null) {
            docForEvents.render(new Runnable(){

                public void run() {
                    CompoundHighlightsContainer.this.fireHighlightsChange(0, Integer.MAX_VALUE);
                }
            });
        }
    }

    public void resetCache() {
        this.layerChanged(null, 0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layerChanged(HighlightsContainer layer, final int changeStartOffset, final int changeEndOffset) {
        Document docForEvents = null;
        String string = this.LOCK;
        synchronized (string) {
            this.cache = null;
            this.increaseVersion();
            docForEvents = this.doc;
        }
        if (docForEvents != null) {
            docForEvents.render(new Runnable(){

                public void run() {
                    CompoundHighlightsContainer.this.fireHighlightsChange(changeStartOffset, changeEndOffset);
                }
            });
        }
    }

    private void updateCache(int startOffset, int endOffset) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Updating cache: <" + startOffset + ", " + endOffset + ">");
        }
        for (HighlightsContainer layer : this.layers) {
            HighlightsSequence seq = layer.getHighlights(startOffset, endOffset);
            this.cache.addAllHighlights(seq);
        }
    }

    private Position createPosition(int offset) {
        try {
            if (offset == Integer.MAX_VALUE) {
                return MAX_POSITION;
            }
            return this.doc.createPosition(offset);
        }
        catch (BadLocationException e) {
            LOG.log(Level.WARNING, "Can't create document position: offset = " + offset + ", document.lenght = " + this.doc.getLength(), e);
            return null;
        }
    }

    private void increaseVersion() {
        ++this.version;
        if (LOG.isLoggable(Level.FINE)) {
            this.lastUpdater = new Throwable("This stacktrace shows, who created version " + this.version + " of this highlighting container");
        }
    }

    private static final class LayerListener
    implements HighlightsChangeListener {
        private WeakReference<CompoundHighlightsContainer> ref;

        public LayerListener(CompoundHighlightsContainer container) {
            this.ref = new WeakReference<CompoundHighlightsContainer>(container);
        }

        public void highlightChanged(HighlightsChangeEvent event) {
            CompoundHighlightsContainer container = (CompoundHighlightsContainer)this.ref.get();
            if (container != null) {
                container.layerChanged((HighlightsContainer)event.getSource(), event.getStartOffset(), event.getEndOffset());
            }
        }
    }

    private final class Seq
    implements HighlightsSequence {
        private HighlightsSequence seq;
        private long version;

        public Seq(long version, HighlightsSequence seq) {
            this.version = version;
            this.seq = seq;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            String string = CompoundHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                return this.seq.moveNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStartOffset() {
            String string = CompoundHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                return this.seq.getStartOffset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEndOffset() {
            String string = CompoundHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                return this.seq.getEndOffset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getAttributes() {
            String string = CompoundHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                return this.seq.getAttributes();
            }
        }

        private void checkVersion() {
            if (this.version != CompoundHighlightsContainer.this.version) {
                ConcurrentModificationException cme = new ConcurrentModificationException("The HighlighsSequence version (" + this.version + ") does not match the current version (" + CompoundHighlightsContainer.this.version + ") of its highlights container.");
                if (CompoundHighlightsContainer.this.lastUpdater != null) {
                    cme.initCause(CompoundHighlightsContainer.this.lastUpdater);
                }
                throw cme;
            }
        }
    }
}

