/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SyntaxHighlighting
extends AbstractHighlightsContainer
implements TokenHierarchyListener {
    private static final Logger LOG = Logger.getLogger(SyntaxHighlighting.class.getName());
    public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.SyntaxHighlighting";
    private final HashMap<String, WeakHashMap<TokenId, AttributeSet>> attribsCache = new HashMap();
    private final HashMap<String, FontColorSettings> fcsCache = new HashMap();
    private final Document document;
    private final String mimeTypeForHack;
    private TokenHierarchy<? extends Document> hierarchy = null;
    private long version = 0L;

    public SyntaxHighlighting(Document document) {
        this.document = document;
        String mimeType = (String)document.getProperty("mimeType");
        this.mimeTypeForHack = mimeType != null && mimeType.startsWith("test") ? mimeType : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        SyntaxHighlighting syntaxHighlighting = this;
        synchronized (syntaxHighlighting) {
            if (this.hierarchy == null) {
                this.hierarchy = TokenHierarchy.get((Document)this.document);
                if (this.hierarchy != null) {
                    this.hierarchy.addTokenHierarchyListener((TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)((Object)this), this.hierarchy));
                }
            }
            if (this.hierarchy != null) {
                return new HSImpl(this.version, this.hierarchy, startOffset, endOffset);
            }
            return HighlightsSequence.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenHierarchyChanged(TokenHierarchyEvent evt) {
        SyntaxHighlighting syntaxHighlighting = this;
        synchronized (syntaxHighlighting) {
            ++this.version;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            StringBuilder sb = new StringBuilder();
            TokenSequence ts = this.hierarchy.tokenSequence();
            sb.append("\n");
            sb.append("Tokens after change: <" + evt.affectedStartOffset() + ", " + evt.affectedEndOffset() + ">\n");
            this.dumpSequence((TokenSequence<? extends TokenId>)ts, sb);
            sb.append("--------------------------------------------\n\n");
            LOG.finest(sb.toString());
        }
        this.fireHighlightsChange(evt.affectedStartOffset(), evt.affectedEndOffset());
    }

    private void dumpSequence(TokenSequence<? extends TokenId> seq, StringBuilder sb) {
        seq.moveStart();
        while (seq.moveNext()) {
            TokenSequence emSeq = seq.embedded();
            if (emSeq != null) {
                this.dumpSequence((TokenSequence<? extends TokenId>)emSeq, sb);
                continue;
            }
            Token token = seq.token();
            sb.append("<");
            sb.append(String.format("%3s", seq.offset())).append(", ");
            sb.append(String.format("%3s", seq.offset() + token.length())).append(", ");
            sb.append(String.format("%+3d", token.length())).append("> : ");
            sb.append(this.tokenId((Token<? extends TokenId>)token)).append(" : '");
            sb.append(this.tokenText((Token<? extends TokenId>)token));
            sb.append("'\n");
        }
    }

    private String tokenId(Token<? extends TokenId> token) {
        TokenId tokenId = token.id();
        return String.format("%20s.%-15s", tokenId.getClass().getSimpleName(), tokenId.name());
    }

    private String tokenText(Token<? extends TokenId> token) {
        CharSequence text = token.text();
        StringBuilder sb = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.isISOControl(ch)) {
                switch (ch) {
                    case '\n': {
                        sb.append("\\n");
                    }
                    case '\t': {
                        sb.append("\\t");
                    }
                    case '\r': {
                        sb.append("\\r");
                    }
                }
                sb.append("\\").append(Integer.toOctalString(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HSImpl
    implements HighlightsSequence {
        private static final int S_NORMAL = 1;
        private static final int S_EMBEDDED_HEAD = 2;
        private static final int S_EMBEDDED_TAIL = 3;
        private static final int S_DONE = 4;
        private long version;
        private TokenHierarchy<? extends Document> scanner;
        private List<TokenSequence<? extends TokenId>> sequences;
        private int startOffset;
        private int endOffset;
        private int state;

        public HSImpl(long version, TokenHierarchy<? extends Document> scanner, int startOffset, int endOffset) {
            this.version = version;
            this.scanner = scanner;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.sequences = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean moveNext() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                TokenSequence seq;
                this.checkVersion();
                if (this.sequences == null) {
                    seq = this.scanner.tokenSequence();
                    seq.move(this.startOffset);
                    this.sequences = new ArrayList<TokenSequence<? extends TokenId>>();
                    this.sequences.add(seq);
                    this.state = 1;
                }
                switch (this.state) {
                    case 1: {
                        this.state = this.moveTheSequence();
                        break;
                    }
                    case 2: {
                        seq = this.sequences.get(this.sequences.size() - 1);
                        seq.moveStart();
                        if (seq.moveNext()) {
                            this.state = 1;
                            break;
                        }
                        throw new IllegalStateException("Invalid state");
                    }
                    case 3: {
                        this.sequences.remove(this.sequences.size() - 1);
                        this.state = this.moveTheSequence();
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid state: " + this.state);
                    }
                }
                if (this.state == 1) {
                    seq = this.sequences.get(this.sequences.size() - 1);
                    TokenSequence embeddedSeq = seq.embedded();
                    while (embeddedSeq != null && embeddedSeq.moveNext()) {
                        this.sequences.add(this.sequences.size(), (TokenSequence<? extends TokenId>)embeddedSeq);
                        if (embeddedSeq.offset() > seq.offset()) {
                            this.state = 2;
                            break;
                        }
                        seq = embeddedSeq;
                        embeddedSeq = seq.embedded();
                    }
                } else if (this.state == 4) {
                    SyntaxHighlighting.this.attribsCache.clear();
                }
                return this.state != 4;
            }
        }

        @Override
        public int getStartOffset() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                this.checkVersion();
                if (this.sequences == null) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                switch (this.state) {
                    case 1: {
                        TokenSequence<? extends TokenId> seq = this.sequences.get(this.sequences.size() - 1);
                        return seq.offset();
                    }
                    case 2: {
                        TokenSequence<? extends TokenId> embeddingSeq = this.sequences.get(this.sequences.size() - 2);
                        return embeddingSeq.offset();
                    }
                    case 3: {
                        TokenSequence<? extends TokenId> seq = this.sequences.get(this.sequences.size() - 1);
                        seq.moveEnd();
                        if (seq.movePrevious()) {
                            return seq.offset() + seq.token().length();
                        }
                        throw new IllegalStateException("Invalid state");
                    }
                    case 4: {
                        throw new NoSuchElementException();
                    }
                }
                throw new IllegalStateException("Invalid state: " + this.state);
            }
        }

        @Override
        public int getEndOffset() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                this.checkVersion();
                if (this.sequences == null) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                switch (this.state) {
                    case 1: {
                        TokenSequence<? extends TokenId> seq = this.sequences.get(this.sequences.size() - 1);
                        return seq.offset() + seq.token().length();
                    }
                    case 2: {
                        TokenSequence<? extends TokenId> seq = this.sequences.get(this.sequences.size() - 1);
                        seq.moveStart();
                        if (seq.moveNext()) {
                            return seq.offset();
                        }
                        TokenSequence<? extends TokenId> embeddingSeq = this.sequences.get(this.sequences.size() - 2);
                        return embeddingSeq.offset() + embeddingSeq.token().length();
                    }
                    case 3: {
                        TokenSequence<? extends TokenId> embeddingSeq = this.sequences.get(this.sequences.size() - 2);
                        return embeddingSeq.offset() + embeddingSeq.token().length();
                    }
                    case 4: {
                        throw new NoSuchElementException();
                    }
                }
                throw new IllegalStateException("Invalid state: " + this.state);
            }
        }

        @Override
        public AttributeSet getAttributes() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                this.checkVersion();
                if (this.sequences == null) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                switch (this.state) {
                    case 1: {
                        return this.findAttribs(this.sequences.size() - 1);
                    }
                    case 2: 
                    case 3: {
                        return this.findAttribs(this.sequences.size() - 2);
                    }
                    case 4: {
                        throw new NoSuchElementException();
                    }
                }
                throw new IllegalStateException("Invalid state: " + this.state);
            }
        }

        private AttributeSet findAttribs(int seqIdx) {
            AttributeSet tokenAttribs;
            TokenSequence<? extends TokenId> seq = this.sequences.get(seqIdx);
            TokenId tokenId = seq.token().id();
            String mimePath = SyntaxHighlighting.this.mimeTypeForHack != null ? this.languagePathToMimePathHack(seq.languagePath()) : seq.languagePath().mimePath();
            WeakHashMap<TokenId, AttributeSet> token2attribs = (WeakHashMap<TokenId, AttributeSet>)SyntaxHighlighting.this.attribsCache.get(mimePath);
            if (token2attribs == null) {
                token2attribs = new WeakHashMap<TokenId, AttributeSet>();
                SyntaxHighlighting.this.attribsCache.put(mimePath, token2attribs);
            }
            if ((tokenAttribs = (AttributeSet)token2attribs.get(tokenId)) == null) {
                tokenAttribs = this.findTokenAttribs(tokenId, mimePath, (Language<? extends TokenId>)seq.languagePath().innerLanguage());
                if (seqIdx > 0) {
                    AttributeSet embeddingTokenAttribs = this.findAttribs(seqIdx - 1);
                    tokenAttribs = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{tokenAttribs, embeddingTokenAttribs});
                }
                token2attribs.put(tokenId, tokenAttribs);
            }
            return tokenAttribs;
        }

        private AttributeSet findTokenAttribs(TokenId tokenId, String mimePath, Language<? extends TokenId> innerLanguage) {
            FontColorSettings fcs = (FontColorSettings)SyntaxHighlighting.this.fcsCache.get(mimePath);
            if (fcs == null) {
                Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)mimePath));
                fcs = (FontColorSettings)lookup.lookup(FontColorSettings.class);
                SyntaxHighlighting.this.fcsCache.put(mimePath, fcs);
            }
            AttributeSet attribs = this.findFontAndColors(fcs, tokenId, innerLanguage);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(mimePath + ":" + tokenId.name() + " -> " + attribs);
            }
            return attribs != null ? attribs : SimpleAttributeSet.EMPTY;
        }

        private String languagePathToMimePathHack(LanguagePath languagePath) {
            if (languagePath.size() == 1) {
                return SyntaxHighlighting.this.mimeTypeForHack;
            }
            if (languagePath.size() > 1) {
                return SyntaxHighlighting.this.mimeTypeForHack + "/" + languagePath.subPath(1).mimePath();
            }
            throw new IllegalStateException("LanguagePath should not be empty.");
        }

        private AttributeSet findFontAndColors(FontColorSettings fcs, TokenId tokenId, Language lang) {
            AttributeSet attribs;
            block2: {
                String c;
                String primary;
                String name = tokenId.name();
                attribs = fcs.getTokenFontColors(name);
                if (attribs == null && (primary = tokenId.primaryCategory()) != null) {
                    attribs = fcs.getTokenFontColors(primary);
                }
                if (attribs != null) break block2;
                List categories = lang.nonPrimaryTokenCategories(tokenId);
                Iterator i$ = categories.iterator();
                while (i$.hasNext() && (attribs = fcs.getTokenFontColors(c = (String)i$.next())) == null) {
                }
            }
            return attribs;
        }

        private int moveTheSequence() {
            TokenSequence<? extends TokenId> seq = this.sequences.get(this.sequences.size() - 1);
            if (seq.moveNext() && seq.offset() < this.endOffset) {
                return 1;
            }
            if (this.sequences.size() > 1) {
                TokenSequence<? extends TokenId> embeddingSeq = this.sequences.get(this.sequences.size() - 2);
                seq.moveEnd();
                if (seq.movePrevious()) {
                    if (seq.offset() + seq.token().length() < embeddingSeq.offset() + embeddingSeq.token().length()) {
                        return 3;
                    }
                    this.sequences.remove(this.sequences.size() - 1);
                    return this.moveTheSequence();
                }
                throw new IllegalStateException("Invalid state");
            }
            this.sequences.clear();
            return 4;
        }

        private void checkVersion() {
            if (this.version != SyntaxHighlighting.this.version) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

