/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.search;

import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.modules.editor.lib2.ComponentUtils;
import org.netbeans.modules.editor.lib2.DocUtils;
import org.netbeans.modules.editor.lib2.DocumentsRegistry;
import org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting;
import org.netbeans.modules.editor.lib2.search.DocumentFinder;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorFindSupport {
    private static final Logger LOG = Logger.getLogger(EditorFindSupport.class.getName());
    public static final String FIND_WHAT = "find-what";
    public static final String FIND_REPLACE_WITH = "find-replace-with";
    public static final String FIND_HIGHLIGHT_SEARCH = "find-highlight-search";
    public static final String FIND_INC_SEARCH = "find-inc-search";
    public static final String FIND_INC_SEARCH_DELAY = "find-inc-search-delay";
    public static final String FIND_BACKWARD_SEARCH = "find-backward-search";
    public static final String FIND_WRAP_SEARCH = "find-wrap-search";
    public static final String FIND_MATCH_CASE = "find-match-case";
    public static final String FIND_SMART_CASE = "find-smart-case";
    public static final String FIND_WHOLE_WORDS = "find-whole-words";
    public static final String FIND_REG_EXP = "find-reg-exp";
    public static final String FIND_HISTORY = "find-history";
    public static final String FIND_HISTORY_SIZE = "find-history-size";
    public static final String FIND_BLOCK_SEARCH = "find-block-search";
    public static final String FIND_BLOCK_SEARCH_START = "find-block-search-start";
    public static final String FIND_BLOCK_SEARCH_END = "find-block-search-end";
    private static final String FOUND_LOCALE = "find-found";
    private static final String NOT_FOUND_LOCALE = "find-not-found";
    private static final String WRAP_START_LOCALE = "find-wrap-start";
    private static final String WRAP_END_LOCALE = "find-wrap-end";
    private static final String WRAP_BLOCK_START_LOCALE = "find-block-wrap-start";
    private static final String WRAP_BLOCK_END_LOCALE = "find-block-wrap-end";
    private static final String ITEMS_REPLACED_LOCALE = "find-items-replaced";
    public static final String REVERT_MAP = "revert-map";
    private static final String SEARCH_BLOCK_START = "search-block-start";
    private static final String SEARCH_BLOCK_END = "search-block-end";
    public static final String FIND_HISTORY_PROP = "find-history-prop";
    public static final String FIND_HISTORY_CHANGED_PROP = "find-history-changed-prop";
    private static EditorFindSupport findSupport;
    private Map<String, Object> findProps;
    private WeakHashMap<JTextComponent, Map<String, WeakReference<BlockHighlighting>>> comp2layer = new WeakHashMap();
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private SPW lastSelected;
    private List<SPW> historyList;

    private EditorFindSupport() {
    }

    public static EditorFindSupport getInstance() {
        if (findSupport == null) {
            findSupport = new EditorFindSupport();
        }
        return findSupport;
    }

    public Map<String, Object> getDefaultFindProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(FIND_WHAT, null);
        props.put(FIND_REPLACE_WITH, null);
        props.put(FIND_HIGHLIGHT_SEARCH, Boolean.TRUE);
        props.put(FIND_INC_SEARCH, Boolean.TRUE);
        props.put(FIND_BACKWARD_SEARCH, Boolean.FALSE);
        props.put(FIND_WRAP_SEARCH, Boolean.TRUE);
        props.put(FIND_MATCH_CASE, Boolean.FALSE);
        props.put(FIND_SMART_CASE, Boolean.FALSE);
        props.put(FIND_WHOLE_WORDS, Boolean.FALSE);
        props.put(FIND_REG_EXP, Boolean.FALSE);
        props.put(FIND_HISTORY, new Integer(30));
        return props;
    }

    private int getBlockEndOffset() {
        Position pos = (Position)this.getFindProperties().get(FIND_BLOCK_SEARCH_END);
        return pos != null ? pos.getOffset() : -1;
    }

    public Map<String, Object> getFindProperties() {
        if (this.findProps == null) {
            this.findProps = this.getDefaultFindProperties();
        }
        return this.findProps;
    }

    public Object getFindProperty(String name) {
        return this.getFindProperties().get(name);
    }

    private Map<String, Object> getValidFindProperties(Map<String, Object> props) {
        return props != null ? props : this.getFindProperties();
    }

    public int[] getBlocks(int[] blocks, Document doc, int startPos, int endPos) throws BadLocationException {
        Map<String, Object> props = this.getValidFindProperties(null);
        Boolean b = (Boolean)props.get(FIND_BLOCK_SEARCH);
        boolean blockSearch = b != null && b != false;
        Integer i = (Integer)props.get(FIND_BLOCK_SEARCH_START);
        int blockSearchStart = i != null ? i : -1;
        int blockSearchEnd = this.getBlockEndOffset();
        if (blockSearch && blockSearchStart > -1 && blockSearchEnd > 0) {
            if (endPos >= blockSearchStart && startPos <= blockSearchEnd) {
                startPos = Math.max(blockSearchStart, startPos);
                endPos = Math.min(blockSearchEnd, endPos);
            } else {
                return blocks;
            }
        }
        return DocumentFinder.findBlocks(doc, startPos, endPos, props, blocks);
    }

    public Object getPropertyNoInit(String name) {
        if (this.findProps == null) {
            return null;
        }
        return this.getFindProperty(name);
    }

    public void putFindProperty(String name, Object newValue) {
        Object oldValue = this.getFindProperty(name);
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        if (newValue != null) {
            this.getFindProperties().put(name, newValue);
        } else {
            this.getFindProperties().remove(name);
        }
        this.firePropertyChange(name, oldValue, newValue);
    }

    public void putFindProperties(Map<String, Object> propsToAdd) {
        if (!((Object)this.getFindProperties()).equals(propsToAdd)) {
            this.getFindProperties().putAll(propsToAdd);
            this.firePropertyChange(null, null, null);
        }
    }

    public void setBlockSearchHighlight(int startSelection, int endSelection) {
        BlockHighlighting layer;
        JTextComponent comp = DocumentsRegistry.getMostActiveComponent();
        BlockHighlighting blockHighlighting = layer = comp == null ? null : this.findLayer(comp, "org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting/BLOCK_SEARCH");
        if (layer != null) {
            if (startSelection >= 0 && endSelection >= 0 && startSelection < endSelection) {
                layer.highlightBlock(startSelection, endSelection, "block-search");
            } else {
                layer.highlightBlock(-1, -1, "block-search");
            }
        }
    }

    public boolean incSearch(Map<String, Object> props, int caretPos) {
        Boolean b = (Boolean)(props = this.getValidFindProperties(props)).get(FIND_REG_EXP);
        if (b != null && b.booleanValue()) {
            return false;
        }
        b = (Boolean)props.get(FIND_INC_SEARCH);
        if (b != null && b.booleanValue()) {
            JTextComponent comp = DocumentsRegistry.getMostActiveComponent();
            if (comp != null) {
                int pos;
                b = (Boolean)props.get(FIND_BACKWARD_SEARCH);
                boolean back = b != null && b != false;
                b = (Boolean)props.get(FIND_BLOCK_SEARCH);
                boolean blockSearch = b != null && b != false;
                Integer i = (Integer)props.get(FIND_BLOCK_SEARCH_START);
                int blockSearchStart = i != null ? i : -1;
                Position endPos = (Position)props.get(FIND_BLOCK_SEARCH_END);
                int blockSearchEnd = endPos != null ? endPos.getOffset() : -1;
                int endOffset = back ? 0 : -1;
                try {
                    int end;
                    int start = blockSearch && blockSearchStart > -1 ? blockSearchStart : 0;
                    int n = end = blockSearch && blockSearchEnd > 0 ? blockSearchEnd : -1;
                    if (start > 0 && end == -1) {
                        return false;
                    }
                    int[] findRet = this.findInBlock(comp, caretPos, start, end, props, false);
                    if (findRet == null) {
                        this.incSearchReset();
                        return false;
                    }
                    pos = findRet[0];
                }
                catch (BadLocationException e) {
                    LOG.log(Level.WARNING, e.getMessage(), e);
                    return false;
                }
                BlockHighlighting layer = this.findLayer(comp, "org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting/INC_SEARCH");
                if (pos >= 0) {
                    int len;
                    String s = (String)props.get(FIND_WHAT);
                    int n = len = s != null ? s.length() : 0;
                    if (len > 0) {
                        Map<String, Object> defaultProps;
                        String findWhatDef;
                        if (comp.getSelectionEnd() > comp.getSelectionStart()) {
                            comp.select(caretPos, caretPos);
                        }
                        if (layer != null) {
                            layer.highlightBlock(pos, pos + len, blockSearch ? "inc-search" : "selection");
                        }
                        if ((findWhatDef = (String)(defaultProps = this.getValidFindProperties(null)).get(FIND_WHAT)) != null && findWhatDef.length() > 0) {
                            defaultProps.put(FIND_WHAT, "");
                            comp.repaint();
                        }
                        this.ensureVisible(comp, pos, pos);
                        return true;
                    }
                }
            }
        } else {
            this.incSearchReset();
        }
        return false;
    }

    public void incSearchReset() {
        BlockHighlighting layer;
        JTextComponent comp = DocumentsRegistry.getMostActiveComponent();
        BlockHighlighting blockHighlighting = layer = comp == null ? null : this.findLayer(comp, "org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting/INC_SEARCH");
        if (layer != null) {
            layer.highlightBlock(-1, -1, null);
        }
    }

    private boolean isBackSearch(Map props, boolean oppositeDir) {
        boolean back;
        Boolean b = (Boolean)props.get(FIND_BACKWARD_SEARCH);
        boolean bl = back = b != null && b != false;
        if (oppositeDir) {
            back = !back;
        }
        return back;
    }

    private void selectText(JTextComponent c, int start, int end, boolean back) {
        Caret caret = c.getCaret();
        this.ensureVisible(c, start, end);
        if (back) {
            caret.setDot(end);
            caret.moveDot(start);
        } else {
            caret.setDot(start);
            caret.moveDot(end);
        }
    }

    private void ensureVisible(JTextComponent c, int startOffset, int endOffset) {
        this.ensureVisible(c, startOffset, endOffset, new Insets(10, 10, 10, 10));
    }

    private void ensureVisible(JTextComponent c, int startOffset, int endOffset, Insets extraInsets) {
        try {
            Rectangle startBounds = c.modelToView(startOffset);
            Rectangle endBounds = c.modelToView(endOffset);
            if (startBounds != null && endBounds != null) {
                startBounds.add(endBounds);
                if (extraInsets != null) {
                    Rectangle visibleBounds = c.getVisibleRect();
                    int extraTop = extraInsets.top < 0 ? -extraInsets.top * visibleBounds.height / 100 : extraInsets.top * endBounds.height;
                    startBounds.y -= extraTop;
                    startBounds.height += extraTop;
                    startBounds.height = startBounds.height + (extraInsets.bottom < 0 ? -extraInsets.bottom * visibleBounds.height / 100 : extraInsets.bottom * endBounds.height);
                    int extraLeft = extraInsets.left < 0 ? -extraInsets.left * visibleBounds.width / 100 : extraInsets.left * endBounds.width;
                    startBounds.x -= extraLeft;
                    startBounds.width += extraLeft;
                    startBounds.width = startBounds.width + (extraInsets.right < 0 ? -extraInsets.right * visibleBounds.width / 100 : extraInsets.right * endBounds.width);
                }
                c.scrollRectToVisible(startBounds);
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    private DocumentFinder.FindReplaceResult findReplaceImpl(String replaceExp, Map<String, Object> props, boolean oppositeDir) {
        this.incSearchReset();
        props = this.getValidFindProperties(props);
        boolean back = this.isBackSearch(props, oppositeDir);
        JTextComponent c = DocumentsRegistry.getMostActiveComponent();
        Object findWhat = props.get(FIND_WHAT);
        if (findWhat == null) {
            return null;
        }
        String exp = "'" + findWhat + "' ";
        if (c != null) {
            Boolean b;
            Object dp;
            boolean direction;
            ComponentUtils.clearStatusText(c);
            Caret caret = c.getCaret();
            int dotPos = caret.getDot();
            if (findWhat.equals(c.getSelectedText()) && dotPos == (oppositeDir ^ (direction = (dp = props.get(FIND_BACKWARD_SEARCH)) != null ? (Boolean)dp : false) ? c.getSelectionEnd() : c.getSelectionStart())) {
                dotPos += oppositeDir ^ direction ? -1 : 1;
            }
            boolean blockSearch = (b = (Boolean)props.get(FIND_BLOCK_SEARCH)) != null && b != false;
            Integer i = (Integer)props.get(FIND_BLOCK_SEARCH_START);
            int blockSearchStart = i != null ? i : -1;
            int blockSearchEnd = this.getBlockEndOffset();
            try {
                DocumentFinder.FindReplaceResult result = this.findReplaceInBlock(replaceExp, c, dotPos, blockSearch && blockSearchStart > -1 ? blockSearchStart : 0, blockSearch && blockSearchEnd > 0 ? blockSearchEnd : -1, props, oppositeDir);
                int[] blk = null;
                if (result != null) {
                    blk = result.getFoundPositions();
                }
                if (blk != null) {
                    this.selectText(c, blk[0], blk[1], back);
                    String msg = exp + NbBundle.getBundle(EditorFindSupport.class).getString(FOUND_LOCALE) + ' ' + DocUtils.debugPosition(c.getDocument(), blk[0]);
                    if (blk[2] == 1) {
                        msg = msg + "; ";
                        msg = blockSearch && blockSearchEnd > 0 && blockSearchStart > -1 ? msg + (back ? NbBundle.getBundle(EditorFindSupport.class).getString(WRAP_BLOCK_END_LOCALE) : NbBundle.getBundle(EditorFindSupport.class).getString(WRAP_BLOCK_START_LOCALE)) : msg + (back ? NbBundle.getBundle(EditorFindSupport.class).getString(WRAP_END_LOCALE) : NbBundle.getBundle(EditorFindSupport.class).getString(WRAP_START_LOCALE));
                        ComponentUtils.setStatusBoldText(c, msg);
                        c.getToolkit().beep();
                    } else {
                        ComponentUtils.setStatusText(c, msg);
                    }
                    return result;
                }
                ComponentUtils.setStatusBoldText(c, exp + NbBundle.getBundle(EditorFindSupport.class).getString(NOT_FOUND_LOCALE));
                c.getCaret().setDot(c.getCaret().getDot());
            }
            catch (BadLocationException e) {
                LOG.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return null;
    }

    public boolean find(Map<String, Object> props, boolean oppositeDir) {
        DocumentFinder.FindReplaceResult result = this.findReplaceImpl(null, props, oppositeDir);
        return result != null;
    }

    private DocumentFinder.FindReplaceResult findReplaceInBlock(String replaceExp, JTextComponent c, int startPos, int blockStartPos, int blockEndPos, Map<String, Object> props, boolean oppositeDir) throws BadLocationException {
        if (c != null) {
            int[] retFind;
            props = this.getValidFindProperties(props);
            Document doc = c.getDocument();
            int pos = -1;
            boolean wrapDone = false;
            String replaced = null;
            boolean back = this.isBackSearch(props, oppositeDir);
            Boolean b = (Boolean)props.get(FIND_WRAP_SEARCH);
            boolean wrap = b != null && b != false;
            int docLen = doc.getLength();
            if (blockEndPos == -1) {
                blockEndPos = docLen;
            }
            while (true) {
                int off2;
                int off1;
                DocumentFinder.FindReplaceResult result;
                if ((result = DocumentFinder.findReplaceResult(replaceExp, doc, Math.min(off1 = startPos, off2 = back ? blockStartPos : blockEndPos), Math.max(off1, off2), props, oppositeDir)) == null) {
                    return null;
                }
                retFind = result.getFoundPositions();
                replaced = result.getReplacedString();
                if (retFind == null || (pos = retFind[0]) != -1 || !wrap) break;
                startPos = back ? blockEndPos : blockStartPos;
                wrapDone = true;
                wrap = false;
            }
            if (pos != -1) {
                int[] ret = new int[]{pos, retFind[1], wrapDone ? 1 : 0};
                return new DocumentFinder.FindReplaceResult(ret, replaced);
            }
        }
        return null;
    }

    public int[] findInBlock(JTextComponent c, int startPos, int blockStartPos, int blockEndPos, Map<String, Object> props, boolean oppositeDir) throws BadLocationException {
        DocumentFinder.FindReplaceResult result = this.findReplaceInBlock(null, c, startPos, blockStartPos, blockEndPos, props, oppositeDir);
        return result == null ? null : result.getFoundPositions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(Map<String, Object> props, boolean oppositeDir) throws BadLocationException {
        boolean back;
        this.incSearchReset();
        props = this.getValidFindProperties(props);
        Boolean b = (Boolean)props.get(FIND_BACKWARD_SEARCH);
        boolean bl = back = b != null && b != false;
        if (oppositeDir) {
            back = !back;
        }
        boolean blockSearch = (b = (Boolean)props.get(FIND_BLOCK_SEARCH)) != null && b != false;
        Integer i = (Integer)props.get(FIND_BLOCK_SEARCH_START);
        int blockSearchStart = i != null ? i : -1;
        int blockSearchEnd = this.getBlockEndOffset();
        JTextComponent c = DocumentsRegistry.getMostActiveComponent();
        if (c != null) {
            DocumentFinder.FindReplaceResult result;
            String s = (String)props.get(FIND_REPLACE_WITH);
            Caret caret = c.getCaret();
            if (caret.isSelectionVisible()) {
                int dotPos = caret.getDot();
                Object dp = props.get(FIND_BACKWARD_SEARCH);
                boolean direction = dp != null ? (Boolean)dp : false;
                dotPos = oppositeDir ^ direction ? c.getSelectionEnd() : c.getSelectionStart();
                c.setCaretPosition(dotPos);
            }
            if ((result = this.findReplaceImpl(s, props, oppositeDir)) == null) {
                return false;
            }
            s = result.getReplacedString();
            Document doc = c.getDocument();
            int startPos = c.getSelectionStart();
            int len = c.getSelectionEnd() - startPos;
            DocUtils.atomicLock(doc);
            try {
                if (len > 0) {
                    doc.remove(startPos, len);
                }
                if (s != null && s.length() > 0) {
                    doc.insertString(startPos, s, null);
                }
            }
            finally {
                DocUtils.atomicUnlock(doc);
                if (blockSearch) {
                    this.setBlockSearchHighlight(blockSearchStart, this.getBlockEndOffset());
                }
            }
            int adjustedCaretPos = back || s == null ? startPos : startPos + s.length();
            caret.setDot(adjustedCaretPos);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceAll(Map<String, Object> props) {
        Integer i;
        boolean backSearch;
        this.incSearchReset();
        JTextComponent c = DocumentsRegistry.getMostActiveComponent();
        Document doc = c.getDocument();
        int maxCnt = doc.getLength();
        int replacedCnt = 0;
        int totalCnt = 0;
        props = this.getValidFindProperties(props);
        props = new HashMap<String, Object>(props);
        String replaceWithOriginal = (String)props.get(FIND_REPLACE_WITH);
        Boolean b = (Boolean)props.get(FIND_BLOCK_SEARCH);
        boolean blockSearch = b != null && b != false;
        b = (Boolean)props.get(FIND_WRAP_SEARCH);
        boolean wrapSearch = b != null && b != false;
        b = (Boolean)props.get(FIND_BACKWARD_SEARCH);
        boolean bl = backSearch = b != null && b != false;
        if (wrapSearch) {
            props.put(FIND_WRAP_SEARCH, Boolean.FALSE);
            props.put(FIND_BACKWARD_SEARCH, Boolean.FALSE);
            this.firePropertyChange(null, null, null);
        }
        int blockSearchStart = (i = (Integer)props.get(FIND_BLOCK_SEARCH_START)) != null ? i : -1;
        int blockSearchEnd = this.getBlockEndOffset();
        if (c != null) {
            DocUtils.atomicLock(doc);
            try {
                int actualPos;
                int startPosWholeSearch = 0;
                int endPosWholeSearch = -1;
                int caretPos = c.getCaret().getDot();
                if (!wrapSearch) {
                    if (backSearch) {
                        startPosWholeSearch = 0;
                        endPosWholeSearch = caretPos;
                    } else {
                        startPosWholeSearch = caretPos;
                        endPosWholeSearch = -1;
                    }
                }
                int n = actualPos = wrapSearch ? 0 : c.getCaret().getDot();
                int pos = blockSearch && blockSearchStart > -1 ? (backSearch ? blockSearchEnd : blockSearchStart) : actualPos;
                while (true) {
                    blockSearchEnd = this.getBlockEndOffset();
                    DocumentFinder.FindReplaceResult result = this.findReplaceInBlock(replaceWithOriginal, c, pos, blockSearch && blockSearchStart > -1 ? blockSearchStart : startPosWholeSearch, blockSearch && blockSearchEnd > 0 ? blockSearchEnd : endPosWholeSearch, props, false);
                    if (result == null) break;
                    int[] blk = result.getFoundPositions();
                    String replaceWith = result.getReplacedString();
                    if (blk == null) break;
                    ++totalCnt;
                    int len = blk[1] - blk[0];
                    boolean skip = false;
                    try {
                        doc.remove(blk[0], len);
                    }
                    catch (BadLocationException e) {
                        if (ComponentUtils.isGuardedException(e)) {
                            skip = true;
                        }
                        throw e;
                    }
                    if (skip) {
                        pos = blk[0] + len;
                        continue;
                    }
                    if (replaceWith != null && replaceWith.length() > 0) {
                        doc.insertString(blk[0], replaceWith, null);
                    }
                    pos = blk[0] + (replaceWith != null ? replaceWith.length() : 0);
                    ++replacedCnt;
                }
                if (totalCnt == 0) {
                    Object findWhat = props.get(FIND_WHAT);
                    String exp = "'' ";
                    if (findWhat != null) {
                        exp = "'" + findWhat + "' ";
                    }
                    ComponentUtils.setStatusBoldText(c, exp + NbBundle.getBundle(EditorFindSupport.class).getString(NOT_FOUND_LOCALE));
                } else {
                    MessageFormat fmt = new MessageFormat(NbBundle.getBundle(EditorFindSupport.class).getString(ITEMS_REPLACED_LOCALE));
                    String msg = fmt.format(new Object[]{new Integer(replacedCnt), new Integer(totalCnt)});
                    ComponentUtils.setStatusText(c, msg);
                }
            }
            catch (BadLocationException e) {
                LOG.log(Level.WARNING, e.getMessage(), e);
            }
            finally {
                DocUtils.atomicUnlock(doc);
                if (blockSearch) {
                    this.setBlockSearchHighlight(blockSearchStart, this.getBlockEndOffset());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hookLayer(BlockHighlighting layer, JTextComponent component) {
        WeakHashMap<JTextComponent, Map<String, WeakReference<BlockHighlighting>>> weakHashMap = this.comp2layer;
        synchronized (weakHashMap) {
            Map<String, WeakReference<BlockHighlighting>> type2layer = this.comp2layer.get(component);
            if (type2layer == null) {
                type2layer = new HashMap<String, WeakReference<BlockHighlighting>>();
                this.comp2layer.put(component, type2layer);
            }
            type2layer.put(layer.getLayerTypeId(), new WeakReference<BlockHighlighting>(layer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unhookLayer(BlockHighlighting layer, JTextComponent component) {
        WeakHashMap<JTextComponent, Map<String, WeakReference<BlockHighlighting>>> weakHashMap = this.comp2layer;
        synchronized (weakHashMap) {
            Map<String, WeakReference<BlockHighlighting>> type2layer = this.comp2layer.get(component);
            if (type2layer != null) {
                type2layer.remove(layer.getLayerTypeId());
                if (type2layer.isEmpty()) {
                    this.comp2layer.remove(component);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockHighlighting findLayer(JTextComponent component, String layerId) {
        WeakHashMap<JTextComponent, Map<String, WeakReference<BlockHighlighting>>> weakHashMap = this.comp2layer;
        synchronized (weakHashMap) {
            WeakReference<BlockHighlighting> ref;
            Map<String, WeakReference<BlockHighlighting>> type2layer = this.comp2layer.get(component);
            BlockHighlighting layer = null;
            if (type2layer != null && (ref = type2layer.get(layerId)) != null) {
                layer = (BlockHighlighting)ref.get();
            }
            return layer;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(String findPropertyName, PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(findPropertyName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    public void firePropertyChange(String settingName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(settingName, oldValue, newValue);
    }

    public void setHistory(List<SPW> spwList) {
        this.historyList = new ArrayList<SPW>(spwList);
        this.firePropertyChange(FIND_HISTORY_CHANGED_PROP, null, null);
    }

    public List<SPW> getHistory() {
        return this.historyList;
    }

    public void setLastSelected(SPW spw) {
        this.lastSelected = spw;
        Map<String, Object> props = this.getFindProperties();
        if (spw == null) {
            return;
        }
        props.put(FIND_WHAT, spw.getSearchExpression());
        props.put(FIND_MATCH_CASE, spw.isMatchCase());
        props.put(FIND_REG_EXP, spw.isRegExp());
        props.put(FIND_WHOLE_WORDS, spw.isWholeWords());
    }

    public SPW getLastSelected() {
        return this.lastSelected;
    }

    public void addToHistory(SPW spw) {
        if (spw == null) {
            return;
        }
        this.firePropertyChange(FIND_HISTORY_PROP, null, spw);
    }

    public static final class SPW {
        private String searchExpression;
        private boolean wholeWords;
        private boolean matchCase;
        private boolean regExp;

        public SPW(String searchExpression, boolean wholeWords, boolean matchCase, boolean regExp) {
            this.searchExpression = searchExpression;
            this.wholeWords = wholeWords;
            this.matchCase = matchCase;
            this.regExp = regExp;
        }

        public String getSearchExpression() {
            return this.searchExpression;
        }

        public boolean isWholeWords() {
            return this.wholeWords;
        }

        public boolean isMatchCase() {
            return this.matchCase;
        }

        public boolean isRegExp() {
            return this.regExp;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SPW)) {
                return false;
            }
            SPW sp = (SPW)obj;
            return this.searchExpression.equals(sp.getSearchExpression()) && this.wholeWords == sp.isWholeWords() && this.matchCase == sp.isMatchCase() && this.regExp == sp.isRegExp();
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.wholeWords ? 1 : 0);
            result = 37 * result + (this.matchCase ? 1 : 0);
            result = 37 * result + (this.regExp ? 1 : 0);
            result = 37 * result + this.searchExpression.hashCode();
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[SearchPatternWrapper:]\nsearchExpression:" + this.searchExpression);
            sb.append('\n');
            sb.append("wholeWords:");
            sb.append(this.wholeWords);
            sb.append('\n');
            sb.append("matchCase:");
            sb.append(this.matchCase);
            sb.append('\n');
            sb.append("regExp:");
            sb.append(this.regExp);
            return sb.toString();
        }
    }
}

