/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.highlighting;

import java.util.Collection;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingSpiPackageAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsLayerAccessor;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.openide.util.TopologicalSortException;

public final class HighlightsLayer {
    private final String layerTypeId;
    private final ZOrder zOrder;
    private final boolean fixedSize;
    private HighlightsContainer container;
    private HighlightsLayerAccessor accessor;

    public static HighlightsLayer create(String layerTypeId, ZOrder zOrder, boolean fixedSize, HighlightsContainer container) {
        return new HighlightsLayer(layerTypeId, zOrder, fixedSize, container);
    }

    private HighlightsLayer(String layerTypeId, ZOrder zOrder, boolean fixedSize, HighlightsContainer container) {
        assert (layerTypeId != null) : "The layerId parameter must not be null.";
        assert (zOrder != null) : "The zOrder parameter must not be null.";
        this.layerTypeId = layerTypeId;
        this.zOrder = zOrder;
        this.fixedSize = fixedSize;
        this.container = container;
    }

    String getLayerTypeId() {
        return this.layerTypeId;
    }

    ZOrder getZOrder() {
        return this.zOrder;
    }

    boolean isFixedSize() {
        return this.fixedSize;
    }

    HighlightsContainer getContainer() {
        return this.container;
    }

    static {
        HighlightingSpiPackageAccessor.register(new PackageAccessor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PackageAccessor
    extends HighlightingSpiPackageAccessor {
        @Override
        public HighlightsLayerFactory.Context createFactoryContext(Document document, JTextComponent component) {
            return new HighlightsLayerFactory.Context(document, component);
        }

        @Override
        public List<? extends HighlightsLayer> sort(Collection<? extends HighlightsLayer> layers) throws TopologicalSortException {
            return ZOrder.sort(layers);
        }

        @Override
        public HighlightsLayerAccessor getHighlightsLayerAccessor(final HighlightsLayer layer) {
            if (layer.accessor == null) {
                layer.accessor = new HighlightsLayerAccessor(){

                    public String getLayerTypeId() {
                        return layer.getLayerTypeId();
                    }

                    public boolean isFixedSize() {
                        return layer.isFixedSize();
                    }

                    public ZOrder getZOrder() {
                        return layer.getZOrder();
                    }

                    public HighlightsContainer getContainer() {
                        return layer.getContainer();
                    }
                };
            }
            return layer.accessor;
        }
    }
}

