/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.highlighting.support;

import java.lang.ref.WeakReference;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.modules.editor.lib2.highlighting.OffsetGapList;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OffsetsBag
extends AbstractHighlightsContainer {
    private static final Logger LOG = Logger.getLogger(OffsetsBag.class.getName());
    private Document document;
    private OffsetGapList<Mark> marks;
    private boolean mergeHighlights;
    private long version = 0L;
    private DocL docListener;

    public OffsetsBag(Document document) {
        this(document, false);
    }

    public OffsetsBag(Document document, boolean mergeHighlights) {
        this.document = document;
        this.mergeHighlights = mergeHighlights;
        this.marks = new OffsetGapList();
        this.docListener = new DocL(this);
        this.document.addDocumentListener(this.docListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHighlight(int startOffset, int endOffset, AttributeSet attributes) {
        int[] offsets;
        OffsetGapList<Mark> offsetGapList = this.marks;
        synchronized (offsetGapList) {
            offsets = this.addHighlightImpl(startOffset, endOffset, attributes);
            if (offsets != null) {
                ++this.version;
            }
        }
        if (offsets != null) {
            this.fireHighlightsChange(offsets[0], offsets[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllHighlights(HighlightsSequence bag) {
        int[] offsets;
        OffsetGapList<Mark> offsetGapList = this.marks;
        synchronized (offsetGapList) {
            offsets = this.addAllHighlightsImpl(bag);
            if (offsets != null) {
                ++this.version;
            }
        }
        if (offsets != null) {
            this.fireHighlightsChange(offsets[0], offsets[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighlights(HighlightsSequence seq) {
        if (seq instanceof Seq) {
            this.setHighlights(((Seq)seq).getBag());
            return;
        }
        int changeStart = Integer.MAX_VALUE;
        int changeEnd = Integer.MIN_VALUE;
        OffsetGapList<Mark> offsetGapList = this.marks;
        synchronized (offsetGapList) {
            int[] clearedArea = this.clearImpl();
            int[] populatedArea = this.addAllHighlightsImpl(seq);
            if (clearedArea != null) {
                changeStart = clearedArea[0];
                changeEnd = clearedArea[1];
            }
            if (populatedArea != null) {
                if (changeStart == Integer.MAX_VALUE || changeStart > populatedArea[0]) {
                    changeStart = populatedArea[0];
                }
                if (changeEnd == Integer.MIN_VALUE || changeEnd < populatedArea[1]) {
                    changeEnd = populatedArea[1];
                }
            }
            if (changeStart < changeEnd) {
                ++this.version;
            }
        }
        if (changeStart < changeEnd) {
            this.fireHighlightsChange(changeStart, changeEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighlights(OffsetsBag bag) {
        int changeStart = Integer.MAX_VALUE;
        int changeEnd = Integer.MIN_VALUE;
        OffsetGapList<Mark> offsetGapList = this.marks;
        synchronized (offsetGapList) {
            OffsetGapList<Mark> newMarks;
            int[] clearedArea = this.clearImpl();
            int[] populatedArea = null;
            OffsetGapList<Mark> offsetGapList2 = newMarks = bag.getMarks();
            synchronized (offsetGapList2) {
                Iterator i$ = newMarks.iterator();
                while (i$.hasNext()) {
                    Mark mark = (Mark)i$.next();
                    this.marks.add(this.marks.size(), new Mark(mark.getOffset(), mark.getAttributes()));
                }
                if (this.marks.size() > 0) {
                    populatedArea = new int[]{((Mark)this.marks.get(0)).getOffset(), ((Mark)this.marks.get(this.marks.size() - 1)).getOffset()};
                }
            }
            if (clearedArea != null) {
                changeStart = clearedArea[0];
                changeEnd = clearedArea[1];
            }
            if (populatedArea != null) {
                if (changeStart == Integer.MAX_VALUE || changeStart > populatedArea[0]) {
                    changeStart = populatedArea[0];
                }
                if (changeEnd == Integer.MIN_VALUE || changeEnd < populatedArea[1]) {
                    changeEnd = populatedArea[1];
                }
            }
            if (changeStart < changeEnd) {
                ++this.version;
            }
        }
        if (changeStart < changeEnd) {
            this.fireHighlightsChange(changeStart, changeEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHighlights(int startOffset, int endOffset, boolean clip) {
        int changeStart = Integer.MAX_VALUE;
        int changeEnd = Integer.MIN_VALUE;
        if (startOffset == endOffset) {
            return;
        }
        assert (startOffset < endOffset) : "Start offset must be before the end offset. startOffset = " + startOffset + ", endOffset = " + endOffset;
        OffsetGapList<Mark> offsetGapList = this.marks;
        synchronized (offsetGapList) {
            if (this.marks.isEmpty()) {
                return;
            }
            int startIdx = this.indexBeforeOffset(startOffset);
            int endIdx = this.indexBeforeOffset(endOffset, startIdx < 0 ? 0 : startIdx, this.marks.size() - 1);
            if (clip) {
                if (startIdx == endIdx) {
                    if (startIdx != -1 && ((Mark)this.marks.get(startIdx)).getAttributes() != null) {
                        AttributeSet original = ((Mark)this.marks.get(startIdx)).getAttributes();
                        if (((Mark)this.marks.get(startIdx)).getOffset() == startOffset) {
                            this.marks.set(startIdx, new Mark(endOffset, original));
                        } else {
                            this.marks.add(startIdx + 1, new Mark(startOffset, null));
                            this.marks.add(startIdx + 2, new Mark(endOffset, original));
                        }
                        changeStart = startOffset;
                        changeEnd = endOffset;
                    }
                    startIdx = Integer.MAX_VALUE;
                    endIdx = Integer.MIN_VALUE;
                } else {
                    assert (endIdx != -1) : "Invalid range: startIdx = " + startIdx + " endIdx = " + endIdx;
                    if (((Mark)this.marks.get(endIdx)).getAttributes() != null) {
                        this.marks.set(endIdx, new Mark(endOffset, ((Mark)this.marks.get(endIdx)).getAttributes()));
                        changeEnd = endOffset;
                        --endIdx;
                    }
                    if (startIdx != -1 && ((Mark)this.marks.get(startIdx)).getAttributes() != null) {
                        if (++startIdx <= endIdx) {
                            this.marks.set(startIdx, new Mark(startOffset, null));
                        } else {
                            this.marks.add(startIdx, new Mark(startOffset, null));
                        }
                        changeStart = startOffset;
                    }
                    ++startIdx;
                }
            } else {
                if (startIdx == -1 || ((Mark)this.marks.get(startIdx)).getAttributes() == null) {
                    ++startIdx;
                }
                if (endIdx != -1 && ((Mark)this.marks.get(endIdx)).getAttributes() != null) {
                    ++endIdx;
                }
            }
            if (startIdx <= endIdx) {
                if (changeStart == Integer.MAX_VALUE) {
                    changeStart = ((Mark)this.marks.get(startIdx)).getOffset();
                }
                if (changeEnd == Integer.MIN_VALUE) {
                    changeEnd = ((Mark)this.marks.get(endIdx)).getOffset();
                }
                this.marks.remove(startIdx, endIdx - startIdx + 1);
            }
            if (changeStart < changeEnd) {
                ++this.version;
            }
        }
        if (changeStart < changeEnd) {
            this.fireHighlightsChange(changeStart, changeEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        if (LOG.isLoggable(Level.FINE) && startOffset >= endOffset) {
            LOG.fine("startOffset must be less than endOffset: startOffset = " + startOffset + " endOffset = " + endOffset);
        }
        OffsetGapList<Mark> offsetGapList = this.marks;
        synchronized (offsetGapList) {
            return new Seq(this.version, startOffset, endOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int[] clearedArea;
        OffsetGapList<Mark> offsetGapList = this.marks;
        synchronized (offsetGapList) {
            clearedArea = this.clearImpl();
            if (clearedArea != null) {
                ++this.version;
            }
        }
        if (clearedArea != null) {
            this.fireHighlightsChange(clearedArea[0], clearedArea[1]);
        }
    }

    OffsetGapList<Mark> getMarks() {
        return this.marks;
    }

    Document getDocument() {
        return this.document;
    }

    private int[] addHighlightImpl(int startOffset, int endOffset, AttributeSet attributes) {
        if (startOffset == endOffset) {
            return null;
        }
        assert (startOffset < endOffset) : "Start offset must be before the end offset. startOffset = " + startOffset + ", endOffset = " + endOffset;
        assert (attributes != null) : "Highlight attributes must not be null.";
        if (this.mergeHighlights) {
            this.merge(startOffset, endOffset, attributes);
        } else {
            this.trim(startOffset, endOffset, attributes);
        }
        return new int[]{startOffset, endOffset};
    }

    private void merge(int startOffset, int endOffset, AttributeSet attributes) {
        AttributeSet lastKnownAttributes = null;
        int startIdx = this.indexBeforeOffset(startOffset);
        if (startIdx < 0) {
            startIdx = 0;
            this.marks.add(startIdx, new Mark(startOffset, attributes));
        } else {
            Mark mark = (Mark)this.marks.get(startIdx);
            AttributeSet markAttribs = mark.getAttributes();
            AttributeSet newAttribs = markAttribs == null ? attributes : AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{attributes, markAttribs});
            lastKnownAttributes = mark.getAttributes();
            if (mark.getOffset() == startOffset) {
                mark.setAttributes(newAttribs);
            } else {
                this.marks.add(++startIdx, new Mark(startOffset, newAttribs));
            }
        }
        int idx = startIdx + 1;
        while (true) {
            Mark mark;
            if (idx < this.marks.size()) {
                mark = (Mark)this.marks.get(idx);
                if (mark.getOffset() >= endOffset) {
                    if (mark.getOffset() <= endOffset) break;
                    this.marks.add(idx, new Mark(endOffset, lastKnownAttributes));
                    break;
                }
            } else {
                this.marks.add(idx, new Mark(endOffset, lastKnownAttributes));
                break;
            }
            lastKnownAttributes = mark.getAttributes();
            mark.setAttributes(lastKnownAttributes == null ? attributes : AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{attributes, lastKnownAttributes}));
            ++idx;
        }
    }

    private void trim(int startOffset, int endOffset, AttributeSet attributes) {
        int startIdx;
        int endIdx = this.indexBeforeOffset(endOffset, (startIdx = this.indexBeforeOffset(startOffset)) < 0 ? 0 : startIdx, this.marks.size() - 1);
        if (startIdx == endIdx) {
            AttributeSet original = null;
            if (startIdx != -1 && ((Mark)this.marks.get(startIdx)).getAttributes() != null) {
                original = ((Mark)this.marks.get(startIdx)).getAttributes();
            }
            if (startIdx != -1 && ((Mark)this.marks.get(startIdx)).getOffset() == startOffset) {
                ((Mark)this.marks.get(startIdx)).setAttributes(attributes);
            } else {
                this.marks.add(++startIdx, new Mark(startOffset, attributes));
            }
            this.marks.add(++startIdx, new Mark(endOffset, original));
        } else {
            assert (endIdx != -1) : "Invalid range: startIdx = " + startIdx + " endIdx = " + endIdx;
            this.marks.set(endIdx, new Mark(endOffset, ((Mark)this.marks.get(endIdx)).getAttributes()));
            if (++startIdx <= --endIdx) {
                this.marks.set(startIdx, new Mark(startOffset, attributes));
            } else {
                this.marks.add(startIdx, new Mark(startOffset, attributes));
            }
            if (++startIdx <= endIdx) {
                this.marks.remove(startIdx, endIdx - startIdx + 1);
            }
        }
    }

    private int[] addAllHighlightsImpl(HighlightsSequence sequence) {
        int changeStart = Integer.MAX_VALUE;
        int changeEnd = Integer.MIN_VALUE;
        while (sequence.moveNext()) {
            this.addHighlightImpl(sequence.getStartOffset(), sequence.getEndOffset(), sequence.getAttributes());
            if (changeStart == Integer.MAX_VALUE) {
                changeStart = sequence.getStartOffset();
            }
            changeEnd = sequence.getEndOffset();
        }
        if (changeStart != Integer.MAX_VALUE && changeEnd != Integer.MIN_VALUE) {
            return new int[]{changeStart, changeEnd};
        }
        return null;
    }

    private int[] clearImpl() {
        if (!this.marks.isEmpty()) {
            int changeStart = ((Mark)this.marks.get(0)).getOffset();
            int changeEnd = ((Mark)this.marks.get(this.marks.size() - 1)).getOffset();
            this.marks.clear();
            return new int[]{changeStart, changeEnd};
        }
        return null;
    }

    private int indexBeforeOffset(int offset, int low, int high) {
        int idx = this.marks.findElementIndex(offset, low, high);
        if (idx < 0) {
            idx = -idx - 1;
            return idx - 1;
        }
        return idx;
    }

    private int indexBeforeOffset(int offset) {
        return this.indexBeforeOffset(offset, 0, this.marks.size() - 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DocL
    extends WeakReference<OffsetsBag>
    implements DocumentListener,
    Runnable {
        private Document document;

        public DocL(OffsetsBag bag) {
            super(bag, Utilities.activeReferenceQueue());
            this.document = bag.getDocument();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertUpdate(DocumentEvent e) {
            OffsetsBag bag = (OffsetsBag)this.get();
            if (bag != null) {
                OffsetGapList offsetGapList = bag.marks;
                synchronized (offsetGapList) {
                    bag.marks.defaultInsertUpdate(e.getOffset(), e.getLength());
                }
            } else {
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeUpdate(DocumentEvent e) {
            OffsetsBag bag = (OffsetsBag)this.get();
            if (bag != null) {
                OffsetGapList offsetGapList = bag.marks;
                synchronized (offsetGapList) {
                    bag.marks.defaultRemoveUpdate(e.getOffset(), e.getLength());
                }
            } else {
                this.run();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void run() {
            Document d = this.document;
            if (d != null) {
                d.removeDocumentListener(this);
                this.document = null;
            }
        }
    }

    static final class Mark
    extends OffsetGapList.Offset {
        private AttributeSet attribs;

        public Mark(int offset, AttributeSet attribs) {
            super(offset);
            this.attribs = attribs;
        }

        public AttributeSet getAttributes() {
            return this.attribs;
        }

        public void setAttributes(AttributeSet attribs) {
            this.attribs = attribs;
        }
    }

    private final class Seq
    implements HighlightsSequence {
        private long version;
        private int startOffset;
        private int endOffset;
        private int idx = -1;

        public Seq(long version, int startOffset, int endOffset) {
            this.version = version;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            OffsetGapList offsetGapList = OffsetsBag.this.marks;
            synchronized (offsetGapList) {
                this.checkVersion();
                if (this.idx == -1) {
                    this.idx = OffsetsBag.this.indexBeforeOffset(this.startOffset);
                    if (this.idx == -1 && OffsetsBag.this.marks.size() > 0) {
                        this.idx = 0;
                    }
                } else {
                    ++this.idx;
                }
                while (this.isIndexValid(this.idx)) {
                    if (((Mark)OffsetsBag.this.marks.get(this.idx)).getAttributes() != null) {
                        return true;
                    }
                    ++this.idx;
                }
                return false;
            }
        }

        public int getStartOffset() {
            OffsetGapList offsetGapList = OffsetsBag.this.marks;
            synchronized (offsetGapList) {
                assert (this.idx != -1) : "Sequence not initialized, call moveNext() first.";
                this.checkVersion();
                if (this.isIndexValid(this.idx)) {
                    return Math.max(((Mark)OffsetsBag.this.marks.get(this.idx)).getOffset(), this.startOffset);
                }
                throw new NoSuchElementException();
            }
        }

        public int getEndOffset() {
            OffsetGapList offsetGapList = OffsetsBag.this.marks;
            synchronized (offsetGapList) {
                assert (this.idx != -1) : "Sequence not initialized, call moveNext() first.";
                this.checkVersion();
                if (this.isIndexValid(this.idx)) {
                    return Math.min(((Mark)OffsetsBag.this.marks.get(this.idx + 1)).getOffset(), this.endOffset);
                }
                throw new NoSuchElementException();
            }
        }

        public AttributeSet getAttributes() {
            OffsetGapList offsetGapList = OffsetsBag.this.marks;
            synchronized (offsetGapList) {
                assert (this.idx != -1) : "Sequence not initialized, call moveNext() first.";
                this.checkVersion();
                if (this.isIndexValid(this.idx)) {
                    return ((Mark)OffsetsBag.this.marks.get(this.idx)).getAttributes();
                }
                throw new NoSuchElementException();
            }
        }

        private boolean isIndexValid(int idx) {
            return idx >= 0 && idx + 1 < OffsetsBag.this.marks.size() && ((Mark)OffsetsBag.this.marks.get(idx)).getOffset() < this.endOffset && ((Mark)OffsetsBag.this.marks.get(idx + 1)).getOffset() > this.startOffset;
        }

        private OffsetsBag getBag() {
            return OffsetsBag.this;
        }

        private void checkVersion() {
            if (OffsetsBag.this.version != this.version) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

