/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.popupswitcher;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.netbeans.swing.popupswitcher.SwitcherTableModel;
import org.openide.util.Utilities;

public class SwitcherTable
extends JTable {
    private static final Border rendererBorder = BorderFactory.createEmptyBorder(2, 5, 0, 5);
    private Icon nullIcon = new NullIcon();
    private Color foreground;
    private Color background;
    private Color selForeground;
    private Color selBackground;
    private Dimension prefSize;
    private boolean needCalcRowHeight = true;
    private static SoftReference<BufferedImage> ctx = null;

    public SwitcherTable(SwitcherTableItem[] items) {
        this(items, 0);
    }

    public SwitcherTable(SwitcherTableItem[] items, int y) {
        this.init();
        int gap = y == 0 ? 10 : 5;
        int height = Utilities.getUsableScreenBounds().height - y - gap;
        this.setModel(new SwitcherTableModel(items, this.getRowHeight(), height));
        this.getSelectionModel().clearSelection();
        this.getSelectionModel().setAnchorSelectionIndex(-1);
        this.getSelectionModel().setLeadSelectionIndex(-1);
    }

    private void init() {
        this.setBorder(BorderFactory.createLineBorder(this.getForeground()));
        this.setShowHorizontalLines(false);
        this.calcRowHeight(SwitcherTable.getOffscreenGraphics());
    }

    public void updateUI() {
        this.needCalcRowHeight = true;
        super.updateUI();
    }

    public void setFont(Font f) {
        this.needCalcRowHeight = true;
        super.setFont(f);
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        SwitcherTableItem item = (SwitcherTableItem)this.getSwitcherTableModel().getValueAt(row, column);
        boolean selected = row == this.getSelectedRow() && column == this.getSelectedColumn() && item != null;
        DefaultTableCellRenderer ren = (DefaultTableCellRenderer)renderer.getTableCellRendererComponent(this, item, selected, selected, row, column);
        if (item == null) {
            ren.setOpaque(false);
            ren.setIcon(null);
            return ren;
        }
        Icon icon = item.getIcon();
        if (icon == null) {
            icon = this.nullIcon;
        }
        ren.setText(selected || item.isActive() ? item.getName() : item.getHtmlName());
        ren.setIcon(icon);
        ren.setBorder(rendererBorder);
        ren.setIconTextGap(26 - icon.getIconWidth());
        if (item.isActive()) {
            ren.setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
        }
        ren.setOpaque(true);
        return ren;
    }

    public Color getForeground() {
        if (this.foreground == null) {
            this.foreground = UIManager.getColor("ComboBox.foreground");
        }
        return this.foreground != null ? this.foreground : super.getForeground();
    }

    public Color getBackground() {
        if (this.background == null) {
            this.background = UIManager.getColor("ComboBox.background");
        }
        return this.background != null ? this.background : super.getBackground();
    }

    public Color getSelectionForeground() {
        if (this.selForeground == null) {
            this.selForeground = UIManager.getColor("ComboBox.selectionForeground");
        }
        return this.selForeground != null ? this.selForeground : super.getSelectionForeground();
    }

    public Color getSelectionBackground() {
        if (this.selBackground == null) {
            this.selBackground = UIManager.getColor("ComboBox.selectionBackground");
        }
        return this.selBackground != null ? this.selBackground : super.getSelectionBackground();
    }

    private void calcRowHeight(Graphics g) {
        Font f = this.getFont();
        FontMetrics fm = g.getFontMetrics(f);
        int rowHeight = Math.max(fm.getHeight(), 16) + 4;
        this.needCalcRowHeight = false;
        this.setRowHeight(rowHeight);
    }

    private static Graphics2D getOffscreenGraphics() {
        BufferedImage result = null;
        if (ctx != null) {
            result = ctx.get();
        }
        if (result == null) {
            result = new BufferedImage(10, 10, 1);
            ctx = new SoftReference<BufferedImage>(result);
        }
        return (Graphics2D)result.getGraphics();
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            int i;
            int cols = this.getColumnCount();
            int rows = this.getRowCount();
            int columnWidth = 0;
            for (i = 0; i < cols; ++i) {
                for (int j = 0; j < rows; ++j) {
                    TableCellRenderer ren = this.getCellRenderer(j, i);
                    Component c = this.prepareRenderer(ren, j, i);
                    columnWidth = Math.max(c.getPreferredSize().width + 1, columnWidth);
                }
            }
            columnWidth = Math.min(columnWidth, 250);
            for (i = 0; i < cols; ++i) {
                this.getColumnModel().getColumn(i).setPreferredWidth(columnWidth);
            }
            this.prefSize = new Dimension(columnWidth * cols, rows * this.getRowHeight());
        }
        return this.prefSize;
    }

    private SwitcherTableModel getSwitcherTableModel() {
        return (SwitcherTableModel)this.getModel();
    }

    public SwitcherTableItem getSelectedItem() {
        return (SwitcherTableItem)this.getValueAt(this.getSelectedRow(), this.getSelectedColumn());
    }

    public void paint(Graphics g) {
        if (this.needCalcRowHeight) {
            this.calcRowHeight(g);
        }
        super.paint(g);
    }

    public int getLastValidRow() {
        int lastColIdx = this.getColumnCount() - 1;
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            if (this.getValueAt(i, lastColIdx) == null) continue;
            return i;
        }
        return -1;
    }

    private static class NullIcon
    implements Icon {
        private NullIcon() {
        }

        public int getIconWidth() {
            return 0;
        }

        public int getIconHeight() {
            return 0;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }
}

