/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.netbeans.swing.tabcontrol.ButtonPopupSwitcher;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.openide.windows.TopComponent;

public class TabListPopupAction
extends AbstractAction {
    private TabDisplayer displayer;

    public TabListPopupAction(TabDisplayer displayer) {
        this.displayer = displayer;
    }

    public void actionPerformed(ActionEvent ae) {
        if ("pressed".equals(ae.getActionCommand())) {
            JComponent jc = (JComponent)ae.getSource();
            Point p = new Point(jc.getWidth(), jc.getHeight());
            SwingUtilities.convertPointToScreen(p, jc);
            if (!ButtonPopupSwitcher.isShown()) {
                Object[] items = this.createSwitcherItems(this.displayer);
                Arrays.sort(items);
                ButtonPopupSwitcher.selectItem(jc, (SwitcherTableItem[])items, p.x, p.y);
            }
            if (jc instanceof AbstractButton) {
                AbstractButton jb = (AbstractButton)jc;
                jb.getModel().setPressed(false);
                jb.getModel().setRollover(false);
                jb.getModel().setArmed(false);
                jb.repaint();
            }
        }
    }

    private SwitcherTableItem[] createSwitcherItems(TabDisplayer displayer) {
        List<TabData> tabs = displayer.getModel().getTabs();
        SwitcherTableItem[] items = new SwitcherTableItem[tabs.size()];
        int i = 0;
        int selIdx = displayer.getSelectionModel().getSelectedIndex();
        TabData selectedTab = selIdx >= 0 ? displayer.getModel().getTab(selIdx) : null;
        for (TabData tab : tabs) {
            String htmlName;
            String name;
            if (tab.getComponent() instanceof TopComponent) {
                TopComponent tabTC = (TopComponent)tab.getComponent();
                name = tabTC.getDisplayName();
                if (name == null) {
                    name = tabTC.getName();
                }
                if ((htmlName = tabTC.getHtmlDisplayName()) == null) {
                    htmlName = name;
                }
            } else {
                name = htmlName = tab.getText();
            }
            items[i++] = new SwitcherTableItem(new ActivatableTab(tab), name, htmlName, tab.getIcon(), tab == selectedTab);
        }
        return items;
    }

    private class ActivatableTab
    implements SwitcherTableItem.Activatable {
        private TabData tab;

        private ActivatableTab(TabData tab) {
            this.tab = tab;
        }

        public void activate() {
            if (this.tab != null) {
                this.selectTab(this.tab);
            }
        }

        private void selectTab(TabData tab) {
            List<TabData> tabs = TabListPopupAction.this.displayer.getModel().getTabs();
            int ind = -1;
            for (int i = 0; i < tabs.size(); ++i) {
                if (!tab.equals(tabs.get(i))) continue;
                ind = i;
                break;
            }
            if (ind != -1) {
                int old = TabListPopupAction.this.displayer.getSelectionModel().getSelectedIndex();
                TabListPopupAction.this.displayer.getSelectionModel().setSelectedIndex(ind);
                if (TabListPopupAction.this.displayer.getType() == 1 && ind >= 0 && ind == old) {
                    TabListPopupAction.this.displayer.getUI().makeTabVisible(ind);
                }
            }
        }
    }
}

