/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AquaEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;

public class AquaEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private Color lineMiddleColor = null;
    private Color lineHlColor = null;
    private static Map<Integer, String[]> buttonIconPaths;

    public AquaEditorTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    public void install() {
        super.install();
        this.scroll().setMinimumXposition(9);
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new AquaEditorTabCellRenderer();
    }

    public Insets getTabAreaInsets() {
        Insets result = super.getTabAreaInsets();
        result.bottom = 2;
        return result;
    }

    public static ComponentUI createUI(JComponent c) {
        return new AquaEditorTabDisplayerUI((TabDisplayer)c);
    }

    protected boolean isAntialiased() {
        return true;
    }

    protected Font createFont() {
        return UIManager.getFont("Label.font");
    }

    protected int createRepaintPolicy() {
        return 351;
    }

    public Dimension getPreferredSize(JComponent c) {
        int prefHeight = 28;
        Graphics2D g = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (g != null) {
            FontMetrics fm = g.getFontMetrics(this.displayer.getFont());
            Insets ins = this.getTabAreaInsets();
            prefHeight = fm.getHeight() + ins.top + ins.bottom + 7;
        }
        if (prefHeight % 2 == 0) {
            ++prefHeight;
        }
        return new Dimension(this.displayer.getWidth(), prefHeight);
    }

    protected void paintAfterTabs(Graphics g) {
        int centerY = (this.displayer.getHeight() - 2) / 2 + 0 - 1 + this.getTabAreaInsets().top + 1;
        if (this.lineMiddleColor == null) {
            this.lineMiddleColor = ColorUtil.getMiddle(UIManager.getColor("controlShadow"), UIManager.getColor("control"));
        }
        g.setColor(this.lineMiddleColor);
        int rightLineStart = this.getTabsAreaWidth() - 13;
        int rightLineEnd = this.displayer.getWidth() - 9;
        if (this.displayer.getModel().size() > 0 && !this.scroll().isLastTabClipped()) {
            int idx = this.scroll().getLastVisibleTab(this.displayer.getWidth());
            rightLineStart = this.scroll().getX(idx) + this.scroll().getW(idx);
        } else if (this.displayer.getModel().size() == 0) {
            rightLineStart = 6;
        }
        if (this.scroll().getOffset() >= 0) {
            g.drawLine(6, centerY, 11, centerY);
        }
        g.drawLine(rightLineStart, centerY, rightLineEnd, centerY);
        if (this.lineHlColor == null) {
            this.lineHlColor = ColorUtil.getMiddle(this.lineMiddleColor, UIManager.getColor("control"));
        }
        g.setColor(this.lineHlColor);
        g.drawLine(rightLineStart, centerY + 1, rightLineEnd, centerY + 1);
        if (this.scroll().getOffset() > 0) {
            g.drawLine(6, centerY + 1, 11, centerY + 1);
        }
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            String[] iconPaths = new String[4];
            iconPaths[0] = "org/netbeans/swing/tabcontrol/resources/mac_scrollleft_enabled.png";
            iconPaths[2] = "org/netbeans/swing/tabcontrol/resources/mac_scrollleft_disabled.png";
            iconPaths[3] = "org/netbeans/swing/tabcontrol/resources/mac_scrollleft_rollover.png";
            iconPaths[1] = "org/netbeans/swing/tabcontrol/resources/mac_scrollleft_pressed.png";
            buttonIconPaths.put(9, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "org/netbeans/swing/tabcontrol/resources/mac_scrollright_enabled.png";
            iconPaths[2] = "org/netbeans/swing/tabcontrol/resources/mac_scrollright_disabled.png";
            iconPaths[3] = "org/netbeans/swing/tabcontrol/resources/mac_scrollright_rollover.png";
            iconPaths[1] = "org/netbeans/swing/tabcontrol/resources/mac_scrollright_pressed.png";
            buttonIconPaths.put(10, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "org/netbeans/swing/tabcontrol/resources/mac_popup_enabled.png";
            iconPaths[2] = "org/netbeans/swing/tabcontrol/resources/mac_popup_disabled.png";
            iconPaths[3] = "org/netbeans/swing/tabcontrol/resources/mac_popup_rollover.png";
            iconPaths[1] = "org/netbeans/swing/tabcontrol/resources/mac_popup_pressed.png";
            buttonIconPaths.put(8, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "org/netbeans/swing/tabcontrol/resources/mac_maximize_enabled.png";
            iconPaths[2] = "org/netbeans/swing/tabcontrol/resources/mac_maximize_disabled.png";
            iconPaths[3] = "org/netbeans/swing/tabcontrol/resources/mac_maximize_rollover.png";
            iconPaths[1] = "org/netbeans/swing/tabcontrol/resources/mac_maximize_pressed.png";
            buttonIconPaths.put(3, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "org/netbeans/swing/tabcontrol/resources/mac_restore_enabled.png";
            iconPaths[2] = "org/netbeans/swing/tabcontrol/resources/mac_restore_disabled.png";
            iconPaths[3] = "org/netbeans/swing/tabcontrol/resources/mac_restore_rollover.png";
            iconPaths[1] = "org/netbeans/swing/tabcontrol/resources/mac_restore_pressed.png";
            buttonIconPaths.put(4, iconPaths);
        }
    }

    public Icon getButtonIcon(int buttonId, int buttonState) {
        Icon res = null;
        AquaEditorTabDisplayerUI.initIcons();
        String[] paths = buttonIconPaths.get(buttonId);
        if (null != paths && buttonState >= 0 && buttonState < paths.length) {
            res = TabControlButtonFactory.getIcon(paths[buttonState]);
        }
        return res;
    }

    protected Rectangle getControlButtonsRectangle(Container parent) {
        int centerY = (this.displayer.getHeight() - 2) / 2 + 0 + this.getTabAreaInsets().top;
        int width = parent.getWidth();
        int height = parent.getHeight();
        int buttonsWidth = this.getControlButtons().getWidth();
        int buttonsHeight = this.getControlButtons().getHeight();
        return new Rectangle(width - buttonsWidth - 3, centerY - buttonsHeight / 2, buttonsWidth, buttonsHeight);
    }
}

