/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.SlidingButton;
import org.netbeans.swing.tabcontrol.SlidingButtonUI;
import org.netbeans.swing.tabcontrol.plaf.ChicletWrapper;

public class AquaSlidingButtonUI
extends SlidingButtonUI {
    private static AquaSlidingButtonUI AQUA_INSTANCE = null;
    static Color[] rollover = new Color[]{new Color(222, 222, 227), new Color(220, 238, 255), new Color(190, 247, 255), new Color(205, 205, 205)};
    private ChicletWrapper chic = new ChicletWrapper();

    private AquaSlidingButtonUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        if (AQUA_INSTANCE == null) {
            AQUA_INSTANCE = new AquaSlidingButtonUI();
        }
        return AQUA_INSTANCE;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setFont(UIManager.getFont("Tree.font"));
    }

    protected void paintBackground(Graphics2D graph, AbstractButton b) {
        this.chic.setNotch(false, false);
        this.chic.setState(((SlidingButton)b).isBlinkState() ? 16 : 0);
        this.chic.setArcs(0.5f, 0.5f, 0.5f, 0.5f);
        this.chic.setBounds(0, 1, b.getWidth(), b.getHeight() - 2);
        this.chic.setAllowVertical(true);
        this.chic.draw(graph);
        this.chic.setAllowVertical(false);
    }

    protected void paintButtonPressed(Graphics graph, AbstractButton b) {
        this.chic.setNotch(false, false);
        int state = 0;
        state |= b.getModel().isSelected() ? 2 : 0;
        state |= b.getModel().isPressed() ? 1 : 0;
        state |= b.getModel().isRollover() ? 4 : 0;
        this.chic.setState(state |= ((SlidingButton)b).isBlinkState() ? 16 : 0);
        this.chic.setArcs(0.5f, 0.5f, 0.5f, 0.5f);
        this.chic.setBounds(0, 1, b.getWidth(), b.getHeight() - 2);
        this.chic.setAllowVertical(true);
        this.chic.draw((Graphics2D)graph);
        this.chic.setAllowVertical(false);
    }

    public Dimension getPreferredSize(JComponent c) {
        SlidingButton slide = (SlidingButton)c;
        Dimension d = new Dimension(super.getPreferredSize(c));
        Insets i = c.getInsets();
        int orientation = slide.getOrientation();
        if (orientation == 3) {
            if (i.top + i.bottom < 5) {
                d.height += 5;
            }
            if (i.left + i.right < 7) {
                d.width += 7;
            }
        } else {
            if (i.top + i.bottom < 7) {
                d.height += 7;
            }
            if (i.left + i.right < 5) {
                d.width += 5;
            }
        }
        return d;
    }
}

