/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BasicTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.DefaultTabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.ScrollingTabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.TabControlButton;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.TabState;

public abstract class BasicScrollingTabDisplayerUI
extends BasicTabDisplayerUI {
    private Rectangle scratch = new Rectangle();
    private JPanel controlButtons;
    private TabControlButton btnScrollLeft;
    private TabControlButton btnScrollRight;
    private TabControlButton btnDropDown;
    private TabControlButton btnMaximizeRestore;
    private int lastKnownModelSize = Integer.MAX_VALUE;
    static SoftReference<BufferedImage> ctx = null;

    public BasicScrollingTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    protected final TabLayoutModel createLayoutModel() {
        DefaultTabLayoutModel dtlm = new DefaultTabLayoutModel(this.displayer.getModel(), this.displayer);
        return new ScrollingTabLayoutModel(dtlm, this.selectionModel, this.displayer.getModel());
    }

    protected TabState createTabState() {
        return new ScrollingTabState();
    }

    protected HierarchyListener createHierarchyListener() {
        return new ScrollingHierarchyListener();
    }

    public void makeTabVisible(int tab) {
        if (this.scroll().makeVisible(tab, this.getTabsAreaWidth())) {
            this.getTabsVisibleArea(this.scratch);
            this.displayer.repaint(this.scratch.x, this.scratch.y, this.scratch.width, this.scratch.height);
        }
    }

    protected final int getTabsAreaWidth() {
        int result = this.displayer.getWidth();
        Insets ins = this.getTabAreaInsets();
        return result - (ins.left + ins.right);
    }

    public Insets getTabAreaInsets() {
        return new Insets(0, 0, 0, this.getControlButtons().getPreferredSize().width + 5);
    }

    protected final int getLastVisibleTab() {
        if (this.displayer.getModel().size() == 0) {
            return -1;
        }
        return this.scroll().getLastVisibleTab(this.getTabsAreaWidth());
    }

    protected final int getFirstVisibleTab() {
        if (this.displayer.getModel().size() == 0) {
            return -1;
        }
        return this.scroll().getFirstVisibleTab(this.getTabsAreaWidth());
    }

    protected void install() {
        super.install();
        this.installControlButtons();
        ((ScrollingTabLayoutModel)this.layoutModel).setPixelsToAddToSelection(this.defaultRenderer.getPixelsToAddToSelection());
    }

    protected void uninstall() {
        super.uninstall();
        this.displayer.setLayout(null);
        this.displayer.removeAll();
    }

    protected LayoutManager createLayout() {
        return new WCLayout();
    }

    protected Component getControlButtons() {
        if (null == this.controlButtons) {
            JPanel buttonsPanel = new JPanel(null);
            buttonsPanel.setOpaque(false);
            int width = 0;
            int height = 0;
            Action a = this.scroll().getBackwardAction();
            a.putValue("control", this.displayer);
            this.btnScrollLeft = TabControlButtonFactory.createScrollLeftButton(this.displayer, a);
            buttonsPanel.add(this.btnScrollLeft);
            Icon icon = this.btnScrollLeft.getIcon();
            this.btnScrollLeft.setBounds(width, 0, icon.getIconWidth(), icon.getIconHeight());
            width += icon.getIconWidth();
            a = this.scroll().getForwardAction();
            a.putValue("control", this.displayer);
            this.btnScrollRight = TabControlButtonFactory.createScrollRightButton(this.displayer, a);
            buttonsPanel.add(this.btnScrollRight);
            icon = this.btnScrollRight.getIcon();
            this.btnScrollRight.setBounds(width, 0, icon.getIconWidth(), icon.getIconHeight());
            width += icon.getIconWidth();
            this.btnDropDown = TabControlButtonFactory.createDropDownButton(this.displayer);
            buttonsPanel.add(this.btnDropDown);
            icon = this.btnDropDown.getIcon();
            this.btnDropDown.setBounds(width += 3, 0, icon.getIconWidth(), icon.getIconHeight());
            width += icon.getIconWidth();
            height = icon.getIconHeight();
            if (null != this.displayer.getWinsysInfo()) {
                this.btnMaximizeRestore = TabControlButtonFactory.createMaximizeRestoreButton(this.displayer);
                buttonsPanel.add(this.btnMaximizeRestore);
                icon = this.btnMaximizeRestore.getIcon();
                this.btnMaximizeRestore.setBounds(width += 3, 0, icon.getIconWidth(), icon.getIconHeight());
                width += icon.getIconWidth();
            }
            Dimension size = new Dimension(width, height);
            buttonsPanel.setMinimumSize(size);
            buttonsPanel.setSize(size);
            buttonsPanel.setPreferredSize(size);
            buttonsPanel.setMaximumSize(size);
            this.controlButtons = buttonsPanel;
        }
        return this.controlButtons;
    }

    protected ComponentListener createComponentListener() {
        return new ScrollingDisplayerComponentListener();
    }

    protected void modelChanged() {
        int modelSize;
        this.scroll().clearCachedData();
        int index = this.selectionModel.getSelectedIndex();
        if (index >= this.scroll().getCachedFirstVisibleTab() && index < this.scroll().getCachedLastVisibleTab()) {
            this.makeTabVisible(this.selectionModel.getSelectedIndex());
        }
        if ((modelSize = this.displayer.getModel().size()) < this.lastKnownModelSize) {
            this.scroll().ensureAvailableSpaceUsed(true);
        }
        this.lastKnownModelSize = modelSize;
        super.modelChanged();
    }

    protected void installControlButtons() {
        this.displayer.setLayout(this.createLayout());
        this.displayer.add(this.getControlButtons());
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    protected final ScrollingTabLayoutModel scroll() {
        return (ScrollingTabLayoutModel)this.layoutModel;
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        int i = e.getWheelRotation();
        this.tabState.clearTransientStates();
        int offset = this.scroll().getOffset();
        if (i > 0 && offset < this.displayer.getModel().size() - 1) {
            if (this.scroll().isLastTabClipped()) {
                this.scroll().setOffset(offset + 1);
            }
        } else if (i < 0) {
            if (offset >= 0) {
                this.scroll().setOffset(offset - 1);
            }
        } else {
            return;
        }
        this.displayer.repaint();
    }

    public static Graphics2D getOffscreenGraphics() {
        BufferedImage result = null;
        if (ctx != null) {
            result = ctx.get();
        }
        if (result == null) {
            result = new BufferedImage(10, 10, 1);
            ctx = new SoftReference<BufferedImage>(result);
        }
        return (Graphics2D)result.getGraphics();
    }

    protected Rectangle getControlButtonsRectangle(Container parent) {
        Component c = this.getControlButtons();
        return new Rectangle(parent.getWidth() - c.getWidth(), 0, c.getWidth(), c.getHeight());
    }

    protected class ScrollingDisplayerComponentListener
    extends ComponentAdapter {
        protected ScrollingDisplayerComponentListener() {
        }

        public void componentResized(ComponentEvent e) {
            BasicScrollingTabDisplayerUI.this.makeTabVisible(BasicScrollingTabDisplayerUI.this.selectionModel.getSelectedIndex());
        }
    }

    protected class ScrollingHierarchyListener
    extends AbstractTabDisplayerUI.DisplayerHierarchyListener {
        protected ScrollingHierarchyListener() {
        }

        public void hierarchyChanged(HierarchyEvent e) {
            super.hierarchyChanged(e);
            if ((e.getChangeFlags() & 4L) != 0L && BasicScrollingTabDisplayerUI.this.displayer.isShowing() && BasicScrollingTabDisplayerUI.this.tabState != null && BasicScrollingTabDisplayerUI.this.selectionModel != null) {
                BasicScrollingTabDisplayerUI.this.tabState.setActive(BasicScrollingTabDisplayerUI.this.displayer.isActive());
                BasicScrollingTabDisplayerUI.this.makeTabVisible(BasicScrollingTabDisplayerUI.this.selectionModel.getSelectedIndex());
            }
        }
    }

    protected class ScrollingTabState
    extends BasicTabDisplayerUI.BasicTabState {
        protected ScrollingTabState() {
            super(BasicScrollingTabDisplayerUI.this);
        }

        public int getState(int tabIndex) {
            int result = super.getState(tabIndex);
            int first = BasicScrollingTabDisplayerUI.this.getFirstVisibleTab();
            int last = BasicScrollingTabDisplayerUI.this.getLastVisibleTab();
            if (tabIndex < first || tabIndex > last) {
                return 64;
            }
            if (first == last && first == tabIndex && BasicScrollingTabDisplayerUI.this.displayer.getModel().size() > 1) {
                result |= 3;
            } else if (BasicScrollingTabDisplayerUI.this.getTabsAreaWidth() < BasicScrollingTabDisplayerUI.this.scroll().getMinimumLeftClippedWidth() + BasicScrollingTabDisplayerUI.this.scroll().getMinimumRightClippedWidth() && tabIndex == first && last == first - 1 && BasicScrollingTabDisplayerUI.this.displayer.getModel().size() > 1 && BasicScrollingTabDisplayerUI.this.scroll().isLastTabClipped()) {
                result |= 2;
            } else {
                if (tabIndex == first && BasicScrollingTabDisplayerUI.this.scroll().getOffset() == first) {
                    result |= 2;
                }
                if (tabIndex == last && BasicScrollingTabDisplayerUI.this.scroll().isLastTabClipped()) {
                    result |= 1;
                }
            }
            return result;
        }
    }

    private class WCLayout
    implements LayoutManager {
        private WCLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            Rectangle r = BasicScrollingTabDisplayerUI.this.getControlButtonsRectangle(parent);
            Component c = BasicScrollingTabDisplayerUI.this.getControlButtons();
            c.setBounds(r);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return BasicScrollingTabDisplayerUI.this.getPreferredSize((JComponent)parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            return BasicScrollingTabDisplayerUI.this.getPreferredSize((JComponent)parent);
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

