/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

final class GtkEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final TabPainter leftClip = new GtkLeftClipPainter();
    private static final TabPainter rightClip = new GtkRightClipPainter();
    private static final TabPainter normal = new GtkPainter();
    private static JTabbedPane dummyTab;
    static final Color ATTENTION_COLOR;
    private static final Insets INSETS;

    public GtkEditorTabCellRenderer() {
        super(leftClip, normal, rightClip, new Dimension(28, 32));
    }

    public Color getSelectedForeground() {
        return UIManager.getColor("textText");
    }

    public Color getForeground() {
        return this.getSelectedForeground();
    }

    public int getPixelsToAddToSelection() {
        return 4;
    }

    protected int getCaptionYAdjustment() {
        return 0;
    }

    public Dimension getPadding() {
        Dimension d = super.getPadding();
        d.width = this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton") ? 28 : 14;
        return d;
    }

    private static void paintTabBackground(Graphics g, int index, int state, int x, int y, int w, int h) {
        if (dummyTab == null) {
            dummyTab = new JTabbedPane();
        }
        Region region = Region.TABBED_PANE_TAB;
        SynthLookAndFeel laf = (SynthLookAndFeel)UIManager.getLookAndFeel();
        SynthStyleFactory sf = laf.getStyleFactory();
        SynthStyle style = sf.getStyle(dummyTab, region);
        SynthContext context = new SynthContext(dummyTab, region, style, state);
        SynthPainter painter = style.getPainter(context);
        painter.paintTabbedPaneTabBackground(context, g, x, y, w, h, index);
    }

    static {
        ATTENTION_COLOR = new Color(255, 238, 120);
        INSETS = new Insets(0, 2, 0, 10);
    }

    private static class GtkLeftClipPainter
    implements TabPainter {
        private GtkLeftClipPainter() {
        }

        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        public Polygon getInteriorPolygon(Component c) {
            GtkEditorTabCellRenderer ren = (GtkEditorTabCellRenderer)c;
            Insets ins = this.getBorderInsets(c);
            Polygon p = new Polygon();
            int x = -3;
            int y = 1;
            int width = c.getWidth() + 3;
            int height = ren.isSelected() ? c.getHeight() + 2 : c.getHeight() - 1;
            p.addPoint(x, y);
            p.addPoint(x + width, y);
            p.addPoint(x + width, y + height);
            p.addPoint(x, y + height);
            return p;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }

        public void paintInterior(Graphics g, Component c) {
            GtkEditorTabCellRenderer ren = (GtkEditorTabCellRenderer)c;
            Polygon p = this.getInteriorPolygon(c);
            if (ren.isSelected()) {
                GtkEditorTabCellRenderer.paintTabBackground(g, 0, 512, p.getBounds().x, p.getBounds().y, p.getBounds().width, p.getBounds().height);
            } else {
                GtkEditorTabCellRenderer.paintTabBackground(g, 0, 0, p.getBounds().x, p.getBounds().y + 2, p.getBounds().width, p.getBounds().height - 2);
            }
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            rect.setBounds(-20, -20, 0, 0);
        }

        public boolean supportsCloseButton(JComponent renderer) {
            return false;
        }
    }

    private static class GtkPainter
    implements TabPainter {
        private GtkPainter() {
        }

        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        public Polygon getInteriorPolygon(Component c) {
            GtkEditorTabCellRenderer ren = (GtkEditorTabCellRenderer)c;
            Insets ins = this.getBorderInsets(c);
            Polygon p = new Polygon();
            int x = ren.isLeftmost() ? 1 : 0;
            int y = 1;
            int width = ren.isLeftmost() ? c.getWidth() - 1 : c.getWidth();
            int height = ren.isSelected() ? c.getHeight() + 2 : c.getHeight() - 1;
            p.addPoint(x, y);
            p.addPoint(x + width, y);
            p.addPoint(x + width, y + height);
            p.addPoint(x, y + height);
            return p;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            GtkEditorTabCellRenderer ren = (GtkEditorTabCellRenderer)c;
            Polygon p = this.getInteriorPolygon(c);
        }

        public void paintInterior(Graphics g, Component c) {
            GtkEditorTabCellRenderer ren = (GtkEditorTabCellRenderer)c;
            Polygon p = this.getInteriorPolygon(c);
            if (ren.isSelected()) {
                GtkEditorTabCellRenderer.paintTabBackground(g, 0, 512, p.getBounds().x, p.getBounds().y, p.getBounds().width, p.getBounds().height);
            } else {
                GtkEditorTabCellRenderer.paintTabBackground(g, 0, 0, p.getBounds().x, p.getBounds().y + 2, p.getBounds().width, p.getBounds().height - 2);
            }
            if (!this.supportsCloseButton((JComponent)c)) {
                return;
            }
            this.paintCloseButton(g, (JComponent)c);
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            boolean notSupported;
            boolean rightClip = ((GtkEditorTabCellRenderer)jc).isClipRight();
            boolean leftClip = ((GtkEditorTabCellRenderer)jc).isClipLeft();
            boolean bl = notSupported = !((GtkEditorTabCellRenderer)jc).isShowCloseButton();
            if (leftClip || rightClip || notSupported) {
                rect.x = -100;
                rect.y = -100;
                rect.width = 0;
                rect.height = 0;
            } else {
                String iconPath = this.findIconPath((GtkEditorTabCellRenderer)jc);
                Icon icon = TabControlButtonFactory.getIcon(iconPath);
                int iconWidth = icon.getIconWidth();
                int iconHeight = icon.getIconHeight();
                rect.x = bounds.x + bounds.width - iconWidth - 2;
                rect.y = bounds.y + Math.max(0, bounds.height / 2 - iconHeight / 2);
                rect.width = iconWidth;
                rect.height = iconHeight;
            }
        }

        private void paintCloseButton(Graphics g, JComponent c) {
            if (((AbstractTabCellRenderer)c).isShowCloseButton()) {
                Rectangle r = new Rectangle(0, 0, c.getWidth(), c.getHeight());
                Rectangle cbRect = new Rectangle();
                this.getCloseButtonRectangle(c, cbRect, r);
                String iconPath = this.findIconPath((GtkEditorTabCellRenderer)c);
                Icon icon = TabControlButtonFactory.getIcon(iconPath);
                icon.paintIcon(c, g, cbRect.x, cbRect.y);
            }
        }

        private String findIconPath(GtkEditorTabCellRenderer renderer) {
            if (renderer.inCloseButton() && renderer.isPressed()) {
                return "org/netbeans/swing/tabcontrol/resources/gtk_close_pressed.png";
            }
            if (renderer.inCloseButton()) {
                return "org/netbeans/swing/tabcontrol/resources/gtk_close_rollover.png";
            }
            return "org/netbeans/swing/tabcontrol/resources/gtk_close_enabled.png";
        }

        public boolean supportsCloseButton(JComponent renderer) {
            return ((AbstractTabCellRenderer)renderer).isShowCloseButton();
        }
    }

    private static class GtkRightClipPainter
    implements TabPainter {
        private GtkRightClipPainter() {
        }

        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Polygon getInteriorPolygon(Component c) {
            GtkEditorTabCellRenderer ren = (GtkEditorTabCellRenderer)c;
            Insets ins = this.getBorderInsets(c);
            Polygon p = new Polygon();
            int x = 0;
            int y = 1;
            int width = c.getWidth() + 10;
            int height = ren.isSelected() ? c.getHeight() + 2 : c.getHeight() - 1;
            p.addPoint(x, y);
            p.addPoint(x + width, y);
            p.addPoint(x + width, y + height);
            p.addPoint(x, y + height);
            return p;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }

        public void paintInterior(Graphics g, Component c) {
            GtkEditorTabCellRenderer ren = (GtkEditorTabCellRenderer)c;
            Polygon p = this.getInteriorPolygon(c);
            if (ren.isSelected()) {
                GtkEditorTabCellRenderer.paintTabBackground(g, 0, 512, p.getBounds().x, p.getBounds().y, p.getBounds().width, p.getBounds().height);
            } else {
                GtkEditorTabCellRenderer.paintTabBackground(g, 0, 0, p.getBounds().x, p.getBounds().y + 2, p.getBounds().width, p.getBounds().height - 2);
            }
        }

        public boolean supportsCloseButton(JComponent renderer) {
            return false;
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            rect.setBounds(-20, -20, 0, 0);
        }
    }
}

