/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.codetemplates.AbbrevSettings;
import org.netbeans.lib.editor.codetemplates.CodeTemplateApiPackageAccessor;
import org.netbeans.lib.editor.codetemplates.ParametrizedTextParser;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class CodeTemplateCompletionItem
implements CompletionItem {
    private static ImageIcon icon;
    private final CodeTemplate codeTemplate;
    private String leftText;
    static /* synthetic */ Class class$org$netbeans$lib$editor$codetemplates$CodeTemplateCompletionItem;

    public static String toHtmlText(String text) {
        StringBuffer htmlText = null;
        for (int i = 0; i < text.length(); ++i) {
            String rep;
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    rep = "&lt;";
                    break;
                }
                case '>': {
                    rep = "&gt;";
                    break;
                }
                case '\n': {
                    rep = "<br>";
                    break;
                }
                default: {
                    rep = null;
                }
            }
            if (rep != null) {
                if (htmlText == null) {
                    htmlText = new StringBuffer(120 * text.length() / 100);
                    if (i > 0) {
                        htmlText.append(text.substring(0, i));
                    }
                }
                htmlText.append(rep);
                continue;
            }
            if (htmlText == null) continue;
            htmlText.append(ch);
        }
        return htmlText != null ? htmlText.toString() : text;
    }

    public CodeTemplateCompletionItem(CodeTemplate codeTemplate) {
        this.codeTemplate = codeTemplate;
    }

    private String getLeftText() {
        return this.codeTemplate.getDescription();
    }

    private String getRightText() {
        if (this.leftText == null) {
            this.leftText = CodeTemplateCompletionItem.toHtmlText(this.codeTemplate.getAbbreviation());
        }
        return this.leftText;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftText(), (String)this.getRightText(), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        if (icon == null) {
            icon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/lib/editor/codetemplates/resources/code_template.png"));
        }
        CompletionUtilities.renderHtml((ImageIcon)icon, (String)this.getLeftText(), (String)this.getRightText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public void defaultAction(JTextComponent component) {
        Completion.get().hideAll();
        Document doc = component.getDocument();
        int caretOffset = component.getSelectionStart();
        int initMatchLen = CodeTemplateCompletionItem.getInitialMatchLength(doc, caretOffset, this.codeTemplate.getParametrizedText());
        if (initMatchLen > 0) {
            try {
                doc.remove(caretOffset - initMatchLen, initMatchLen);
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
        }
        this.codeTemplate.insert(component);
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public boolean instantSubstitution(JTextComponent component) {
        return false;
    }

    public static int getInitialMatchLength(Document doc, int caretOffset, String text) {
        int matchLength;
        CharSequence docText = DocumentUtilities.getText((Document)((BaseDocument)doc));
        for (matchLength = Math.min(text.length(), caretOffset); matchLength > 0; --matchLength) {
            int i;
            for (i = 1; i < matchLength && docText.charAt(caretOffset - i) == text.charAt(matchLength - i); ++i) {
            }
            if (i == matchLength) break;
        }
        return matchLength;
    }

    public CompletionTask createDocumentationTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(this.codeTemplate));
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getSortPriority() {
        return 650;
    }

    public CharSequence getSortText() {
        return "";
    }

    public CharSequence getInsertPrefix() {
        String insertPrefix = this.codeTemplate.getParametrizedText();
        int dollarIndex = insertPrefix.indexOf("${");
        if (dollarIndex >= 0) {
            insertPrefix = insertPrefix.substring(0, dollarIndex);
        }
        return insertPrefix;
    }

    private static final class DocItem
    implements CompletionDocumentation {
        private CodeTemplate codeTemplate;
        private String text;

        DocItem(CodeTemplate codeTemplate) {
            this.codeTemplate = codeTemplate;
            this.text = this.createText();
        }

        public String getText() {
            return this.text;
        }

        private String createText() {
            StringBuffer htmlText = new StringBuffer("<html><pre>");
            ParametrizedTextParser parser = new ParametrizedTextParser(null, this.codeTemplate.getParametrizedText());
            parser.parse();
            parser.appendHtmlText(htmlText);
            htmlText.append("</pre><br>");
            String mimeType = CodeTemplateApiPackageAccessor.get().getOperation(this.codeTemplate).getMimeType();
            htmlText.append(NbBundle.getMessage((Class)(class$org$netbeans$lib$editor$codetemplates$CodeTemplateCompletionItem == null ? (class$org$netbeans$lib$editor$codetemplates$CodeTemplateCompletionItem = CodeTemplateCompletionItem.class$("org.netbeans.lib.editor.codetemplates.CodeTemplateCompletionItem")) : class$org$netbeans$lib$editor$codetemplates$CodeTemplateCompletionItem), (String)"DOC_ITEM_Abbreviation", (Object)CodeTemplateCompletionItem.toHtmlText(this.codeTemplate.getAbbreviation()), (Object)AbbrevSettings.get(mimeType).getExpandKeyStrokeText()));
            return htmlText.toString();
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public URL getURL() {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static final class DocQuery
    extends AsyncCompletionQuery {
        private CodeTemplate codeTemplate;

        DocQuery(CodeTemplate codeTemplate) {
            this.codeTemplate = codeTemplate;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            resultSet.setDocumentation((CompletionDocumentation)new DocItem(this.codeTemplate));
            resultSet.finish();
        }
    }
}

