/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.codetemplates.CodeTemplateDrawLayer;
import org.netbeans.lib.editor.codetemplates.CodeTemplateOverrideAction;
import org.netbeans.lib.editor.codetemplates.CodeTemplateParameterImpl;
import org.netbeans.lib.editor.codetemplates.CodeTemplateSpiPackageAccessor;
import org.netbeans.lib.editor.codetemplates.ParametrizedTextParser;
import org.netbeans.lib.editor.codetemplates.SyncDocumentRegion;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateInsertRequest;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.openide.ErrorManager;

public final class CodeTemplateInsertHandler
implements DocumentListener,
KeyListener {
    private static final Object EDITING_TEMPLATE_DOC_PROPERTY;
    private final CodeTemplate codeTemplate;
    private final JTextComponent component;
    private final List processors;
    private String parametrizedText;
    private ParametrizedTextParser parametrizedTextParser;
    private String insertText;
    private List allParameters;
    private List allParametersUnmodifiable;
    private List masters;
    private List mastersUnmodifiable;
    private List editableMasters;
    private CodeTemplateInsertRequest request;
    private boolean inserted;
    private boolean released;
    private Position caretPosition;
    private int activeMasterIndex;
    private ActionMap componentOrigActionMap;
    private List drawLayers;
    private Document doc;
    private MutablePositionRegion positionRegion;
    private boolean nestedTemplateExpanding;
    private CodeTemplateParameterImpl apiSetValueParamImpl;
    private int lastActiveRegionStartOffset;
    private int lastActiveRegionEndOffset;
    private boolean activeMasterModified;
    private boolean syncingDocModification;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CodeTemplateInsertHandler(CodeTemplate codeTemplate, JTextComponent component, Collection processorFactories) {
        this.codeTemplate = codeTemplate;
        this.component = component;
        Position zeroPos = PositionRegion.createFixedPosition((int)0);
        this.positionRegion = new MutablePositionRegion(zeroPos, zeroPos);
        CodeTemplateInsertRequest.class.getClass().getName();
        this.request = CodeTemplateSpiPackageAccessor.get().createInsertRequest(this);
        this.processors = new ArrayList();
        Iterator it = processorFactories.iterator();
        while (it.hasNext()) {
            CodeTemplateProcessorFactory factory = (CodeTemplateProcessorFactory)it.next();
            this.processors.add(factory.createProcessor(this.request));
        }
        this.setParametrizedText(codeTemplate.getParametrizedText());
    }

    public CodeTemplate getCodeTemplate() {
        return this.codeTemplate;
    }

    public JTextComponent getComponent() {
        return this.component;
    }

    public CodeTemplateInsertRequest getRequest() {
        return this.request;
    }

    public synchronized boolean isInserted() {
        return this.inserted;
    }

    private synchronized void markInserted() {
        this.inserted = true;
        this.resetCachedInsertText();
    }

    public synchronized boolean isReleased() {
        return this.released;
    }

    public String getParametrizedText() {
        return this.parametrizedText;
    }

    public void setParametrizedText(String parametrizedText) {
        this.parametrizedText = parametrizedText;
        this.parseParametrizedText();
    }

    public int getInsertOffset() {
        return this.positionRegion.getStartOffset();
    }

    public String getInsertText() {
        if (this.inserted) {
            try {
                int startOffset = this.positionRegion.getStartOffset();
                return this.doc.getText(startOffset, this.positionRegion.getEndOffset() - startOffset);
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return "";
            }
        }
        this.checkInsertTextBuilt();
        return this.insertText;
    }

    public List getAllParameters() {
        return this.allParametersUnmodifiable;
    }

    public List getMasterParameters() {
        return this.mastersUnmodifiable;
    }

    public void processTemplate() {
        Iterator it = this.processors.iterator();
        while (it.hasNext()) {
            CodeTemplateProcessor processor = (CodeTemplateProcessor)it.next();
            processor.updateDefaultValues();
        }
        this.insertTemplate();
        this.installActions();
    }

    void checkInsertTextBuilt() {
        if (this.insertText == null) {
            this.insertText = this.buildInsertText();
        }
    }

    void resetCachedInsertText() {
        this.insertText = null;
    }

    CodeTemplateParameter getActiveMaster() {
        return this.activeMasterIndex < this.editableMasters.size() ? (CodeTemplateParameter)this.editableMasters.get(this.activeMasterIndex) : null;
    }

    CodeTemplateParameterImpl getActiveMasterImpl() {
        CodeTemplateParameter master = this.getActiveMaster();
        return master != null ? CodeTemplateInsertHandler.paramImpl(master) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTemplate() {
        this.doc = this.component.getDocument();
        this.nestedTemplateExpanding = Boolean.TRUE.equals(this.doc.getProperty(EDITING_TEMPLATE_DOC_PROPERTY));
        String completeInsertString = this.getInsertText();
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).atomicLock();
        }
        try {
            BaseDocument bdoc;
            Formatter formatter;
            Caret caret = this.component.getCaret();
            if (caret.isSelectionVisible()) {
                int removeOffset = this.component.getSelectionStart();
                int removeLength = this.component.getSelectionEnd() - removeOffset;
                this.doc.remove(removeOffset, removeLength);
            }
            int insertOffset = this.component.getCaretPosition();
            int docLen = this.doc.getLength();
            this.doc.insertString(insertOffset, completeInsertString, null);
            Iterator it = this.request.getMasterParameters().iterator();
            while (it.hasNext()) {
                CodeTemplateParameter parameter = (CodeTemplateParameter)it.next();
                if ("cursor".equals(parameter.getName())) {
                    this.caretPosition = this.doc.createPosition(insertOffset + parameter.getInsertTextOffset());
                    CodeTemplateParameterImpl paramImpl = CodeTemplateParameterImpl.get(parameter);
                    paramImpl.resetPositions(this.caretPosition, this.caretPosition);
                    continue;
                }
                ArrayList parameterRegions = new ArrayList(4);
                this.addParameterRegion(parameterRegions, parameter, this.doc, insertOffset);
                Iterator slaveIt = parameter.getSlaves().iterator();
                while (slaveIt.hasNext()) {
                    CodeTemplateParameter slaveParameter = (CodeTemplateParameter)slaveIt.next();
                    this.addParameterRegion(parameterRegions, slaveParameter, this.doc, insertOffset);
                }
                SyncDocumentRegion region = new SyncDocumentRegion(this.doc, parameterRegions);
                CodeTemplateInsertHandler.paramImpl(parameter).setRegion(region);
            }
            this.positionRegion.reset(this.doc.createPosition(insertOffset), this.doc.createPosition(insertOffset + (this.doc.getLength() - docLen)));
            if (this.caretPosition == null) {
                this.caretPosition = this.doc.createPosition(insertOffset + completeInsertString.length());
            }
            if (this.parametrizedText.indexOf(10) != -1 && this.doc instanceof BaseDocument && (formatter = (bdoc = (BaseDocument)this.doc).getFormatter()) != null) {
                formatter.reformat(bdoc, insertOffset, insertOffset + completeInsertString.length());
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        finally {
            if (this.doc instanceof BaseDocument) {
                ((BaseDocument)this.doc).atomicUnlock();
            }
            this.markInserted();
        }
    }

    public void installActions() {
        if (!this.nestedTemplateExpanding && this.editableMasters.size() > 0) {
            this.doc.putProperty(EDITING_TEMPLATE_DOC_PROPERTY, Boolean.TRUE);
            if (this.doc instanceof BaseDocument) {
                ((BaseDocument)this.doc).setPostModificationDocumentListener((DocumentListener)this);
                this.updateLastRegionBounds();
            }
            this.componentOrigActionMap = CodeTemplateOverrideAction.installOverrideActionMap(this.component, this);
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.component);
            this.drawLayers = new ArrayList(this.editableMasters.size());
            Iterator it = this.editableMasters.iterator();
            while (it.hasNext()) {
                CodeTemplateParameterImpl paramImpl = CodeTemplateInsertHandler.paramImpl((CodeTemplateParameter)it.next());
                CodeTemplateDrawLayer drawLayer = new CodeTemplateDrawLayer(paramImpl);
                this.drawLayers.add(drawLayer);
                editorUI.addLayer((DrawLayer)drawLayer, 5000);
            }
            this.component.addKeyListener(this);
            this.tabUpdate();
        } else {
            this.forceCaretPosition();
            this.release();
        }
    }

    public void defaultKeyTypedAction(ActionEvent evt, Action origAction) {
        origAction.actionPerformed(evt);
    }

    public void tabAction(ActionEvent evt, Action origAction) {
        this.checkNotifyParameterUpdate();
        ++this.activeMasterIndex;
        this.activeMasterIndex %= this.editableMasters.size();
        this.tabUpdate();
    }

    public void shiftTabAction(ActionEvent evt) {
        this.checkNotifyParameterUpdate();
        if (this.activeMasterIndex-- == 0) {
            this.activeMasterIndex = this.editableMasters.size() - 1;
        }
        this.tabUpdate();
    }

    public void enterAction(ActionEvent evt) {
        this.checkNotifyParameterUpdate();
        ++this.activeMasterIndex;
        if (this.activeMasterIndex == this.editableMasters.size()) {
            this.forceCaretPosition();
            this.release();
        } else {
            this.tabUpdate();
        }
    }

    void undoAction(ActionEvent evt) {
    }

    void redoAction(ActionEvent evt) {
    }

    public String getDocParameterValue(CodeTemplateParameterImpl paramImpl) {
        String parameterText;
        MutablePositionRegion positionRegion = paramImpl.getPositionRegion();
        int offset = positionRegion.getStartOffset();
        try {
            parameterText = this.doc.getText(offset, positionRegion.getEndOffset() - offset);
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            parameterText = null;
        }
        return parameterText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocParameterValue(CodeTemplateParameterImpl paramImpl, String newValue) {
        if (!$assertionsDisabled && paramImpl == this.getActiveMasterImpl()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && paramImpl.isSlave()) {
            throw new AssertionError();
        }
        SyncDocumentRegion region = paramImpl.getRegion();
        if (!$assertionsDisabled && region == null) {
            throw new AssertionError();
        }
        int offset = region.getFirstRegionStartOffset();
        int length = region.getFirstRegionLength();
        this.apiSetValueParamImpl = paramImpl;
        try {
            CharSequence parameterText = DocumentUtilities.getText((Document)this.doc, (int)offset, (int)length);
            if (!CharSequenceUtilities.textEquals((CharSequence)parameterText, (CharSequence)newValue)) {
                this.doc.remove(offset, length);
                this.doc.insertString(offset, newValue, null);
                region.sync(newValue.length());
                paramImpl.setValue(newValue, false);
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        finally {
            this.apiSetValueParamImpl = null;
        }
    }

    public void insertUpdate(DocumentEvent evt) {
        int insertLength;
        int offset = evt.getOffset();
        if (offset + (insertLength = evt.getLength()) == this.caretPosition.getOffset()) {
            try {
                this.caretPosition = this.doc.createPosition(offset);
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        if (!this.syncingDocModification) {
            this.syncingDocModification = true;
            this.syncInsert(evt);
            this.syncingDocModification = false;
        }
    }

    public void removeUpdate(DocumentEvent evt) {
        if (!this.syncingDocModification) {
            this.syncingDocModification = true;
            this.syncRemove(evt);
            this.syncingDocModification = false;
        }
    }

    public void changedUpdate(DocumentEvent evt) {
    }

    public void keyPressed(KeyEvent e) {
        if (KeyStroke.getKeyStroke(27, 0).equals(KeyStroke.getKeyStrokeForEvent(e))) {
            this.release();
            e.consume();
        } else if (KeyStroke.getKeyStroke(10, 0).equals(KeyStroke.getKeyStrokeForEvent(e)) && (this.getActiveMaster() == null || !this.isManagedInsert(this.component.getCaretPosition()))) {
            this.checkNotifyParameterUpdate();
            this.release();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private void forceCaretPosition() {
        this.component.setCaretPosition(this.caretPosition.getOffset());
    }

    private void notifyParameterUpdate(CodeTemplateParameter parameter, boolean typingChange) {
        Iterator it = this.processors.iterator();
        while (it.hasNext()) {
            CodeTemplateProcessor processor = (CodeTemplateProcessor)it.next();
            processor.parameterValueChanged(parameter, typingChange);
        }
    }

    private void checkNotifyParameterUpdate() {
        if (this.activeMasterModified) {
            this.activeMasterModified = false;
            this.notifyParameterUpdate(this.getActiveMaster(), false);
        }
    }

    private void parseParametrizedText() {
        this.allParameters = new ArrayList(2);
        this.allParametersUnmodifiable = Collections.unmodifiableList(this.allParameters);
        this.masters = new ArrayList(2);
        this.mastersUnmodifiable = Collections.unmodifiableList(this.masters);
        this.editableMasters = new ArrayList(2);
        this.parametrizedTextParser = new ParametrizedTextParser(this, this.parametrizedText);
        this.parametrizedTextParser.parse();
    }

    void notifyParameterParsed(CodeTemplateParameterImpl paramImpl) {
        this.allParameters.add(paramImpl.getParameter());
        this.checkSlave(paramImpl.getParameter());
    }

    private void checkSlave(CodeTemplateParameter parameter) {
        Iterator it = this.getMasterParameters().iterator();
        while (it.hasNext()) {
            CodeTemplateParameter master = (CodeTemplateParameter)it.next();
            if (!master.getName().equals(parameter.getName())) continue;
            CodeTemplateInsertHandler.paramImpl(parameter).markSlave(master);
            return;
        }
        this.masters.add(parameter);
        if (parameter.isEditable()) {
            this.editableMasters.add(parameter);
        }
    }

    private static CodeTemplateParameterImpl paramImpl(CodeTemplateParameter param) {
        return CodeTemplateSpiPackageAccessor.get().getImpl(param);
    }

    private void tabUpdate() {
        this.updateLastRegionBounds();
        SyncDocumentRegion active = this.getActiveMasterImpl().getRegion();
        this.component.select(active.getFirstRegionStartOffset(), active.getFirstRegionEndOffset());
        this.requestRepaint();
    }

    private void requestRepaint() {
        int startOffset = Integer.MAX_VALUE;
        int endOffset = 0;
        Iterator it = this.editableMasters.iterator();
        while (it.hasNext()) {
            SyncDocumentRegion region = CodeTemplateInsertHandler.paramImpl((CodeTemplateParameter)it.next()).getRegion();
            startOffset = Math.min(startOffset, region.getSortedRegion(0).getStartOffset());
            endOffset = Math.max(endOffset, region.getSortedRegion(region.getRegionCount() - 1).getEndOffset());
        }
        JTextComponent component = this.getComponent();
        if (endOffset != 0) {
            component.getUI().damageRange(component, startOffset, endOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        CodeTemplateInsertHandler codeTemplateInsertHandler = this;
        synchronized (codeTemplateInsertHandler) {
            if (this.released) {
                return;
            }
            this.released = true;
        }
        if (!this.nestedTemplateExpanding && this.editableMasters.size() > 0) {
            if (this.doc instanceof BaseDocument) {
                ((BaseDocument)this.doc).setPostModificationDocumentListener(null);
            }
            this.doc.putProperty(EDITING_TEMPLATE_DOC_PROPERTY, Boolean.FALSE);
            this.component.removeKeyListener(this);
            JTextComponent component = this.getComponent();
            component.setActionMap(this.componentOrigActionMap);
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)component);
            if (editorUI != null) {
                Iterator it = this.drawLayers.iterator();
                while (it.hasNext()) {
                    DrawLayer drawLayer = (DrawLayer)it.next();
                    editorUI.removeLayer(drawLayer.getName());
                }
            }
            component.putClientProperty("text-frame-start-position", null);
            component.putClientProperty("text-frame-end-position", null);
            this.requestRepaint();
        }
        Iterator it = this.processors.iterator();
        while (it.hasNext()) {
            CodeTemplateProcessor processor = (CodeTemplateProcessor)it.next();
            processor.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncInsert(DocumentEvent evt) {
        int offset = evt.getOffset();
        int insertLength = evt.getLength();
        CodeTemplateParameterImpl activeMasterImpl = this.getActiveMasterImpl();
        if (this.apiSetValueParamImpl == null && activeMasterImpl != null) {
            SyncDocumentRegion region = activeMasterImpl.getRegion();
            if (this.isManagedInsert(offset)) {
                this.doc.putProperty("abbrev-ignore-modification", Boolean.TRUE);
                try {
                    region.sync(offset == this.lastActiveRegionStartOffset ? insertLength : 0);
                }
                finally {
                    this.doc.putProperty("abbrev-ignore-modification", Boolean.FALSE);
                }
                activeMasterImpl.setValue(this.getDocParameterValue(activeMasterImpl), false);
                activeMasterImpl.markUserModified();
                this.notifyParameterUpdate(activeMasterImpl.getParameter(), true);
            } else if (DocumentUtilities.isTypingModification((DocumentEvent)evt)) {
                this.release();
            }
        }
        this.updateLastRegionBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncRemove(DocumentEvent evt) {
        CodeTemplateParameterImpl activeMasterImpl = this.getActiveMasterImpl();
        if (this.apiSetValueParamImpl == null && activeMasterImpl != null) {
            SyncDocumentRegion region = activeMasterImpl.getRegion();
            if (this.isManagedRemove(evt.getOffset(), evt.getLength())) {
                this.doc.putProperty("abbrev-ignore-modification", Boolean.TRUE);
                try {
                    region.sync(0);
                }
                finally {
                    this.doc.putProperty("abbrev-ignore-modification", Boolean.FALSE);
                }
                activeMasterImpl.setValue(this.getDocParameterValue(activeMasterImpl), false);
                activeMasterImpl.markUserModified();
                if (this.doc.getProperty("doc-replace-selection-property") == null) {
                    this.notifyParameterUpdate(activeMasterImpl.getParameter(), true);
                }
            } else if (DocumentUtilities.isTypingModification((DocumentEvent)evt)) {
                this.release();
            }
        }
        this.updateLastRegionBounds();
    }

    private void updateLastRegionBounds() {
        CodeTemplateParameterImpl masterImpl = this.getActiveMasterImpl();
        if (masterImpl != null) {
            SyncDocumentRegion region = masterImpl.getRegion();
            this.lastActiveRegionStartOffset = region.getFirstRegionStartOffset();
            this.lastActiveRegionEndOffset = region.getFirstRegionEndOffset();
        } else {
            this.lastActiveRegionStartOffset = -1;
            this.lastActiveRegionEndOffset = -1;
        }
    }

    private boolean isManagedInsert(int offset) {
        return offset >= this.lastActiveRegionStartOffset && offset <= this.lastActiveRegionEndOffset;
    }

    private boolean isManagedRemove(int offset, int length) {
        return offset >= this.lastActiveRegionStartOffset && offset + length <= this.lastActiveRegionEndOffset;
    }

    private void addParameterRegion(List parameterRegions, CodeTemplateParameter parameter, Document doc, int insertOffset) throws BadLocationException {
        int startOffset = insertOffset + parameter.getInsertTextOffset();
        BaseDocument bdoc = (BaseDocument)doc;
        Position startPos = bdoc.createPosition(startOffset);
        Position endPos = doc.createPosition(startOffset + parameter.getValue().length());
        CodeTemplateParameterImpl paramImpl = CodeTemplateParameterImpl.get(parameter);
        paramImpl.resetPositions(startPos, endPos);
        parameterRegions.add(paramImpl.getPositionRegion());
    }

    private String buildInsertText() {
        return this.parametrizedTextParser.buildInsertText(this.allParameters);
    }

    static {
        $assertionsDisabled = !CodeTemplateInsertHandler.class.desiredAssertionStatus();
        EDITING_TEMPLATE_DOC_PROPERTY = "processing-code-template";
    }
}

