/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.codetemplates.CodeTemplateManagerOperation;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class SurroundWithFix
implements Fix {
    private static String SURROUND_WITH = NbBundle.getMessage((Class)SurroundWithFix.class, (String)"TXT_SurroundWithHint_Prefix");
    private CodeTemplate template;
    private JTextComponent component;

    public static List getFixes(JTextComponent component) {
        ArrayList<SurroundWithFix> fixes = new ArrayList<SurroundWithFix>();
        Document doc = component.getDocument();
        CodeTemplateManagerOperation op = CodeTemplateManagerOperation.get(doc);
        op.waitLoaded();
        Collection filters = op.getTemplateFilters(component, component.getSelectionStart());
        Iterator it = op.findSelectionTemplates().iterator();
        while (it.hasNext()) {
            CodeTemplate template = (CodeTemplate)it.next();
            if (!SurroundWithFix.accept(template, filters)) continue;
            fixes.add(new SurroundWithFix(template, component));
        }
        return fixes;
    }

    private SurroundWithFix(CodeTemplate template, JTextComponent component) {
        this.template = template;
        this.component = component;
    }

    public String getText() {
        return SURROUND_WITH + this.template.getDescription();
    }

    public ChangeInfo implement() {
        this.template.insert(this.component);
        return null;
    }

    private static boolean accept(CodeTemplate template, Collection filters) {
        Iterator it = filters.iterator();
        while (it.hasNext()) {
            CodeTemplateFilter filter = (CodeTemplateFilter)it.next();
            if (filter.accept(template)) continue;
            return false;
        }
        return true;
    }
}

