/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.warmup;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class MenuWarmUpTask
implements Runnable {
    private Component[] comps;

    public void run() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Frame main = WindowManager.getDefault().getMainWindow();
                    assert (main != null);
                    main.addWindowListener(new NbWindowsAdapter());
                    if (main instanceof JFrame) {
                        MenuWarmUpTask.access$102(MenuWarmUpTask.this, ((JFrame)main).getJMenuBar().getComponents());
                    }
                }
            });
        }
        catch (Exception e) {
            return;
        }
        if (this.comps != null) {
            this.walkMenu(this.comps);
            this.comps = null;
        }
    }

    private void walkMenu(Component[] items) {
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] instanceof JMenu)) continue;
            try {
                Class<?> cls = items[i].getClass();
                Method m = cls.getDeclaredMethod("doInitialize", new Class[0]);
                m.setAccessible(true);
                m.invoke((Object)items[i], new Object[0]);
                this.walkMenu(((JMenu)items[i]).getMenuComponents());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Component[] access$102(MenuWarmUpTask x0, Component[] x1) {
        x0.comps = x1;
        return x1;
    }

    private static class NbWindowsAdapter
    extends WindowAdapter
    implements Runnable {
        private static final RequestProcessor rp = new RequestProcessor("Refresh-After-WindowActivated");
        private RequestProcessor.Task task = null;
        private static FileSystem[] fileSystems;

        private NbWindowsAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowActivated(WindowEvent e) {
            RequestProcessor requestProcessor = rp;
            synchronized (requestProcessor) {
                if (this.task != null) {
                    this.task.cancel();
                } else {
                    this.task = rp.create((Runnable)this);
                }
                this.task.schedule(1500);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowDeactivated(WindowEvent e) {
            RequestProcessor requestProcessor = rp;
            synchronized (requestProcessor) {
                if (this.task != null) {
                    this.task.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FileSystem[] all = NbWindowsAdapter.getFileSystems();
            for (int i = 0; i < all.length; ++i) {
                FileSystem fileSystem = all[i];
                fileSystem.refresh(false);
            }
            RequestProcessor requestProcessor = rp;
            synchronized (requestProcessor) {
                this.task = null;
            }
        }

        private static FileSystem[] getFileSystems() {
            if (fileSystems != null) {
                return fileSystems;
            }
            File[] roots = File.listRoots();
            LinkedHashSet<FileSystem> allRoots = new LinkedHashSet<FileSystem>();
            assert (roots != null && roots.length > 0) : "Could not list file roots";
            for (int i = 0; i < roots.length; ++i) {
                File root = roots[i];
                FileObject random = FileUtil.toFileObject((File)root);
                if (random == null) continue;
                try {
                    FileSystem fs = random.getFileSystem();
                    allRoots.add(fs);
                    if (fs == null) continue;
                    break;
                }
                catch (FileStateInvalidException e) {
                    throw new AssertionError((Object)e);
                }
            }
            FileSystem[] retVal = new FileSystem[allRoots.size()];
            allRoots.toArray(retVal);
            fileSystems = retVal;
            return retVal;
        }
    }
}

