/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.tools.JavaCompiler;

public class ToolProvider {
    private ToolProvider() {
    }

    public static JavaCompiler getSystemJavaCompiler() {
        if (Lazy.compilerClass == null) {
            return null;
        }
        try {
            return Lazy.compilerClass.newInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static ClassLoader getSystemToolClassLoader() {
        if (Lazy.compilerClass == null) {
            return null;
        }
        return Lazy.compilerClass.getClassLoader();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Lazy {
        private static final String defaultJavaCompilerName = "com.sun.tools.javac.api.JavacTool";
        private static final String[] defaultToolsLocation = new String[]{"lib", "tools.jar"};
        static final Class<? extends JavaCompiler> compilerClass;

        Lazy() {
        }

        private static Class<?> findClass() throws MalformedURLException, ClassNotFoundException {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return Lazy.enableAsserts(Class.forName(defaultJavaCompilerName, false, cl));
            }
            catch (ClassNotFoundException e) {
                File file = new File(System.getProperty("java.home"));
                if (file.getName().equalsIgnoreCase("jre")) {
                    file = file.getParentFile();
                }
                for (String name : defaultToolsLocation) {
                    file = new File(file, name);
                }
                URL[] urls = new URL[]{file.toURI().toURL()};
                URLClassLoader cl = URLClassLoader.newInstance(urls);
                cl.setPackageAssertionStatus("com.sun.tools.javac", true);
                return Class.forName(defaultJavaCompilerName, false, cl);
            }
        }

        private static Class<?> enableAsserts(Class<?> cls) {
            try {
                ClassLoader loader = cls.getClassLoader();
                if (loader != null) {
                    loader.setPackageAssertionStatus("com.sun.tools.javac", true);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return cls;
        }

        static {
            Class<JavaCompiler> c = null;
            try {
                c = Lazy.findClass().asSubclass(JavaCompiler.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            compilerClass = c;
        }
    }
}

