/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.imageio.ImageIO;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.openide.awt.Mnemonics;
import org.openide.awt.SwingBrowserImpl;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HtmlBrowser
extends JPanel {
    private static final long serialVersionUID = 2912844785502987960L;
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 600;
    private static Factory browserFactory;
    private static String homePage;
    private Icon iBack;
    private Icon iForward;
    private Icon iHome;
    private Icon iReload;
    private Icon iStop;
    private Icon iHistory;
    final Impl browserImpl;
    private boolean everythinkIListenInCheckBoxIsUnimportant = false;
    private boolean toolbarVisible = false;
    private boolean statusLineVisible = false;
    private BrowserListener browserListener;
    private JButton bBack;
    private JButton bForward;
    private JButton bHome;
    private JButton bReload;
    private JButton bStop;
    private JButton bHistory;
    private JComboBox cbLocation;
    private JLabel cbLabel;
    private JLabel lStatusLine;
    final Component browserComponent;
    private JPanel head;
    private RequestProcessor rp = new RequestProcessor();

    public HtmlBrowser() {
        this(true, true);
    }

    public HtmlBrowser(boolean toolbar, boolean statusLine) {
        this(null, toolbar, statusLine);
    }

    public HtmlBrowser(Factory fact, boolean toolbar, boolean statusLine) {
        this.init();
        Impl impl = null;
        Component comp = null;
        try {
            if (fact == null) {
                Impl[] arr = new Impl[1];
                comp = HtmlBrowser.findComponent(arr);
                impl = arr[0];
            } else {
                try {
                    impl = fact.createHtmlBrowserImpl();
                    comp = impl.getComponent();
                }
                catch (UnsupportedOperationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    impl = new SwingBrowserImpl();
                    comp = impl.getComponent();
                }
            }
        }
        catch (RuntimeException e) {
            Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(HtmlBrowser.class, (String)"EXC_Module"));
            Exceptions.printStackTrace((Throwable)e);
        }
        this.browserImpl = impl;
        this.browserComponent = comp;
        this.setLayout(new BorderLayout(0, 2));
        this.add((Component)(this.browserComponent != null ? new JScrollPane(this.browserComponent) : new JScrollPane()), "Center");
        this.browserListener = new BrowserListener();
        if (toolbar) {
            this.initToolbar();
        }
        if (statusLine) {
            this.initStatusLine();
        }
        this.browserImpl.addPropertyChangeListener(this.browserListener);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HtmlBrowser.class, (String)"ACS_HtmlBrowser"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HtmlBrowser.class, (String)"ACSD_HtmlBrowser"));
    }

    public static void setHomePage(String u) {
        homePage = u;
    }

    public static String getHomePage() {
        if (homePage == null) {
            return NbBundle.getMessage(HtmlBrowser.class, (String)"PROP_HomePage");
        }
        return homePage;
    }

    public static void setFactory(Factory brFactory) {
        browserFactory = brFactory;
    }

    private static Component findComponent(Impl[] handle) {
        Lookup.Result r = Lookup.getDefault().lookup(new Lookup.Template(Factory.class));
        for (Factory f : r.allInstances()) {
            try {
                Impl impl = f.createHtmlBrowserImpl();
                Component c = impl != null ? impl.getComponent() : null;
                if (c == null) continue;
                handle[0] = impl;
                return c;
            }
            catch (UnsupportedOperationException ex) {
            }
        }
        Factory f = browserFactory;
        if (f != null) {
            try {
                handle[0] = f.createHtmlBrowserImpl();
                return handle[0].getComponent();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        handle[0] = new SwingBrowserImpl();
        return handle[0].getComponent();
    }

    private void init() {
        try {
            if (this.iBack != null) {
                return;
            }
            this.iBack = new ImageIcon(ImageIO.read(HtmlBrowser.class.getResource("/org/openide/resources/html/back.gif")));
            this.iForward = new ImageIcon(ImageIO.read(HtmlBrowser.class.getResource("/org/openide/resources/html/forward.gif")));
            this.iHome = new ImageIcon(ImageIO.read(HtmlBrowser.class.getResource("/org/openide/resources/html/home.gif")));
            this.iReload = new ImageIcon(ImageIO.read(HtmlBrowser.class.getResource("/org/openide/resources/html/refresh.gif")));
            this.iStop = new ImageIcon(ImageIO.read(HtmlBrowser.class.getResource("/org/openide/resources/html/stop.gif")));
            this.iHistory = new ImageIcon(ImageIO.read(HtmlBrowser.class.getResource("/org/openide/resources/html/history.gif")));
        }
        catch (IOException ex) {
            Logger.getLogger(HtmlBrowser.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void initToolbar() {
        this.toolbarVisible = true;
        this.head = new JPanel();
        this.head.setLayout(new BorderLayout(11, 0));
        JPanel p = new JPanel(new GridBagLayout());
        this.bBack = new JButton(this.iBack);
        p.add(this.bBack);
        this.bBack.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Back"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 5);
        this.bForward = new JButton(this.iForward);
        p.add((Component)this.bForward, gbc);
        this.bForward.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Forward"));
        this.bStop = new JButton(this.iStop);
        p.add(this.bStop);
        this.bStop.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Stop"));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 5);
        this.bReload = new JButton(this.iReload);
        p.add((Component)this.bReload, gbc);
        this.bReload.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Reload"));
        this.bHome = new JButton(this.iHome);
        p.add(this.bHome);
        this.bHome.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Home"));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 5);
        this.bHistory = new JButton(this.iHistory);
        p.add((Component)this.bHistory, gbc);
        this.bHistory.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_History"));
        if (this.browserImpl != null) {
            this.bBack.setEnabled(this.browserImpl.isBackward());
            this.bForward.setEnabled(this.browserImpl.isForward());
            this.bHistory.setEnabled(this.browserImpl.isHistory());
        }
        JToolBar.Separator ts = new JToolBar.Separator();
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 5);
        p.add((Component)ts, gbc);
        ts.updateUI();
        this.cbLabel = new JLabel();
        p.add(this.cbLabel);
        Mnemonics.setLocalizedText(this.cbLabel, NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Location"));
        this.head.add("West", p);
        this.cbLocation = new JComboBox();
        this.head.add("Center", this.cbLocation);
        this.cbLocation.setEditable(true);
        this.cbLabel.setLabelFor(this.cbLocation);
        this.add((Component)this.head, "North");
        this.cbLocation.addActionListener(this.browserListener);
        this.bHistory.addActionListener(this.browserListener);
        this.bBack.addActionListener(this.browserListener);
        this.bForward.addActionListener(this.browserListener);
        this.bReload.addActionListener(this.browserListener);
        this.bHome.addActionListener(this.browserListener);
        this.bStop.addActionListener(this.browserListener);
        this.bHistory.getAccessibleContext().setAccessibleName(this.bHistory.getToolTipText());
        this.bBack.getAccessibleContext().setAccessibleName(this.bBack.getToolTipText());
        this.bForward.getAccessibleContext().setAccessibleName(this.bForward.getToolTipText());
        this.bReload.getAccessibleContext().setAccessibleName(this.bReload.getToolTipText());
        this.bHome.getAccessibleContext().setAccessibleName(this.bHome.getToolTipText());
        this.bStop.getAccessibleContext().setAccessibleName(this.bStop.getToolTipText());
        this.cbLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HtmlBrowser.class, (String)"ACSD_HtmlBrowser_Location"));
    }

    private void destroyToolbar() {
        this.remove(this.head);
        this.head = null;
        this.toolbarVisible = false;
    }

    private void initStatusLine() {
        this.statusLineVisible = true;
        this.lStatusLine = new JLabel(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Loading"));
        this.add((Component)this.lStatusLine, "South");
        this.lStatusLine.setLabelFor(this);
    }

    private void destroyStatusLine() {
        this.remove(this.lStatusLine);
        this.lStatusLine = null;
        this.statusLineVisible = false;
    }

    public void setURL(String str) {
        URL URL2;
        try {
            URL2 = new URL(str);
        }
        catch (MalformedURLException ee) {
            try {
                URL2 = new URL("http://" + str);
            }
            catch (MalformedURLException e) {
                if (this.browserImpl instanceof SwingBrowserImpl) {
                    ((SwingBrowserImpl)this.browserImpl).setStatusText(NbBundle.getMessage(SwingBrowserImpl.class, (String)"FMT_InvalidURL", (Object[])new Object[]{str}));
                } else {
                    Exceptions.printStackTrace((Throwable)ee);
                }
                return;
            }
        }
        this.setURL(URL2);
    }

    public void setURL(final URL url) {
        if (url == null) {
            return;
        }
        HtmlBrowser htmlBrowser = this;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class URLSetter
        implements Runnable {
            private boolean sameHosts = false;

            URLSetter() {
            }

            @Override
            public void run() {
                if (!SwingUtilities.isEventDispatchThread()) {
                    this.sameHosts = "nbfs".equals(url.getProtocol()) ? true : url.getHost() != null && HtmlBrowser.this.browserImpl.getURL() != null && url.getHost().equals(HtmlBrowser.this.browserImpl.getURL().getHost());
                    SwingUtilities.invokeLater(this);
                } else if (url.equals(HtmlBrowser.this.browserImpl.getURL()) && this.sameHosts) {
                    HtmlBrowser.this.browserImpl.reloadDocument();
                } else {
                    HtmlBrowser.this.browserImpl.setURL(url);
                }
            }
        }
        htmlBrowser.rp.getDefault().post((Runnable)new URLSetter());
    }

    public final URL getDocumentURL() {
        return this.browserImpl.getURL();
    }

    public final void setEnableHome(boolean b) {
        this.bHome.setEnabled(b);
        this.bHome.setVisible(b);
    }

    public final void setEnableLocation(boolean b) {
        this.cbLocation.setEditable(b);
        this.cbLocation.setVisible(b);
        this.cbLabel.setVisible(b);
    }

    public boolean isStatusLineVisible() {
        return this.statusLineVisible;
    }

    public void setStatusLineVisible(boolean v) {
        if (v == this.statusLineVisible) {
            return;
        }
        if (v) {
            this.initStatusLine();
        } else {
            this.destroyStatusLine();
        }
    }

    public boolean isToolbarVisible() {
        return this.toolbarVisible;
    }

    public void setToolbarVisible(boolean v) {
        if (v == this.toolbarVisible) {
            return;
        }
        if (v) {
            this.initToolbar();
        } else {
            this.destroyToolbar();
        }
    }

    public final Impl getBrowserImpl() {
        return this.browserImpl;
    }

    public final Component getBrowserComponent() {
        return this.browserComponent;
    }

    public Dimension getPreferredSize() {
        Dimension superPref = super.getPreferredSize();
        return new Dimension(Math.max(400, superPref.width), Math.max(600, superPref.height));
    }

    private void updateLocationBar() {
        if (this.toolbarVisible) {
            this.everythinkIListenInCheckBoxIsUnimportant = true;
            URL url = this.browserImpl.getURL();
            if (url != null) {
                this.cbLocation.setSelectedItem(url.toString());
            }
            this.everythinkIListenInCheckBoxIsUnimportant = false;
        }
    }

    public void requestFocus() {
        if (this.browserComponent != null) {
            boolean ownerFound = false;
            if (this.browserComponent instanceof JComponent) {
                ownerFound = ((JComponent)this.browserComponent).requestDefaultFocus();
            }
            if (!ownerFound) {
                this.browserComponent.requestFocus();
            }
        } else {
            super.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.browserComponent != null) {
            boolean ownerFound = false;
            if (this.browserComponent instanceof JComponent) {
                ownerFound = ((JComponent)this.browserComponent).requestDefaultFocus();
            }
            if (!ownerFound) {
                return this.browserComponent.requestFocusInWindow();
            }
            return true;
        }
        return super.requestFocusInWindow();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleHtmlBrowser();
        }
        return this.accessibleContext;
    }

    static {
        homePage = null;
    }

    private class AccessibleHtmlBrowser
    extends JPanel.AccessibleJPanel {
        AccessibleHtmlBrowser() {
            super(HtmlBrowser.this);
        }

        public void setAccessibleName(String name) {
            super.setAccessibleName(name);
            if (HtmlBrowser.this.browserComponent instanceof Accessible) {
                HtmlBrowser.this.browserComponent.getAccessibleContext().setAccessibleName(name);
            }
        }

        public void setAccessibleDescription(String desc) {
            super.setAccessibleDescription(desc);
            if (HtmlBrowser.this.browserComponent instanceof Accessible) {
                HtmlBrowser.this.browserComponent.getAccessibleContext().setAccessibleDescription(desc);
            }
        }
    }

    private class BrowserListener
    implements ActionListener,
    PropertyChangeListener {
        BrowserListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if (property == null) {
                return;
            }
            if (property.equals("url") || property.equals("title")) {
                HtmlBrowser.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
            if (property.equals("url")) {
                HtmlBrowser.this.updateLocationBar();
            } else if (property.equals("statusMessage")) {
                String s = HtmlBrowser.this.browserImpl.getStatusMessage();
                if (s == null || s.length() < 1) {
                    s = NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Document_done");
                }
                if (HtmlBrowser.this.lStatusLine != null) {
                    HtmlBrowser.this.lStatusLine.setText(s);
                }
            } else if (property.equals("forward") && HtmlBrowser.this.bForward != null) {
                HtmlBrowser.this.bForward.setEnabled(HtmlBrowser.this.browserImpl.isForward());
            } else if (property.equals("backward") && HtmlBrowser.this.bBack != null) {
                HtmlBrowser.this.bBack.setEnabled(HtmlBrowser.this.browserImpl.isBackward());
            } else if (property.equals("history") && HtmlBrowser.this.bHistory != null) {
                HtmlBrowser.this.bHistory.setEnabled(HtmlBrowser.this.browserImpl.isHistory());
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == HtmlBrowser.this.cbLocation) {
                int i;
                if (HtmlBrowser.this.everythinkIListenInCheckBoxIsUnimportant) {
                    return;
                }
                JComboBox cb = (JComboBox)e.getSource();
                Object o = cb.getSelectedItem();
                if (o == null) {
                    return;
                }
                HtmlBrowser.this.setURL((String)o);
                ComboBoxModel lm = cb.getModel();
                int k = lm.getSize();
                for (i = 0; i < k && !o.equals(lm.getElementAt(i)); ++i) {
                }
                if (i != k) {
                    return;
                }
                if (k == 20) {
                    cb.removeItem(lm.getElementAt(k - 1));
                }
                cb.insertItemAt(o, 0);
            } else if (e.getSource() == HtmlBrowser.this.bHistory) {
                HtmlBrowser.this.browserImpl.showHistory();
            } else if (e.getSource() == HtmlBrowser.this.bBack) {
                HtmlBrowser.this.browserImpl.backward();
            } else if (e.getSource() == HtmlBrowser.this.bForward) {
                HtmlBrowser.this.browserImpl.forward();
            } else if (e.getSource() == HtmlBrowser.this.bReload) {
                HtmlBrowser.this.updateLocationBar();
                HtmlBrowser.this.browserImpl.reloadDocument();
            } else if (e.getSource() == HtmlBrowser.this.bHome) {
                HtmlBrowser.this.setURL(HtmlBrowser.getHomePage());
            } else if (e.getSource() == HtmlBrowser.this.bStop) {
                HtmlBrowser.this.browserImpl.stopLoading();
            }
        }
    }

    public static interface Factory {
        public Impl createHtmlBrowserImpl();
    }

    public static abstract class Impl {
        static final long serialVersionUID = 2912844785502962114L;
        public static final String PROP_STATUS_MESSAGE = "statusMessage";
        public static final String PROP_URL = "url";
        public static final String PROP_TITLE = "title";
        public static final String PROP_FORWARD = "forward";
        public static final String PROP_BACKWARD = "backward";
        public static final String PROP_HISTORY = "history";

        public abstract Component getComponent();

        public abstract void reloadDocument();

        public abstract void stopLoading();

        public abstract void setURL(URL var1);

        public abstract URL getURL();

        public abstract String getStatusMessage();

        public abstract String getTitle();

        public abstract boolean isForward();

        public abstract void forward();

        public abstract boolean isBackward();

        public abstract void backward();

        public abstract boolean isHistory();

        public abstract void showHistory();

        public abstract void addPropertyChangeListener(PropertyChangeListener var1);

        public abstract void removePropertyChangeListener(PropertyChangeListener var1);
    }

    private static final class TrivialURLDisplayer
    extends URLDisplayer {
        public void showURL(URL u) {
            HtmlBrowser browser = new HtmlBrowser();
            browser.setURL(u);
            JFrame frame = new JFrame();
            frame.setDefaultCloseOperation(2);
            frame.getContentPane().add(browser);
            frame.pack();
            frame.setVisible(true);
        }
    }

    public static abstract class URLDisplayer {
        protected URLDisplayer() {
        }

        public static URLDisplayer getDefault() {
            URLDisplayer dflt = (URLDisplayer)Lookup.getDefault().lookup(URLDisplayer.class);
            if (dflt == null) {
                dflt = new TrivialURLDisplayer();
            }
            return dflt;
        }

        public abstract void showURL(URL var1);
    }
}

