/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.openfile.OpenFile;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.ExternalDropHandler;

public class DefaultExternalDropHandler
extends ExternalDropHandler {
    private static DataFlavor uriListDataFlavor;

    public boolean canDrop(DropTargetDragEvent e) {
        return this.canDrop(e.getCurrentDataFlavors());
    }

    public boolean canDrop(DropTargetDropEvent e) {
        return this.canDrop(e.getCurrentDataFlavors());
    }

    boolean canDrop(DataFlavor[] flavors) {
        for (int i = 0; null != flavors && i < flavors.length; ++i) {
            if (!DataFlavor.javaFileListFlavor.equals(flavors[i]) && !this.getUriListDataFlavor().equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    public boolean handleDrop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (null == t) {
            return false;
        }
        List fileList = this.getFileList(t);
        if (null != fileList && !fileList.isEmpty()) {
            Iterator i = fileList.iterator();
            while (i.hasNext()) {
                this.openFile((File)i.next());
            }
            return true;
        }
        return false;
    }

    List getFileList(Transferable t) {
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            if (t.isDataFlavorSupported(this.getUriListDataFlavor())) {
                String uriList = (String)t.getTransferData(this.getUriListDataFlavor());
                return this.textURIListToFileList(uriList);
            }
        }
        catch (UnsupportedFlavorException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IOException ex) {
            Logger.getLogger(DefaultExternalDropHandler.class.getName()).log(Level.FINE, null, ex);
        }
        return null;
    }

    void openFile(File file) {
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        OpenFile.open(fo, -1);
    }

    DataFlavor getUriListDataFlavor() {
        if (null == uriListDataFlavor) {
            try {
                uriListDataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            }
            catch (ClassNotFoundException cnfE) {
                throw new AssertionError((Object)cnfE);
            }
        }
        return uriListDataFlavor;
    }

    List textURIListToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>(1);
        StringTokenizer st = new StringTokenizer(data, "\r\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                URI uri = new URI(s);
                File file = new File(uri);
                list.add(file);
            }
            catch (URISyntaxException e) {
            }
            catch (IllegalArgumentException e) {}
        }
        return list;
    }
}

