/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.openfile.OpenFileImpl;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.actions.ToolsAction;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class DefaultOpenFileImpl
implements OpenFileImpl,
Runnable {
    static final String JAVA_EXT = ".JAVA";
    static final String TXT_EXT = ".TXT";
    private static final int OPEN_EDITOR_WAIT_PERIOD_MS = 100;
    private static final int OPEN_EDITOR_TOTAL_TIMEOUT_MS = 1000;
    private static final String ZIP_EXT = "zip";
    private static final String JAR_EXT = "jar";
    private static final String WAR_EXT = "war";
    private final FileObject fileObject;
    private final int line;

    private DefaultOpenFileImpl(FileObject fileObject, int line) {
        this.fileObject = fileObject;
        this.line = line;
    }

    public DefaultOpenFileImpl() {
        this.fileObject = null;
        this.line = -1;
    }

    protected final void setStatusLine(String text) {
        StatusDisplayer.getDefault().setStatusText(text);
    }

    protected void notifyCannotOpen(String fileName) {
        assert (EventQueue.isDispatchThread());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_cannotOpenWillClose", (Object)fileName)));
    }

    private boolean openEditor(EditorCookie editorCookie, int line) {
        StyledDocument doc;
        assert (EventQueue.isDispatchThread());
        JEditorPane[] openPanes = editorCookie.getOpenedPanes();
        if (openPanes != null) {
            if (line >= 0) {
                int cursorOffset = this.getCursorOffset(editorCookie.getDocument(), line);
                openPanes[0].setCaretPosition(cursorOffset);
            }
            Container c = SwingUtilities.getAncestorOfClass(TopComponent.class, openPanes[0]);
            assert (c != null);
            final TopComponent tc = (TopComponent)c;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    tc.requestActive();
                }
            });
            return true;
        }
        try {
            doc = editorCookie.openDocument();
        }
        catch (IOException ex) {
            String msg = NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_cannotOpenWillClose");
            ErrorManager.getDefault().notify(4096, ErrorManager.getDefault().annotate((Throwable)ex, msg));
            return false;
        }
        if (line < 0) {
            editorCookie.open();
        } else {
            this.openDocAtLine(editorCookie, doc, line);
        }
        return true;
    }

    private void openDocAtLine(final EditorCookie editorCookie, StyledDocument doc, int line) {
        assert (EventQueue.isDispatchThread());
        assert (line >= 0);
        assert (editorCookie.getDocument() == doc);
        final int offset = this.getCursorOffset(doc, line);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SetCursorTask
        implements Runnable {
            private boolean completed = false;
            private PropertyChangeListener listenerToUnregister;

            SetCursorTask() {
            }

            private boolean perform() {
                if (EventQueue.isDispatchThread()) {
                    this.run();
                } else {
                    try {
                        EventQueue.invokeAndWait(this);
                    }
                    catch (Exception ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                        this.completed = true;
                    }
                }
                return this.completed;
            }

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                if (this.completed) {
                    return;
                }
                JEditorPane[] panes = editorCookie.getOpenedPanes();
                if (panes != null) {
                    panes[0].setCaretPosition(offset);
                    if (this.listenerToUnregister != null) {
                        ((EditorCookie.Observable)editorCookie).removePropertyChangeListener(this.listenerToUnregister);
                    }
                    this.completed = true;
                }
            }

            private void setListenerToUnregister(PropertyChangeListener l) {
                this.listenerToUnregister = l;
            }
        }
        final SetCursorTask setCursorTask = new SetCursorTask();
        editorCookie.open();
        if (setCursorTask.perform()) {
            return;
        }
        if (editorCookie instanceof EditorCookie.Observable) {
            if (!setCursorTask.perform()) {
                PropertyChangeListener openPanesListener = new PropertyChangeListener(){
                    {
                    }

                    public void propertyChange(PropertyChangeEvent e) {
                        if ("openedPanes".equals(e.getPropertyName())) {
                            setCursorTask.perform();
                        }
                    }
                };
                setCursorTask.setListenerToUnregister(openPanesListener);
                ((EditorCookie.Observable)editorCookie).addPropertyChangeListener(openPanesListener);
                setCursorTask.perform();
            }
        } else {
            int numberOfTries = 10;
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                }
                if (setCursorTask.perform()) break;
            }
            if (!setCursorTask.completed) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_couldNotOpenAt"));
            }
        }
    }

    private int getCursorOffset(StyledDocument doc, int line) {
        assert (EventQueue.isDispatchThread());
        assert (line >= 0);
        try {
            return NbDocument.findLineOffset((StyledDocument)doc, (int)line);
        }
        catch (IndexOutOfBoundsException ex) {
            Element lineRootElement = NbDocument.findLineRootElement((StyledDocument)doc);
            int lineCount = lineRootElement.getElementCount();
            if (line >= lineCount) {
                return NbDocument.findLineOffset((StyledDocument)doc, (int)(lineCount - 1));
            }
            throw ex;
        }
    }

    protected boolean openByCookie(Node.Cookie cookie, Class cookieClass, int line) {
        assert (EventQueue.isDispatchThread());
        if (cookieClass == EditorCookie.Observable.class || cookieClass == EditorCookie.Observable.class) {
            return this.openEditor((EditorCookie)cookie, line);
        }
        if (cookieClass == OpenCookie.class) {
            ((OpenCookie)cookie).open();
        } else if (cookieClass == EditCookie.class) {
            ((EditCookie)cookie).edit();
        } else if (cookieClass == ViewCookie.class) {
            ((ViewCookie)cookie).view();
        } else {
            throw new IllegalArgumentException();
        }
        return true;
    }

    private final boolean openDataObjectByCookie(DataObject dataObject, int line) {
        block3: {
            Node.Cookie cookie;
            Class<OpenCookie> cookieClass;
            block2: {
                cookieClass = OpenCookie.class;
                cookie = dataObject.getCookie(OpenCookie.class);
                if (cookie != null) break block2;
                cookieClass = EditCookie.class;
                cookie = dataObject.getCookie(EditCookie.class);
                if (cookie != null) break block2;
                cookieClass = ViewCookie.class;
                cookie = dataObject.getCookie(ViewCookie.class);
                if (cookie == null) break block3;
            }
            return this.openByCookie(cookie, cookieClass, line);
        }
        return false;
    }

    public void run() {
        assert (EventQueue.isDispatchThread());
        this.open(this.fileObject, this.line);
    }

    public boolean open(FileObject fileObject, int line) {
        Node dataNode;
        Action action;
        DataObject dataObject;
        String fileName;
        block11: {
            Node.Cookie cookie;
            Class<EditorCookie.Observable> cookieClass;
            block12: {
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeLater(new DefaultOpenFileImpl(fileObject, line));
                    return true;
                }
                assert (EventQueue.isDispatchThread());
                fileName = fileObject.getNameExt();
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                    return false;
                }
                if (line == -1) break block11;
                cookieClass = EditorCookie.Observable.class;
                cookie = dataObject.getCookie(EditorCookie.Observable.class);
                if (cookie != null) break block12;
                cookieClass = EditorCookie.class;
                cookie = dataObject.getCookie(EditorCookie.class);
                if (cookie == null) break block11;
            }
            boolean ret = this.openByCookie(cookie, cookieClass, line);
            return ret;
        }
        if ((action = (dataNode = dataObject.getNodeDelegate()).getPreferredAction()) != null && !(action instanceof FileSystemAction) && !(action instanceof ToolsAction)) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    action.actionPerformed(new ActionEvent(dataNode, 0, null));
                }
            });
            return true;
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_opening", (Object)fileName));
        boolean success = this.openDataObjectByCookie(dataObject, line);
        if (success) {
            return true;
        }
        String ext = fileObject.getExt();
        if (ZIP_EXT.equalsIgnoreCase(ext) || JAR_EXT.equalsIgnoreCase(ext) || WAR_EXT.equalsIgnoreCase(ext) || fileObject.isFolder()) {
            Node node = dataObject.getNodeDelegate();
            if (node != null) {
                NodeOperation.getDefault().explore(node);
                return true;
            }
            return false;
        }
        return false;
    }
}

