/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.io.File;
import org.netbeans.modules.openfile.OpenFileImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class OpenFile {
    private OpenFile() {
    }

    public static boolean open(FileObject fileObject, int line) {
        for (OpenFileImpl impl : Lookup.getDefault().lookupAll(OpenFileImpl.class)) {
            if (!impl.open(fileObject, line)) continue;
            return true;
        }
        return false;
    }

    static boolean openFile(File file, int line) {
        if (!OpenFile.checkFileExists(file)) {
            return false;
        }
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject != null) {
            return OpenFile.open(fileObject, line);
        }
        return false;
    }

    private static boolean checkFileExists(File file) {
        String errMsgKey;
        if (!file.exists()) {
            errMsgKey = "MSG_fileNotFound";
        } else if (OpenFile.isSpecifiedByUNCPath(file)) {
            errMsgKey = "MSG_UncNotSupported";
        } else if (!file.isFile() && !file.isDirectory()) {
            errMsgKey = "MSG_fileNotFound";
        } else {
            return true;
        }
        String fileName = file.toString();
        String msg = NbBundle.getMessage(OpenFile.class, (String)errMsgKey, (Object)fileName);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
        return false;
    }

    static boolean isSpecifiedByUNCPath(File file) {
        assert (file != null && file.exists());
        file = FileUtil.normalizeFile((File)file);
        return file.getPath().startsWith("\\\\");
    }
}

