/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.netbeans.modules.openfile.FileChooser;
import org.netbeans.modules.openfile.OpenFile;
import org.netbeans.modules.utilities.Manager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class OpenFileAction
extends CallableSystemAction {
    public OpenFileAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(OpenFileAction.class, (String)"LBL_openFile");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(OpenFileAction.class);
    }

    protected String iconResource() {
        return "org/netbeans/modules/openfile/openFile.png";
    }

    protected JFileChooser prepareFileChooser() {
        FileChooser chooser = new FileChooser();
        File currDir = OpenFileAction.findStartingDirectory();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, (File)currDir);
        HelpCtx.setHelpIDString((JComponent)chooser, (String)this.getHelpCtx().getHelpID());
        return chooser;
    }

    public static File[] chooseFilesToOpen(JFileChooser chooser) throws UserCancelException {
        File[] files;
        do {
            int selectedOption;
            if ((selectedOption = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) continue;
            throw new UserCancelException();
        } while ((files = chooser.getSelectedFiles()).length == 0);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction() {
        if (!Manager.actionActivated((SystemAction)this)) {
            return;
        }
        try {
            File[] files;
            JFileChooser chooser = this.prepareFileChooser();
            try {
                files = OpenFileAction.chooseFilesToOpen(chooser);
            }
            catch (UserCancelException ex) {
                Manager.actionFinished((SystemAction)this);
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                OpenFile.openFile(files[i], -1);
            }
        }
        finally {
            Manager.actionFinished((SystemAction)this);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private static File findStartingDirectory() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        for (int i = 0; i < nodes.length; ++i) {
            File f;
            DataObject d = (DataObject)nodes[i].getCookie(DataObject.class);
            if (d == null || (f = FileUtil.toFile((FileObject)d.getPrimaryFile())) == null) continue;
            if (f.isFile()) {
                f = f.getParentFile();
            }
            return f;
        }
        return new File(System.getProperty("user.home"));
    }
}

