/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.pdf;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.pdf.ReconfigureReaderPanel;
import org.netbeans.modules.pdf.Settings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.util.NbBundle;

class PDFOpenSupport
implements OpenCookie {
    private static final String[] APP_DIRS = new String[]{"/usr/bin", "/usr/local/bin"};
    private static final String[] VIEWER_NAMES = new String[]{"evince", "xpdf", "kghostview", "ggv", "acroread"};
    private static final String[] NO_PATH_VIEWERS = new String[]{"acroread", "open"};
    static final String FALLBACK_VIEWER_NAME = "acroread";
    private File f;

    public PDFOpenSupport(File f) {
        this.f = f;
    }

    public void open() {
        boolean viewerUnset;
        Settings sett = Settings.getDefault();
        File viewer = sett.getPDFViewer();
        boolean bl = viewerUnset = viewer == null;
        if (viewerUnset && (viewer = PDFOpenSupport.tryPredefinedViewers(this.f)) != null) {
            sett.setPDFViewer(viewer);
            return;
        }
        if (viewerUnset) {
            viewer = new File(FALLBACK_VIEWER_NAME);
        }
        boolean viewerFailed = false;
        while (true) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{viewer.getPath(), this.f.getAbsolutePath()});
                if (!viewerUnset && !viewerFailed) break;
                sett.setPDFViewer(viewer);
            }
            catch (IOException ioe) {
                viewerFailed = true;
                String excmessage = ioe.getLocalizedMessage();
                ReconfigureReaderPanel configPanel = new ReconfigureReaderPanel(viewer, excmessage);
                String title = NbBundle.getMessage(PDFOpenSupport.class, (String)"TITLE_pick_a_viewer");
                DialogDescriptor d = new DialogDescriptor((Object)configPanel, title);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != DialogDescriptor.OK_OPTION) break;
                viewer = configPanel.getSelectedFile();
                sett.setPDFViewer(viewer);
                continue;
            }
            break;
        }
    }

    private static File tryPredefinedViewers(File fileToOpen) {
        int i;
        for (i = 0; i < APP_DIRS.length; ++i) {
            File dir = new File(APP_DIRS[i]);
            if (!dir.exists() || !dir.isDirectory()) continue;
            for (int j = 0; j < VIEWER_NAMES.length; ++j) {
                String viewerPath = APP_DIRS[i] + File.separatorChar + VIEWER_NAMES[j];
                File viewer = new File(viewerPath);
                if (!viewer.exists()) continue;
                try {
                    Process p = Runtime.getRuntime().exec(new String[]{viewerPath, fileToOpen.getAbsolutePath()});
                    return viewer;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        for (i = 0; i < NO_PATH_VIEWERS.length; ++i) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{NO_PATH_VIEWERS[i], fileToOpen.getAbsolutePath()});
                return new File(NO_PATH_VIEWERS[i]);
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return null;
    }
}

