/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.pdf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.pdf.Settings;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ReconfigureReaderPanel
extends JPanel {
    private Settings settings;
    private final File defaultViewer;
    private ResourceBundle bundle = NbBundle.getBundle(ReconfigureReaderPanel.class);
    private JButton chooseButton;
    private JLabel currentViewerLabel;
    private JLabel topLabel;
    private JTextField viewerField;

    public ReconfigureReaderPanel(File defaultViewer, String exceptionMessage) {
        this.settings = Settings.getDefault();
        this.defaultViewer = defaultViewer;
        this.initComponents();
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("LBL_reconfigure"));
        this.viewerField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_Field"));
        this.chooseButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_LBL_choose"));
    }

    private void initComponents() {
        this.topLabel = new JLabel();
        this.currentViewerLabel = new JLabel();
        this.viewerField = new JTextField();
        this.chooseButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.topLabel.setText(this.bundle.getString("LBL_reconfigure"));
        this.topLabel.setHorizontalAlignment(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 12, 11);
        this.add((Component)this.topLabel, gridBagConstraints);
        this.currentViewerLabel.setText(this.bundle.getString("LBL_current_viewer"));
        this.currentViewerLabel.setLabelFor(this.viewerField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 12, 12, 12);
        this.add((Component)this.currentViewerLabel, gridBagConstraints);
        this.viewerField.setText(this.settings.getPDFViewer() != null ? this.settings.getPDFViewer().getPath() : "acroread");
        this.viewerField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ReconfigureReaderPanel.this.viewerFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.viewerField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chooseButton, (String)NbBundle.getMessage(ReconfigureReaderPanel.class, (String)"LBL_choose"));
        this.chooseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReconfigureReaderPanel.this.chooseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 12, 11);
        this.add((Component)this.chooseButton, gridBagConstraints);
    }

    private void viewerFieldFocusGained(FocusEvent evt) {
        this.viewerField.selectAll();
    }

    private void chooseButtonActionPerformed(ActionEvent evt) {
        String chooserTitle;
        File dir = this.defaultViewer.getParentFile();
        JFileChooser chooser = dir != null ? new JFileChooser(dir) : new JFileChooser();
        if (chooser.showDialog(this, chooserTitle = this.bundle.getString("LBL_select_viewer")) == 0) {
            this.viewerField.setText(chooser.getSelectedFile().getPath());
        }
    }

    File getSelectedFile() {
        return new File(this.viewerField.getText().trim());
    }
}

