/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.NodeRenderer;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultTreeModel;
import org.openide.actions.EditAction;
import org.openide.cookies.EditCookie;
import org.openide.nodes.Node;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

final class NodeListener
implements MouseListener,
KeyListener,
TreeWillExpandListener,
TreeExpansionListener {
    private static final boolean COLLAPSE_FILE_ON_SELECTION = false;
    private static final boolean COLLAPSE_FILE_ON_UNSELECTION = true;
    private boolean selectionChangeEnabled = true;

    NodeListener() {
    }

    public void mouseClicked(MouseEvent e) {
        JTree tree = (JTree)e.getSource();
        int clickCount = e.getClickCount();
        if (clickCount != 1 && clickCount != 2) {
            return;
        }
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        ResultModel resultModel = this.getResultModel(tree);
        boolean insideCheckBox = this.isInsideCheckBox(tree, path, resultModel, e);
        int modifiers = e.getModifiersEx();
        if (modifiers == 0 || modifiers == 16 || modifiers == 1024) {
            if (clickCount == 1 && insideCheckBox) {
                assert (path != null);
                this.toggleSelection(tree, path);
            }
            if (clickCount == 2 && !insideCheckBox) {
                if (path.getPathCount() == 1) {
                    this.toggleExpansionState(tree, path);
                } else {
                    Node nbNode = NodeListener.getNbNode(path, resultModel);
                    this.callDefaultAction(nbNode, e.getSource(), e.getID(), "double-click");
                }
            }
        }
    }

    private void popupTriggerEventFired(MouseEvent e) {
        JTree tree = (JTree)e.getSource();
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        ResultModel resultModel = this.getResultModel(tree);
        tree.setSelectionPath(path);
        if (!this.isInsideCheckBox(tree, path, resultModel, e)) {
            this.showPopup(tree, path, resultModel, e);
        }
    }

    private boolean isInsideCheckBox(JTree tree, TreePath path, ResultModel resultModel, MouseEvent mouseEvent) {
        if (resultModel == null || !resultModel.searchAndReplace) {
            return false;
        }
        Rectangle rowRect = tree.getPathBounds(path);
        Rectangle chRect = NodeRenderer.getCheckBoxRectangle();
        chRect.setLocation(rowRect.x + chRect.x, rowRect.y + chRect.y);
        return chRect.contains(mouseEvent.getPoint());
    }

    private void showPopup(JTree tree, TreePath path, ResultModel resultModel, MouseEvent e) {
        int pathCount = path.getPathCount();
        if (pathCount != 1) {
            if (pathCount == 2) {
                JPopupMenu popup;
                Node nbNode = NodeListener.getNbNode(path, resultModel);
                if (nbNode != null && (popup = this.createFileNodePopupMenu(nbNode)) != null) {
                    popup.show(tree, e.getX(), e.getY());
                }
            } else if (pathCount == 3) {
                Node nbNode = NodeListener.getNbNode(path, resultModel);
                if (nbNode != null) {
                    nbNode.getContextMenu().show(tree, e.getX(), e.getY());
                }
            } else assert (false);
        }
    }

    private boolean autocollapseFileNodeIfNeeded(JTree tree, TreePath treePath, MatchingObject matchingObj, boolean selected) {
        boolean isCollapsed;
        boolean autocollapse;
        assert (treePath.getPathCount() == 2 && treePath.getLastPathComponent() == matchingObj);
        boolean bl = autocollapse = !selected;
        if (autocollapse) {
            if (matchingObj.isExpanded()) {
                tree.collapsePath(treePath);
            }
            isCollapsed = true;
        } else {
            isCollapsed = !tree.isExpanded(treePath);
        }
        return isCollapsed;
    }

    private void toggleRootNodeSelection(JTree tree, TreePath path) {
        ResultTreeModel resultTreeModel = this.getResultTreeModel(path);
        ResultModel resultModel = resultTreeModel.resultModel;
        boolean isSelected = resultTreeModel.isSelected();
        boolean willBeSelected = !isSelected;
        boolean autocollapse = !willBeSelected;
        MatchingObject[] matchingObjects = resultModel.getMatchingObjects();
        int[] toggledIndices = null;
        MatchingObject[] toggledObjects = null;
        ArrayList<MatchingObject> expandedToggled = null;
        int toggledCount = 0;
        for (int i = 0; i < matchingObjects.length; ++i) {
            boolean collapsed;
            MatchingObject matchingObj = matchingObjects[i];
            boolean bl = collapsed = !matchingObj.isExpanded();
            if (autocollapse && !collapsed) {
                tree.collapsePath(path.pathByAddingChild(matchingObj));
                collapsed = true;
            }
            if (matchingObj.isSelected() == willBeSelected) continue;
            matchingObj.setSelected(willBeSelected);
            if (toggledCount == 0) {
                int arrayLength = matchingObjects.length - i;
                toggledIndices = new int[arrayLength];
                toggledObjects = new MatchingObject[arrayLength];
            }
            toggledIndices[toggledCount] = i;
            toggledObjects[toggledCount] = matchingObj;
            ++toggledCount;
            if (collapsed) {
                matchingObj.markChildrenSelectionDirty();
                continue;
            }
            if (expandedToggled == null) {
                expandedToggled = new ArrayList<MatchingObject>(6);
            }
            expandedToggled.add(matchingObj);
        }
        if (toggledCount != 0 && toggledCount != matchingObjects.length) {
            int[] newToggledIndices = new int[toggledCount];
            System.arraycopy(toggledIndices, 0, newToggledIndices, 0, toggledCount);
            toggledIndices = newToggledIndices;
            MatchingObject[] newToggledObjects = new MatchingObject[toggledCount];
            System.arraycopy(toggledObjects, 0, newToggledObjects, 0, toggledCount);
            toggledObjects = newToggledObjects;
        }
        resultTreeModel.setSelected(willBeSelected);
        resultTreeModel.fireRootNodeChanged();
        if (toggledCount != 0) {
            assert (toggledIndices.length == toggledCount);
            assert (toggledObjects.length == toggledCount);
            resultTreeModel.fireFileNodesSelectionChanged(toggledIndices, toggledObjects);
        }
        if (expandedToggled != null) {
            for (MatchingObject obj : expandedToggled) {
                resultTreeModel.fireFileNodeChildrenSelectionChanged(obj);
            }
        }
    }

    private void setFileNodeSelected(JTree tree, TreePath treePath, MatchingObject matchingObj, boolean selected) {
        boolean collapsed;
        assert (treePath.getPathCount() == 2);
        boolean deferChildrenSelection = collapsed = this.autocollapseFileNodeIfNeeded(tree, treePath, matchingObj, selected);
        matchingObj.setSelected(selected);
        this.getResultTreeModel(treePath).fireFileNodeSelectionChanged(matchingObj, !deferChildrenSelection);
        if (deferChildrenSelection) {
            matchingObj.markChildrenSelectionDirty();
        }
    }

    private void toggleDetailNodeSelection(JTree tree, ResultModel resultModel, MatchingObject matchingObj, int index) {
        matchingObj.toggleSubnodeSelection(resultModel, index);
        this.getResultTreeModel(tree).fireDetailNodeSelectionChanged(matchingObj, index);
    }

    private ResultTreeModel getResultTreeModel(TreePath path) {
        return (ResultTreeModel)path.getPathComponent(0);
    }

    private ResultTreeModel getResultTreeModel(JTree tree) {
        return (ResultTreeModel)tree.getPathForRow(0).getPathComponent(0);
    }

    private ResultModel getResultModel(JTree tree) {
        return ((ResultTreeModel)tree.getPathForRow((int)0).getPathComponent((int)0)).resultModel;
    }

    private static Node getNbNode(TreePath path, ResultModel resultModel) {
        Node node;
        boolean isFileNode;
        MatchingObject matchingObj;
        Object obj = path.getLastPathComponent();
        if (obj.getClass() == MatchingObject.class) {
            matchingObj = (MatchingObject)obj;
            isFileNode = true;
        } else {
            Object parentObj = path.getParentPath().getLastPathComponent();
            assert (parentObj.getClass() == MatchingObject.class);
            matchingObj = (MatchingObject)parentObj;
            isFileNode = false;
        }
        if (!matchingObj.isObjectValid()) {
            return null;
        }
        if (isFileNode) {
            node = resultModel.getSearchGroup().getNodeForFoundObject(matchingObj.object);
        } else {
            assert (obj instanceof Node);
            node = (Node)obj;
        }
        return node;
    }

    private JPopupMenu createFileNodePopupMenu(Node fileNode) {
        Action action = this.getDefaultAction(fileNode);
        if (action == null) {
            return null;
        }
        assert (action.isEnabled());
        JMenuItem menuItem = action instanceof Presenter.Popup ? ((Presenter.Popup)action).getPopupPresenter() : null;
        JPopupMenu popupMenu = new JPopupMenu();
        if (menuItem != null) {
            popupMenu.add(menuItem);
        } else {
            popupMenu.add(action);
        }
        return popupMenu;
    }

    private Action getDefaultAction(Node node) {
        Action action;
        EditAction editAction = (EditAction)SharedClassObject.findObject(EditAction.class, (boolean)true);
        if (editAction != null && (action = editAction.createContextAwareInstance(Lookups.singleton((Object)node))).isEnabled()) {
            return action;
        }
        Action preferredAction = node.getPreferredAction();
        if (preferredAction == null) {
            return null;
        }
        action = preferredAction;
        if (action instanceof NodeAction) {
            action = ((NodeAction)action).createContextAwareInstance(Lookups.singleton((Object)node));
        }
        return action != null && action.isEnabled() ? action : null;
    }

    private void callDefaultAction(Node node, Object eventSource, int eventId, String command) {
        if (node == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        EditCookie editCookie = (EditCookie)node.getCookie(EditCookie.class);
        if (editCookie != null) {
            editCookie.edit();
            return;
        }
        Action action = node.getPreferredAction();
        if (action == null) {
            return;
        }
        if (action instanceof NodeAction) {
            action = ((NodeAction)action).createContextAwareInstance(Lookups.singleton((Object)node));
        }
        if (action != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(eventSource, eventId, command));
        }
    }

    private void toggleExpansionState(JTree tree, TreePath path) {
        if (tree.isCollapsed(path)) {
            tree.expandPath(path);
        } else {
            tree.collapsePath(path);
        }
    }

    private void toggleSelection(JTree tree, TreePath path) {
        assert (EventQueue.isDispatchThread());
        if (!this.selectionChangeEnabled) {
            return;
        }
        int pathCount = path.getPathCount();
        if (pathCount == 1) {
            this.toggleRootNodeSelection(tree, path);
        } else if (pathCount == 2) {
            MatchingObject matchingObj;
            this.setFileNodeSelected(tree, path, matchingObj, !(matchingObj = (MatchingObject)path.getPathComponent(1)).isSelected());
        } else {
            assert (pathCount == 3);
            MatchingObject matchingObj = (MatchingObject)path.getPathComponent(1);
            int parentPathRow = tree.getRowForPath(path.getParentPath());
            int row = tree.getRowForPath(path);
            int index = row - parentPathRow - 1;
            this.toggleDetailNodeSelection(tree, this.getResultModel(tree), matchingObj, index);
        }
    }

    void setSelectionChangeEnabled(boolean enabled) {
        assert (EventQueue.isDispatchThread());
        this.selectionChangeEnabled = enabled;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() != 10 || e.getModifiersEx() != 0) {
            return;
        }
        JTree tree = (JTree)e.getSource();
        TreeSelectionModel selectionModel = tree.getSelectionModel();
        if (selectionModel.getSelectionCount() != 1) {
            return;
        }
        TreePath selectedPath = selectionModel.getLeadSelectionPath();
        if (selectedPath == null || selectedPath.getParentPath() == null) {
            return;
        }
        Node nbNode = NodeListener.getNbNode(selectedPath, this.getResultModel(tree));
        this.callDefaultAction(nbNode, e.getSource(), e.getID(), "enter");
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupTriggerEventFired(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupTriggerEventFired(e);
        }
    }

    public void keyPressed(KeyEvent e) {
        JTree tree;
        TreePath path;
        if (e.getKeyChar() == ' ' && (path = (tree = (JTree)e.getSource()).getSelectionPath()) != null) {
            this.toggleSelection(tree, path);
        }
    }

    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        MatchingObject matchingObj;
        TreePath path = event.getPath();
        if (path.getPathCount() == 2 && (matchingObj = (MatchingObject)path.getLastPathComponent()).isChildrenSelectionDirty()) {
            this.getResultTreeModel(path).fireFileNodeChildrenSelectionChanged(matchingObj);
            matchingObj.markChildrenSelectionClean();
        }
    }

    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        TreePath path = event.getPath();
        if (path.getPathCount() == 2) {
            ((MatchingObject)path.getLastPathComponent()).markExpanded(true);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        TreePath path = event.getPath();
        if (path.getPathCount() == 2) {
            ((MatchingObject)path.getLastPathComponent()).markExpanded(false);
        }
    }
}

