/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.search.MatchingObject;
import org.openide.util.NbBundle;

final class ReplaceTask
implements Runnable {
    private static final int MAX_ERRORS_CHECKED = 20;
    private final MatchingObject[] matchingObjects;
    private final ProgressHandle progressHandle;
    private final List<String> problems;
    private ResultStatus resultStatus = null;

    ReplaceTask(MatchingObject[] matchingObjects) {
        this.matchingObjects = matchingObjects;
        this.problems = new ArrayList<String>(4);
        this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"LBL_Replacing"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        assert (!EventQueue.isDispatchThread());
        this.progressHandle.start(this.matchingObjects.length * 2);
        try {
            this.replace();
            assert (this.resultStatus != null);
        }
        finally {
            this.progressHandle.finish();
        }
    }

    private void replace() {
        assert (!EventQueue.isDispatchThread());
        this.checkForErrors();
        if (this.resultStatus == null) {
            this.doReplace();
        }
    }

    private void checkForErrors() {
        assert (!EventQueue.isDispatchThread());
        int errorsCount = 0;
        for (int i = 0; i < this.matchingObjects.length; ++i) {
            MatchingObject.InvalidityStatus status = this.matchingObjects[i].checkValidity();
            if (status == null) continue;
            this.problems.add(status.getDescription(this.matchingObjects[i].getFile().getPath()));
            if (++errorsCount > 20) break;
        }
        if (!this.problems.isEmpty()) {
            this.resultStatus = ResultStatus.PRE_CHECK_FAILED;
        }
    }

    private void doReplace() {
        assert (!EventQueue.isDispatchThread());
        for (int i = 0; i < this.matchingObjects.length; ++i) {
            String errMessage;
            block7: {
                MatchingObject obj = this.matchingObjects[i];
                this.progressHandle.progress(obj.getName(), i + this.matchingObjects.length);
                if (!obj.isSelected() || !obj.isValid()) continue;
                String invDescription = obj.getInvalidityDescription();
                if (invDescription != null) {
                    this.problems.add(invDescription);
                    continue;
                }
                errMessage = null;
                try {
                    MatchingObject.InvalidityStatus status = obj.replace();
                    if (status == null) {
                        obj.write();
                    } else {
                        errMessage = status.getDescription(obj.getFile().getPath());
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    errMessage = ex.getLocalizedMessage();
                    if (errMessage != null) break block7;
                    errMessage = ex.getMessage();
                }
            }
            if (errMessage == null) continue;
            this.problems.add(errMessage);
        }
        this.resultStatus = this.problems.isEmpty() ? ResultStatus.SUCCESS : ResultStatus.PROBLEMS_ENCOUNTERED;
    }

    ResultStatus getResultStatus() {
        return this.resultStatus;
    }

    String[] getProblems() {
        return this.problems.isEmpty() ? null : this.problems.toArray(new String[this.problems.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ResultStatus {
        SUCCESS,
        PRE_CHECK_FAILED,
        PROBLEMS_ENCOUNTERED;

    }
}

