/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.netbeans.modules.search.ContextView;
import org.netbeans.modules.search.IssuesPanel;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.NodeListener;
import org.netbeans.modules.search.NodeRenderer;
import org.netbeans.modules.search.ReplaceTask;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultTreeModel;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.SearchTask;
import org.netbeans.modules.search.Utils;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openidex.search.SearchType;

final class ResultView
extends TopComponent {
    private static final boolean SHOW_CONTEXT_BY_DEFAULT = true;
    private static final String RESULTS_CARD = "results";
    private static final String ISSUES_CARD = "issues";
    private boolean contextViewEnabled = true;
    private boolean contextViewVisible = false;
    private double dividerLocation = -1.0;
    private boolean ignoreContextButtonToggle = false;
    private boolean hasResults = false;
    private int objectsCount = 0;
    private volatile boolean hasDetails = false;
    private volatile boolean searchInProgress = false;
    private static final String ID = "search-results";
    private static WeakReference instance = null;
    private final JScrollPane treeView;
    private ResultModel resultModel = null;
    private ResultTreeModel treeModel = null;
    private final JTree tree;
    private final NodeListener nodeListener;
    private Node[] lastSearchNodes;
    private List lastEnabledSearchTypes;
    private MessageFormat nodeCountFormat;
    private MessageFormat nodeCountFormatFullText;
    private final CardLayout contentCards;
    private final CardLayout resultViewCards;
    private final JPanel mainPanel;
    private final JPanel resultsPanel;
    private final JButton btnReplace;
    private final JButton btnModifySearch;
    private final JButton btnShowDetails;
    private final JButton btnStop;
    private final JButton btnPrev;
    private final JButton btnNext;
    private final JToggleButton btnDisplayContext;
    private JSplitPane splitPane;
    private ContextView contextView;
    private IssuesPanel issuesPanel;
    private MatchingObject matchingObjIndexCacheObj = null;
    private int matchingObjIndexCacheIndex = -1;

    static synchronized ResultView getInstance() {
        ResultView view = (ResultView)WindowManager.getDefault().findTopComponent(ID);
        if (view == null) {
            view = ResultView.getDefault();
        }
        return view;
    }

    public static synchronized ResultView getDefault() {
        ResultView view;
        if (instance == null) {
            view = new ResultView();
            instance = new WeakReference<ResultView>(view);
        } else {
            view = (ResultView)((Object)instance.get());
            if (view == null) {
                view = new ResultView();
                instance = new WeakReference<ResultView>(view);
            }
        }
        return view;
    }

    private ResultView() {
        JToolBar toolBar = new JToolBar(1);
        this.btnDisplayContext = new JToggleButton();
        this.btnDisplayContext.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/search/res/context.gif", (boolean)true)));
        this.btnDisplayContext.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TOOLTIP_ShowContext"));
        this.btnDisplayContext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ACSD_ShowContext"));
        this.btnDisplayContext.setSelected(true);
        this.btnPrev = new JButton();
        this.btnPrev.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/search/res/prev.png", (boolean)true)));
        this.btnNext = new JButton();
        this.btnNext.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/search/res/next.png", (boolean)true)));
        toolBar.add(this.btnDisplayContext);
        toolBar.add(new JToolBar.Separator());
        toolBar.add(this.btnPrev);
        toolBar.add(this.btnNext);
        toolBar.setRollover(true);
        toolBar.setFloatable(false);
        this.treeModel = ResultView.createTreeModel();
        this.nodeListener = new NodeListener();
        this.tree = ResultView.createTree(this.treeModel, this.nodeListener);
        this.treeView = new JScrollPane(this.tree);
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResultView.class, (String)"ACS_TREEVIEW"));
        this.treeView.setBorder(BorderFactory.createEmptyBorder());
        this.resultViewCards = new CardLayout();
        this.resultsPanel = new JPanel(this.resultViewCards);
        this.btnShowDetails = new JButton();
        this.btnModifySearch = new JButton();
        this.btnStop = new JButton();
        this.btnReplace = new JButton();
        ButtonListener buttonListener = new ButtonListener();
        this.btnShowDetails.addActionListener(buttonListener);
        this.btnModifySearch.addActionListener(buttonListener);
        this.btnStop.addActionListener(buttonListener);
        this.btnReplace.addActionListener(buttonListener);
        this.btnPrev.addActionListener(buttonListener);
        this.btnNext.addActionListener(buttonListener);
        this.btnDisplayContext.addItemListener(buttonListener);
        Mnemonics.setLocalizedText((AbstractButton)this.btnStop, (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TEXT_BUTTON_STOP"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowDetails, (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TEXT_BUTTON_FILL"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReplace, (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TEXT_BUTTON_REPLACE"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnModifySearch, (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TEXT_BUTTON_CUSTOMIZE"));
        this.btnStop.setEnabled(false);
        this.btnShowDetails.setEnabled(false);
        this.btnReplace.setVisible(false);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(this.btnReplace);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.btnShowDetails);
        buttonsPanel.add(this.btnModifySearch);
        buttonsPanel.add(this.btnStop);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 5));
        this.mainPanel.add((Component)toolBar, "West");
        this.mainPanel.add((Component)this.resultsPanel, "Center");
        this.mainPanel.add((Component)buttonsPanel, "South");
        this.mainPanel.setOpaque(true);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this.contentCards = new CardLayout();
        this.setLayout(this.contentCards);
        this.add(this.mainPanel, RESULTS_CARD);
        this.setName("Search Results");
        this.setDisplayName(NbBundle.getMessage(ResultView.class, (String)"TITLE_SEARCH_RESULTS"));
        this.setToolTipText(NbBundle.getMessage(ResultView.class, (String)"TOOLTIP_SEARCH_RESULTS"));
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/search/res/find.gif"));
        this.initAccessibility();
        this.resultModelChanged();
    }

    private static ResultTreeModel createTreeModel() {
        ResultTreeModel treeModel = new ResultTreeModel(null);
        treeModel.setRootDisplayName(ResultView.getInitialRootNodeText());
        return treeModel;
    }

    private static JTree createTree(ResultTreeModel treeModel, NodeListener nodeListener) {
        JTree tree = new JTree(treeModel);
        tree.setCellRenderer(new NodeRenderer(false));
        tree.putClientProperty("JTree.lineStyle", "Angled");
        tree.addMouseListener(nodeListener);
        tree.addKeyListener(nodeListener);
        tree.addTreeWillExpandListener(nodeListener);
        tree.addTreeExpansionListener(nodeListener);
        tree.setToggleClickCount(0);
        return tree;
    }

    private static String getInitialRootNodeText() {
        return NbBundle.getMessage(ResultView.class, (String)"TEXT_Search_in_filesystems");
    }

    public int getPersistenceType() {
        return 0;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    private Object readResolve() throws ObjectStreamException {
        return ResultView.getDefault();
    }

    private void initAccessibility() {
        ResourceBundle bundle = NbBundle.getBundle(ResultView.class);
        this.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResultViewTopComponent"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResultViewTopComponent"));
        AccessibleContext accessCtx = this.treeView.getHorizontalScrollBar().getAccessibleContext();
        accessCtx.setAccessibleName(bundle.getString("ACSN_HorizontalScrollbar"));
        accessCtx = this.treeView.getVerticalScrollBar().getAccessibleContext();
        accessCtx.setAccessibleName(bundle.getString("ACSN_VerticalScrollbar"));
        accessCtx = this.treeView.getAccessibleContext();
        accessCtx.setAccessibleName(bundle.getString("ACSN_ResultTree"));
        accessCtx.setAccessibleDescription(bundle.getString("ACSD_ResultTree"));
        this.btnReplace.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_REPLACE"));
        this.btnModifySearch.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_CUSTOMIZE"));
        this.btnShowDetails.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_FILL"));
        this.btnStop.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_STOP"));
    }

    void closeResults() {
        this.close();
    }

    public void fillOutput() {
        this.btnShowDetails.setEnabled(false);
        Manager.getInstance().schedulePrintingDetails(this.resultModel.getFoundObjects(), this.resultModel.getSearchGroup());
    }

    private void setRootDisplayName(String displayName) {
        this.treeModel.setRootDisplayName(displayName);
    }

    protected void componentOpened() {
        assert (EventQueue.isDispatchThread());
        Manager.getInstance().searchWindowOpened();
        this.setRootDisplayName(ResultView.getInitialRootNodeText());
        if (this.lastSearchNodes == null) {
            this.btnModifySearch.setEnabled(false);
        }
    }

    protected void componentClosed() {
        assert (EventQueue.isDispatchThread());
        this.rememberInput(null, null);
        Manager.getInstance().searchWindowClosed();
        if (this.contextView != null) {
            this.contextView.unbindFromTreeSelection(this.tree);
            this.contextView = null;
        }
        if (this.splitPane != null) {
            this.rememberDividerLocation();
            this.resultsPanel.remove(this.splitPane);
            this.splitPane = null;
        }
        if (this.issuesPanel != null) {
            this.removeIssuesPanel();
        }
        this.contextViewVisible = false;
        this.contextViewEnabled = true;
    }

    void notifySearchPending(int blockingTask) {
        assert (EventQueue.isDispatchThread());
        this.removeIssuesPanel();
        String msgKey = null;
        switch (blockingTask) {
            case 1: {
                msgKey = "TEXT_FINISHING_PREV_SEARCH";
                break;
            }
            case 2: {
                msgKey = "TEXT_CLEANING_RESULT";
                break;
            }
            case 4: {
                msgKey = "TEXT_PRINTING_DETAILS";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)msgKey));
        this.btnStop.setEnabled(true);
        this.btnReplace.setEnabled(false);
    }

    void searchTaskStateChanged(int changeType) {
        switch (changeType) {
            case 1: {
                this.searchStarted();
                break;
            }
            case 2: {
                this.searchFinished();
                break;
            }
            case 3: {
                this.searchInterrupted();
                break;
            }
            case 4: {
                this.searchCancelled();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void showAllDetailsFinished() {
        assert (EventQueue.isDispatchThread());
        this.updateShowAllDetailsBtn();
    }

    private void searchStarted() {
        assert (EventQueue.isDispatchThread());
        this.removeIssuesPanel();
        this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_SEARCHING___"));
        this.nodeCountFormat = new MessageFormat(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_RootSearchedNodes"));
        this.nodeCountFormatFullText = new MessageFormat(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_RootSearchedNodesFulltext"));
        this.searchInProgress = true;
        this.updateShowAllDetailsBtn();
        this.btnModifySearch.setEnabled(true);
        this.btnStop.setEnabled(true);
        this.btnReplace.setEnabled(false);
    }

    private void searchFinished() {
        assert (EventQueue.isDispatchThread());
        this.setFinalRootNodeText();
        this.searchInProgress = false;
        this.hasDetails = this.resultModel != null ? this.resultModel.hasDetails() : false;
        this.updateShowAllDetailsBtn();
        this.btnStop.setEnabled(false);
        this.btnReplace.setEnabled(true);
    }

    private void searchInterrupted() {
        assert (EventQueue.isDispatchThread());
        this.searchFinished();
    }

    private void searchCancelled() {
        assert (EventQueue.isDispatchThread());
        this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_TASK_CANCELLED"));
        this.searchInProgress = true;
        this.updateShowAllDetailsBtn();
        this.btnStop.setEnabled(false);
        this.btnReplace.setEnabled(true);
    }

    private void setFinalRootNodeText() {
        String baseMsg;
        assert (EventQueue.isDispatchThread());
        int resultSize = this.resultModel.size();
        if (this.resultModel.wasLimitReached()) {
            this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_FOUND_X_NODES_LIMIT", (Object)new Integer(resultSize)));
            return;
        }
        if (resultSize == 0) {
            baseMsg = NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_NO_NODE_FOUND");
        } else {
            Object[] args;
            String bundleKey;
            if (this.resultModel.searchAndReplace) {
                bundleKey = "TEXT_MSG_FOUND_X_NODES_REPLACE";
                args = new Object[4];
            } else if (this.resultModel.fullTextOnly) {
                bundleKey = "TEXT_MSG_FOUND_X_NODES_FULLTEXT";
                args = new Object[2];
            } else {
                bundleKey = "TEXT_MSG_FOUND_X_NODES";
                args = new Object[]{new Integer(this.objectsCount)};
            }
            if (args.length > 1) {
                args[1] = new Integer(this.resultModel.getTotalDetailsCount());
            }
            if (args.length > 2) {
                args[2] = this.resultModel.fullTextSearchType.getMatchTemplateDescr();
                args[3] = this.resultModel.fullTextSearchType.getReplaceString();
            }
            baseMsg = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)bundleKey, (Object[])args);
        }
        String exMsg = this.resultModel.getExceptionMsg();
        String msg = exMsg == null ? baseMsg : baseMsg + " (" + exMsg + ")";
        this.setRootDisplayName(msg);
    }

    private void updateShowAllDetailsBtn() {
        assert (EventQueue.isDispatchThread());
        this.btnShowDetails.setEnabled(this.hasResults && !this.searchInProgress && this.hasDetails);
    }

    void setResultModel(ResultModel resultModel) {
        assert (EventQueue.isDispatchThread());
        if (this.resultModel == null && resultModel == null) {
            return;
        }
        boolean hadCheckBoxes = this.resultModel != null && this.resultModel.searchAndReplace;
        boolean hasCheckBoxes = resultModel != null && resultModel.searchAndReplace;
        this.resultModel = resultModel;
        this.treeModel = new ResultTreeModel(resultModel);
        this.tree.setModel(this.treeModel);
        if (hasCheckBoxes != hadCheckBoxes) {
            this.tree.setCellRenderer(new NodeRenderer(hasCheckBoxes));
            this.btnReplace.setVisible(hasCheckBoxes);
        }
        if (resultModel != null) {
            this.hasResults = !resultModel.isEmpty();
            this.hasDetails = this.hasResults && resultModel.hasDetails();
            resultModel.setObserver(this);
        } else {
            this.hasResults = false;
            this.hasDetails = false;
        }
        this.resultModelChanged();
        this.updateShowAllDetailsBtn();
    }

    private void resultModelChanged() {
        this.updateDisplayContextButton();
        this.updateContextViewVisibility();
        if (this.contextView != null) {
            this.contextView.setResultModel(this.resultModel);
        }
        this.nodeListener.setSelectionChangeEnabled(true);
        this.btnPrev.setEnabled(this.resultModel != null);
        this.btnNext.setEnabled(this.resultModel != null);
        this.resetMatchingObjIndexCache();
        this.objectsCount = 0;
    }

    private boolean isSearchAndReplace() {
        return this.resultModel != null && this.resultModel.searchAndReplace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDisplayContextButton() {
        boolean searchAndReplace = this.isSearchAndReplace();
        this.btnDisplayContext.setEnabled(searchAndReplace);
        this.ignoreContextButtonToggle = true;
        try {
            this.btnDisplayContext.setSelected(searchAndReplace && this.contextViewEnabled);
        }
        finally {
            this.ignoreContextButtonToggle = false;
        }
    }

    private void updateContextViewVisibility() {
        this.setContextViewVisible(this.isSearchAndReplace() && this.contextViewEnabled);
    }

    private void setContextViewVisible(boolean visible) {
        String cardName;
        assert (EventQueue.isDispatchThread());
        assert (this.splitPane == null == (this.contextView == null));
        int componentCount = this.resultsPanel.getComponentCount();
        if (visible == this.contextViewVisible && componentCount != 0) {
            return;
        }
        this.contextViewVisible = visible;
        if (!visible) {
            cardName = "tree only";
            assert (componentCount < 2);
            this.resultsPanel.add((Component)this.treeView, cardName);
            if (this.contextView != null) {
                this.contextView.unbindFromTreeSelection(this.tree);
                this.rememberDividerLocation();
            }
        } else {
            assert (this.resultModel != null);
            cardName = "tree and context";
            if (this.splitPane == null) {
                this.contextView = new ContextView(this.resultModel);
                this.splitPane = new JSplitPane(1, true, this.treeView, this.contextView);
                this.splitPane.setBorder(BorderFactory.createEmptyBorder());
                this.splitPane.setResizeWeight(0.4);
                this.resultsPanel.add((Component)this.splitPane, cardName);
            } else {
                this.splitPane.setLeftComponent(this.treeView);
            }
            this.setDividerLocation();
            this.contextView.bindToTreeSelection(this.tree);
        }
        this.resultViewCards.show(this.resultsPanel, cardName);
        this.treeView.setVisible(true);
    }

    private void rememberDividerLocation() {
        if (this.splitPane == null) {
            return;
        }
        this.dividerLocation = (double)this.splitPane.getDividerLocation() / (double)(this.splitPane.getWidth() - this.splitPane.getDividerSize());
    }

    private void setDividerLocation() {
        assert (this.splitPane != null);
        if (this.dividerLocation != -1.0) {
            this.splitPane.setDividerLocation(this.dividerLocation);
        }
    }

    void objectFound(Object foundObject, final int totalDetailsCount) {
        assert (!EventQueue.isDispatchThread());
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ResultView.this.updateObjectsCount(totalDetailsCount);
            }
        });
    }

    private void updateObjectsCount(int totalDetailsCount) {
        assert (EventQueue.isDispatchThread());
        ++this.objectsCount;
        this.hasResults = true;
        this.setRootDisplayName(this.resultModel.fullTextOnly ? this.nodeCountFormatFullText.format(new Object[]{new Integer(this.objectsCount), new Integer(totalDetailsCount)}) : this.nodeCountFormat.format(new Object[]{new Integer(this.objectsCount)}));
    }

    void removeIssuesPanel() {
        if (this.issuesPanel != null) {
            this.remove(this.issuesPanel);
            this.issuesPanel = null;
        }
        this.contentCards.show((Container)((Object)this), RESULTS_CARD);
    }

    private void goToNext(boolean forward) {
        TreePath nextPath;
        assert (EventQueue.isDispatchThread());
        assert (this.resultModel != null);
        if (!this.hasResults) {
            return;
        }
        TreePath leadPath = this.tree.getLeadSelectionPath();
        if (leadPath == null) {
            leadPath = new TreePath(this.tree.getModel().getRoot());
        }
        if ((nextPath = this.findNextPath(leadPath, forward)) != null) {
            this.tree.expandPath(nextPath.getParentPath());
            this.tree.setSelectionPath(nextPath);
            this.tree.scrollRectToVisible(this.tree.getPathBounds(nextPath));
        }
    }

    private TreePath findNextPath(TreePath forPath, boolean forward) {
        TreePath nextPath;
        TreePath parentPath = forPath.getParentPath();
        if (parentPath == null) {
            Object root = forPath.getLastPathComponent();
            nextPath = forward ? this.getNextDetail(root, null, -1, forward) : null;
        } else {
            Object lastComp = forPath.getLastPathComponent();
            if (lastComp.getClass() == MatchingObject.class) {
                Object root = parentPath.getLastPathComponent();
                MatchingObject matchingObj = (MatchingObject)lastComp;
                nextPath = this.getNextDetail(root, matchingObj, -1, forward);
            } else {
                Object root = parentPath.getParentPath().getLastPathComponent();
                Object parentComp = parentPath.getLastPathComponent();
                assert (parentComp.getClass() == MatchingObject.class);
                MatchingObject matchingObj = (MatchingObject)parentComp;
                int parentPathRow = this.tree.getRowForPath(parentPath);
                int row = this.tree.getRowForPath(forPath);
                int index = row - parentPathRow - 1;
                nextPath = this.getNextDetail(root, matchingObj, index, forward);
            }
        }
        return nextPath;
    }

    private TreePath getNextDetail(Object root, MatchingObject matchingObj, int detailIndex, boolean forward) {
        if (matchingObj != null) {
            int nextDetailIndex;
            int n = nextDetailIndex = forward ? detailIndex + 1 : detailIndex - 1;
            if (nextDetailIndex >= 0 && nextDetailIndex < this.resultModel.getDetailsCount(matchingObj)) {
                return new TreePath(new Object[]{root, matchingObj, this.resultModel.getDetails(matchingObj)[nextDetailIndex]});
            }
        } else if (!forward) {
            return null;
        }
        MatchingObject[] matchingObjs = this.resultModel.getMatchingObjects();
        int currMatchingObjIndex = this.getMatchingObjIndex(matchingObjs, matchingObj, forward);
        if (forward) {
            for (int i = currMatchingObjIndex + 1; i < matchingObjs.length; ++i) {
                MatchingObject nextMatchingObj = matchingObjs[i];
                if (!this.resultModel.hasDetails(nextMatchingObj)) continue;
                return new TreePath(new Object[]{root, nextMatchingObj, this.resultModel.getDetails(nextMatchingObj)[0]});
            }
        } else {
            for (int i = currMatchingObjIndex - 1; i >= 0; --i) {
                MatchingObject nextMatchingObj = matchingObjs[i];
                if (!this.resultModel.hasDetails(nextMatchingObj)) continue;
                Node[] details = this.resultModel.getDetails(nextMatchingObj);
                return new TreePath(new Object[]{root, nextMatchingObj, details[details.length - 1]});
            }
        }
        return null;
    }

    private void resetMatchingObjIndexCache() {
        this.matchingObjIndexCacheObj = null;
        this.matchingObjIndexCacheIndex = -1;
    }

    private int getMatchingObjIndex(MatchingObject[] matchingObjs, MatchingObject matchingObj, boolean forward) {
        if (matchingObj == null) {
            return -1;
        }
        if (matchingObj == this.matchingObjIndexCacheObj) {
            assert (this.matchingObjIndexCacheIndex != -1);
            return this.matchingObjIndexCacheIndex;
        }
        int foundIndex = -1;
        if (this.matchingObjIndexCacheIndex != -1) {
            int i;
            int endIndex;
            int startIndex;
            int quickSearchRange = 3;
            if (forward) {
                startIndex = Math.min(this.matchingObjIndexCacheIndex + 1, matchingObjs.length - 1);
                endIndex = Math.min(this.matchingObjIndexCacheIndex + 3, matchingObjs.length - 1);
                for (i = startIndex; i <= endIndex; ++i) {
                    if (matchingObjs[i] != matchingObj) continue;
                    foundIndex = i;
                    break;
                }
                if (foundIndex == -1 && this.matchingObjIndexCacheIndex > 0 && matchingObjs[i = this.matchingObjIndexCacheIndex - 1] == matchingObj) {
                    foundIndex = i;
                }
            } else {
                startIndex = Math.max(this.matchingObjIndexCacheIndex - 1, 0);
                endIndex = Math.max(this.matchingObjIndexCacheIndex - 3, 0);
                for (i = startIndex; i >= endIndex; --i) {
                    if (matchingObjs[i] != matchingObj) continue;
                    foundIndex = i;
                    break;
                }
                if (foundIndex == -1 && this.matchingObjIndexCacheIndex < matchingObjs.length - 1 && matchingObjs[i = this.matchingObjIndexCacheIndex + 1] == matchingObj) {
                    foundIndex = i;
                }
            }
        }
        if (foundIndex == -1) {
            for (int i = 0; i < matchingObjs.length; ++i) {
                if (matchingObj != matchingObjs[i]) continue;
                foundIndex = i;
                break;
            }
        }
        if (foundIndex != -1) {
            this.matchingObjIndexCacheObj = matchingObj;
            this.matchingObjIndexCacheIndex = foundIndex;
        }
        return foundIndex;
    }

    void rememberInput(Node[] nodes, List enabledSearchTypes) {
        this.lastSearchNodes = nodes;
        this.lastEnabledSearchTypes = enabledSearchTypes;
    }

    private void customizeCriteria() {
        assert (EventQueue.isDispatchThread());
        assert (this.lastSearchNodes != null);
        Node[] nodesToSearch = this.lastSearchNodes;
        List searchTypes = this.lastEnabledSearchTypes;
        ArrayList<Object> searchTypesClone = new ArrayList<Object>(searchTypes.size());
        Iterator it = searchTypes.iterator();
        while (it.hasNext()) {
            searchTypesClone.add(((SearchType)it.next()).clone());
        }
        this.lastEnabledSearchTypes = searchTypesClone;
        SearchPanel searchPanel = new SearchPanel(searchTypesClone, true);
        searchPanel.showDialog();
        if (searchPanel.getReturnStatus() != 1) {
            return;
        }
        this.rememberInput(nodesToSearch, Utils.cloneSearchTypes(searchTypesClone));
        Manager.getInstance().scheduleSearchTask(new SearchTask(nodesToSearch, searchTypesClone, searchPanel.getCustomizedSearchTypes()));
    }

    private void replaceMatches() {
        assert (EventQueue.isDispatchThread());
        this.nodeListener.setSelectionChangeEnabled(false);
        this.btnReplace.setEnabled(false);
        Manager.getInstance().scheduleReplaceTask(new ReplaceTask(this.resultModel.getMatchingObjects()));
    }

    void closeAndSendFocusToEditor() {
        TopComponent tc;
        assert (EventQueue.isDispatchThread());
        this.close();
        Mode m = WindowManager.getDefault().findMode("editor");
        if (m != null && (tc = m.getSelectedTopComponent()) != null) {
            tc.requestActive();
        }
    }

    void displayIssuesToUser(String title, String[] problems, boolean reqAtt) {
        assert (EventQueue.isDispatchThread());
        assert (this.issuesPanel == null);
        this.issuesPanel = new IssuesPanel(title, problems);
        this.add(this.issuesPanel, ISSUES_CARD);
        this.contentCards.show((Container)((Object)this), ISSUES_CARD);
        if (!this.isOpened()) {
            this.open();
        }
        if (reqAtt) {
            this.requestAttention(true);
        }
    }

    void rescan() {
        assert (EventQueue.isDispatchThread());
        this.removeIssuesPanel();
        Manager.getInstance().scheduleSearchTaskRerun();
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private class ButtonListener
    implements ActionListener,
    ItemListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == ResultView.this.btnStop) {
                Manager.getInstance().stopSearching();
            } else if (source == ResultView.this.btnModifySearch) {
                ResultView.this.customizeCriteria();
            } else if (source == ResultView.this.btnShowDetails) {
                ResultView.this.fillOutput();
            } else if (source == ResultView.this.btnReplace) {
                ResultView.this.replaceMatches();
            } else if (source == ResultView.this.btnPrev) {
                ResultView.this.goToNext(false);
            } else if (source == ResultView.this.btnNext) {
                ResultView.this.goToNext(true);
            } else assert (false);
        }

        public void itemStateChanged(ItemEvent e) {
            assert (e.getSource() == ResultView.this.btnDisplayContext);
            if (!ResultView.this.ignoreContextButtonToggle) {
                ResultView.this.contextViewEnabled = e.getStateChange() == 1;
                ResultView.this.updateContextViewVisibility();
            }
        }
    }

    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7398708142639457544L;

        public Object readResolve() {
            return ResultView.getDefault();
        }
    }
}

