/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.SearchCriterion;
import org.netbeans.modules.search.SearchProjectSettings;
import org.netbeans.modules.search.SearchTypePanel;
import org.netbeans.modules.search.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openidex.search.SearchType;

public final class SearchPanel
extends JPanel
implements PropertyChangeListener,
FocusListener,
ChangeListener,
ActionListener {
    public static final String PROP_DIALOG_TITLE = "Find Files dialog title";
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private DialogDescriptor dialogDescriptor;
    private final JButton okButton;
    private final JButton cancelButton;
    private Dialog dialog;
    private int returnStatus = 0;
    private List orderedSearchTypePanels;
    private boolean customized;
    private JTabbedPane tabbedPane;

    public SearchPanel(List searchTypeList) {
        this(searchTypeList, false);
    }

    public SearchPanel(List searchTypeList, boolean activateWithPreviousValues) {
        this.orderedSearchTypePanels = new ArrayList(searchTypeList.size());
        SearchCriterion[] allCriteria = SearchProjectSettings.getInstance().getSearchCriteria();
        Map sortedCriteria = Utils.sortCriteriaBySearchType(allCriteria);
        ArrayList<String> processedClassNames = new ArrayList<String>();
        for (SearchType searchType : searchTypeList) {
            String className = searchType.getClass().getName();
            if (processedClassNames.contains(className)) continue;
            processedClassNames.add(className);
            boolean initPanelFromHistory = !activateWithPreviousValues && FindDialogMemory.getDefault().wasSearchTypeUsed(searchType.getClass().getName());
            SearchTypePanel newPanel = new SearchTypePanel(searchType, initPanelFromHistory);
            Collection savedCriteria = sortedCriteria == null ? null : (Collection)sortedCriteria.get(className);
            int index = this.orderedSearchTypePanels.indexOf(newPanel);
            if (savedCriteria != null) {
                SearchTypePanel targetPanel = index == -1 ? newPanel : (SearchTypePanel)this.orderedSearchTypePanels.get(index);
                targetPanel.addSavedCriteria(Collections.unmodifiableCollection(savedCriteria));
            }
            if (index != -1) continue;
            this.orderedSearchTypePanels.add(newPanel);
            newPanel.addPropertyChangeListener(this);
        }
        this.initComponents();
        Iterator it = this.orderedSearchTypePanels.iterator();
        while (it.hasNext()) {
            this.tabbedPane.add((Component)it.next());
        }
        int index = 0;
        if (activateWithPreviousValues && (index = this.getIndexOfSearchType(FindDialogMemory.getDefault().getLastSearchType())) < 0) {
            index = 0;
        }
        this.tabbedPane.setSelectedIndex(index);
        this.setName(NbBundle.getBundle(SearchPanel.class).getString("TEXT_TITLE_CUSTOMIZE"));
        this.okButton = new JButton(NbBundle.getBundle(SearchPanel.class).getString("TEXT_BUTTON_SEARCH"));
        this.updateIsCustomized();
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getBundle(SearchPanel.class).getString("TEXT_BUTTON_CANCEL"));
        Object[] options = new Object[]{this.okButton, this.cancelButton};
        this.initAccessibility();
        this.dialogDescriptor = new DialogDescriptor((Object)this, this.getName(), true, options, options[0], 0, null, (ActionListener)this);
    }

    public void actionPerformed(ActionEvent evt) {
        this.doClose(evt.getSource() == this.okButton ? 1 : 0);
    }

    void setTitle(String title) {
        this.dialogDescriptor.setTitle(title);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SearchPanel.class).getString("ACS_SearchPanel"));
        this.tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle(SearchPanel.class).getString("ACSN_Tabs"));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SearchPanel.class).getString("ACSD_Tabs"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SearchPanel.class).getString("ACS_TEXT_BUTTON_SEARCH"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SearchPanel.class).getString("ACS_TEXT_BUTTON_CANCEL"));
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabbedPane, gridBagConstraints);
    }

    public boolean isCustomized() {
        return this.customized;
    }

    private List getOrderedSearchTypePanels() {
        return new ArrayList(this.orderedSearchTypePanels);
    }

    private String getTabText(int index) {
        try {
            return ((SearchTypePanel)this.getOrderedSearchTypePanels().get(index)).getName();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    public SearchType[] getCustomizedSearchTypes() {
        ArrayList<SearchType> searchTypeList = new ArrayList<SearchType>(this.orderedSearchTypePanels.size());
        for (SearchTypePanel searchTypePanel : this.orderedSearchTypePanels) {
            if (!searchTypePanel.isCustomized()) continue;
            searchTypeList.add(searchTypePanel.getSearchType());
        }
        return searchTypeList.toArray(new SearchType[searchTypeList.size()]);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void doClose(int returnStatus) {
        int selectedIndex;
        for (SearchTypePanel panel : this.orderedSearchTypePanels) {
            panel.removePropertyChangeListener(this);
        }
        if (returnStatus == 1) {
            FindDialogMemory.getDefault().clearSearchTypesUsed();
        }
        if ((selectedIndex = this.tabbedPane.getSelectedIndex()) >= 0) {
            SearchTypePanel panel = this.getSearchTypePanel(selectedIndex);
            if (returnStatus == 1) {
                FindDialogMemory.getDefault().setLastUsedSearchType(panel.getSearchType());
                panel.onOk();
            } else {
                panel.onCancel();
            }
        }
        this.returnStatus = returnStatus;
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void showDialog() {
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        this.dialog.setModal(true);
        this.tabbedPane.addFocusListener(this);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void focusGained(FocusEvent e) {
        SearchTypePanel panel;
        this.tabbedPane.removeFocusListener(this);
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex >= 0 && (panel = this.getSearchTypePanel(selectedIndex)) != null && panel.customizerComponent != null) {
            panel.customizerComponent.requestFocus();
        }
        this.tabbedPane.addChangeListener(this);
    }

    public void focusLost(FocusEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        SearchTypePanel panel;
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex >= 0 && (panel = this.getSearchTypePanel(selectedIndex)) != null) {
            panel.initializeWithObject();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("customized".equals(event.getPropertyName())) {
            this.updateIsCustomized();
        }
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            this.tabbedPane.setTitleAt(i, this.getTabText(i));
            this.tabbedPane.setIconAt(i, null);
        }
    }

    private void updateIsCustomized() {
        this.customized = this.getCustomizedSearchTypes().length != 0;
        this.okButton.setEnabled(this.isCustomized());
    }

    private SearchTypePanel getSearchTypePanel(int index) {
        SearchTypePanel searchTypePanel = null;
        Iterator it = this.getOrderedSearchTypePanels().iterator();
        while (index >= 0 && it.hasNext()) {
            searchTypePanel = (SearchTypePanel)it.next();
            --index;
        }
        return searchTypePanel;
    }

    private int getIndexOfSearchType(SearchType searchTypeToFind) {
        if (searchTypeToFind == null) {
            return -1;
        }
        SearchTypePanel searchTypePanel = null;
        Iterator it = this.getOrderedSearchTypePanels().iterator();
        int index = -1;
        while (it.hasNext()) {
            ++index;
            searchTypePanel = (SearchTypePanel)it.next();
            if (searchTypePanel.getSearchType().getClass() != searchTypeToFind.getClass()) continue;
            return index;
        }
        return -1;
    }
}

