/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.search.SearchCriterion;
import org.openide.ErrorManager;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openidex.search.SearchType;

public class SearchProjectSettings
extends SystemOption {
    private static final long serialVersionUID = 6955446757377175182L;
    public static final String PROP_CRITERIA = "search criteria";
    private static SearchCriterion[] searchCriteria;

    public String displayName() {
        return NbBundle.getBundle(SearchProjectSettings.class).getString("TEXT_Search_settings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SearchProjectSettings.class);
    }

    private void importOldSettings() {
        ArrayList<SearchCriterion> oldCriteria = new ArrayList<SearchCriterion>();
        Collection instances = Lookup.getDefault().lookup(new Lookup.Template(SearchType.class)).allInstances();
        for (SearchType instance : instances) {
            if (!instance.isValid()) continue;
            try {
                oldCriteria.add(new SearchCriterion(instance));
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
            }
        }
        if (oldCriteria.isEmpty()) {
            searchCriteria = new SearchCriterion[0];
        } else {
            searchCriteria = new SearchCriterion[oldCriteria.size()];
            oldCriteria.toArray(searchCriteria);
        }
    }

    public SearchCriterion[] getSearchCriteria() {
        if (searchCriteria == null) {
            this.importOldSettings();
        }
        return searchCriteria;
    }

    public void setSearchCriteria(SearchCriterion[] criteria) {
        if (criteria == null) {
            criteria = new SearchCriterion[]{};
        }
        SearchCriterion[] old = searchCriteria;
        searchCriteria = criteria;
        this.firePropertyChange(PROP_CRITERIA, old, searchCriteria);
    }

    static final SearchProjectSettings getInstance() {
        return (SearchProjectSettings)SharedClassObject.findObject(SearchProjectSettings.class, (boolean)true);
    }

    void addSearchCriterion(SearchCriterion c) {
        if (searchCriteria == null) {
            searchCriteria = new SearchCriterion[1];
            SearchProjectSettings.searchCriteria[0] = c;
            this.firePropertyChange(PROP_CRITERIA, null, searchCriteria);
        } else {
            SearchCriterion[] old = searchCriteria;
            searchCriteria = new SearchCriterion[old.length + 1];
            System.arraycopy(old, 0, searchCriteria, 0, old.length);
            SearchProjectSettings.searchCriteria[old.length] = c;
            this.firePropertyChange(PROP_CRITERIA, old, searchCriteria);
        }
    }

    boolean replaceSearchCriterion(String name, String className, SearchCriterion c) {
        if (searchCriteria == null) {
            return false;
        }
        for (int i = 0; i < searchCriteria.length; ++i) {
            SearchCriterion candidate = searchCriteria[i];
            if (!candidate.name.equals(name) || !candidate.searchTypeClassName.equals(className)) continue;
            SearchProjectSettings.searchCriteria[i] = c;
            this.markSearchCriteriaChanged();
            return true;
        }
        return false;
    }

    void markSearchCriteriaChanged() {
        this.firePropertyChange(PROP_CRITERIA, null, null);
    }
}

