/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.search.types.DataObjectType;

public abstract class TextType
extends DataObjectType {
    private static final long serialVersionUID = 3L;
    private static final String WORD_SEPARATORS = " \t,;.:+-*/\\()[]{}<>=&|\"'`~!?@#%^\n\r";
    protected boolean caseSensitive;
    protected boolean wholeWords;
    protected transient String ciMatchString;
    protected String matchString;
    protected String reString;
    protected transient Pattern pattern;
    private transient Matcher matcher;

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (!this.caseSensitive && this.matchString != null) {
            this.ciMatchString = this.matchString.toUpperCase();
        }
        if (this.reString != null) {
            this.setRe(this.reString);
        }
    }

    protected boolean match(String text) {
        if (this.matchString != null) {
            int matchIndex;
            if (text.length() < this.matchString.length()) {
                return false;
            }
            if (!this.caseSensitive) {
                text = text.toUpperCase();
            }
            int fromIndex = 1;
            int fromIndexMax = text.length() - this.matchString.length() + 1;
            do {
                matchIndex = this.matchString(text, fromIndex);
                fromIndex = Math.abs(matchIndex) + 1;
            } while (matchIndex < 0 && fromIndex <= fromIndexMax);
            return matchIndex > 0;
        }
        return this.matchRE(text);
    }

    protected boolean matchRE(String line) {
        this.matcher = this.pattern.matcher(line);
        return this.matcher.find();
    }

    protected Matcher getMatcher() {
        return this.matcher;
    }

    protected int matchString(String text, int fromIndex) {
        int boundaryIndex;
        assert (fromIndex >= 1);
        int index = text.indexOf(this.caseSensitive ? this.matchString : this.ciMatchString, fromIndex - 1);
        int retValue = index + 1;
        if (this.wholeWords && retValue != 0 && ((boundaryIndex = index - 1) >= 0 && WORD_SEPARATORS.indexOf(text.charAt(boundaryIndex)) < 0 || (boundaryIndex = index + this.matchString.length()) < text.length() && WORD_SEPARATORS.indexOf(text.charAt(boundaryIndex)) < 0)) {
            retValue = -retValue;
        }
        return retValue;
    }

    public String getMatchString() {
        if (this.matchString == null) {
            return "";
        }
        return this.matchString;
    }

    public void setMatchString(String substring) {
        if (substring == null) {
            this.setValid(false);
            throw new IllegalArgumentException();
        }
        if (substring.length() == 0) {
            substring = null;
        } else if (!this.caseSensitive) {
            this.ciMatchString = substring.toUpperCase();
        }
        this.matchString = substring;
        this.pattern = null;
        this.reString = null;
        this.setValid(substring != null);
    }

    public String getRe() {
        if (this.reString == null) {
            return "";
        }
        return this.reString;
    }

    public String getMatchTemplateDescr() {
        return this.matchString != null ? this.matchString : this.reString;
    }

    public Pattern getSearchPattern() {
        if (this.pattern == null) {
            String regexp;
            assert (this.matchString != null);
            String quoted = TextType.quoteString(this.matchString);
            if (!this.wholeWords) {
                regexp = quoted;
            } else {
                StringBuilder buf = new StringBuilder(quoted.length() + 6);
                if (this.wholeWords) {
                    buf.append("\\b");
                }
                buf.append(quoted);
                if (this.wholeWords) {
                    buf.append("\\b");
                }
                regexp = buf.toString();
            }
            int flags = 64;
            if (!this.caseSensitive) {
                flags |= 2;
            }
            this.pattern = Pattern.compile(regexp, flags);
        }
        return this.pattern;
    }

    private static String quoteString(String string) {
        StringBuilder buf;
        if (string.length() == 0) {
            return string;
        }
        int startIndex = 0;
        int endIndex = string.indexOf(92);
        if (endIndex == -1) {
            buf = new StringBuilder(string.length() + 4);
            buf.append("\\Q").append(string).append("\\E");
        } else {
            buf = new StringBuilder(string.length() + 16);
            do {
                if (endIndex != startIndex) {
                    buf.append("\\Q");
                    buf.append(string.substring(startIndex, endIndex));
                    buf.append("\\E");
                }
                buf.append('\\').append('\\');
            } while ((endIndex = string.indexOf(92, startIndex = endIndex + 1)) != -1);
            if (startIndex != string.length()) {
                buf.append("\\Q");
                buf.append(string.substring(startIndex));
                buf.append("\\E");
            }
        }
        return buf.toString();
    }

    public void setRe(String re) {
        this.setReImpl(re);
    }

    private void setReImpl(String exp) {
        if (exp == null) {
            this.setValid(false);
            throw new IllegalArgumentException();
        }
        if (exp.length() == 0) {
            exp = null;
        } else {
            try {
                this.pattern = Pattern.compile(exp);
            }
            catch (PatternSyntaxException ex) {
                this.setValid(false);
                throw new IllegalArgumentException();
            }
        }
        this.reString = exp;
        this.matchString = null;
        this.setValid(exp != null);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        if (caseSensitive == this.caseSensitive) {
            return;
        }
        this.caseSensitive = caseSensitive;
        if (this.matchString != null) {
            this.ciMatchString = caseSensitive ? null : this.matchString.toUpperCase();
        }
    }

    public boolean getWholeWords() {
        return this.wholeWords;
    }

    public void setWholeWords(boolean wholeWords) {
        if (wholeWords == this.wholeWords) {
            return;
        }
        this.wholeWords = wholeWords;
    }
}

