/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DrawEngineDocView;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.FixLineSyntaxState;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.LocalBaseAction;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.MacroDialogSupport;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.view.spi.ViewUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.search.EditorFindSupport;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class ActionFactory {
    private ActionFactory() {
    }

    private static Fold getLineFold(FoldHierarchy hierarchy, int dot, int lineStart, int lineEnd) {
        Fold nextFold;
        Fold caretOffsetFold = FoldUtilities.findOffsetFold((FoldHierarchy)hierarchy, (int)dot);
        Fold fold = FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)lineStart);
        while (fold != null && (fold.getEndOffset() <= dot || !fold.isCollapsed() && fold.getFoldCount() > 0 && fold.getStartOffset() + 1 < dot) && (nextFold = FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)(fold.getFoldCount() > 0 ? fold.getStartOffset() + 1 : fold.getEndOffset()))) != null && nextFold.getStartOffset() < lineEnd) {
            if (nextFold == fold) {
                return fold;
            }
            fold = nextFold;
        }
        if (fold == null || fold.getStartOffset() > lineEnd) {
            if (caretOffsetFold == null) {
                caretOffsetFold = FoldUtilities.findOffsetFold((FoldHierarchy)hierarchy, (int)lineStart);
            }
            return caretOffsetFold;
        }
        if (caretOffsetFold == null) {
            return fold;
        }
        if (caretOffsetFold.isCollapsed()) {
            return caretOffsetFold;
        }
        if (caretOffsetFold.getEndOffset() > fold.getEndOffset() && fold.getEndOffset() > dot) {
            return fold;
        }
        if (fold.getStartOffset() > caretOffsetFold.getEndOffset()) {
            return caretOffsetFold;
        }
        if (fold.getEndOffset() < dot) {
            return caretOffsetFold;
        }
        return fold;
    }

    public static class AbbrevExpandAction
    extends LocalBaseAction {
        static final long serialVersionUID = -2124569510083544403L;

        public AbbrevExpandAction() {
            super("abbrev-expand", 26);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                EditorUI editorUI = ((BaseTextUI)target.getUI()).getEditorUI();
                try {
                    editorUI.getAbbrev().checkAndExpand(evt);
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class AbbrevResetAction
    extends LocalBaseAction {
        static final long serialVersionUID = -2807497346060448395L;

        public AbbrevResetAction() {
            super("abbrev-reset", 4);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }
    }

    public static class AdjustCaretAction
    extends LocalBaseAction {
        int percentFromWindowTop;
        static final long serialVersionUID = 3223383913531191066L;

        public AdjustCaretAction(String name, int percentFromWindowTop) {
            super(name);
            this.percentFromWindowTop = percentFromWindowTop;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Utilities.getEditorUI(target).adjustCaret(this.percentFromWindowTop);
            }
        }
    }

    public static class AdjustWindowAction
    extends LocalBaseAction {
        int percentFromWindowTop;
        static final long serialVersionUID = 8864278998999643292L;

        public AdjustWindowAction(String name, int percentFromWindowTop) {
            super(name);
            this.percentFromWindowTop = percentFromWindowTop;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Utilities.getEditorUI(target).adjustWindow(this.percentFromWindowTop);
            }
        }
    }

    public static class AnnotationsCyclingAction
    extends LocalBaseAction {
        public AnnotationsCyclingAction() {
            super("annotations-cycling");
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                try {
                    Caret caret = target.getCaret();
                    BaseDocument doc = Utilities.getDocument(target);
                    int caretLine = Utilities.getLineOffset(doc, caret.getDot());
                    AnnotationDesc aDesc = doc.getAnnotations().activateNextAnnotation(caretLine);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class ChangeCaseAction
    extends LocalBaseAction {
        int changeCaseMode;
        static final long serialVersionUID = 5680212865619897402L;

        public ChangeCaseAction(String name, int changeCaseMode) {
            super(name, 30);
            this.changeCaseMode = changeCaseMode;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = target.getCaret();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    if (caret.isSelectionVisible()) {
                        int startPos = target.getSelectionStart();
                        int endPos = target.getSelectionEnd();
                        Utilities.changeCase(doc, startPos, endPos - startPos, this.changeCaseMode);
                        caret.setSelectionVisible(false);
                        caret.setDot(endPos);
                    } else {
                        int dotPos = caret.getDot();
                        Utilities.changeCase(doc, dotPos, 1, this.changeCaseMode);
                        caret.setDot(dotPos + 1);
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class CollapseAllFolds
    extends LocalBaseAction {
        public CollapseAllFolds() {
            super("collapse-all-folds");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.collapseAll((FoldHierarchy)hierarchy);
        }
    }

    public static class CollapseFold
    extends LocalBaseAction {
        public CollapseFold() {
            super("collapse-fold");
        }

        private boolean dotInFoldArea(JTextComponent target, Fold fold, int dot) throws BadLocationException {
            int foldStart = fold.getStartOffset();
            int foldEnd = fold.getEndOffset();
            int foldRowStart = javax.swing.text.Utilities.getRowStart(target, foldStart);
            int foldRowEnd = javax.swing.text.Utilities.getRowEnd(target, foldEnd);
            return foldRowStart <= dot && foldRowEnd >= dot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            Fold fold;
            int dot;
            FoldHierarchy hierarchy;
            block7: {
                hierarchy = FoldHierarchy.get((JTextComponent)target);
                dot = target.getCaret().getDot();
                hierarchy.lock();
                int rowStart = javax.swing.text.Utilities.getRowStart(target, dot);
                int rowEnd = javax.swing.text.Utilities.getRowEnd(target, dot);
                fold = FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)rowStart);
                fold = ActionFactory.getLineFold(hierarchy, dot, rowStart, rowEnd);
                if (fold != null) break block7;
                hierarchy.unlock();
                return;
            }
            try {
                try {
                    if (this.dotInFoldArea(target, fold, dot)) {
                        hierarchy.collapse(fold);
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                hierarchy.unlock();
            }
        }
    }

    static class CopySelectionElseLineDownAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public CopySelectionElseLineDownAction() {
            super("copy-selection-else-line-down", 30);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block13: {
                if (target != null) {
                    if (!target.isEditable() || !target.isEnabled()) {
                        target.getToolkit().beep();
                        return;
                    }
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    doc.atomicLock();
                    DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                    try {
                        int start;
                        Element rootElement = doc.getDefaultRootElement();
                        Caret caret = target.getCaret();
                        boolean selection = false;
                        boolean backwardSelection = false;
                        int end = start = target.getCaretPosition();
                        if (caret.isSelectionVisible()) {
                            int selStart = caret.getDot();
                            int selEnd = caret.getMark();
                            start = Math.min(selStart, selEnd);
                            end = Math.max(selStart, selEnd) - 1;
                            selection = true;
                            backwardSelection = selStart >= selEnd;
                        }
                        int zeroBaseStartLineNumber = rootElement.getElementIndex(start);
                        int zeroBaseEndLineNumber = rootElement.getElementIndex(end);
                        if (zeroBaseEndLineNumber == -1) {
                            target.getToolkit().beep();
                            return;
                        }
                        try {
                            Element startLineElement = rootElement.getElement(zeroBaseStartLineNumber);
                            int startLineStartOffset = startLineElement.getStartOffset();
                            Element endLineElement = rootElement.getElement(zeroBaseEndLineNumber);
                            int endLineEndOffset = endLineElement.getEndOffset();
                            String linesText = doc.getText(startLineStartOffset, endLineEndOffset - startLineStartOffset);
                            int column = start - startLineStartOffset;
                            doc.insertString(endLineEndOffset, linesText, null);
                            if (selection) {
                                if (backwardSelection) {
                                    caret.setDot(endLineEndOffset + column);
                                    caret.moveDot(endLineEndOffset + (endLineEndOffset - startLineStartOffset) - (endLineEndOffset - end - 1));
                                } else {
                                    caret.setDot(endLineEndOffset + (endLineEndOffset - startLineStartOffset) - (endLineEndOffset - end - 1));
                                    caret.moveDot(endLineEndOffset + column);
                                }
                                break block13;
                            }
                            target.setCaretPosition(Math.min(doc.getLength() - 1, endLineEndOffset + column));
                        }
                        catch (BadLocationException ex) {
                            target.getToolkit().beep();
                        }
                    }
                    finally {
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                        doc.atomicUnlock();
                    }
                }
            }
        }
    }

    static class CopySelectionElseLineUpAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public CopySelectionElseLineUpAction() {
            super("copy-selection-else-line-up", 30);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block13: {
                if (target != null) {
                    if (!target.isEditable() || !target.isEnabled()) {
                        target.getToolkit().beep();
                        return;
                    }
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    doc.atomicLock();
                    DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                    try {
                        int start;
                        Element rootElement = doc.getDefaultRootElement();
                        Caret caret = target.getCaret();
                        boolean selection = false;
                        boolean backwardSelection = false;
                        int end = start = target.getCaretPosition();
                        if (caret.isSelectionVisible()) {
                            int selStart = caret.getDot();
                            int selEnd = caret.getMark();
                            start = Math.min(selStart, selEnd);
                            end = Math.max(selStart, selEnd) - 1;
                            selection = true;
                            backwardSelection = selStart >= selEnd;
                        }
                        int zeroBaseStartLineNumber = rootElement.getElementIndex(start);
                        int zeroBaseEndLineNumber = rootElement.getElementIndex(end);
                        if (zeroBaseStartLineNumber == -1) {
                            target.getToolkit().beep();
                            return;
                        }
                        try {
                            Element startLineElement = rootElement.getElement(zeroBaseStartLineNumber);
                            int startLineStartOffset = startLineElement.getStartOffset();
                            Element endLineElement = rootElement.getElement(zeroBaseEndLineNumber);
                            int endLineEndOffset = endLineElement.getEndOffset();
                            String linesText = doc.getText(startLineStartOffset, endLineEndOffset - startLineStartOffset);
                            int column = start - startLineStartOffset;
                            doc.insertString(startLineStartOffset, linesText, null);
                            if (selection) {
                                if (backwardSelection) {
                                    caret.setDot(startLineStartOffset + column);
                                    caret.moveDot(startLineStartOffset + (endLineEndOffset - startLineStartOffset) - (endLineEndOffset - end - 1));
                                } else {
                                    caret.setDot(startLineStartOffset + (endLineEndOffset - startLineStartOffset) - (endLineEndOffset - end - 1));
                                    caret.moveDot(startLineStartOffset + column);
                                }
                                break block13;
                            }
                            target.setCaretPosition(startLineStartOffset + column);
                        }
                        catch (BadLocationException ex) {
                            target.getToolkit().beep();
                        }
                    }
                    finally {
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                        doc.atomicUnlock();
                    }
                }
            }
        }
    }

    public static class CutToLineBeginOrEndAction
    extends LocalBaseAction {
        private final boolean toLineEnd;

        public CutToLineBeginOrEndAction(boolean toLineEnd) {
            super(toLineEnd ? "cut-to-line-end" : "cut-to-line-begin", 14);
            this.toLineEnd = toLineEnd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            BaseDocument doc = (BaseDocument)target.getDocument();
            doc.atomicLock();
            DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
            try {
                Action cutAction;
                ActionMap actionMap = target.getActionMap();
                if (actionMap != null && (cutAction = actionMap.get("cut-to-clipboard")) != null) {
                    int boundOffset;
                    Caret caret = target.getCaret();
                    int caretOffset = caret.getDot();
                    int n = boundOffset = this.toLineEnd ? Utilities.getRowEnd(target, caretOffset) : Utilities.getRowStart(target, caretOffset);
                    if (this.toLineEnd) {
                        String text = target.getText(caretOffset, boundOffset - caretOffset);
                        if (boundOffset < doc.getLength() && text != null && text.matches("^[\\s]*$")) {
                            ++boundOffset;
                        }
                    }
                    caret.moveDot(boundOffset);
                    cutAction.actionPerformed(evt);
                }
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
            finally {
                DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                doc.atomicUnlock();
            }
        }
    }

    public static class DumpViewHierarchyAction
    extends LocalBaseAction {
        public DumpViewHierarchyAction() {
            super("dump-view-hierarchy");
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            DrawEngineDocView rootView = (DrawEngineDocView)Utilities.getDocumentView(target);
            AbstractDocument adoc = (AbstractDocument)target.getDocument();
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            adoc.readLock();
            try {
                hierarchy.lock();
                try {
                    System.err.println("FOLD HIERARCHY DUMP:\n" + hierarchy);
                }
                finally {
                    hierarchy.unlock();
                }
            }
            finally {
                adoc.readUnlock();
            }
            System.err.println("DOCUMENT VIEW: " + System.identityHashCode(rootView) + ", " + rootView + "\nLINE VIEWS:\n" + rootView.childrenToString());
            int caretOffset = target.getCaretPosition();
            int caretViewIndex = rootView.getViewIndex(caretOffset, Position.Bias.Forward);
            System.err.println("caretOffset=" + caretOffset + ", caretViewIndex=" + caretViewIndex);
            if (caretViewIndex >= 0 && caretViewIndex < rootView.getViewCount()) {
                View caretView = rootView.getView(caretViewIndex);
                System.err.println("caretView: " + caretView);
            }
            System.err.println(FixLineSyntaxState.lineInfosToString(adoc));
            ViewUtilities.checkViewHierarchy(rootView);
            if (adoc instanceof BaseDocument) {
                System.err.println("DOCUMENT:\n" + ((BaseDocument)adoc).toStringDetail());
            }
        }
    }

    public static class ExpandAllFolds
    extends LocalBaseAction {
        public ExpandAllFolds() {
            super("expand-all-folds");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.expandAll((FoldHierarchy)hierarchy);
        }
    }

    public static class ExpandFold
    extends LocalBaseAction {
        public ExpandFold() {
            super("expand-fold");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            int dot = target.getCaret().getDot();
            hierarchy.lock();
            try {
                try {
                    int rowStart = javax.swing.text.Utilities.getRowStart(target, dot);
                    int rowEnd = javax.swing.text.Utilities.getRowEnd(target, dot);
                    Fold fold = ActionFactory.getLineFold(hierarchy, dot, rowStart, rowEnd);
                    if (fold != null) {
                        hierarchy.expand(fold);
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
            finally {
                hierarchy.unlock();
            }
        }
    }

    public static class FindNextAction
    extends LocalBaseAction {
        static final long serialVersionUID = 6878814427731642684L;

        public FindNextAction() {
            super("find-next", 30);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/find_next.png");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                EditorFindSupport.getInstance().find(null, false);
            }
        }
    }

    public static class FindPreviousAction
    extends LocalBaseAction {
        static final long serialVersionUID = -43746947902694926L;

        public FindPreviousAction() {
            super("find-previous", 30);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/find_previous.png");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                EditorFindSupport.getInstance().find(null, true);
            }
        }
    }

    public static class FindSelectionAction
    extends LocalBaseAction {
        static final long serialVersionUID = -5601618936504699565L;

        public FindSelectionAction() {
            super("find-selection");
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/find_selection.png");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Boolean revertValue;
                EditorFindSupport findSupport = EditorFindSupport.getInstance();
                Caret caret = target.getCaret();
                int dotPos = caret.getDot();
                HashMap<String, Object> props = new HashMap<String, Object>(findSupport.getFindProperties());
                String searchWord = null;
                boolean revert = false;
                Boolean originalValue = null;
                HashMap<String, Boolean> revertMap = (HashMap<String, Boolean>)props.get("revert-map");
                Boolean bl = revertValue = revertMap != null ? (Boolean)revertMap.get("find-whole-words") : null;
                if (caret.isSelectionVisible()) {
                    searchWord = target.getSelectedText();
                    originalValue = props.put("find-whole-words", Boolean.FALSE);
                    if (Boolean.FALSE.equals(revertValue)) {
                        revertMap.remove("find-whole-words");
                    } else {
                        revert = !Boolean.FALSE.equals(originalValue);
                    }
                } else {
                    try {
                        searchWord = Utilities.getIdentifier((BaseDocument)target.getDocument(), dotPos);
                        originalValue = props.put("find-whole-words", Boolean.TRUE);
                        if (Boolean.TRUE.equals(revertValue)) {
                            revertMap.remove("find-whole-words");
                        } else {
                            revert = !Boolean.TRUE.equals(originalValue);
                        }
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
                if (searchWord != null) {
                    int n = searchWord.indexOf(10);
                    if (n >= 0) {
                        searchWord = searchWord.substring(0, n);
                    }
                    props.put("find-what", searchWord);
                    if (revert) {
                        revertMap = new HashMap<String, Boolean>();
                        revertMap.put("find-whole-words", originalValue != null ? originalValue : Boolean.FALSE);
                        props.put("revert-map", revertMap);
                    }
                    findSupport.putFindProperties(props);
                    findSupport.find(null, false);
                }
            }
        }
    }

    public static class FirstNonWhiteAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = -5888439539790901158L;

        public FirstNonWhiteAction(String nm, boolean select) {
            super(nm, 30);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int pos = Utilities.getRowFirstNonWhite((BaseDocument)target.getDocument(), caret.getDot());
                    if (pos >= 0) {
                        if (this.select) {
                            caret.moveDot(pos);
                        } else {
                            caret.setDot(pos);
                        }
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class FormatAction
    extends LocalBaseAction {
        static final long serialVersionUID = -7666172828961171865L;

        public FormatAction() {
            super("format", 14);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                GuardedDocument gdoc = doc instanceof GuardedDocument ? (GuardedDocument)doc : null;
                Cursor origCursor = target.getCursor();
                target.setCursor(Cursor.getPredefinedCursor(3));
                doc.atomicLock();
                try {
                    Position endPosition;
                    int startPos;
                    if (caret.isSelectionVisible()) {
                        startPos = target.getSelectionStart();
                        endPosition = doc.createPosition(target.getSelectionEnd());
                    } else {
                        startPos = 0;
                        endPosition = doc.createPosition(doc.getLength());
                    }
                    int pos = startPos;
                    if (gdoc != null) {
                        pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
                    }
                    while (pos < endPosition.getOffset()) {
                        int stopPos = endPosition.getOffset();
                        if (gdoc != null && ((stopPos = gdoc.getGuardedBlockChain().adjustToNextBlockStart(pos)) == -1 || stopPos > endPosition.getOffset())) {
                            stopPos = endPosition.getOffset();
                        }
                        int reformattedLen = doc.getFormatter().reformat(doc, pos, stopPos);
                        pos += reformattedLen;
                        if (gdoc == null) continue;
                        pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
                    }
                }
                catch (GuardedException e) {
                    target.getToolkit().beep();
                }
                catch (BadLocationException e) {
                    Utilities.annotateLoggable(e);
                }
                finally {
                    doc.atomicUnlock();
                    target.setCursor(origCursor);
                }
            }
        }
    }

    public static class GenerateGutterPopupAction
    extends LocalBaseAction {
        static final long serialVersionUID = -3502499718130556525L;

        public GenerateGutterPopupAction() {
            super("generate-gutter-popup");
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }

        public JMenuItem getPopupMenuItem(JTextComponent target) {
            EditorUI ui = Utilities.getEditorUI(target);
            try {
                return ui.getDocument().getAnnotations().createMenu(Utilities.getKit(target), Utilities.getLineOffset(ui.getDocument(), target.getCaret().getDot()));
            }
            catch (BadLocationException ex) {
                return null;
            }
        }
    }

    public static class InsertDateTimeAction
    extends LocalBaseAction {
        static final long serialVersionUID = 2865619897402L;

        public InsertDateTimeAction() {
            super("insert-date-time", 30);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = target.getCaret();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    SimpleDateFormat formatter = new SimpleDateFormat();
                    Date currentTime = new Date();
                    String dateString = formatter.format(currentTime);
                    doc.insertString(caret.getDot(), dateString, null);
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class JumpListNextAction
    extends LocalBaseAction {
        static final long serialVersionUID = 6891721278404990446L;
        PropertyChangeListener pcl;

        public JumpListNextAction() {
            super("jump-list-next");
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/edit_next.png");
            this.pcl = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    JumpListNextAction.this.setEnabled(JumpList.hasNext());
                }
            };
            JumpList.addPropertyChangeListener(this.pcl);
            this.setEnabled(JumpList.hasNext());
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                JumpList.jumpNext(target);
            }
        }
    }

    public static class JumpListNextComponentAction
    extends LocalBaseAction {
        static final long serialVersionUID = -2059070050865876892L;

        public JumpListNextComponentAction() {
            super("jump-list-next-component");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                JumpList.jumpNextComponent(target);
            }
        }
    }

    public static class JumpListPrevAction
    extends LocalBaseAction {
        static final long serialVersionUID = 7174907031986424265L;
        PropertyChangeListener pcl;

        public JumpListPrevAction() {
            super("jump-list-prev");
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/edit_previous.png");
            this.pcl = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    JumpListPrevAction.this.setEnabled(JumpList.hasPrev());
                }
            };
            JumpList.addPropertyChangeListener(this.pcl);
            this.setEnabled(JumpList.hasPrev());
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                JumpList.jumpPrev(target);
            }
        }
    }

    public static class JumpListPrevComponentAction
    extends LocalBaseAction {
        static final long serialVersionUID = 2032230534727849525L;

        public JumpListPrevComponentAction() {
            super("jump-list-prev-component");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                JumpList.jumpPrevComponent(target);
            }
        }
    }

    public static class LastNonWhiteAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 4503533041729712917L;

        public LastNonWhiteAction(String nm, boolean select) {
            super(nm, 30);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int pos = Utilities.getRowLastNonWhite((BaseDocument)target.getDocument(), caret.getDot());
                    if (pos >= 0) {
                        if (this.select) {
                            caret.moveDot(pos);
                        } else {
                            caret.setDot(pos);
                        }
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    static class MoveSelectionElseLineDownAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public MoveSelectionElseLineDownAction() {
            super("move-selection-else-line-down", 30);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block15: {
                if (target != null) {
                    if (!target.isEditable() || !target.isEnabled()) {
                        target.getToolkit().beep();
                        return;
                    }
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    doc.atomicLock();
                    DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                    try {
                        int start;
                        Element rootElement = doc.getDefaultRootElement();
                        Caret caret = target.getCaret();
                        boolean selection = false;
                        boolean backwardSelection = false;
                        int end = start = target.getCaretPosition();
                        if (caret.isSelectionVisible()) {
                            int selStart = caret.getDot();
                            int selEnd = caret.getMark();
                            start = Math.min(selStart, selEnd);
                            end = Math.max(selStart, selEnd) - 1;
                            selection = true;
                            backwardSelection = selStart >= selEnd;
                        }
                        int zeroBaseStartLineNumber = rootElement.getElementIndex(start);
                        int zeroBaseEndLineNumber = rootElement.getElementIndex(end);
                        if (zeroBaseEndLineNumber == -1) {
                            target.getToolkit().beep();
                            return;
                        }
                        if (zeroBaseEndLineNumber >= rootElement.getElementCount() - 2) {
                            return;
                        }
                        try {
                            Element startLineElement = rootElement.getElement(zeroBaseStartLineNumber);
                            int startLineStartOffset = startLineElement.getStartOffset();
                            Element endLineElement = rootElement.getElement(zeroBaseEndLineNumber);
                            int endLineEndOffset = endLineElement.getEndOffset();
                            String linesText = doc.getText(startLineStartOffset, endLineEndOffset - startLineStartOffset);
                            Element nextLineElement = rootElement.getElement(zeroBaseEndLineNumber + 1);
                            int nextLineStartOffset = nextLineElement.getStartOffset();
                            int nextLineEndOffset = nextLineElement.getEndOffset();
                            int column = start - startLineStartOffset;
                            doc.insertString(nextLineEndOffset, linesText, null);
                            doc.remove(startLineStartOffset, endLineEndOffset - startLineStartOffset);
                            if (selection) {
                                if (backwardSelection) {
                                    caret.setDot(nextLineEndOffset - (endLineEndOffset - startLineStartOffset) + column);
                                    caret.moveDot(nextLineEndOffset - (endLineEndOffset - end - 1));
                                } else {
                                    caret.setDot(nextLineEndOffset - (endLineEndOffset - end - 1));
                                    caret.moveDot(nextLineEndOffset - (endLineEndOffset - startLineStartOffset) + column);
                                }
                                break block15;
                            }
                            target.setCaretPosition(Math.min(doc.getLength() - 1, nextLineEndOffset + column - (endLineEndOffset - startLineStartOffset)));
                        }
                        catch (BadLocationException ex) {
                            target.getToolkit().beep();
                        }
                    }
                    finally {
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                        doc.atomicUnlock();
                    }
                }
            }
        }
    }

    static class MoveSelectionElseLineUpAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public MoveSelectionElseLineUpAction() {
            super("move-selection-else-line-up", 30);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block15: {
                if (target != null) {
                    if (!target.isEditable() || !target.isEnabled()) {
                        target.getToolkit().beep();
                        return;
                    }
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    doc.atomicLock();
                    DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                    try {
                        int start;
                        Element rootElement = doc.getDefaultRootElement();
                        Caret caret = target.getCaret();
                        boolean selection = false;
                        boolean backwardSelection = false;
                        int end = start = target.getCaretPosition();
                        if (caret.isSelectionVisible()) {
                            int selStart = caret.getDot();
                            int selEnd = caret.getMark();
                            start = Math.min(selStart, selEnd);
                            end = Math.max(selStart, selEnd) - 1;
                            selection = true;
                            backwardSelection = selStart >= selEnd;
                        }
                        int zeroBaseStartLineNumber = rootElement.getElementIndex(start);
                        int zeroBaseEndLineNumber = rootElement.getElementIndex(end);
                        if (zeroBaseStartLineNumber == -1) {
                            target.getToolkit().beep();
                            return;
                        }
                        if (zeroBaseStartLineNumber == 0) {
                            return;
                        }
                        try {
                            Element startLineElement = rootElement.getElement(zeroBaseStartLineNumber);
                            int startLineStartOffset = startLineElement.getStartOffset();
                            Element endLineElement = rootElement.getElement(zeroBaseEndLineNumber);
                            int endLineEndOffset = endLineElement.getEndOffset();
                            String linesText = doc.getText(startLineStartOffset, endLineEndOffset - startLineStartOffset);
                            Element previousLineElement = rootElement.getElement(zeroBaseStartLineNumber - 1);
                            int previousLineStartOffset = previousLineElement.getStartOffset();
                            int column = start - startLineStartOffset;
                            doc.remove(startLineStartOffset, Math.min(doc.getLength(), endLineEndOffset) - startLineStartOffset);
                            doc.insertString(previousLineStartOffset, linesText, null);
                            if (selection) {
                                if (backwardSelection) {
                                    caret.setDot(previousLineStartOffset + column);
                                    caret.moveDot(previousLineStartOffset + (endLineEndOffset - startLineStartOffset) - (endLineEndOffset - end - 1));
                                } else {
                                    caret.setDot(previousLineStartOffset + (endLineEndOffset - startLineStartOffset) - (endLineEndOffset - end - 1));
                                    caret.moveDot(previousLineStartOffset + column);
                                }
                                break block15;
                            }
                            target.setCaretPosition(previousLineStartOffset + column);
                        }
                        catch (BadLocationException ex) {
                            target.getToolkit().beep();
                        }
                    }
                    finally {
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                        doc.atomicUnlock();
                    }
                }
            }
        }
    }

    public static class RedoAction
    extends LocalBaseAction {
        static final long serialVersionUID = 6048125996333769202L;

        public RedoAction() {
            super("redo", 30);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            Document doc = target.getDocument();
            UndoableEdit undoMgr = (UndoableEdit)doc.getProperty("undo-manager");
            if (target != null && undoMgr != null) {
                try {
                    undoMgr.redo();
                }
                catch (CannotRedoException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class ReindentLineAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public ReindentLineAction() {
            super("reindent-line", 14);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                GuardedDocument gdoc = doc instanceof GuardedDocument ? (GuardedDocument)doc : null;
                doc.atomicLock();
                try {
                    Position endPosition;
                    int startPos;
                    int caretLine = Utilities.getLineOffset(doc, caret.getDot());
                    if (caret.isSelectionVisible()) {
                        startPos = target.getSelectionStart();
                        endPosition = doc.createPosition(target.getSelectionEnd());
                    } else {
                        startPos = Utilities.getRowStart(doc, caret.getDot());
                        endPosition = doc.createPosition(Utilities.getRowEnd(doc, caret.getDot()));
                    }
                    int pos = startPos;
                    if (gdoc != null) {
                        pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
                    }
                    while (pos < endPosition.getOffset()) {
                        int stopPos = endPosition.getOffset();
                        if (gdoc != null && ((stopPos = gdoc.getGuardedBlockChain().adjustToNextBlockStart(pos)) == -1 || stopPos > endPosition.getOffset())) {
                            stopPos = endPosition.getOffset();
                        }
                        int reformattedLen = doc.getFormatter().reformat(doc, pos, stopPos);
                        pos += reformattedLen;
                        if (gdoc == null) continue;
                        pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
                    }
                }
                catch (GuardedException e) {
                    target.getToolkit().beep();
                }
                catch (BadLocationException e) {
                    Utilities.annotateLoggable(e);
                }
                finally {
                    doc.atomicUnlock();
                }
            }
        }
    }

    public static class RemoveLineAction
    extends LocalBaseAction {
        static final long serialVersionUID = -536315497241419877L;

        public RemoveLineAction() {
            super("remove-line", 30);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                doc.atomicLock();
                DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                try {
                    int dotPos = caret.getDot();
                    int bolPos = Utilities.getRowStart(target, dotPos);
                    int eolPos = Utilities.getRowEnd(target, dotPos);
                    eolPos = Math.min(eolPos + 1, doc.getLength());
                    doc.remove(bolPos, eolPos - bolPos);
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
                finally {
                    DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                    doc.atomicUnlock();
                }
            }
        }
    }

    public static class RemoveLineBeginAction
    extends LocalBaseAction {
        static final long serialVersionUID = 9193117196412195554L;

        public RemoveLineBeginAction() {
            super("remove-line-begin", 30);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                doc.atomicLock();
                DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                try {
                    int dotPos = caret.getDot();
                    int bolPos = Utilities.getRowStart(doc, dotPos);
                    if (dotPos == bolPos) {
                        if (dotPos > 0) {
                            doc.remove(dotPos - 1, 1);
                        }
                    } else {
                        char[] chars = doc.getChars(bolPos, dotPos - bolPos);
                        if (Analyzer.isWhitespace(chars, 0, chars.length)) {
                            doc.remove(bolPos, dotPos - bolPos);
                        } else {
                            int firstNW = Utilities.getRowFirstNonWhite(doc, bolPos);
                            if (firstNW >= 0 && firstNW < dotPos) {
                                doc.remove(firstNW, dotPos - firstNW);
                            }
                        }
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
                finally {
                    DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                    doc.atomicUnlock();
                }
            }
        }
    }

    public static class RemoveSelectionAction
    extends LocalBaseAction {
        static final long serialVersionUID = -1419424594746686573L;

        public RemoveSelectionAction() {
            super("remove-selection", 30);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                BaseDocument doc = (BaseDocument)target.getDocument();
                doc.atomicLock();
                DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                try {
                    target.replaceSelection(null);
                }
                finally {
                    DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                    doc.atomicUnlock();
                }
            }
        }
    }

    public static class RemoveTabAction
    extends LocalBaseAction {
        static final long serialVersionUID = -1537748600593395706L;

        public RemoveTabAction() {
            super("remove-tab", 22);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block13: {
                if (target != null) {
                    if (!target.isEditable() || !target.isEnabled()) {
                        target.getToolkit().beep();
                        return;
                    }
                    Caret caret = target.getCaret();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    doc.atomicLock();
                    DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                    try {
                        if (caret.isSelectionVisible()) {
                            try {
                                doc.getFormatter().changeBlockIndent(doc, target.getSelectionStart(), target.getSelectionEnd(), -1);
                            }
                            catch (GuardedException e) {
                                target.getToolkit().beep();
                            }
                            catch (BadLocationException e) {
                                e.printStackTrace();
                            }
                            break block13;
                        }
                        try {
                            int startOffset = Utilities.getRowStart(doc, caret.getDot());
                            int firstNW = Utilities.getRowFirstNonWhite(doc, caret.getDot());
                            int endOffset = Utilities.getRowEnd(doc, caret.getDot());
                            if (firstNW == -1 || firstNW >= caret.getDot()) {
                                doc.getFormatter().changeBlockIndent(doc, startOffset, endOffset, -1);
                            }
                        }
                        catch (GuardedException e) {
                            target.getToolkit().beep();
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                        doc.atomicUnlock();
                    }
                }
            }
        }
    }

    public static class RemoveWordNextAction
    extends LocalBaseAction {
        public RemoveWordNextAction() {
            super("remove-word-next", 30);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                doc.atomicLock();
                DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                try {
                    int dotPos = caret.getDot();
                    int eolPos = Utilities.getRowEnd(doc, dotPos);
                    int wsPos = Utilities.getNextWord(target, dotPos);
                    wsPos = dotPos == eolPos ? wsPos : Math.min(eolPos, wsPos);
                    doc.remove(dotPos, wsPos - dotPos);
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
                finally {
                    DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                    doc.atomicUnlock();
                }
            }
        }
    }

    public static class RemoveWordPreviousAction
    extends LocalBaseAction {
        public RemoveWordPreviousAction() {
            super("remove-word-previous", 30);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                doc.atomicLock();
                DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                try {
                    int dotPos = caret.getDot();
                    int bolPos = Utilities.getRowStart(doc, dotPos);
                    int wsPos = Utilities.getPreviousWord(target, dotPos);
                    wsPos = dotPos == bolPos ? wsPos : Math.max(bolPos, wsPos);
                    doc.remove(wsPos, dotPos - wsPos);
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
                finally {
                    DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                    doc.atomicUnlock();
                }
            }
        }
    }

    public static class RunMacroAction
    extends BaseAction {
        static final long serialVersionUID = 1L;
        static HashSet runningActions = new HashSet();
        private String macroName;

        public RunMacroAction(String name) {
            super("macro-" + name);
            this.macroName = name;
        }

        protected void error(JTextComponent target, String messageKey) {
            Utilities.setStatusText(target, LocaleSupport.getString(messageKey, "Error in macro: " + messageKey));
            Toolkit.getDefaultToolkit().beep();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (!runningActions.add(this.macroName)) {
                this.error(target, "loop");
                return;
            }
            if (target == null) {
                return;
            }
            BaseKit kit = Utilities.getKit(target);
            if (kit == null) {
                return;
            }
            Map macroMap = (Map)Settings.getValue(kit.getClass(), "macro-map");
            String commandString = (String)macroMap.get(this.macroName);
            if (commandString == null) {
                this.error(target, "macro-not-found");
                runningActions.remove(this.macroName);
                return;
            }
            StringBuffer actionName = new StringBuffer();
            char[] command = commandString.toCharArray();
            int len = command.length;
            BaseDocument doc = (BaseDocument)target.getDocument();
            doc.atomicLock();
            try {
                for (int i = 0; i < len; ++i) {
                    if (Character.isWhitespace(command[i])) continue;
                    if (command[i] == '\"') {
                        while (++i < len && command[i] != '\"') {
                            Action a;
                            char ch = command[i];
                            if (ch == '\\') {
                                if (++i >= len) {
                                    this.error(target, "macro-malformed");
                                    return;
                                }
                                ch = command[i];
                                if (ch != '\"' && ch != '\\') {
                                    this.error(target, "macro-malformed");
                                    return;
                                }
                            }
                            if ((a = target.getKeymap().getDefaultAction()) == null) continue;
                            ActionEvent newEvt = new ActionEvent(target, 0, new String(new char[]{ch}));
                            if (a instanceof BaseAction) {
                                ((BaseAction)a).updateComponent(target);
                                ((BaseAction)a).actionPerformed(newEvt, target);
                                continue;
                            }
                            a.actionPerformed(newEvt);
                        }
                        continue;
                    }
                    actionName.setLength(0);
                    while (i < len && !Character.isWhitespace(command[i])) {
                        char ch;
                        if ((ch = command[i++]) == '\\') {
                            if (i >= len) {
                                this.error(target, "macro-malformed");
                                return;
                            }
                            if ((ch = command[i++]) != '\\' && !Character.isWhitespace(ch)) {
                                this.error(target, "macro-malformed");
                                return;
                            }
                        }
                        actionName.append(ch);
                    }
                    Action a = kit.getActionByName(actionName.toString());
                    if (a != null) {
                        ActionEvent fakeEvt = new ActionEvent(target, 0, "");
                        if (a instanceof BaseAction) {
                            ((BaseAction)a).updateComponent(target);
                            ((BaseAction)a).actionPerformed(fakeEvt, target);
                        } else {
                            a.actionPerformed(fakeEvt);
                        }
                        if (!"insert-break".equals(actionName.toString())) continue;
                        Action def = target.getKeymap().getDefaultAction();
                        ActionEvent fakeEvt10 = new ActionEvent(target, 0, new String(new byte[]{10}));
                        if (def instanceof BaseAction) {
                            ((BaseAction)def).updateComponent(target);
                            ((BaseAction)def).actionPerformed(fakeEvt10, target);
                            continue;
                        }
                        def.actionPerformed(fakeEvt10);
                        continue;
                    }
                    this.error(target, "macro-unknown-action");
                    return;
                }
            }
            finally {
                doc.atomicUnlock();
                runningActions.remove(this.macroName);
            }
        }
    }

    public static class ScrollDownAction
    extends LocalBaseAction {
        public ScrollDownAction() {
            super("scroll-down");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                EditorUI editorUI = Utilities.getEditorUI(target);
                Rectangle bounds = editorUI.getExtentBounds();
                bounds.y -= editorUI.getLineHeight();
                bounds.x += editorUI.getTextMargin().left;
                editorUI.scrollRectToVisible(bounds, 2);
            }
        }
    }

    public static class ScrollUpAction
    extends LocalBaseAction {
        public ScrollUpAction() {
            super("scroll-up");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                EditorUI editorUI = Utilities.getEditorUI(target);
                Rectangle bounds = editorUI.getExtentBounds();
                bounds.y += editorUI.getLineHeight();
                bounds.x += editorUI.getTextMargin().left;
                editorUI.scrollRectToVisible(bounds, 2);
            }
        }
    }

    public static class SelectIdentifierAction
    extends LocalBaseAction {
        static final long serialVersionUID = -7288216961333147873L;

        public SelectIdentifierAction() {
            super("select-identifier", 2);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    if (caret.isSelectionVisible()) {
                        caret.setSelectionVisible(false);
                    } else {
                        int[] block = Utilities.getIdentifierBlock((BaseDocument)target.getDocument(), caret.getDot());
                        if (block != null) {
                            caret.setDot(block[0]);
                            caret.moveDot(block[1]);
                        }
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class SelectNextParameterAction
    extends LocalBaseAction {
        static final long serialVersionUID = 8045372985336370934L;

        public SelectNextParameterAction() {
            super("select-next-parameter", 34);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                int dotPos = caret.getDot();
                int selectStartPos = -1;
                try {
                    int selectEndPos;
                    if (dotPos > 0 && doc.getChars(dotPos - 1, 1)[0] == ',') {
                        selectStartPos = dotPos;
                    }
                    if (dotPos < doc.getLength()) {
                        char dotChar = doc.getChars(dotPos, 1)[0];
                        if (dotChar == ',') {
                            selectStartPos = dotPos + 1;
                        } else if (dotChar == ')') {
                            caret.setDot(dotPos + 1);
                        }
                    }
                    if (selectStartPos >= 0 && (selectEndPos = doc.find(new FinderFactory.CharArrayFwdFinder(new char[]{',', ')'}), selectStartPos, -1)) >= 0) {
                        target.select(selectStartPos, selectEndPos);
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class ShiftLineAction
    extends LocalBaseAction {
        boolean right;
        static final long serialVersionUID = -5124732597493699582L;

        public ShiftLineAction(String name, boolean right) {
            super(name, 10);
            this.right = right;
            this.putValue("IconResource", right ? "org/netbeans/modules/editor/resources/shift_line_right.png" : "org/netbeans/modules/editor/resources/shift_line_left.png");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = Utilities.getDocument(target);
                doc.atomicLock();
                DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                try {
                    if (caret.isSelectionVisible()) {
                        doc.getFormatter().changeBlockIndent(doc, target.getSelectionStart(), target.getSelectionEnd(), this.right ? 1 : -1);
                    } else {
                        doc.getFormatter().shiftLine(doc, caret.getDot(), this.right);
                    }
                }
                catch (GuardedException e) {
                    target.getToolkit().beep();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                finally {
                    DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                    doc.atomicUnlock();
                }
            }
        }
    }

    public static class StartMacroRecordingAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public StartMacroRecordingAction() {
            super("start-macro-recording", 64);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/start_macro_recording.png");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null && !this.startRecording(target)) {
                target.getToolkit().beep();
            }
        }
    }

    public static class StartNewLine
    extends LocalBaseAction {
        public StartNewLine() {
            super("start-new-line", 14);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            BaseDocument doc = (BaseDocument)target.getDocument();
            doc.atomicLock();
            try {
                Caret caret = target.getCaret();
                int dotpos = caret.getDot();
                doc.insertString(dotpos, "-", null);
                doc.remove(dotpos, 1);
                int eolDot = Utilities.getRowEnd(target, caret.getDot());
                int newDotPos = doc.getFormatter().indentNewLine(doc, eolDot);
                caret.setDot(newDotPos);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
            finally {
                doc.atomicUnlock();
            }
        }
    }

    public static class StopMacroRecordingAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public StopMacroRecordingAction() {
            super("stop-macro-recording", 64);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/stop_macro_recording.png");
        }

        protected MacroDialogSupport getMacroDialogSupport(Class kitClass) {
            return new MacroDialogSupport(kitClass);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                String macro = this.stopRecording(target);
                if (macro == null) {
                    target.getToolkit().beep();
                } else {
                    BaseKit kit = Utilities.getKit(target);
                    MacroDialogSupport support = this.getMacroDialogSupport(kit.getClass());
                    support.setBody(macro);
                    support.showMacroDialog();
                }
            }
        }
    }

    public static class ToggleHighlightSearchAction
    extends LocalBaseAction
    implements Presenter.Toolbar {
        static final long serialVersionUID = 4603809175771743200L;

        public ToggleHighlightSearchAction() {
            super("toggle-highlight-search", 32);
            this.putValue("SmallIcon", new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/editor/resources/toggle_highlight.png")));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Boolean cur = (Boolean)EditorFindSupport.getInstance().getFindProperty("find-highlight-search");
                cur = cur == null || cur == false ? Boolean.TRUE : Boolean.FALSE;
                EditorFindSupport.getInstance().putFindProperty("find-highlight-search", (Object)cur);
            }
        }

        public Component getToolbarPresenter() {
            MyGaGaButton b = new MyGaGaButton();
            ((AbstractButton)b).setModel(new HighlightButtonModel());
            b.putClientProperty("hideActionText", Boolean.TRUE);
            b.setAction(this);
            return b;
        }

        private static final class HighlightButtonModel
        extends JToggleButton.ToggleButtonModel
        implements PropertyChangeListener {
            public HighlightButtonModel() {
                EditorFindSupport efs = EditorFindSupport.getInstance();
                efs.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)efs));
                this.propertyChange(null);
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt == null || evt.getPropertyName() == null || evt.getPropertyName().equals("find-highlight-search")) {
                    Boolean value = (Boolean)EditorFindSupport.getInstance().getFindProperty("find-highlight-search");
                    this.setSelected(value == null ? false : value);
                }
            }
        }

        private static final class MyGaGaButton
        extends JToggleButton
        implements ChangeListener {
            public void setModel(ButtonModel model) {
                ButtonModel oldModel = this.getModel();
                if (oldModel != null) {
                    oldModel.removeChangeListener(this);
                }
                super.setModel(model);
                ButtonModel newModel = this.getModel();
                if (newModel != null) {
                    newModel.addChangeListener(this);
                }
                this.stateChanged(null);
            }

            public void stateChanged(ChangeEvent evt) {
                boolean selected = this.isSelected();
                super.setContentAreaFilled(selected);
                super.setBorderPainted(selected);
            }

            public void setBorderPainted(boolean arg0) {
                if (!this.isSelected()) {
                    super.setBorderPainted(arg0);
                }
            }

            public void setContentAreaFilled(boolean arg0) {
                if (!this.isSelected()) {
                    super.setContentAreaFilled(arg0);
                }
            }
        }
    }

    public static class ToggleLineNumbersAction
    extends LocalBaseAction {
        static final long serialVersionUID = -3502499718130556526L;
        private JCheckBoxMenuItem item = null;

        public ToggleLineNumbersAction() {
            super("toggle-line-numbers");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            this.toggleLineNumbers();
        }

        public JMenuItem getPopupMenuItem(JTextComponent target) {
            this.item = new JCheckBoxMenuItem(NbBundle.getBundle(BaseKit.class).getString("line-numbers-menuitem"), this.isLineNumbersVisible());
            this.item.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ToggleLineNumbersAction.this.actionPerformed(null, null);
                }
            });
            return this.item;
        }

        protected boolean isLineNumbersVisible() {
            return false;
        }

        protected void toggleLineNumbers() {
        }
    }

    public static class ToggleTypingModeAction
    extends LocalBaseAction {
        static final long serialVersionUID = -2431132686507799723L;

        public ToggleTypingModeAction() {
            super("toggle-typing-mode");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                EditorUI editorUI = Utilities.getEditorUI(target);
                Boolean overwriteMode = (Boolean)editorUI.getProperty("overwriteMode");
                overwriteMode = overwriteMode == null || overwriteMode == false ? Boolean.TRUE : Boolean.FALSE;
                editorUI.putProperty("overwriteMode", overwriteMode);
            }
        }
    }

    public static class UndoAction
    extends LocalBaseAction {
        static final long serialVersionUID = 8628586205035497612L;

        public UndoAction() {
            super("undo", 30);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            Document doc = target.getDocument();
            UndoableEdit undoMgr = (UndoableEdit)doc.getProperty("undo-manager");
            if (target != null && undoMgr != null) {
                try {
                    undoMgr.undo();
                }
                catch (CannotUndoException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class WordMatchAction
    extends LocalBaseAction {
        private boolean direction;
        static final long serialVersionUID = 595571114685133170L;

        public WordMatchAction(String name, boolean direction) {
            super(name, 14);
            this.direction = direction;
            this.putValue("IconResource", direction ? "org/netbeans/modules/editor/resources/next_matching.png" : "org/netbeans/modules/editor/resources/previous_matching.png");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                EditorUI editorUI = Utilities.getEditorUI(target);
                Caret caret = target.getCaret();
                BaseDocument doc = Utilities.getDocument(target);
                if (caret.isSelectionVisible()) {
                    target.replaceSelection(null);
                }
                int dotPos = caret.getDot();
                String s = editorUI.getWordMatch().getMatchWord(dotPos, this.direction);
                String prevWord = editorUI.getWordMatch().getPreviousWord();
                if (s != null) {
                    doc.atomicLock();
                    DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                    try {
                        int pos = dotPos;
                        if (prevWord != null && prevWord.length() > 0) {
                            doc.remove(pos -= prevWord.length(), prevWord.length());
                        }
                        doc.insertString(pos, s, null);
                    }
                    catch (BadLocationException e) {
                        target.getToolkit().beep();
                    }
                    finally {
                        doc.atomicUnlock();
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                    }
                }
            }
        }
    }
}

