/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FoldMultiLineView;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.lib.editor.view.GapDocumentView;

class DrawEngineDocView
extends GapDocumentView
implements FoldHierarchyListener,
PropertyChangeListener {
    private static final boolean debugRebuild = Boolean.getBoolean("netbeans.debug.editor.view.rebuild");
    private FoldHierarchy foldHierarchy;
    private EditorUI editorUI;
    private Iterator collapsedFoldIterator;
    private Fold collapsedFold;
    private int collapsedFoldStartOffset;
    private int collapsedFoldEndOffset;
    private boolean collapsedFoldsInPresentViews;
    private boolean estimatedSpanResetInitiated;

    DrawEngineDocView(Element elem) {
        super(elem);
        this.setEstimatedSpan(true);
    }

    public void setParent(View parent) {
        if (parent != null) {
            JTextComponent component = (JTextComponent)parent.getContainer();
            this.foldHierarchy = FoldHierarchy.get((JTextComponent)component);
            this.foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)this);
            TextUI tui = component.getUI();
            if (tui instanceof BaseTextUI) {
                this.editorUI = ((BaseTextUI)tui).getEditorUI();
                if (this.editorUI != null) {
                    this.editorUI.addPropertyChangeListener(this);
                }
            }
        }
        super.setParent(parent);
        if (parent == null) {
            this.foldHierarchy.removeFoldHierarchyListener((FoldHierarchyListener)this);
            this.foldHierarchy = null;
            if (this.editorUI != null) {
                this.editorUI.removePropertyChangeListener(this);
                this.editorUI = null;
            }
        }
    }

    protected void attachListeners() {
        if (this.foldHierarchy != null) {
            // empty if block
        }
    }

    private FoldHierarchy getFoldHierarchy() {
        return this.foldHierarchy;
    }

    protected boolean useCustomReloadChildren() {
        return true;
    }

    protected Fold nextCollapsedFold() {
        Fold fold;
        block3: {
            while (true) {
                Fold fold2 = fold = this.collapsedFoldIterator.hasNext() ? (Fold)this.collapsedFoldIterator.next() : null;
                if (fold == null) break block3;
                this.collapsedFoldStartOffset = fold.getStartOffset();
                this.collapsedFoldEndOffset = fold.getEndOffset();
                if (this.collapsedFoldStartOffset != this.collapsedFoldEndOffset) break;
                if (!debugRebuild) continue;
                System.err.println("GapBoxView.nextCollapsedFold(): ignored empty fold " + fold);
            }
            if (this.collapsedFoldEndOffset > this.getDocument().getLength()) {
                fold = null;
            }
        }
        if (fold != null) {
            this.collapsedFoldsInPresentViews = true;
        }
        return fold;
    }

    protected void initCustomReloadChildren(FoldHierarchy hierarchy, int startOffset, int endOffset) {
        this.collapsedFoldIterator = FoldUtilities.collapsedFoldIterator((FoldHierarchy)hierarchy, (int)startOffset, (int)endOffset);
        this.collapsedFold = this.nextCollapsedFold();
    }

    protected void finishCustomReloadChildren(FoldHierarchy hierarchy) {
        this.collapsedFoldIterator = null;
        this.collapsedFold = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void customReloadChildren(int index, int removeLength, int startOffset, int endOffset) {
        FoldHierarchy hierarchy;
        if (index == 0 && removeLength == this.getViewCount()) {
            this.collapsedFoldsInPresentViews = false;
        }
        if ((hierarchy = this.getFoldHierarchy()) != null) {
            hierarchy.lock();
            try {
                this.initCustomReloadChildren(hierarchy, startOffset, endOffset);
                super.customReloadChildren(index, removeLength, startOffset, endOffset);
                this.finishCustomReloadChildren(hierarchy);
            }
            finally {
                hierarchy.unlock();
            }
        }
    }

    protected View createCustomView(ViewFactory f, int startOffset, int maxEndOffset, int elementIndex) {
        boolean createCollapsed;
        if (elementIndex == -1) {
            throw new IllegalStateException("Need underlying line element structure");
        }
        View view = null;
        Element elem = this.getElement();
        Element lineElem = elem.getElement(elementIndex);
        boolean bl = createCollapsed = this.collapsedFold != null;
        if (createCollapsed) {
            int lineElemEndOffset = lineElem.getEndOffset();
            boolean bl2 = createCollapsed = this.collapsedFoldStartOffset < lineElemEndOffset;
            if (createCollapsed) {
                Element firstLineElem = lineElem;
                ArrayList<Object> foldAndEndLineElemList = new ArrayList<Object>();
                do {
                    int collapsedFoldEndOffset = this.collapsedFold.getEndOffset();
                    while (collapsedFoldEndOffset > lineElemEndOffset) {
                        lineElem = elem.getElement(++elementIndex);
                        lineElemEndOffset = lineElem.getEndOffset();
                    }
                    foldAndEndLineElemList.add(this.collapsedFold);
                    foldAndEndLineElemList.add(lineElem);
                    this.collapsedFold = this.nextCollapsedFold();
                } while (this.collapsedFold != null && this.collapsedFoldStartOffset < lineElemEndOffset);
                view = new FoldMultiLineView(firstLineElem, foldAndEndLineElemList);
            }
        }
        if (!createCollapsed) {
            view = f.create(lineElem);
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void foldHierarchyChanged(FoldHierarchyEvent evt) {
        LockView lockView = LockView.get(this);
        lockView.lock();
        try {
            this.layoutLock();
            try {
                FoldHierarchy hierarchy = (FoldHierarchy)evt.getSource();
                if (hierarchy.getComponent().getDocument() != lockView.getDocument()) {
                    return;
                }
                boolean rebuildViews = true;
                int affectedStartOffset = evt.getAffectedStartOffset();
                int affectedEndOffset = evt.getAffectedEndOffset();
                if (!this.collapsedFoldsInPresentViews && FoldUtilities.findCollapsedFold((FoldHierarchy)hierarchy, (int)affectedStartOffset, (int)affectedEndOffset) == null) {
                    rebuildViews = false;
                }
                if (rebuildViews) {
                    int docLength = this.getDocument().getLength();
                    int rebuildStartOffset = Math.min(affectedStartOffset, docLength);
                    int rebuildEndOffset = Math.min(affectedEndOffset, docLength);
                    this.offsetRebuild(rebuildStartOffset, rebuildEndOffset);
                }
            }
            finally {
                this.updateLayout();
                this.layoutUnlock();
            }
        }
        finally {
            lockView.unlock();
        }
    }

    public void paint(Graphics g, Shape allocation) {
        TextUI textUI;
        Container c = this.getContainer();
        if (c instanceof JTextComponent && (textUI = ((JTextComponent)c).getUI()) instanceof BaseTextUI) {
            ((BaseTextUI)textUI).getEditorUI().paint(g);
        }
        super.paint(g, allocation);
    }

    public void setSize(float width, float height) {
        super.setSize(width, height);
    }

    protected boolean isChildrenResizeDisabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        JTextComponent component = (JTextComponent)this.getContainer();
        if (component == null || evt == null || !"line-height-changed-prop".equals(evt.getPropertyName())) {
            return;
        }
        AbstractDocument doc = (AbstractDocument)this.getDocument();
        if (doc != null) {
            doc.readLock();
            try {
                LockView lockView = LockView.get(this);
                lockView.lock();
                try {
                    this.rebuild(0, this.getViewCount());
                }
                finally {
                    lockView.unlock();
                }
            }
            finally {
                doc.readUnlock();
            }
            component.revalidate();
        }
    }

    public int getYFromPos(int offset, Shape a) {
        int index = this.getViewIndex(offset);
        if (index >= 0) {
            Shape ca = this.getChildAllocation(index, a);
            return ca instanceof Rectangle ? ((Rectangle)ca).y : (ca != null ? ca.getBounds().y : 0);
        }
        return 0;
    }
}

