/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.Utilities;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class GlyphGutter
extends JComponent
implements Annotations.AnnotationsListener,
Accessible,
SettingsChangeListener,
SideBarFactory {
    private EditorUI editorUI;
    private BaseDocument doc;
    private Annotations annos;
    private Image gutterButton;
    private Color backgroundColor;
    private Color foreColor;
    private Font font;
    private int lineHeight;
    private boolean init;
    private int glyphGutterWidth;
    private static final int glyphWidth = 16;
    private static final int glyphButtonWidth = 9;
    private static final int leftGap = 10;
    private static final int rightGap = 4;
    private boolean showLineNumbers = true;
    private ImageObserver imgObserver = null;
    private static final int ENLARGE_GUTTER_HEIGHT = 300;
    private int highestLineNumber = 0;
    private boolean drawOverLineNumbers = false;
    private int cachedCountOfAnnos = -1;
    private int cachedCountOfAnnosForLine = -1;
    private PropertyChangeListener annoTypesListener;
    private PropertyChangeListener editorUIListener;
    private GlyphGutterFoldHierarchyListener glyphGutterFoldHierarchyListener;
    private GutterMouseListener gutterMouseListener;
    private FoldHierarchy foldHierarchy;
    private Map renderingHints;

    public GlyphGutter() {
    }

    public GlyphGutter(EditorUI editorUI) {
        this.editorUI = editorUI;
        this.init = false;
        this.doc = editorUI.getDocument();
        this.annos = this.doc.getAnnotations();
        this.annos.addAnnotationsListener(this);
        this.init();
        this.update();
        Settings.addSettingsChangeListener(this);
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.foldHierarchy = FoldHierarchy.get((JTextComponent)editorUI.getComponent());
        this.glyphGutterFoldHierarchyListener = new GlyphGutterFoldHierarchyListener();
        this.foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)this.glyphGutterFoldHierarchyListener);
        this.editorUIListener = new EditorUIListener();
        editorUI.addPropertyChangeListener(this.editorUIListener);
        this.updateRenderingHints();
        this.setOpaque(true);
    }

    private void updateRenderingHints() {
        JTextComponent comp = this.editorUI.getComponent();
        if (comp == null) {
            return;
        }
        Object value = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (value == null) {
            value = Settings.getValue(Utilities.getKitClass(comp), "rendering-hints");
        }
        this.renderingHints = value instanceof Map ? (Map)value : null;
    }

    public void settingsChange(SettingsChangeEvent evt) {
        Rectangle rect;
        if (this.editorUI == null) {
            return;
        }
        JTextComponent component = this.editorUI.getComponent();
        if (evt == null || component == null) {
            return;
        }
        String settingName = evt.getSettingName();
        if (settingName == null || "rendering-hints".equals(settingName)) {
            this.updateRenderingHints();
        }
        Class kitClass = evt.getKitClass();
        if (Utilities.getKitClass(component) != kitClass && (rect = component.getVisibleRect()) != null && rect.width == 0) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.resize();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GlyphGutter.this.resize();
                    }
                });
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
        }
        return this.accessibleContext;
    }

    protected void init() {
        if (this.editorUI == null) {
            return;
        }
        URL imageURL = null;
        try {
            imageURL = new URL("nbresloc:/org/netbeans/editor/resources/glyphbutton.gif");
        }
        catch (MalformedURLException ex) {
            Utilities.annotateLoggable(ex);
            return;
        }
        if (imageURL != null) {
            this.gutterButton = Toolkit.getDefaultToolkit().getImage(imageURL);
        }
        this.setToolTipText("");
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle(BaseKit.class).getString("ACSN_Glyph_Gutter"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BaseKit.class).getString("ACSD_Glyph_Gutter"));
        this.gutterMouseListener = new GutterMouseListener();
        this.addMouseListener(this.gutterMouseListener);
        this.addMouseMotionListener(this.gutterMouseListener);
        this.imgObserver = new Observer(this);
        this.annoTypesListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "glyphsOverLineNumbers" || evt.getPropertyName() == "showGlyphGutter") {
                    GlyphGutter.this.update();
                }
            }
        };
        AnnotationTypes.getTypes().addPropertyChangeListener(this.annoTypesListener);
    }

    public void update() {
        if (this.editorUI == null) {
            return;
        }
        Coloring lineColoring = (Coloring)this.editorUI.getColoringMap().get("line-number");
        Coloring defaultColoring = this.editorUI.getDefaultColoring();
        if (lineColoring == null) {
            return;
        }
        this.backgroundColor = lineColoring.getBackColor() != null ? lineColoring.getBackColor() : defaultColoring.getBackColor();
        this.foreColor = lineColoring.getForeColor() != null ? lineColoring.getForeColor() : defaultColoring.getForeColor();
        if (lineColoring.getFont() != null) {
            Font lineFont = lineColoring.getFont();
            this.font = lineFont != null ? lineFont.deriveFont((float)lineFont.getSize() - 1.0f) : null;
        } else {
            this.font = defaultColoring.getFont();
            this.font = new Font("Monospaced", 0, this.font.getSize() - 1);
        }
        this.lineHeight = this.editorUI.getLineHeight();
        this.showLineNumbers = this.editorUI.lineNumberVisibleSetting;
        this.drawOverLineNumbers = AnnotationTypes.getTypes().isGlyphsOverLineNumbers();
        this.init = true;
        this.highestLineNumber = this.getLineCount();
        this.repaint();
        this.resize();
    }

    protected void resize() {
        Dimension dim = new Dimension();
        dim.width = this.glyphGutterWidth = this.getWidthDimension();
        dim.height = this.getHeightDimension();
        dim.height += 300 * this.lineHeight;
        this.setPreferredSize(dim);
        this.revalidate();
    }

    protected int getLineCount() {
        int lineCnt;
        try {
            lineCnt = this.doc != null ? Utilities.getLineOffset(this.doc, this.doc.getLength()) + 1 : 1;
        }
        catch (BadLocationException e) {
            lineCnt = 1;
        }
        return lineCnt;
    }

    protected int getDigitCount(int number) {
        return Integer.toString(number).length();
    }

    protected int getLineNumberWidth() {
        int newWidth = 0;
        if (this.editorUI != null) {
            newWidth += this.getDigitCount(this.highestLineNumber) * this.editorUI.getLineNumberDigitWidth();
        }
        return newWidth;
    }

    protected int getWidthDimension() {
        int newWidth = 0;
        if (this.showLineNumbers) {
            int lineNumberWidth = this.getLineNumberWidth();
            newWidth = 10 + lineNumberWidth + 4;
        } else if (this.editorUI != null) {
            if (this.annos.isGlyphColumn() || AnnotationTypes.getTypes().isShowGlyphGutter().booleanValue()) {
                newWidth += 16;
            }
            if (this.annos.isGlyphButtonColumn()) {
                newWidth += 9;
            }
        }
        return newWidth;
    }

    protected int getHeightDimension() {
        if (this.editorUI == null) {
            return 0;
        }
        JTextComponent comp = this.editorUI.getComponent();
        if (comp == null) {
            return 0;
        }
        return this.highestLineNumber * this.lineHeight + (int)comp.getSize().getHeight();
    }

    void paintGutterForView(Graphics g, View view, int y) {
        if (this.editorUI == null) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        JTextComponent component = this.editorUI.getComponent();
        if (component == null) {
            return;
        }
        BaseTextUI textUI = (BaseTextUI)component.getUI();
        Rectangle rec = new Rectangle(0, y, 0, this.editorUI.getLineHeight());
        g.setFont(this.font);
        g.setColor(this.foreColor);
        FontMetrics fm = FontMetricsCache.getFontMetrics(this.font, this);
        Element rootElem = textUI.getRootView(component).getElement();
        int line = rootElem.getElementIndex(view.getStartOffset());
        int lineWithAnno = this.annos.getNextLineWithAnnotation(line);
        int lineNumberWidth = fm.stringWidth(String.valueOf(line + 1));
        int count = this.annos.getNumberOfAnnotations(line);
        AnnotationDesc anno = this.annos.getActiveAnnotation(line);
        if (this.showLineNumbers) {
            boolean glyphHasIcon = false;
            if (!(line != lineWithAnno || anno == null || anno.isDefaultGlyph() && count == 1 || anno.getGlyph() == null)) {
                glyphHasIcon = true;
            }
            if (!glyphHasIcon || !this.drawOverLineNumbers || this.drawOverLineNumbers && line != lineWithAnno) {
                g.drawString(String.valueOf(line + 1), this.glyphGutterWidth - lineNumberWidth - 4, y + this.editorUI.getLineAscent());
            }
        }
        if (line == lineWithAnno) {
            int xPos;
            int n = xPos = this.showLineNumbers ? this.getLineNumberWidth() : 0;
            if (this.drawOverLineNumbers) {
                xPos = this.getWidth() - 16;
                if (count > 1) {
                    xPos -= 9;
                }
            }
            if (anno != null && (count != 1 || !anno.isDefaultGlyph()) && anno.getGlyph() != null && this.prepareImage(anno.getGlyph(), this.imgObserver)) {
                g.drawImage(anno.getGlyph(), xPos, y + (this.lineHeight - anno.getGlyph().getHeight(null)) / 2 + 1, null);
            }
            if (count > 1 && anno.getGlyph() != null && this.prepareImage(this.gutterButton, this.imgObserver) && this.prepareImage(anno.getGlyph(), this.imgObserver)) {
                g.drawImage(this.gutterButton, xPos + 16 - 1, y + (this.lineHeight - anno.getGlyph().getHeight(null)) / 2, null);
            }
            lineWithAnno = this.annos.getNextLineWithAnnotation(line + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        block14: {
            super.paintComponent(g);
            if (this.editorUI == null) {
                return;
            }
            if (this.renderingHints != null) {
                ((Graphics2D)g).setRenderingHints(this.renderingHints);
            }
            if (!this.init) {
                return;
            }
            Rectangle clip = g.getClipBounds();
            JTextComponent component = this.editorUI.getComponent();
            if (component == null) {
                return;
            }
            BaseTextUI textUI = (BaseTextUI)component.getUI();
            Element rootElem = textUI.getRootView(component).getElement();
            View rootView = Utilities.getDocumentView(component);
            if (rootView == null) {
                return;
            }
            g.setColor(this.backgroundColor);
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            g.setColor(SettingsDefaults.defaultGutterLine);
            g.drawLine(this.glyphGutterWidth - 1, clip.y, this.glyphGutterWidth - 1, clip.height + clip.y);
            AbstractDocument doc = (AbstractDocument)component.getDocument();
            doc.readLock();
            try {
                this.foldHierarchy.lock();
                try {
                    int startPos = textUI.getPosFromY(clip.y);
                    int startViewIndex = rootView.getViewIndex(startPos, Position.Bias.Forward);
                    int rootViewCount = rootView.getViewCount();
                    if (startViewIndex < 0 || startViewIndex >= rootViewCount) break block14;
                    int lineWithAnno = this.annos.getNextLineWithAnnotation(rootElem.getElementIndex(startPos));
                    Rectangle rec = textUI.modelToView(component, rootView.getView(startViewIndex).getStartOffset());
                    int y = rec == null ? 0 : rec.y;
                    int clipEndY = clip.y + clip.height;
                    for (int i = startViewIndex; i < rootViewCount; ++i) {
                        View view = rootView.getView(i);
                        this.paintGutterForView(g, view, y);
                        if ((y += this.editorUI.getLineHeight()) < clipEndY) continue;
                        break;
                    }
                }
                finally {
                    this.foldHierarchy.unlock();
                }
            }
            catch (BadLocationException ble) {
                ErrorManager.getDefault().notify((Throwable)ble);
            }
            finally {
                doc.readUnlock();
            }
        }
    }

    public void changedLine(int line) {
        JTextComponent component;
        if (!this.init || this.editorUI == null) {
            return;
        }
        this.cachedCountOfAnnos = -1;
        if (line > 0) {
            --line;
        }
        if ((component = this.editorUI.getComponent()) != null) {
            BaseTextUI textUI = (BaseTextUI)component.getUI();
            try {
                Element rootElem = component.getDocument().getDefaultRootElement();
                if (line >= rootElem.getElementCount()) {
                    return;
                }
                Element lineElem = rootElem.getElement(line);
                if (lineElem == null) {
                    return;
                }
                int lineOffset = lineElem.getStartOffset();
                Rectangle mtvRect = textUI.modelToView(component, lineOffset);
                if (mtvRect == null) {
                    return;
                }
                this.repaint(0, mtvRect.y, (int)this.getSize().getWidth(), 3 * this.lineHeight);
                this.checkSize();
            }
            catch (BadLocationException ble) {
                ErrorManager.getDefault().notify((Throwable)ble);
            }
        }
    }

    public void changedAll() {
        if (!this.init || this.editorUI == null) {
            return;
        }
        this.cachedCountOfAnnos = -1;
        try {
            int lineCnt = Utilities.getLineOffset(this.doc, this.doc.getLength()) + 1;
        }
        catch (BadLocationException e) {
            boolean lineCnt = true;
        }
        this.repaint();
        this.checkSize();
    }

    protected void checkSize() {
        int count = this.getLineCount();
        if (count > this.highestLineNumber) {
            this.highestLineNumber = count;
        }
        Dimension dim = this.getPreferredSize();
        if (this.getWidthDimension() > dim.width || this.getHeightDimension() > dim.height) {
            this.resize();
        }
    }

    public String getToolTipText(MouseEvent e) {
        if (this.editorUI == null) {
            return null;
        }
        int line = this.getLineFromMouseEvent(e);
        if (this.annos.getNumberOfAnnotations(line) == 0) {
            return null;
        }
        if (this.isMouseOverCycleButton(e) && this.annos.getNumberOfAnnotations(line) > 1) {
            return MessageFormat.format(NbBundle.getBundle(BaseKit.class).getString("cycling-glyph_tooltip"), new Integer(this.annos.getNumberOfAnnotations(line)));
        }
        if (this.isMouseOverGlyph(e)) {
            return this.annos.getActiveAnnotation(line).getShortDescription();
        }
        return null;
    }

    private int getXPosOfGlyph(int line) {
        int xPos;
        if (this.editorUI == null) {
            return 0;
        }
        int n = xPos = this.showLineNumbers ? this.getLineNumberWidth() : 0;
        if (this.drawOverLineNumbers) {
            xPos = this.getWidth() - 16;
            if (this.cachedCountOfAnnos == -1 || this.cachedCountOfAnnosForLine != line) {
                this.cachedCountOfAnnos = this.annos.getNumberOfAnnotations(line);
                this.cachedCountOfAnnosForLine = line;
            }
            if (this.cachedCountOfAnnos > 1) {
                xPos -= 9;
            }
        }
        return xPos;
    }

    private boolean isMouseOverGlyph(MouseEvent e) {
        int line = this.getLineFromMouseEvent(e);
        return e.getX() >= this.getXPosOfGlyph(line) && e.getX() <= this.getXPosOfGlyph(line) + 16;
    }

    private boolean isMouseOverCycleButton(MouseEvent e) {
        int line = this.getLineFromMouseEvent(e);
        return e.getX() >= this.getXPosOfGlyph(line) + 16 && e.getX() <= this.getXPosOfGlyph(line) + 16 + 9;
    }

    public JComponent createSideBar(JTextComponent target) {
        EditorUI eui = Utilities.getEditorUI(target);
        if (eui == null) {
            return null;
        }
        GlyphGutter glyph = new GlyphGutter(eui);
        eui.setGlyphGutter(glyph);
        return glyph;
    }

    private int getLineFromMouseEvent(MouseEvent e) {
        int line = -1;
        if (this.editorUI != null) {
            try {
                JTextComponent component = this.editorUI.getComponent();
                BaseTextUI textUI = (BaseTextUI)component.getUI();
                int clickOffset = textUI.viewToModel(component, new Point(0, e.getY()));
                line = Utilities.getLineOffset(this.doc, clickOffset);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        return line;
    }

    class EditorUIListener
    implements PropertyChangeListener {
        EditorUIListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt != null && "component".equals(evt.getPropertyName()) && evt.getNewValue() == null) {
                GlyphGutter.this.editorUI.removePropertyChangeListener(GlyphGutter.this.editorUIListener);
                GlyphGutter.this.annos.removeAnnotationsListener(GlyphGutter.this);
                GlyphGutter.this.foldHierarchy.removeFoldHierarchyListener((FoldHierarchyListener)GlyphGutter.this.glyphGutterFoldHierarchyListener);
                if (GlyphGutter.this.gutterMouseListener != null) {
                    GlyphGutter.this.removeMouseListener(GlyphGutter.this.gutterMouseListener);
                    GlyphGutter.this.removeMouseMotionListener(GlyphGutter.this.gutterMouseListener);
                }
                if (GlyphGutter.this.annoTypesListener != null) {
                    AnnotationTypes.getTypes().removePropertyChangeListener(GlyphGutter.this.annoTypesListener);
                }
                GlyphGutter.this.foldHierarchy.removeFoldHierarchyListener((FoldHierarchyListener)GlyphGutter.this.glyphGutterFoldHierarchyListener);
                GlyphGutter.this.foldHierarchy = null;
                GlyphGutter.this.doc = null;
                GlyphGutter.this.editorUI.removePropertyChangeListener(this);
                GlyphGutter.this.editorUI = null;
                GlyphGutter.this.annos = null;
            }
        }
    }

    class GlyphGutterFoldHierarchyListener
    implements FoldHierarchyListener {
        public void foldHierarchyChanged(FoldHierarchyEvent evt) {
            GlyphGutter.this.repaint();
        }
    }

    class GutterMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private int dragStartLine;
        private int dragEndLine;
        private int currentEndLine;
        private boolean selectForward;

        GutterMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (GlyphGutter.this.editorUI == null) {
                return;
            }
            if (e.getModifiers() == 16) {
                if (GlyphGutter.this.isMouseOverCycleButton(e)) {
                    int line = GlyphGutter.this.getLineFromMouseEvent(e);
                    GlyphGutter.this.annos.activateNextAnnotation(line);
                } else {
                    Action[] actions = ImplementationProvider.getDefault().getGlyphGutterActions(GlyphGutter.this.editorUI.getComponent());
                    if (actions != null && actions.length > 0) {
                        Action a = actions[0];
                        if (a != null && a.isEnabled()) {
                            int currentLine = -1;
                            int line = GlyphGutter.this.getLineFromMouseEvent(e);
                            if (line == -1) {
                                return;
                            }
                            try {
                                currentLine = Utilities.getLineOffset(GlyphGutter.this.doc, GlyphGutter.this.editorUI.getComponent().getCaret().getDot());
                            }
                            catch (BadLocationException ex) {
                                return;
                            }
                            if (line != currentLine) {
                                int offset = Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, line);
                                JumpList.checkAddEntry();
                                GlyphGutter.this.editorUI.getComponent().getCaret().setDot(offset);
                            }
                            a.actionPerformed(new ActionEvent(GlyphGutter.this.editorUI.getComponent(), 0, ""));
                            GlyphGutter.this.repaint();
                        }
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        }

        private void showPopup(MouseEvent e) {
            if (GlyphGutter.this.editorUI == null) {
                return;
            }
            if (e.isPopupTrigger()) {
                int line = GlyphGutter.this.getLineFromMouseEvent(e);
                int offset = GlyphGutter.this.annos.getActiveAnnotation(line) != null ? GlyphGutter.this.annos.getActiveAnnotation(line).getOffset() : Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, line);
                if (GlyphGutter.this.editorUI.getComponent().getCaret().getDot() != offset) {
                    JumpList.checkAddEntry();
                }
                GlyphGutter.this.editorUI.getComponent().getCaret().setDot(offset);
                JPopupMenu pm = GlyphGutter.this.annos.createPopupMenu(Utilities.getKit(GlyphGutter.this.editorUI.getComponent()), line);
                if (pm != null) {
                    pm.show(GlyphGutter.this, e.getX(), e.getY());
                }
                pm.addPopupMenuListener(new PopupMenuListener(){

                    public void popupMenuCanceled(PopupMenuEvent e2) {
                        GlyphGutter.this.editorUI.getComponent().requestFocus();
                    }

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
                        GlyphGutter.this.editorUI.getComponent().requestFocus();
                    }

                    public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
                    }
                });
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        private void updateSelection(boolean newSelection) {
            if (GlyphGutter.this.editorUI == null) {
                return;
            }
            JTextComponent comp = Utilities.getLastActiveComponent();
            try {
                if (newSelection) {
                    this.selectForward = true;
                    int rowStart = Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragStartLine);
                    if (rowStart < 0) {
                        rowStart = Utilities.getRowStart(GlyphGutter.this.doc, GlyphGutter.this.doc.getLength());
                        this.dragStartLine = Utilities.getLineOffset(GlyphGutter.this.doc, rowStart);
                    }
                    comp.setCaretPosition(rowStart);
                    int offSet = Utilities.getRowEnd(GlyphGutter.this.doc, rowStart);
                    if (offSet < GlyphGutter.this.doc.getLength()) {
                        ++offSet;
                    }
                    comp.moveCaretPosition(offSet);
                    this.currentEndLine = this.dragEndLine = this.dragStartLine;
                } else {
                    if (this.currentEndLine == this.dragEndLine) {
                        return;
                    }
                    if (this.dragEndLine < this.dragStartLine) {
                        int rowStart;
                        if (this.selectForward) {
                            int offSet = Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragStartLine + 1);
                            if (offSet < 0) {
                                offSet = Utilities.getRowEnd(GlyphGutter.this.doc, Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragStartLine));
                            }
                            comp.setCaretPosition(offSet);
                            this.selectForward = false;
                        }
                        if ((rowStart = Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragEndLine)) < 0) {
                            rowStart = 0;
                        }
                        comp.moveCaretPosition(rowStart);
                    } else {
                        int offSet;
                        if (!this.selectForward) {
                            comp.setCaretPosition(Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragStartLine));
                            this.selectForward = true;
                        }
                        if ((offSet = Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragEndLine + 1)) < 0) {
                            offSet = GlyphGutter.this.doc.getLength();
                        }
                        comp.moveCaretPosition(offSet);
                    }
                }
                this.currentEndLine = this.dragEndLine;
            }
            catch (BadLocationException ble) {
                ErrorManager.getDefault().notify((Throwable)ble);
            }
        }
    }

    private static class Observer
    implements ImageObserver {
        WeakReference glyphGutter;

        private Observer(GlyphGutter gutter) {
            this.glyphGutter = new WeakReference<GlyphGutter>(gutter);
        }

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            GlyphGutter obj;
            if ((infoflags & 0x20) == 32 && (obj = (GlyphGutter)this.glyphGutter.get()) != null) {
                obj.repaint();
            }
            return true;
        }
    }
}

