/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.WeakEventListenerList;
import org.openide.util.RequestProcessor;

public class Settings {
    private static final Logger LOG = Logger.getLogger(Settings.class.getName());
    public static final int CORE_LEVEL = 0;
    public static final int SYSTEM_LEVEL = 1;
    public static final int EXTENSION_LEVEL = 2;
    public static final int OPTION_LEVEL = 3;
    public static final int USER_LEVEL = 4;
    private static final ArrayList initializerLists = new ArrayList();
    private static long initializerListsVersion = 0L;
    private static List[] listsOfInitializers = null;
    private static long listsOfInitializersVersion = -1L;
    private static InitializerSorter currentInitializerSorter;
    private static final Filter[] NULL_FILTERS;
    private static final String FILTERS_LOCK;
    private static volatile Filter[] filters;
    private static final Map kit2Maps;
    private static final WeakEventListenerList listenerList;
    private static final Map NULL_MAP;
    private static volatile boolean firingEnabled;
    private static final HashMap emptyMaps;
    private static final RequestProcessor PROCESSOR;
    private static final RequestProcessor.Task RESET_TASK;

    private Settings() {
    }

    public static void addInitializer(Initializer i) {
        Settings.addInitializer(i, 1);
        Settings.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInitializer(Initializer i, int level) {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            int size;
            for (int j = size = initializerLists.size(); j <= level; ++j) {
                initializerLists.add(new ArrayList());
            }
            ((List)initializerLists.get(level)).add(i);
            if (currentInitializerSorter != null) {
                currentInitializerSorter.sort(initializerLists);
            }
            ++initializerListsVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInitializer(String name) {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            Iterator itit = initializerLists.iterator();
            while (itit.hasNext()) {
                Iterator it = ((List)itit.next()).iterator();
                while (it.hasNext()) {
                    if (!name.equals(((Initializer)it.next()).getName())) continue;
                    it.remove();
                }
            }
            if (currentInitializerSorter != null) {
                currentInitializerSorter.sort(initializerLists);
            }
            ++initializerListsVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InitializerSorter getInitializerSorter() {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            return currentInitializerSorter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInitializerSorter(InitializerSorter initializerSorter) {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            currentInitializerSorter = initializerSorter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List[] getListsOfInitializers() {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            if (listsOfInitializersVersion != initializerListsVersion) {
                List[] lists = initializerLists.toArray(new List[initializerLists.size()]);
                for (int i = 0; i < lists.length; ++i) {
                    lists[i] = Collections.unmodifiableList(new ArrayList(lists[i]));
                }
                listsOfInitializers = lists;
                listsOfInitializersVersion = initializerListsVersion;
            }
            return listsOfInitializers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFilter(Filter f) {
        String string = FILTERS_LOCK;
        synchronized (string) {
            if (filters.length == 0) {
                filters = new Filter[]{f};
            } else {
                Filter[] tmp = new Filter[filters.length + 1];
                System.arraycopy(filters, 0, tmp, 0, filters.length);
                tmp[Settings.filters.length] = f;
                filters = tmp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFilter(Filter f) {
        String string = FILTERS_LOCK;
        synchronized (string) {
            if (filters.length == 0) {
                return;
            }
            if (filters.length == 1 && filters[0] == f) {
                filters = NULL_FILTERS;
            } else {
                int idx = -1;
                for (int i = 0; i < filters.length; ++i) {
                    if (filters[i] != f) continue;
                    idx = i;
                    break;
                }
                if (idx != -1) {
                    Filter[] tmp = new Filter[filters.length - 1];
                    System.arraycopy(filters, 0, tmp, 0, idx);
                    if (idx < tmp.length) {
                        System.arraycopy(filters, idx + 1, tmp, idx, tmp.length - idx);
                    }
                    filters = tmp;
                }
            }
        }
    }

    public static Object getValue(Class kitClass, String settingName) {
        return Settings.getValue(kitClass, settingName, true);
    }

    public static synchronized Object getValue(Class kitClass, String settingName, boolean evaluateEvaluators) {
        Object value = null;
        Class kc = kitClass;
        while (true) {
            Map map;
            if ((map = Settings.getKitMap(kc, false)) != null) {
                value = map.get(settingName);
                if (evaluateEvaluators && value instanceof Evaluator) {
                    value = ((Evaluator)value).getValue(kitClass, settingName);
                }
                if (value != null) break;
            }
            if (kc == null) break;
            kc = kc.getSuperclass();
        }
        Filter[] currentFilters = filters;
        for (int i = 0; i < currentFilters.length; ++i) {
            value = currentFilters[i].filterValue(kitClass, settingName, value);
        }
        return value;
    }

    public static KitAndValue[] getValueHierarchy(Class kitClass, String settingName) {
        return Settings.getValueHierarchy(kitClass, settingName, true);
    }

    public static synchronized KitAndValue[] getValueHierarchy(Class kitClass, String settingName, boolean evaluateEvaluators) {
        ArrayList<KitAndValue> kavList = new ArrayList<KitAndValue>();
        Class kc = kitClass;
        while (true) {
            Map map;
            if ((map = Settings.getKitMap(kc, false)) != null) {
                Object value = map.get(settingName);
                if (evaluateEvaluators && value instanceof Evaluator) {
                    value = ((Evaluator)value).getValue(kitClass, settingName);
                }
                if (value != null) {
                    kavList.add(new KitAndValue(kc, value));
                }
            }
            if (kc == null) break;
            kc = kc.getSuperclass();
        }
        KitAndValue[] kavArray = kavList.toArray(new KitAndValue[kavList.size()]);
        Filter[] currentFilters = filters;
        for (int i = 0; i < currentFilters.length; ++i) {
            kavArray = currentFilters[i].filterValueHierarchy(kitClass, settingName, kavArray);
        }
        return kavArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setValue(Class kitClass, String settingName, Object newValue) {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            Map map = Settings.getKitMap(kitClass, true);
            Object oldValue = map.get(settingName);
            if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            if (newValue != null) {
                map.put(settingName, newValue);
            } else {
                map.remove(settingName);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            Settings.fireSettingsChange(kitClass, settingName, oldValue, newValue);
            return;
        }
    }

    public static void touchValue(Class kitClass, String settingName) {
        Settings.fireSettingsChange(kitClass, settingName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void propagateValue(Class kitClass, String settingName, Object newValue) {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            Map map = Settings.getKitMap(kitClass, true);
            if (newValue != null) {
                map.put(settingName, newValue);
            } else {
                map.remove(settingName);
            }
            for (Map.Entry me : kit2Maps.entrySet()) {
                Class kc = (Class)me.getKey();
                if (kitClass == kc || kitClass != null && !kitClass.isAssignableFrom(kc)) continue;
                ((Map)me.getValue()).remove(settingName);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Settings.fireSettingsChange(null, settingName, null, null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(Runnable r) {
        boolean fire = false;
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            boolean turnedOff = firingEnabled;
            firingEnabled = false;
            try {
                r.run();
            }
            finally {
                if (turnedOff) {
                    firingEnabled = true;
                    fire = true;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (fire) {
                Settings.fireSettingsChange(null, null, null, null);
            }
            return;
        }
    }

    public static void reset() {
        RESET_TASK.schedule(1);
    }

    public static String initializersToString() {
        StringBuffer sb = new StringBuffer();
        List[] lists = Settings.getListsOfInitializers();
        for (int i = 0; i < lists.length; ++i) {
            switch (i) {
                case 0: {
                    sb.append("CORE_LEVEL");
                    break;
                }
                case 1: {
                    sb.append("SYSTEM_LEVEL");
                    break;
                }
                case 2: {
                    sb.append("EXTENSION_LEVEL");
                    break;
                }
                case 3: {
                    sb.append("OPTION_LEVEL");
                    break;
                }
                case 4: {
                    sb.append("USER_LEVEL");
                    break;
                }
                default: {
                    sb.append("level " + i);
                }
            }
            sb.append(":\n");
            sb.append(EditorDebug.debugList(lists[i]));
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void addSettingsChangeListener(SettingsChangeListener l) {
        listenerList.add(SettingsChangeListener.class, l);
    }

    public static void removeSettingsChangeListener(SettingsChangeListener l) {
        listenerList.remove(SettingsChangeListener.class, l);
    }

    private static void fireSettingsChange(Class kitClass, String settingName, Object oldValue, Object newValue) {
        if (firingEnabled) {
            SettingsChangeListener[] listeners = (SettingsChangeListener[])listenerList.getListeners(SettingsChangeListener.class);
            SettingsChangeEvent evt = new SettingsChangeEvent(Settings.class, kitClass, settingName, oldValue, newValue);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].settingsChange(evt);
            }
        }
    }

    private static Map getKitMap(Class kitClass, boolean forceCreation) {
        Map kitMap = (LoggingMap)kit2Maps.get(kitClass);
        if (kitMap == null) {
            LoggingMap emptyMap = (LoggingMap)emptyMaps.get(kitClass);
            if (emptyMap != null) {
                return emptyMap;
            }
            if (emptyMap == null) {
                emptyMap = LOG.isLoggable(Level.FINE) ? new LoggingMap(kitClass, Level.FINE) : new HashMap();
                emptyMaps.put(kitClass, emptyMap);
            }
            List[] lists = Settings.getListsOfInitializers();
            for (int i = 0; i < lists.length; ++i) {
                for (Initializer initializer : lists[i]) {
                    try {
                        initializer.updateSettingsMap(kitClass, emptyMap);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, null, t);
                    }
                }
            }
            if (emptyMap.size() > 0) {
                kitMap = emptyMap;
            }
            if (kitMap == null) {
                kitMap = NULL_MAP;
            }
            kit2Maps.put(kitClass, kitMap);
            emptyMaps.remove(kitClass);
        }
        if (kitMap == NULL_MAP) {
            if (!forceCreation) {
                return null;
            }
            kitMap = LOG.isLoggable(Level.FINE) ? new LoggingMap(kitClass, Level.FINE) : new HashMap();
            kit2Maps.put(kitClass, kitMap);
        }
        return kitMap;
    }

    static {
        NULL_FILTERS = new Filter[0];
        FILTERS_LOCK = new String("Settings.FILTERS_LOCK");
        filters = NULL_FILTERS;
        kit2Maps = new HashMap();
        listenerList = new WeakEventListenerList();
        NULL_MAP = new HashMap(1);
        firingEnabled = true;
        emptyMaps = new HashMap();
        PROCESSOR = new RequestProcessor("org.netbeans.editor.Settings.PROCESSOR");
        RESET_TASK = PROCESSOR.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Class<Settings> clazz = Settings.class;
                synchronized (Settings.class) {
                    kit2Maps.clear();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    Settings.fireSettingsChange(null, null, null, null);
                    return;
                }
            }
        });
    }

    public static abstract class AbstractInitializer
    implements Initializer {
        private String name;

        public AbstractInitializer(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static interface Evaluator {
        public Object getValue(Class var1, String var2);
    }

    public static interface Filter {
        public Object filterValue(Class var1, String var2, Object var3);

        public KitAndValue[] filterValueHierarchy(Class var1, String var2, KitAndValue[] var3);
    }

    public static abstract class FilterInitializerSorter {
        private InitializerSorter delegate;

        public FilterInitializerSorter(InitializerSorter delegate) {
            this.delegate = delegate;
        }

        public void sort(List initializersList) {
            if (this.delegate != null) {
                this.delegate.sort(initializersList);
            }
        }
    }

    public static interface Initializer {
        public String getName();

        public void updateSettingsMap(Class var1, Map var2);
    }

    public static interface InitializerSorter {
        public void sort(List var1);
    }

    public static class KitAndValue {
        public Class kitClass;
        public Object value;

        public KitAndValue(Class kitClass, Object value) {
            this.kitClass = kitClass;
            this.value = value;
        }
    }

    private static final class LoggingMap
    extends HashMap {
        private Class kitClass;
        private Level logLevel;

        public LoggingMap(Class kitClass, Level logLevel) {
            this.kitClass = kitClass;
            this.logLevel = logLevel;
        }

        public Object put(Object key, Object value) {
            if (key != null && (key.equals("rendering-hints") || key.equals("textAntialiasing"))) {
                String msg = "Settings map: put('" + key + "' to '" + value + "') for kitClass=" + this.kitClass;
                LOG.log(this.logLevel, msg, new Throwable());
            }
            return super.put(key, value);
        }
    }
}

