/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.openide.util.NbBundle;

public class StatusBar
implements PropertyChangeListener,
SettingsChangeListener,
DocumentListener {
    public static final String CELL_MAIN = "main";
    public static final String CELL_POSITION = "position";
    public static final String CELL_TYPING_MODE = "typing-mode";
    public static final String INSERT_LOCALE = "status-bar-insert";
    public static final String OVERWRITE_LOCALE = "status-bar-overwrite";
    private static final String[] POS_MAX_STRINGS = new String[]{"99999:999"};
    private static final Insets NULL_INSETS = new Insets(0, 0, 0, 0);
    static final Border CELL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("control")), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, UIManager.getDefaults().getColor("controlHighlight")), BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlDkShadow")))), BorderFactory.createEmptyBorder(0, 2, 0, 2));
    protected EditorUI editorUI;
    private JPanel panel;
    private boolean visible;
    private Coloring coloring;
    private Coloring boldColoring;
    private List cellList = new ArrayList();
    private Caret caret;
    private CaretListener caretL;
    private int caretDelay;
    private boolean overwriteModeDisplayed;
    private String insText;
    private String ovrText;
    private String caretPositionLocaleString;
    private String insertModeLocaleString;
    private String overwriteModeLocaleString;
    static final long serialVersionUID = -6266183959929157349L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusBar(EditorUI editorUI) {
        this.editorUI = editorUI;
        this.caretDelay = 10;
        this.caretL = new CaretListener(this.caretDelay);
        ResourceBundle bundle = NbBundle.getBundle(BaseKit.class);
        this.insText = bundle.getString(INSERT_LOCALE);
        this.ovrText = bundle.getString(OVERWRITE_LOCALE);
        this.caretPositionLocaleString = bundle.getString("status-bar-caret-position");
        this.insertModeLocaleString = bundle.getString("status-bar-insert-mode");
        this.overwriteModeLocaleString = bundle.getString("status-bar-overwrite-mode");
        Settings.addSettingsChangeListener(this);
        Object object = editorUI.getComponentLock();
        synchronized (object) {
            JTextComponent component = editorUI.getComponent();
            if (component != null) {
                this.propertyChange(new PropertyChangeEvent(editorUI, "component", null, component));
            }
            editorUI.addPropertyChangeListener(this);
        }
    }

    public void settingsChange(SettingsChangeEvent evt) {
        String settingName;
        Class kitClass = Utilities.getKitClass(this.editorUI.getComponent());
        String string = settingName = evt != null ? evt.getSettingName() : null;
        if (kitClass != null) {
            this.coloring = this.editorUI.getColoring("status-bar");
            this.boldColoring = this.editorUI.getColoring("status-bar-bold");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusBar.this.refreshPanel();
                }
            });
            if (settingName == null || "status-bar-caret-delay".equals(settingName)) {
                this.caretDelay = SettingsUtil.getInteger(kitClass, "status-bar-caret-delay", SettingsDefaults.defaultStatusBarCaretDelay);
                if (this.caretL != null) {
                    this.caretL.setDelay(this.caretDelay);
                }
            }
            if (settingName == null || "status-bar-visible".equals(settingName)) {
                boolean wantVisible = SettingsUtil.getBoolean(kitClass, "status-bar-visible", SettingsDefaults.defaultStatusBarVisible);
                this.setVisible(wantVisible);
            }
        }
    }

    private void documentUndo(DocumentEvent evt) {
        Utilities.runInEventDispatchThread(new Runnable(){

            public void run() {
                StatusBar.this.setText(StatusBar.CELL_MAIN, "");
            }
        });
    }

    public void insertUpdate(DocumentEvent evt) {
        if (evt.getType() == DocumentEvent.EventType.REMOVE) {
            this.documentUndo(evt);
        }
    }

    public void removeUpdate(DocumentEvent evt) {
        if (evt.getType() == DocumentEvent.EventType.INSERT) {
            this.documentUndo(evt);
        }
    }

    public void changedUpdate(DocumentEvent evt) {
    }

    protected JPanel createPanel() {
        return new JPanel(new GridBagLayout());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean v) {
        if (v != this.visible) {
            this.visible = v;
            if (this.panel != null || this.visible) {
                if (this.visible) {
                    this.refreshPanel();
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    this.getPanel().setVisible(this.visible);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusBar.this.getPanel().setVisible(StatusBar.this.visible);
                        }
                    });
                }
            }
        }
    }

    public final JPanel getPanel() {
        if (this.panel == null) {
            this.panel = this.createPanel();
            this.initPanel();
        }
        return this.panel;
    }

    protected void initPanel() {
        JLabel cell = this.addCell(CELL_POSITION, POS_MAX_STRINGS);
        cell.setHorizontalAlignment(0);
        cell.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Action a;
                if (e.getClickCount() == 2 && (a = Utilities.getKit(StatusBar.this.editorUI.getComponent()).getActionByName("goto")) != null) {
                    a.actionPerformed(new ActionEvent(StatusBar.this.editorUI.getComponent(), 0, null));
                }
            }
        });
        this.addCell(CELL_TYPING_MODE, new String[]{this.insText, this.ovrText}).setHorizontalAlignment(0);
        this.setText(CELL_TYPING_MODE, this.insText);
        this.addCell(CELL_MAIN, null);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("component".equals(propName)) {
            JTextComponent component = (JTextComponent)evt.getNewValue();
            if (component != null) {
                Document doc;
                component.addPropertyChangeListener(this);
                this.caret = component.getCaret();
                if (this.caret != null) {
                    this.caret.addChangeListener(this.caretL);
                }
                if ((doc = component.getDocument()) != null) {
                    doc.addDocumentListener(this);
                }
                this.settingsChange(null);
                this.refreshPanel();
            } else {
                Document doc;
                component = (JTextComponent)evt.getOldValue();
                component.removePropertyChangeListener(this);
                this.caret = component.getCaret();
                if (this.caret != null) {
                    this.caret.removeChangeListener(this.caretL);
                }
                if ((doc = component.getDocument()) != null) {
                    doc.removeDocumentListener(this);
                }
            }
        } else if ("caret".equals(propName)) {
            if (this.caret != null) {
                this.caret.removeChangeListener(this.caretL);
            }
            this.caret = (Caret)evt.getNewValue();
            if (this.caret != null) {
                this.caret.addChangeListener(this.caretL);
            }
        } else if ("document".equals(propName)) {
            Document old = (Document)evt.getOldValue();
            Document cur = (Document)evt.getNewValue();
            if (old != null) {
                old.removeDocumentListener(this);
            }
            if (cur != null) {
                cur.addDocumentListener(this);
            }
        }
        if ("overwriteMode".equals(propName)) {
            this.caretL.actionPerformed(null);
        } else {
            this.caretL.stateChanged(null);
        }
    }

    private void applyColoring(Cell cell, Coloring coloring) {
        coloring.apply(cell);
        if (coloring.getForeColor() == null) {
            cell.setForeground(cell.getDefaultForeground());
        }
        if (coloring.getBackColor() == null) {
            cell.setBackground(cell.getDefaultBackground());
        }
    }

    public int getCellCount() {
        return this.cellList.size();
    }

    public JLabel addCell(String name, String[] widestStrings) {
        return this.addCell(-1, name, widestStrings);
    }

    public JLabel addCell(int i, String name, String[] widestStrings) {
        Cell c = new Cell(name, widestStrings);
        this.addCellImpl(i, c);
        return c;
    }

    public void addCustomCell(int i, JLabel c) {
        this.addCellImpl(i, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCellImpl(int i, JLabel c) {
        List list = this.cellList;
        synchronized (list) {
            ArrayList<JLabel> newCellList = new ArrayList<JLabel>(this.cellList);
            int cnt = newCellList.size();
            if (i < 0 || i > cnt) {
                i = cnt;
            }
            newCellList.add(i, c);
            this.cellList = newCellList;
            this.updateCellBorders(i);
        }
        this.refreshPanel();
    }

    private void updateCellBorders(int addedIndex) {
        int cellCount = this.getCellCount();
        Border innerBorder = (Border)UIManager.get("Nb.Editor.Status.innerBorder");
        Border leftBorder = (Border)UIManager.get("Nb.Editor.Status.leftBorder");
        Border rightBorder = (Border)UIManager.get("Nb.Editor.Status.rightBorder");
        Border onlyOneBorder = (Border)UIManager.get("Nb.Editor.Status.onlyOneBorder");
        if (innerBorder == null || leftBorder == null || rightBorder == null || onlyOneBorder == null) {
            return;
        }
        if (cellCount == 1) {
            ((JLabel)this.cellList.get(0)).setBorder(onlyOneBorder);
            return;
        }
        if (addedIndex == 0) {
            ((JLabel)this.cellList.get(0)).setBorder(leftBorder);
            JLabel second = (JLabel)this.cellList.get(1);
            second.setBorder(cellCount == 2 ? rightBorder : innerBorder);
        } else if (addedIndex == cellCount - 1) {
            ((JLabel)this.cellList.get(cellCount - 1)).setBorder(rightBorder);
            JLabel previous = (JLabel)this.cellList.get(cellCount - 2);
            previous.setBorder(cellCount == 2 ? leftBorder : innerBorder);
        } else {
            ((JLabel)this.cellList.get(addedIndex)).setBorder(innerBorder);
        }
    }

    public JLabel getCellByName(String name) {
        for (JLabel c : this.cellList) {
            if (!name.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    public String getText(String cellName) {
        JLabel cell = this.getCellByName(cellName);
        return cell != null ? cell.getText() : null;
    }

    public void setText(String cellName, String text) {
        this.setText(cellName, text, null);
    }

    public void setBoldText(String cellName, String text) {
        this.setText(cellName, text, this.boldColoring);
    }

    public void setText(String cellName, String text, Coloring extraColoring) {
        JLabel cell = this.getCellByName(cellName);
        if (cell != null) {
            Coloring c = this.coloring;
            if (c != null && extraColoring != null) {
                c = extraColoring.apply(c);
            } else if (c == null) {
                c = extraColoring;
            }
            cell.setText(text);
            if (CELL_POSITION.equals(cellName)) {
                cell.setToolTipText(this.caretPositionLocaleString);
            } else if (CELL_TYPING_MODE.equals(cellName)) {
                cell.setToolTipText(this.insText.equals(text) ? this.insertModeLocaleString : this.overwriteModeLocaleString);
            } else {
                cell.setToolTipText("".equals(text) ? null : text);
            }
            if (c != null && cell instanceof Cell) {
                this.applyColoring((Cell)cell, c);
            }
        }
    }

    private void refreshPanel() {
        if (this.isVisible()) {
            for (JLabel c : this.cellList) {
                if (!(c instanceof Cell) || this.coloring == null) continue;
                this.applyColoring((Cell)c, this.coloring);
            }
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = -1;
            gc.gridwidth = 1;
            gc.gridheight = 1;
            for (JLabel c : this.cellList) {
                boolean main = CELL_MAIN.equals(c.getName());
                if (main) {
                    gc.fill = 2;
                    gc.weightx = 1.0;
                }
                this.getPanel().add((Component)c, gc);
                if (!main) continue;
                gc.fill = 0;
                gc.weightx = 0.0;
            }
        }
    }

    class CaretListener
    implements ChangeListener,
    ActionListener {
        Timer timer;

        CaretListener(int delay) {
            this.timer = new Timer(delay, new WeakTimerListener(this));
            this.timer.setRepeats(false);
        }

        void setDelay(int delay) {
            this.timer.setInitialDelay(delay);
        }

        public void stateChanged(ChangeEvent evt) {
            this.timer.restart();
        }

        public void actionPerformed(ActionEvent evt) {
            Caret c = StatusBar.this.caret;
            JTextComponent component = StatusBar.this.editorUI.getComponent();
            if (component != null) {
                Boolean b;
                boolean om;
                BaseDocument doc;
                if (c != null && (doc = Utilities.getDocument(StatusBar.this.editorUI.getComponent())) != null && doc.getDefaultRootElement().getElementCount() > 0) {
                    int pos = c.getDot();
                    String s = Utilities.debugPosition(doc, pos);
                    StatusBar.this.setText(StatusBar.CELL_POSITION, s);
                }
                boolean bl = om = (b = (Boolean)StatusBar.this.editorUI.getProperty("overwriteMode")) != null && b != false;
                if (om != StatusBar.this.overwriteModeDisplayed) {
                    StatusBar.this.overwriteModeDisplayed = om;
                    StatusBar.this.setText(StatusBar.CELL_TYPING_MODE, StatusBar.this.overwriteModeDisplayed ? StatusBar.this.ovrText : StatusBar.this.insText);
                }
            }
        }
    }

    static class Cell
    extends JLabel {
        Dimension maxDimension;
        String[] widestStrings;
        private final Color defaultBackground;
        private final Color defaultForeground;
        static final long serialVersionUID = -2554600362177165648L;

        Cell(String name, String[] widestStrings) {
            this.setName(name);
            this.setBorder(CELL_BORDER);
            this.setOpaque(true);
            this.widestStrings = widestStrings;
            this.defaultBackground = this.getBackground();
            this.defaultForeground = this.getForeground();
        }

        private void updateSize() {
            Font f = this.getFont();
            if (this.maxDimension == null) {
                this.maxDimension = new Dimension();
            }
            if (f != null) {
                Border b = this.getBorder();
                Insets ins = b != null ? b.getBorderInsets(this) : NULL_INSETS;
                FontMetrics fm = this.getFontMetrics(f);
                int mw = fm.stringWidth(this.getText());
                this.maxDimension.height = fm.getHeight() + ins.top + ins.bottom;
                if (this.widestStrings != null) {
                    for (int i = 0; i < this.widestStrings.length; ++i) {
                        String widestString = this.widestStrings[i];
                        if (widestString == null) continue;
                        mw = Math.max(mw, fm.stringWidth(widestString));
                    }
                }
                this.maxDimension.width = mw + ins.left + ins.right;
            }
        }

        public Dimension getPreferredSize() {
            if (this.maxDimension == null) {
                this.maxDimension = new Dimension();
            }
            return new Dimension(this.maxDimension);
        }

        public Dimension getMinimumSize() {
            if (this.maxDimension == null) {
                this.maxDimension = new Dimension();
            }
            return new Dimension(this.maxDimension);
        }

        public void setFont(Font f) {
            super.setFont(f);
            this.updateSize();
        }

        public Color getDefaultForeground() {
            Color color = (Color)UIManager.get("Label.foreground");
            return color != null ? color : this.defaultForeground;
        }

        public Color getDefaultBackground() {
            Color color = (Color)UIManager.get("Label.background");
            return color != null ? color : this.defaultBackground;
        }
    }

    public static final class StatusBarFactory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent target) {
            return Utilities.getEditorUI(target).getStatusBar().getPanel();
        }
    }
}

