/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.ExtUtilities;

public class ExtCaret
extends BaseCaret {
    public static final String HIGHLIGHT_ROW_LAYER_NAME = "highlight-row-layer";
    public static final int HIGHLIGHT_ROW_LAYER_VISIBILITY = 2050;
    public static final String HIGHLIGHT_BRACE_LAYER_NAME = "highlight-brace-layer";
    public static final int HIGHLIGHT_BRACE_LAYER_VISIBILITY = 11000;
    boolean highlightBrace;
    Coloring highlightBraceColoring;
    MarkFactory.DrawMark highlightBraceStartMark;
    MarkFactory.DrawMark highlightBraceEndMark;
    private Timer braceTimer;
    private ActionListener braceTimerListener;
    private boolean matchBraceUpdateSync;
    boolean braceMarksValid;
    boolean simpleMatchBrace;
    private boolean popupMenuEnabled;
    static final long serialVersionUID = -4292670043122577690L;

    protected void modelChanged(BaseDocument oldDoc, BaseDocument newDoc) {
        this.braceMarksValid = false;
        if (this.highlightBraceStartMark != null) {
            try {
                this.highlightBraceStartMark.remove();
            }
            catch (InvalidMarkException e) {
                // empty catch block
            }
            this.highlightBraceStartMark = null;
        }
        if (this.highlightBraceEndMark != null) {
            try {
                this.highlightBraceEndMark.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
            this.highlightBraceEndMark = null;
        }
        super.modelChanged(oldDoc, newDoc);
    }

    public void settingsChange(SettingsChangeEvent evt) {
        super.settingsChange(evt);
        JTextComponent c = this.component;
        if (c != null) {
            EditorUI editorUI = Utilities.getEditorUI(c);
            Class kitClass = Utilities.getKitClass(c);
            this.highlightBraceColoring = editorUI.getColoring("highlight-match-brace");
            this.highlightBrace = SettingsUtil.getBoolean(kitClass, "highlight-match-brace", ExtSettingsDefaults.defaultHighlightMatchBrace);
            int highlightBraceDelay = SettingsUtil.getInteger(kitClass, "highlight-match-brace-delay", ExtSettingsDefaults.defaultHighlightMatchBraceDelay);
            if (this.highlightBrace) {
                if (highlightBraceDelay > 0) {
                    final JTextComponent c2 = this.component;
                    this.braceTimer = new Timer(highlightBraceDelay, null);
                    this.braceTimerListener = new ActionListener(){

                        public void actionPerformed(ActionEvent evt2) {
                            SwingUtilities.invokeLater(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    BaseDocument doc;
                                    if (c2 != null && (doc = Utilities.getDocument(c2)) != null) {
                                        doc.readLock();
                                        try {
                                            ExtCaret.this.updateMatchBrace();
                                        }
                                        finally {
                                            doc.readUnlock();
                                        }
                                    }
                                }
                            });
                        }
                    };
                    this.braceTimer.addActionListener(new WeakTimerListener(this.braceTimerListener));
                    this.braceTimer.setRepeats(false);
                } else {
                    this.braceTimer = null;
                }
                c.repaint();
            }
            this.simpleMatchBrace = SettingsUtil.getBoolean(kitClass, "caret-simple-match-brace", ExtSettingsDefaults.defaultCaretSimpleMatchBrace);
            this.popupMenuEnabled = SettingsUtil.getBoolean(kitClass, "popup-menu-enabled", true);
        }
    }

    public void install(JTextComponent c) {
        EditorUI editorUI = Utilities.getEditorUI(c);
        editorUI.addLayer(new HighlightBraceLayer(), 11000);
        super.install(c);
    }

    public void deinstall(JTextComponent c) {
        EditorUI editorUI = Utilities.getEditorUI(c);
        editorUI.removeLayer(HIGHLIGHT_BRACE_LAYER_NAME);
        super.deinstall(c);
    }

    protected void updateMatchBrace() {
        JTextComponent c = this.component;
        if (c != null && this.highlightBrace) {
            try {
                int[] matchBlk;
                EditorUI editorUI = Utilities.getEditorUI(c);
                BaseDocument doc = (BaseDocument)c.getDocument();
                int dotPos = this.getDot();
                boolean madeValid = false;
                if (dotPos > 0 && (matchBlk = ((ExtSyntaxSupport)doc.getSyntaxSupport()).findMatchingBlock(dotPos - 1, this.simpleMatchBrace)) != null) {
                    if (this.highlightBraceStartMark != null) {
                        int markStartPos = this.highlightBraceStartMark.getOffset();
                        int markEndPos = this.highlightBraceEndMark.getOffset();
                        if (markStartPos != matchBlk[0] || markEndPos != matchBlk[1]) {
                            editorUI.repaintBlock(markStartPos, markEndPos);
                            Utilities.moveMark(doc, this.highlightBraceStartMark, matchBlk[0]);
                            Utilities.moveMark(doc, this.highlightBraceEndMark, matchBlk[1]);
                            editorUI.repaintBlock(matchBlk[0], matchBlk[1]);
                        } else if (!this.braceMarksValid) {
                            editorUI.repaintBlock(matchBlk[0], matchBlk[1]);
                        }
                    } else {
                        this.highlightBraceStartMark = new MarkFactory.DrawMark(HIGHLIGHT_BRACE_LAYER_NAME, editorUI);
                        this.highlightBraceEndMark = new MarkFactory.DrawMark(HIGHLIGHT_BRACE_LAYER_NAME, editorUI);
                        this.highlightBraceStartMark.setActivateLayer(true);
                        Utilities.insertMark(doc, this.highlightBraceStartMark, matchBlk[0]);
                        Utilities.insertMark(doc, this.highlightBraceEndMark, matchBlk[1]);
                        editorUI.repaintBlock(matchBlk[0], matchBlk[1]);
                    }
                    this.braceMarksValid = true;
                    madeValid = true;
                }
                if (!madeValid && this.braceMarksValid) {
                    this.braceMarksValid = false;
                    editorUI.repaintBlock(this.highlightBraceStartMark.getOffset(), this.highlightBraceEndMark.getOffset());
                }
            }
            catch (BadLocationException e) {
                Utilities.annotateLoggable(e);
                this.highlightBrace = false;
            }
            catch (InvalidMarkException e) {
                Utilities.annotateLoggable(e);
                this.highlightBrace = false;
            }
        }
    }

    protected void update(boolean scrollViewToCaret) {
        if (this.highlightBrace) {
            if (this.matchBraceUpdateSync || this.braceTimer == null) {
                this.updateMatchBrace();
                this.matchBraceUpdateSync = false;
            } else {
                this.braceTimer.restart();
            }
        }
        super.update(scrollViewToCaret);
    }

    public void requestMatchBraceUpdateSync() {
        this.matchBraceUpdateSync = true;
    }

    public void mousePressed(MouseEvent evt) {
        Completion completion = ExtUtilities.getCompletion(this.component);
        if (completion != null && completion.isPaneVisible()) {
            completion.setPaneVisible(false);
        }
        super.mousePressed(evt);
        this.showPopup(evt);
    }

    private boolean showPopup(MouseEvent evt) {
        if (this.component != null && evt.isPopupTrigger() && this.popupMenuEnabled) {
            ExtUtilities.getExtEditorUI(this.component).showPopupMenu(evt.getX(), evt.getY());
            return true;
        }
        return false;
    }

    public void mouseReleased(MouseEvent evt) {
        if (!this.showPopup(evt)) {
            super.mouseReleased(evt);
        }
    }

    class HighlightBraceLayer
    extends DrawLayer.AbstractLayer {
        public HighlightBraceLayer() {
            super(ExtCaret.HIGHLIGHT_BRACE_LAYER_NAME);
        }

        public void init(DrawContext ctx) {
        }

        public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
            if (ExtCaret.this.braceMarksValid) {
                if (mark != null) {
                    return mark.getActivateLayer();
                }
                try {
                    if (ctx.getStartOffset() > ExtCaret.this.highlightBraceEndMark.getOffset()) {
                        return ExtCaret.this.highlightBraceEndMark.getActivateLayer();
                    }
                    if (ctx.getStartOffset() > ExtCaret.this.highlightBraceStartMark.getOffset()) {
                        return ExtCaret.this.highlightBraceStartMark.getActivateLayer();
                    }
                }
                catch (InvalidMarkException invalidMarkException) {
                    // empty catch block
                }
            }
            return false;
        }

        public void updateContext(DrawContext ctx) {
            if (ExtCaret.this.highlightBraceColoring != null) {
                ExtCaret.this.highlightBraceColoring.apply(ctx);
            }
        }
    }
}

