/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.JavaDocPane;
import org.netbeans.editor.ext.JavaDocView;
import org.openide.util.NbBundle;

public class ScrollJavaDocPane
extends JPanel
implements JavaDocPane,
SettingsChangeListener {
    protected ExtEditorUI extEditorUI;
    private JComponent view;
    private CompletionJavaDoc cjd;
    protected JScrollPane scrollPane = new JScrollPane();
    Border lineBorder;

    public ScrollJavaDocPane(ExtEditorUI extEditorUI) {
        this.setLayout(null);
        this.extEditorUI = extEditorUI;
        this.cjd = extEditorUI.getCompletionJavaDoc();
        if (this.cjd != null) {
            JavaDocView javaDocView = this.cjd.getJavaDocView();
            if (javaDocView instanceof JComponent) {
                if (javaDocView instanceof JEditorPane) {
                    ((JEditorPane)((Object)javaDocView)).addHyperlinkListener(this.createHyperlinkAction());
                }
                this.view = (JComponent)((Object)javaDocView);
                this.scrollPane.setViewportView(this.view);
            }
            Settings.addSettingsChangeListener(this);
            this.setMinimumSize(new Dimension(100, 100));
            this.setMaximumSize(this.getMaxPopupSize());
        } else {
            this.setMinimumSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        super.setVisible(false);
        this.add(this.scrollPane);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BaseKit.class).getString("ACSD_JAVADOC_javaDocPane"));
        this.installTitleComponent();
        this.setBorder(new LineBorder(UIManager.getColor("controlDkShadow")));
    }

    protected HyperlinkAction createHyperlinkAction() {
        return new HyperlinkAction();
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.scrollPane.setBounds(r.x, 0, r.width + 1, r.height);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.cjd != null && !visible) {
            this.cjd.clearHistory();
        }
    }

    protected ImageIcon resolveIcon(String res) {
        ClassLoader loader = this.getClass().getClassLoader();
        URL resource = loader.getResource(res);
        if (resource == null) {
            resource = ClassLoader.getSystemResource(res);
        }
        return resource != null ? new ImageIcon(resource) : null;
    }

    protected void installTitleComponent() {
    }

    private Dimension getMaxPopupSize() {
        Class kitClass = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (kitClass != null) {
            return (Dimension)SettingsUtil.getValue(kitClass, "javadoc-preferred-size", ExtSettingsDefaults.defaultJavaDocAutoPopupDelay);
        }
        return ExtSettingsDefaults.defaultJavaDocPreferredSize;
    }

    public void settingsChange(SettingsChangeEvent evt) {
        if ("javadoc-preferred-size".equals(evt.getSettingName())) {
            this.setMaximumSize(this.getMaxPopupSize());
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void setForwardEnabled(boolean enable) {
    }

    public void setBackEnabled(boolean enable) {
    }

    public void setShowWebEnabled(boolean enable) {
    }

    public JComponent getJavadocDisplayComponent() {
        return this.scrollPane;
    }

    public class BrowserButton
    extends JButton {
        public BrowserButton() {
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }

        public BrowserButton(String text) {
            super(text);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }

        public BrowserButton(Icon icon) {
            super(icon);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }
    }

    protected class HyperlinkAction
    implements HyperlinkListener {
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e != null && HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && e.getDescription() != null) {
                Object obj = ScrollJavaDocPane.this.cjd.parseLink(e.getDescription(), null);
                if (obj != null) {
                    ScrollJavaDocPane.this.cjd.setContent(obj, false);
                    ScrollJavaDocPane.this.cjd.addToHistory(obj);
                } else {
                    obj = e.getURL() == null ? e.getDescription() : e.getURL();
                    ScrollJavaDocPane.this.cjd.setContent(obj, false);
                }
            }
        }
    }
}

