/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.codetemplates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.options.codetemplates.CodeTemplatesModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CodeTemplatesPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private CodeTemplatesModel model;
    private Lookup lookup;
    private int lastIndex = -1;
    private JButton bNew;
    private JButton bRemove;
    private JComboBox cbExpandTemplateOn;
    private JComboBox cbLanguage;
    private JEditorPane epExpandedText;
    private JLabel lExpandedText;
    private JLabel lExplandTemplateOn;
    private JLabel lLanguage;
    private JLabel lTemplates;
    private JScrollPane spExpandedText;
    private JScrollPane spTemplates;
    private JTable tTemplates;

    public CodeTemplatesPanel() {
        this.initComponents();
        CodeTemplatesPanel.loc(this.lLanguage, "Language");
        CodeTemplatesPanel.loc(this.lTemplates, "Templates");
        CodeTemplatesPanel.loc(this.bNew, "New");
        CodeTemplatesPanel.loc(this.bRemove, "Remove");
        this.cbExpandTemplateOn.addItem(CodeTemplatesPanel.loc("SPACE"));
        this.cbExpandTemplateOn.addItem(CodeTemplatesPanel.loc("S-SPACE"));
        this.cbExpandTemplateOn.addItem(CodeTemplatesPanel.loc("TAB"));
        this.cbExpandTemplateOn.addItem(CodeTemplatesPanel.loc("ENTER"));
        CodeTemplatesPanel.loc(this.lExpandedText, "Expanded_Text");
        CodeTemplatesPanel.loc(this.lExplandTemplateOn, "ExpandTemplateOn");
        this.bRemove.setEnabled(false);
        JLabel lExpander = new JLabel();
        this.tTemplates.getTableHeader().setReorderingAllowed(false);
        this.tTemplates.getSelectionModel().setSelectionMode(0);
        Font f = this.tTemplates.getFont();
        JLabel lbTemplates = new JLabel();
        lbTemplates.setLabelFor(this.tTemplates);
        JLabel lbExpandedText = new JLabel();
        lbExpandedText.setLabelFor(this.epExpandedText);
        this.tTemplates.getTableHeader().getColumnModel().getColumn(0).setHeaderValue(CodeTemplatesPanel.loc("Abbreviation_Title"));
        this.tTemplates.getTableHeader().getColumnModel().getColumn(1).setHeaderValue(CodeTemplatesPanel.loc("Expanded_Text_Title"));
    }

    private static String loc(String key) {
        return NbBundle.getMessage(CodeTemplatesPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext().setAccessibleName(CodeTemplatesPanel.loc("AN_" + key));
            c.getAccessibleContext().setAccessibleDescription(CodeTemplatesPanel.loc("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)CodeTemplatesPanel.loc("CTL_" + key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)CodeTemplatesPanel.loc("CTL_" + key));
        }
    }

    void update() {
        this.model = new CodeTemplatesModel();
        this.cbLanguage.removeActionListener(this);
        this.bNew.removeActionListener(this);
        this.bRemove.removeActionListener(this);
        this.cbExpandTemplateOn.removeActionListener(this);
        this.tTemplates.getSelectionModel().removeListSelectionListener(this);
        this.cbLanguage.removeAllItems();
        ArrayList languages = new ArrayList(this.model.getLanguages());
        Collections.sort(languages);
        Iterator it = languages.iterator();
        while (it.hasNext()) {
            this.cbLanguage.addItem(it.next());
        }
        KeyStroke expander = this.model.getExpander();
        if (KeyStroke.getKeyStroke(32, 1).equals(expander)) {
            this.cbExpandTemplateOn.setSelectedIndex(1);
        } else if (KeyStroke.getKeyStroke(9, 0).equals(expander)) {
            this.cbExpandTemplateOn.setSelectedIndex(2);
        } else if (KeyStroke.getKeyStroke(10, 0).equals(expander)) {
            this.cbExpandTemplateOn.setSelectedIndex(3);
        } else {
            this.cbExpandTemplateOn.setSelectedIndex(0);
        }
        this.cbLanguage.addActionListener(this);
        this.bNew.addActionListener(this);
        this.bRemove.addActionListener(this);
        this.cbExpandTemplateOn.addActionListener(this);
        this.tTemplates.getSelectionModel().addListSelectionListener(this);
        this.cbLanguage.setSelectedItem("Java");
    }

    void applyChanges() {
        if (this.model != null) {
            this.saveCurrentTemplate();
            this.model.saveChanges();
        }
    }

    void cancel() {
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        return this.model.isChanged();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cbLanguage) {
            this.saveCurrentTemplate();
            final String language = (String)this.cbLanguage.getSelectedItem();
            final DefaultTableModel tableModel = this.model.getTableModel(language);
            this.tTemplates.setModel(tableModel);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CodeTemplatesPanel.this.epExpandedText.setEditorKit(CloneableEditorSupport.getEditorKit((String)CodeTemplatesPanel.this.model.getMimeType(language)));
                    if (tableModel.getRowCount() > 0) {
                        CodeTemplatesPanel.this.lastIndex = -1;
                        CodeTemplatesPanel.this.tTemplates.getSelectionModel().setSelectionInterval(0, 0);
                        CodeTemplatesPanel.this.lastIndex = 0;
                    } else {
                        CodeTemplatesPanel.this.lastIndex = -1;
                    }
                }
            });
        } else if (e.getSource() == this.bNew) {
            this.saveCurrentTemplate();
            NotifyDescriptor.InputLine descriptor = new NotifyDescriptor.InputLine(CodeTemplatesPanel.loc("CTL_Enter_template_name"), CodeTemplatesPanel.loc("CTL_New_template_dialog_title"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.InputLine.OK_OPTION) {
                String templateName = descriptor.getInputText().trim();
                if (templateName.length() == 0) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CodeTemplatesPanel.loc("CTL_Empty_template_name"), 0));
                } else {
                    int i;
                    TableModel tableModel = this.tTemplates.getModel();
                    int k = tableModel.getRowCount();
                    for (i = 0; i < k; ++i) {
                        String name = (String)tableModel.getValueAt(i, 0);
                        if (!templateName.equals(name)) continue;
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CodeTemplatesPanel.loc("CTL_Duplicate_template_name"), 0));
                        break;
                    }
                    if (i == k) {
                        String language = (String)this.cbLanguage.getSelectedItem();
                        this.lastIndex = -1;
                        this.model.addRow(language, templateName, "");
                        this.tTemplates.getSelectionModel().setSelectionInterval(0, 0);
                        this.spTemplates.getVerticalScrollBar().setValue(0);
                    }
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CodeTemplatesPanel.this.epExpandedText.requestFocus();
                }
            });
        } else if (e.getSource() == this.bRemove) {
            String language = (String)this.cbLanguage.getSelectedItem();
            int index = this.tTemplates.getSelectedRow();
            this.model.removeRow(language, index);
            this.lastIndex = -1;
            if (index < this.tTemplates.getModel().getRowCount()) {
                this.tTemplates.getSelectionModel().setSelectionInterval(index, index);
            } else if (this.tTemplates.getModel().getRowCount() > 0) {
                this.tTemplates.getSelectionModel().setSelectionInterval(this.tTemplates.getModel().getRowCount() - 1, this.tTemplates.getModel().getRowCount() - 1);
            } else {
                this.bRemove.setEnabled(false);
            }
        } else if (e.getSource() == this.cbExpandTemplateOn) {
            switch (this.cbExpandTemplateOn.getSelectedIndex()) {
                case 0: {
                    this.model.setExpander(KeyStroke.getKeyStroke(32, 0));
                    break;
                }
                case 1: {
                    this.model.setExpander(KeyStroke.getKeyStroke(32, 1));
                    break;
                }
                case 2: {
                    this.model.setExpander(KeyStroke.getKeyStroke(9, 0));
                    break;
                }
                case 3: {
                    this.model.setExpander(KeyStroke.getKeyStroke(10, 0));
                }
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int index = this.tTemplates.getSelectedRow();
        if (index < 0) {
            this.epExpandedText.setText("");
            this.bRemove.setEnabled(false);
            this.lastIndex = -1;
            return;
        }
        this.saveCurrentTemplate();
        TableModel tableModel = this.tTemplates.getModel();
        this.bRemove.setEnabled(true);
        String text = (String)tableModel.getValueAt(index, 1);
        this.epExpandedText.setText(text);
        this.lastIndex = index;
    }

    void setLookup(Lookup lookup) {
        this.lookup = lookup;
    }

    void saveCurrentTemplate() {
        TableModel tableModel = this.tTemplates.getModel();
        if (this.lastIndex < 0) {
            return;
        }
        if (this.epExpandedText.getText().equals(tableModel.getValueAt(this.lastIndex, 1))) {
            return;
        }
        tableModel.setValueAt(this.epExpandedText.getText(), this.lastIndex, 1);
        this.firePropertyChange("changed", null, null);
    }

    private void initComponents() {
        this.lLanguage = new JLabel();
        this.cbLanguage = new JComboBox();
        this.lTemplates = new JLabel();
        this.spTemplates = new JScrollPane();
        this.tTemplates = new JTable();
        this.bNew = new JButton();
        this.bRemove = new JButton();
        this.lExpandedText = new JLabel();
        this.spExpandedText = new JScrollPane();
        this.epExpandedText = new JEditorPane();
        this.lExplandTemplateOn = new JLabel();
        this.cbExpandTemplateOn = new JComboBox();
        this.lLanguage.setLabelFor(this.cbLanguage);
        this.lLanguage.setText("Language:");
        this.lTemplates.setLabelFor(this.tTemplates);
        this.lTemplates.setText("Templates:");
        this.tTemplates.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Abbreviation", "Expanded Text"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.spTemplates.setViewportView(this.tTemplates);
        this.bNew.setText("New");
        this.bRemove.setText("Remove");
        this.lExpandedText.setLabelFor(this.epExpandedText);
        this.lExpandedText.setText("Expanded Text:");
        this.spExpandedText.setViewportView(this.epExpandedText);
        this.lExplandTemplateOn.setLabelFor(this.cbExpandTemplateOn);
        this.lExplandTemplateOn.setText("Expand Template on:");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lLanguage).addPreferredGap(0).add((Component)this.cbLanguage, -2, -1, -2)).add((Component)this.lTemplates).add((Component)this.lExpandedText).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lExplandTemplateOn).addPreferredGap(0).add((Component)this.cbExpandTemplateOn, -2, -1, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.spExpandedText, -1, 335, Short.MAX_VALUE).add((Component)this.spTemplates, -1, 335, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.bRemove, -1, -1, Short.MAX_VALUE).add((Component)this.bNew, -1, 122, Short.MAX_VALUE)).add(10, 10, 10))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lLanguage).add((Component)this.cbLanguage, -2, -1, -2)).addPreferredGap(0).add((Component)this.lTemplates).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bNew).addPreferredGap(0).add((Component)this.bRemove)).add((Component)this.spTemplates, -1, 132, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.lExpandedText).addPreferredGap(0).add((Component)this.spExpandedText, -1, 63, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lExplandTemplateOn).add((Component)this.cbExpandTemplateOn, -2, -1, -2))));
    }
}

