/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.generaleditor;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;

public class Model {
    boolean isShowCodeFolding() {
        return this.getFoldingParameter("code-folding-enable", true);
    }

    boolean isFoldImports() {
        return this.getFoldingParameter("code-folding-collapse-import", false);
    }

    boolean isFoldInitialComment() {
        return this.getFoldingParameter("code-folding-collapse-initial-comment", false);
    }

    boolean isFoldInnerClasses() {
        return this.getFoldingParameter("code-folding-collapse-innerclass", false);
    }

    boolean isFoldJavaDocComments() {
        return this.getFoldingParameter("code-folding-collapse-javadoc", false);
    }

    boolean isFoldMethods() {
        return this.getFoldingParameter("code-folding-collapse-method", false);
    }

    void setFoldingOptions(boolean showCodeFolding, boolean foldImports, boolean foldInitialComent, boolean foldInnerClasses, boolean foldJavaDoc, boolean foldMethods) {
        Set mimeTypes = EditorSettings.getDefault().getAllMimeTypes();
        for (String mimeType : mimeTypes) {
            BaseOptions baseOptions = Model.getOptions(mimeType);
            if (baseOptions == null) continue;
            Map m = baseOptions.getCodeFoldingProps();
            m.put("code-folding-enable", showCodeFolding);
            m.put("code-folding-collapse-import", foldImports);
            m.put("code-folding-collapse-initial-comment", foldInitialComent);
            m.put("code-folding-collapse-innerclass", foldInnerClasses);
            m.put("code-folding-collapse-javadoc", foldJavaDoc);
            m.put("code-folding-collapse-method", foldMethods);
            baseOptions.setCodeFoldingProps(m);
        }
    }

    boolean isPairCharacterCompletion() {
        return this.getParameter("getPairCharactersCompletion", true);
    }

    boolean isCompletionAutoPopup() {
        return this.getParameter("getCompletionAutoPopup", true);
    }

    boolean isShowDeprecatedMembers() {
        return this.getParameter("getShowDeprecatedMembers", true);
    }

    boolean isCompletionInstantSubstitution() {
        return this.getParameter("getCompletionInstantSubstitution", true);
    }

    boolean isCompletionCaseSensitive() {
        return this.getParameter("getCompletionCaseSensitive", true);
    }

    void setCompletionOptions(boolean pairCharacterCompletion, boolean completionAutoPopup, boolean showDeprecatedMembers, boolean completionInstantSubstitution, boolean completionCaseSensitive) {
        Set mimeTypes = EditorSettings.getDefault().getMimeTypes();
        for (String mimeType : mimeTypes) {
            Method method;
            BaseOptions baseOptions = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)mimeType)).lookup(BaseOptions.class);
            if (baseOptions == null) continue;
            try {
                method = baseOptions.getClass().getMethod("setPairCharactersCompletion", Boolean.TYPE);
                method.invoke((Object)baseOptions, pairCharacterCompletion);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                method = baseOptions.getClass().getMethod("setCompletionAutoPopup", Boolean.TYPE);
                method.invoke((Object)baseOptions, completionAutoPopup);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                method = baseOptions.getClass().getMethod("setShowDeprecatedMembers", Boolean.TYPE);
                method.invoke((Object)baseOptions, showDeprecatedMembers);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                method = baseOptions.getClass().getMethod("setCompletionInstantSubstitution", Boolean.TYPE);
                method.invoke((Object)baseOptions, completionInstantSubstitution);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                method = baseOptions.getClass().getMethod("setCompletionCaseSensitive", Boolean.TYPE);
                method.invoke((Object)baseOptions, completionCaseSensitive);
            }
            catch (Exception ex) {}
        }
    }

    private boolean getFoldingParameter(String parameterName, boolean defaultValue) {
        boolean successfullRead = false;
        Set mimeTypes = EditorSettings.getDefault().getAllMimeTypes();
        for (String mimeType : mimeTypes) {
            BaseOptions options = Model.getOptions(mimeType);
            if (options == null) continue;
            Map foldingParams = options.getCodeFoldingProps();
            Boolean value = (Boolean)foldingParams.get(parameterName);
            if (value != null && value.booleanValue()) {
                return true;
            }
            successfullRead = true;
        }
        return successfullRead ? false : defaultValue;
    }

    private boolean getParameter(String parameterName, boolean defaultValue) {
        boolean successfullRead = false;
        Set mimeTypes = EditorSettings.getDefault().getAllMimeTypes();
        for (String mimeType : mimeTypes) {
            BaseOptions options = Model.getOptions(mimeType);
            if (options == null) continue;
            try {
                Method method = options.getClass().getMethod(parameterName, new Class[0]);
                boolean value = (Boolean)method.invoke((Object)options, new Object[0]);
                if (value) {
                    return true;
                }
                successfullRead = true;
            }
            catch (Exception ex) {}
        }
        return successfullRead ? false : defaultValue;
    }

    private static BaseOptions getOptions(String mimeType) {
        return (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)mimeType)).lookup(BaseOptions.class);
    }
}

