/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.macros;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.options.macros.MacrosPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class MacrosModel {
    private ShortcutsFinder keymapModel;
    private Map macroNameToText;
    private DefaultTableModel tableModel;
    private boolean changed = false;

    MacrosModel(Lookup lookup) {
        this.keymapModel = (ShortcutsFinder)lookup.lookup(ShortcutsFinder.class);
        this.init();
    }

    private void init() {
        this.macroNameToText = new HashMap();
        Set mimeTypes = EditorSettings.getDefault().getMimeTypes();
        for (String mimeType : mimeTypes) {
            BaseOptions baseOptions = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)mimeType)).lookup(BaseOptions.class);
            if (baseOptions == null) continue;
            this.macroNameToText.putAll(baseOptions.getMacroMap());
        }
        this.macroNameToText.remove(null);
        Vector data = new Vector();
        for (String macroName : this.macroNameToText.keySet()) {
            String[] shortcuts;
            String shortcut = "";
            ShortcutAction action = this.keymapModel.findActionForId("macro-" + macroName);
            if (action == null) {
                action = this.keymapModel.findActionForId(macroName);
            }
            if (action != null && (shortcuts = this.keymapModel.getShortcuts(action)).length > 0) {
                shortcut = shortcuts[0];
            }
            Vector<String> line = new Vector<String>();
            line.add(macroName);
            line.add(shortcut);
            data.add(line);
        }
        Collections.sort(data, new MComparator());
        Vector<String> columns = new Vector<String>(2);
        columns.add(MacrosModel.loc("Macro_Name_Title"));
        columns.add(MacrosModel.loc("Macro_Code_Title"));
        this.tableModel = new DefaultTableModel(data, columns){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tableModel.getColumnName(2);
    }

    DefaultTableModel getShortcutsTableModel() {
        return this.tableModel;
    }

    boolean isChanged() {
        return this.changed;
    }

    Collection getMacroNames() {
        return Collections.unmodifiableCollection(this.macroNameToText.keySet());
    }

    String getMacroText(String macroName) {
        return (String)this.macroNameToText.get(macroName);
    }

    void addMacro(String macroName, String text) {
        this.tableModel.insertRow(0, new Object[]{macroName, text});
        this.macroNameToText.put(macroName, text);
    }

    void removeMacro(int index) {
        String macroName = (String)this.tableModel.getValueAt(index, 0);
        this.macroNameToText.remove(macroName);
        this.tableModel.removeRow(index);
        this.keymapModel.refreshActions();
        ShortcutAction actionImpl = this.keymapModel.findActionForId("macro-" + macroName);
        if (actionImpl != null) {
            this.keymapModel.setShortcuts(actionImpl, Collections.emptySet());
        }
        this.changed = true;
    }

    void setMacroText(String macroName, String text) {
        if (this.macroNameToText.containsKey(macroName) && text.equals(this.macroNameToText.get(macroName))) {
            return;
        }
        this.macroNameToText.put(macroName, text);
        this.changed = true;
    }

    void setShortcut(int index, String shortcut) {
        this.tableModel.setValueAt(shortcut, index, 1);
        this.saveMacros();
        ShortcutAction shortcutAction = this.keymapModel.findActionForId("macro-" + this.tableModel.getValueAt(index, 0));
        this.keymapModel.setShortcuts(shortcutAction, Collections.singleton(shortcut));
        this.changed = true;
    }

    void applyChanges() {
        this.saveMacros();
        this.keymapModel.apply();
        this.changed = false;
    }

    void cancel() {
        this.init();
        this.changed = false;
    }

    private static String loc(String key) {
        return NbBundle.getMessage(MacrosPanel.class, (String)key);
    }

    private void saveMacros() {
        Set mimeTypes = EditorSettings.getDefault().getMimeTypes();
        for (String mimeType : mimeTypes) {
            BaseOptions baseOptions = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)mimeType)).lookup(BaseOptions.class);
            if (baseOptions == null) continue;
            baseOptions.setMacroMap(new HashMap(this.macroNameToText));
        }
    }

    private static class MComparator
    implements Comparator {
        private MComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)((Vector)o1).get(0);
            String s2 = (String)((Vector)o2).get(0);
            return s1.compareTo(s2);
        }
    }
}

