/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.mimelookup;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.editor.mimelookup.MimePathLookup;

public final class MimePath {
    public static final MimePath EMPTY = new MimePath();
    private static final Object LOCK = new Object();
    private static final ArrayList<MimePath> LRU = new ArrayList();
    static final int MAX_LRU_SIZE = 3;
    private static final String REG_NAME = "[[\\p{Alnum}][!#$&.+\\-^_]]{1,127}";
    private static final Pattern MIME_TYPE_PATTERN = Pattern.compile("^[[\\p{Alnum}][!#$&.+\\-^_]]{1,127}/{1}[[\\p{Alnum}][!#$&.+\\-^_]]{1,127}$");
    private final MimePath[] mimePaths;
    private final String path;
    private final String mimeType;
    private Map<String, SoftReference<MimePath>> mimeType2mimePathRef;
    private MimePathLookup lookup;
    private final String LOOKUP_LOCK = new String("MimePath.LOOKUP_LOCK");

    public static MimePath get(String mimeType) {
        if (mimeType == null || mimeType.length() == 0) {
            return EMPTY;
        }
        return MimePath.get(EMPTY, mimeType);
    }

    public static MimePath get(MimePath prefix, String mimeType) {
        return prefix.getEmbedded(mimeType);
    }

    public static MimePath parse(String path) {
        return MimePath.parseImpl(path);
    }

    private MimePath(MimePath prefix, String mimeType) {
        int prefixSize = prefix.size();
        this.mimePaths = new MimePath[prefixSize + 1];
        System.arraycopy(prefix.mimePaths, 0, this.mimePaths, 0, prefixSize);
        this.mimePaths[prefixSize] = this;
        String prefixPath = prefix.path;
        this.path = prefixPath != null && prefixPath.length() > 0 ? (prefixPath + '/' + mimeType).intern() : mimeType.intern();
        this.mimeType = mimeType;
    }

    private MimePath() {
        this.mimePaths = new MimePath[0];
        this.path = "";
        this.mimeType = "";
    }

    public String getPath() {
        return this.path;
    }

    public int size() {
        return this.mimePaths.length;
    }

    public String getMimeType(int index) {
        return this.mimePaths[index].mimeType;
    }

    public MimePath getPrefix(int size) {
        return size == 0 ? EMPTY : this.mimePaths[size - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimePath getEmbedded(String mimeType) {
        Object object = LOCK;
        synchronized (object) {
            MimePath mimePath;
            Reference mpRef;
            if (this.mimeType2mimePathRef == null) {
                this.mimeType2mimePathRef = new HashMap<String, SoftReference<MimePath>>();
            }
            if ((mpRef = (Reference)this.mimeType2mimePathRef.get(mimeType)) == null || (mimePath = (MimePath)mpRef.get()) == null) {
                Matcher m = MIME_TYPE_PATTERN.matcher(mimeType);
                if (!m.matches()) {
                    throw new IllegalArgumentException("Invalid mimeType=\"" + mimeType + "\"");
                }
                mimePath = new MimePath(this, mimeType);
                this.mimeType2mimePathRef.put(mimeType, new SoftReference<MimePath>(mimePath));
                LRU.add(0, mimePath);
                if (LRU.size() > 3) {
                    LRU.remove(LRU.size() - 1);
                }
            }
            return mimePath;
        }
    }

    private static MimePath parseImpl(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        MimePath mimePath = EMPTY;
        int pathLen = path.length();
        int startIndex = 0;
        while (true) {
            int index;
            int slashIndex = -1;
            for (index = startIndex; index < pathLen; ++index) {
                if (path.charAt(index) != '/') continue;
                slashIndex = index;
                break;
            }
            if (slashIndex == -1) {
                if (index == startIndex) break;
                throw new IllegalArgumentException("mimeType '" + path.substring(startIndex) + "' does not contain '/'.");
            }
            ++index;
            while (index < pathLen) {
                if (path.charAt(index) == '/') {
                    if (index != slashIndex + 1) break;
                    throw new IllegalArgumentException("Two successive slashes in '" + path.substring(startIndex) + "'");
                }
                ++index;
            }
            if (index == slashIndex + 1) {
                throw new IllegalArgumentException("Empty string after '/' in '" + path.substring(startIndex) + "'");
            }
            String mimeType = path.substring(startIndex, index);
            mimePath = MimePath.get(mimePath, mimeType);
            startIndex = index + 1;
        }
        return mimePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MimePathLookup getLookup() {
        String string = this.LOOKUP_LOCK;
        synchronized (string) {
            if (this.lookup == null) {
                this.lookup = new MimePathLookup(this);
            }
            return this.lookup;
        }
    }
}

