/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup;

import java.util.ArrayList;
import java.util.EventListener;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.spi.editor.mimelookup.MimeDataProvider;
import org.netbeans.spi.editor.mimelookup.MimeLookupInitializer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;

public final class MimePathLookup
extends ProxyLookup
implements LookupListener {
    private MimePath mimePath;
    private Lookup.Result<MimeDataProvider> dataProviders;
    private Lookup.Result<MimeLookupInitializer> mimeInitializers;

    public MimePathLookup(MimePath mimePath) {
        if (mimePath == null) {
            throw new NullPointerException("Mime path can't be null.");
        }
        this.mimePath = mimePath;
        this.dataProviders = Lookup.getDefault().lookup(new Lookup.Template(MimeDataProvider.class));
        this.dataProviders.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.dataProviders));
        this.mimeInitializers = Lookup.getDefault().lookup(new Lookup.Template(MimeLookupInitializer.class));
        this.mimeInitializers.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.mimeInitializers));
        this.rebuild();
    }

    public MimePath getMimePath() {
        return this.mimePath;
    }

    private void rebuild() {
        ArrayList<Lookup> lookups = new ArrayList<Lookup>();
        for (MimeDataProvider provider : this.dataProviders.allInstances()) {
            Lookup mimePathLookup = provider.getLookup(this.mimePath);
            if (mimePathLookup == null) continue;
            lookups.add(mimePathLookup);
        }
        for (MimeLookupInitializer initializer : this.mimeInitializers.allInstances()) {
            for (int j = 0; j < this.mimePath.size(); ++j) {
                Lookup.Result children = initializer.child(this.mimePath.getMimeType(j));
                for (MimeLookupInitializer mli : children.allInstances()) {
                    Lookup mimePathLookup = mli.lookup();
                    if (mimePathLookup == null) continue;
                    lookups.add(mimePathLookup);
                }
            }
        }
        this.setLookups(lookups.toArray(new Lookup[lookups.size()]));
    }

    public void resultChanged(LookupEvent ev) {
        this.rebuild();
    }
}

