/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.ui.FmtOptions;

public final class CodeStyle {
    private static CodeStyle INSTANCE;
    private Preferences preferences;

    private CodeStyle(Preferences preferences) {
        this.preferences = preferences;
    }

    public static synchronized CodeStyle getDefault(Project project) {
        if (FmtOptions.codeStyleProducer == null) {
            FmtOptions.codeStyleProducer = new Producer();
        }
        if (INSTANCE == null) {
            INSTANCE = CodeStyle.create();
        }
        return INSTANCE;
    }

    static CodeStyle create() {
        return new CodeStyle(FmtOptions.getPreferences(FmtOptions.getCurrentProfileId()));
    }

    public boolean expandTabToSpaces() {
        return this.preferences.getBoolean("expandTabToSpaces", true);
    }

    public int getTabSize() {
        return this.preferences.getInt("tabSize", 4);
    }

    public int getIndentSize() {
        return this.preferences.getInt("indentSize", 4);
    }

    public int getContinuationIndentSize() {
        return this.preferences.getInt("continuationIndentSize", 8);
    }

    public int getLabelIndent() {
        return this.preferences.getInt("labelIndent", 0);
    }

    public boolean absoluteLabelIndent() {
        return this.preferences.getBoolean("absoluteLabelIndent", false);
    }

    public boolean indentTopLevelClassMembers() {
        return this.preferences.getBoolean("indentTopLevelClassMembers", true);
    }

    public boolean indentCasesFromSwitch() {
        return this.preferences.getBoolean("indentCasesFromSwitch", true);
    }

    public int getRightMargin() {
        return this.preferences.getInt("rightMargin", 120);
    }

    public boolean preferLongerNames() {
        return this.preferences.getBoolean("preferLongerNames", true);
    }

    public String getFieldNamePrefix() {
        return this.preferences.get("fieldNamePrefix", null);
    }

    public String getFieldNameSuffix() {
        return this.preferences.get("fieldNameSuffix", null);
    }

    public String getStaticFieldNamePrefix() {
        return this.preferences.get("staticFieldNamePrefix", null);
    }

    public String getStaticFieldNameSuffix() {
        return this.preferences.get("staticFieldNameSuffix", null);
    }

    public String getParameterNamePrefix() {
        return this.preferences.get("parameterNamePrefix", null);
    }

    public String getParameterNameSuffix() {
        return this.preferences.get("parameterNameSuffix", null);
    }

    public String getLocalVarNamePrefix() {
        return this.preferences.get("localVarNamePrefix", null);
    }

    public String getLocalVarNameSuffix() {
        return this.preferences.get("localVarNameSuffix", null);
    }

    public boolean qualifyFieldAccess() {
        return this.preferences.getBoolean("qualifyFieldAccess", false);
    }

    public boolean useIsForBooleanGetters() {
        return this.preferences.getBoolean("useIsForBooleanGetters", true);
    }

    public boolean addOverrideAnnotation() {
        return this.preferences.getBoolean("addOverrideAnnotation", true);
    }

    public boolean makeLocalVarsFinal() {
        return this.preferences.getBoolean("makeLocalVarsFinal", false);
    }

    public boolean makeParametersFinal() {
        return this.preferences.getBoolean("makeParametersFinal", false);
    }

    public BracePlacement getClassDeclBracePlacement() {
        String placement = this.preferences.get("classDeclBracePlacement", null);
        return placement != null ? BracePlacement.valueOf(placement) : BracePlacement.SAME_LINE;
    }

    public BracePlacement getMethodDeclBracePlacement() {
        String placement = this.preferences.get("methodDeclBracePlacement", null);
        return placement != null ? BracePlacement.valueOf(placement) : BracePlacement.SAME_LINE;
    }

    public BracePlacement getOtherBracePlacement() {
        String placement = this.preferences.get("otherBracePlacement", null);
        return placement != null ? BracePlacement.valueOf(placement) : BracePlacement.SAME_LINE;
    }

    public boolean specialElseIf() {
        return this.preferences.getBoolean("specialElseIf", true);
    }

    public BracesGenerationStyle redundantIfBraces() {
        String redundant = this.preferences.get("redundantIfBraces", null);
        return redundant != null ? BracesGenerationStyle.valueOf(redundant) : BracesGenerationStyle.GENERATE;
    }

    public BracesGenerationStyle redundantForBraces() {
        String redundant = this.preferences.get("redundantForBraces", null);
        return redundant != null ? BracesGenerationStyle.valueOf(redundant) : BracesGenerationStyle.GENERATE;
    }

    public BracesGenerationStyle redundantWhileBraces() {
        String redundant = this.preferences.get("redundantWhileBraces", null);
        return redundant != null ? BracesGenerationStyle.valueOf(redundant) : BracesGenerationStyle.GENERATE;
    }

    public BracesGenerationStyle redundantDoWhileBraces() {
        String redundant = this.preferences.get("redundantDoWhileBraces", null);
        return redundant != null ? BracesGenerationStyle.valueOf(redundant) : BracesGenerationStyle.GENERATE;
    }

    public boolean alignMultilineMethodParams() {
        return this.preferences.getBoolean("alignMultilineMethodParams", false);
    }

    public boolean alignMultilineCallArgs() {
        return this.preferences.getBoolean("alignMultilineCallArgs", false);
    }

    public boolean alignMultilineImplements() {
        return this.preferences.getBoolean("alignMultilineImplements", false);
    }

    public boolean alignMultilineThrows() {
        return this.preferences.getBoolean("alignMultilineThrows", false);
    }

    public boolean alignMultilineParenthesized() {
        return this.preferences.getBoolean("alignMultilineParenthesized", false);
    }

    public boolean alignMultilineBinaryOp() {
        return this.preferences.getBoolean("alignMultilineBinaryOp", false);
    }

    public boolean alignMultilineTernaryOp() {
        return this.preferences.getBoolean("alignMultilineTernaryOp", false);
    }

    public boolean alignMultilineAssignment() {
        return this.preferences.getBoolean("alignMultilineAssignment", false);
    }

    public boolean alignMultilineFor() {
        return this.preferences.getBoolean("alignMultilineFor", false);
    }

    public boolean alignMultilineArrayInit() {
        return this.preferences.getBoolean("alignMultilineArrayInit", false);
    }

    public boolean placeElseOnNewLine() {
        return this.preferences.getBoolean("placeElseOnNewLine", false);
    }

    public boolean placeWhileOnNewLine() {
        return this.preferences.getBoolean("placeWhileOnNewLine", false);
    }

    public boolean placeCatchOnNewLine() {
        return this.preferences.getBoolean("placeCatchOnNewLine", false);
    }

    public boolean placeFinallyOnNewLine() {
        return this.preferences.getBoolean("placeFinallyOnNewLine", false);
    }

    public boolean placeNewLineAfterModifiers() {
        return this.preferences.getBoolean("placeNewLineAfterModifiers", false);
    }

    public WrapStyle wrapExtendsImplementsKeyword() {
        String wrap = this.preferences.get("wrapExtendsImplementsKeyword", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_NEVER;
    }

    public WrapStyle wrapExtendsImplementsList() {
        String wrap = this.preferences.get("wrapExtendsImplementsList", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_NEVER;
    }

    public WrapStyle wrapMethodParams() {
        String wrap = this.preferences.get("wrapMethodParams", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_NEVER;
    }

    public WrapStyle wrapThrowsKeyword() {
        String wrap = this.preferences.get("wrapThrowsKeyword", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_NEVER;
    }

    public WrapStyle wrapThrowsList() {
        String wrap = this.preferences.get("wrapThrowsList", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_NEVER;
    }

    public WrapStyle wrapMethodCallArgs() {
        String wrap = this.preferences.get("wrapMethodCallArgs", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_NEVER;
    }

    public WrapStyle wrapChainedMethodCalls() {
        String wrap = this.preferences.get("wrapChainedMethodCalls", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_NEVER;
    }

    public WrapStyle wrapArrayInit() {
        String wrap = this.preferences.get("wrapArrayInit", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_NEVER;
    }

    public WrapStyle wrapFor() {
        String wrap = this.preferences.get("wrapFor", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_NEVER;
    }

    public WrapStyle wrapForStatement() {
        String wrap = this.preferences.get("wrapForStatement", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_ALWAYS;
    }

    public WrapStyle wrapIfStatement() {
        String wrap = this.preferences.get("wrapIfStatement", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_ALWAYS;
    }

    public WrapStyle wrapWhileStatement() {
        String wrap = this.preferences.get("wrapWhileStatement", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_ALWAYS;
    }

    public WrapStyle wrapDoWhileStatement() {
        String wrap = this.preferences.get("wrapDoWhileStatement", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_ALWAYS;
    }

    public WrapStyle wrapAssert() {
        String wrap = this.preferences.get("wrapAssert", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_NEVER;
    }

    public WrapStyle wrapEnumConstants() {
        String wrap = this.preferences.get("wrapEnumConstants", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_NEVER;
    }

    public WrapStyle wrapAnnotations() {
        String wrap = this.preferences.get("wrapAnnotations", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_ALWAYS;
    }

    public WrapStyle wrapBinaryOps() {
        String wrap = this.preferences.get("wrapBinaryOps", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_NEVER;
    }

    public WrapStyle wrapTernaryOps() {
        String wrap = this.preferences.get("wrapTernaryOps", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_NEVER;
    }

    public WrapStyle wrapAssignOps() {
        String wrap = this.preferences.get("wrapAssignOps", null);
        return wrap != null ? WrapStyle.valueOf(wrap) : WrapStyle.WRAP_NEVER;
    }

    public int getBlankLinesBeforePackage() {
        return this.preferences.getInt("blankLinesBeforePackage", 0);
    }

    public int getBlankLinesAfterPackage() {
        return this.preferences.getInt("blankLinesAfterPackage", 1);
    }

    public int getBlankLinesBeforeImports() {
        return this.preferences.getInt("blankLinesBeforeImports", 1);
    }

    public int getBlankLinesAfterImports() {
        return this.preferences.getInt("blankLinesAfterImports", 1);
    }

    public int getBlankLinesBeforeClass() {
        return this.preferences.getInt("blankLinesBeforeClass", 1);
    }

    public int getBlankLinesAfterClass() {
        return this.preferences.getInt("blankLinesAfterClass", 0);
    }

    public int getBlankLinesAfterClassHeader() {
        return this.preferences.getInt("blankLinesAfterClassHeader", 1);
    }

    public int getBlankLinesBeforeFields() {
        return this.preferences.getInt("blankLinesBeforeFields", 0);
    }

    public int getBlankLinesAfterFields() {
        return this.preferences.getInt("blankLinesAfterFields", 0);
    }

    public int getBlankLinesBeforeMethods() {
        return this.preferences.getInt("blankLinesBeforeMethods", 1);
    }

    public int getBlankLinesAfterMethods() {
        return this.preferences.getInt("blankLinesAfterMethods", 0);
    }

    public boolean spaceBeforeWhile() {
        return this.preferences.getBoolean("spaceBeforeWhile", true);
    }

    public boolean spaceBeforeElse() {
        return this.preferences.getBoolean("spaceBeforeElse", true);
    }

    public boolean spaceBeforeCatch() {
        return this.preferences.getBoolean("spaceBeforeCatch", true);
    }

    public boolean spaceBeforeFinally() {
        return this.preferences.getBoolean("spaceBeforeFinally", true);
    }

    public boolean spaceBeforeMethodDeclParen() {
        return this.preferences.getBoolean("spaceBeforeMethodDeclParen", false);
    }

    public boolean spaceBeforeMethodCallParen() {
        return this.preferences.getBoolean("spaceBeforeMethodCallParen", false);
    }

    public boolean spaceBeforeIfParen() {
        return this.preferences.getBoolean("spaceBeforeIfParen", true);
    }

    public boolean spaceBeforeForParen() {
        return this.preferences.getBoolean("spaceBeforeForParen", true);
    }

    public boolean spaceBeforeWhileParen() {
        return this.preferences.getBoolean("spaceBeforeWhileParen", true);
    }

    public boolean spaceBeforeCatchParen() {
        return this.preferences.getBoolean("spaceBeforeCatchParen", true);
    }

    public boolean spaceBeforeSwitchParen() {
        return this.preferences.getBoolean("spaceBeforeSwitchParen", true);
    }

    public boolean spaceBeforeSynchronizedParen() {
        return this.preferences.getBoolean("spaceBeforeSynchronizedParen", true);
    }

    public boolean spaceBeforeAnnotationParen() {
        return this.preferences.getBoolean("spaceBeforeAnnotationParen", false);
    }

    public boolean spaceAroundUnaryOps() {
        return this.preferences.getBoolean("spaceAroundUnaryOps", false);
    }

    public boolean spaceAroundBinaryOps() {
        return this.preferences.getBoolean("spaceAroundBinaryOps", true);
    }

    public boolean spaceAroundTernaryOps() {
        return this.preferences.getBoolean("spaceAroundTernaryOps", true);
    }

    public boolean spaceAroundAssignOps() {
        return this.preferences.getBoolean("spaceAroundAssignOps", true);
    }

    public boolean spaceBeforeClassDeclLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeClassDeclLeftBrace", true);
    }

    public boolean spaceBeforeMethodDeclLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeMethodDeclLeftBrace", true);
    }

    public boolean spaceBeforeIfLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeIfLeftBrace", true);
    }

    public boolean spaceBeforeElseLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeElseLeftBrace", true);
    }

    public boolean spaceBeforeWhileLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeWhileLeftBrace", true);
    }

    public boolean spaceBeforeForLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeForLeftBrace", true);
    }

    public boolean spaceBeforeDoLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeDoLeftBrace", true);
    }

    public boolean spaceBeforeSwitchLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeSwitchLeftBrace", true);
    }

    public boolean spaceBeforeTryLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeTryLeftBrace", true);
    }

    public boolean spaceBeforeCatchLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeCatchLeftBrace", true);
    }

    public boolean spaceBeforeFinallyLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeFinallyLeftBrace", true);
    }

    public boolean spaceBeforeSynchronizedLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeSynchronizedLeftBrace", true);
    }

    public boolean spaceBeforeStaticInitLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeStaticInitLeftBrace", true);
    }

    public boolean spaceBeforeArrayInitLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeArrayInitLeftBrace", true);
    }

    public boolean spaceWithinParens() {
        return this.preferences.getBoolean("spaceWithinParens", false);
    }

    public boolean spaceWithinMethodDeclParens() {
        return this.preferences.getBoolean("spaceWithinMethodDeclParens", false);
    }

    public boolean spaceWithinMethodCallParens() {
        return this.preferences.getBoolean("spaceWithinMethodCallParens", false);
    }

    public boolean spaceWithinIfParens() {
        return this.preferences.getBoolean("spaceWithinIfParens", false);
    }

    public boolean spaceWithinForParens() {
        return this.preferences.getBoolean("spaceWithinForParens", false);
    }

    public boolean spaceWithinWhileParens() {
        return this.preferences.getBoolean("spaceWithinWhileParens", false);
    }

    public boolean spaceWithinSwitchParens() {
        return this.preferences.getBoolean("spaceWithinSwitchParens", false);
    }

    public boolean spaceWithinCatchParens() {
        return this.preferences.getBoolean("spaceWithinCatchParens", false);
    }

    public boolean spaceWithinSynchronizedParens() {
        return this.preferences.getBoolean("spaceWithinSynchronizedParens", false);
    }

    public boolean spaceWithinTypeCastParens() {
        return this.preferences.getBoolean("spaceWithinTypeCastParens", false);
    }

    public boolean spaceWithinAnnotationParens() {
        return this.preferences.getBoolean("spaceWithinAnnotationParens", false);
    }

    public boolean spaceWithinBraces() {
        return this.preferences.getBoolean("spaceWithinBraces", false);
    }

    public boolean spaceWithinArrayInitBrackets() {
        return this.preferences.getBoolean("spaceWithinArrayInitBrackets", false);
    }

    public boolean spaceBeforeComma() {
        return this.preferences.getBoolean("spaceBeforeComma", false);
    }

    public boolean spaceAfterComma() {
        return this.preferences.getBoolean("spaceAfterComma", true);
    }

    public boolean spaceBeforeSemi() {
        return this.preferences.getBoolean("spaceBeforeSemi", false);
    }

    public boolean spaceAfterSemi() {
        return this.preferences.getBoolean("spaceAfterSemi", true);
    }

    public boolean spaceBeforeColon() {
        return this.preferences.getBoolean("spaceBeforeColon", true);
    }

    public boolean spaceAfterColon() {
        return this.preferences.getBoolean("spaceAfterColon", true);
    }

    public boolean spaceAfterTypeCast() {
        return this.preferences.getBoolean("spaceAfterTypeCast", true);
    }

    public boolean useSingleClassImport() {
        return this.preferences.getBoolean("useSingleClassImport", true);
    }

    public boolean useFQNs() {
        return this.preferences.getBoolean("useFQNs", false);
    }

    public int countForUsingStarImport() {
        return this.preferences.getInt("countForUsingStarImport", 5);
    }

    public int countForUsingStaticStarImport() {
        return this.preferences.getInt("countForUsingStaticStarImport", 3);
    }

    public String[] getPackagesForStarImport() {
        return null;
    }

    static {
        FmtOptions.codeStyleProducer = new Producer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BracePlacement {
        SAME_LINE,
        NEW_LINE,
        NEW_LINE_HALF_INDENTED,
        NEW_LINE_INDENTED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BracesGenerationStyle {
        GENERATE,
        LEAVE_ALONE,
        ELIMINATE;

    }

    private static class Producer
    implements FmtOptions.CodeStyleProducer {
        private Producer() {
        }

        public CodeStyle create(Preferences preferences) {
            return new CodeStyle(preferences);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WrapStyle {
        WRAP_ALWAYS,
        WRAP_IF_LONG,
        WRAP_NEVER;

    }
}

