/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;

public final class TreePathHandle {
    private PositionRef position;
    private KindPath kindPath;
    private FileObject file;
    private ElementHandle enclosingElement;
    private boolean enclElIsCorrespondingEl;

    public FileObject getFileObject() {
        return this.file;
    }

    public TreePath resolve(CompilationInfo compilationInfo) throws IllegalArgumentException {
        assert (compilationInfo != null);
        if (!compilationInfo.getFileObject().equals(this.getFileObject())) {
            throw new IllegalArgumentException("TreePathHandle [" + FileUtil.getFileDisplayName((FileObject)this.getFileObject()) + "] was not created from " + FileUtil.getFileDisplayName((FileObject)compilationInfo.getFileObject()));
        }
        Object element = this.enclosingElement.resolve(compilationInfo);
        TreePath tp = null;
        if (element != null) {
            TreePath startPath = compilationInfo.getTrees().getPath((Element)element);
            if (startPath == null) {
                Logger.getLogger(TreePathHandle.class.getName()).fine("compilationInfo.getTrees().getPath(element) returned null for element %s " + element + "(" + this.file.getPath() + ")");
            } else {
                tp = compilationInfo.getTreeUtilities().pathFor(startPath, this.position.getOffset() + 1);
            }
        }
        if (tp != null && new KindPath(tp).equals(this.kindPath)) {
            return tp;
        }
        tp = compilationInfo.getTreeUtilities().pathFor(this.position.getOffset() + 1);
        if (new KindPath(tp).equals(this.kindPath)) {
            return tp;
        }
        return null;
    }

    public Element resolveElement(CompilationInfo info) {
        TreePath tp = null;
        IllegalStateException ise = null;
        try {
            if (info.getFileObject().equals(this.file)) {
                tp = this.resolve(info);
            }
        }
        catch (IllegalStateException i) {
            ise = i;
        }
        if (tp == null) {
            if (this.enclElIsCorrespondingEl) {
                return this.enclosingElement.resolve(info);
            }
            if (ise == null) {
                return null;
            }
            throw ise;
        }
        Element el = info.getTrees().getElement(tp);
        if (el == null) {
            Logger.getLogger(TreePathHandle.class.toString()).fine("info.getTrees().getElement(tp) returned null for " + tp);
            if (this.enclElIsCorrespondingEl) {
                return this.enclosingElement.resolve(info);
            }
            return null;
        }
        return el;
    }

    public Tree.Kind getKind() {
        return (Tree.Kind)((Object)this.kindPath.kindPath.get(0));
    }

    private TreePathHandle(PositionRef position, KindPath kindPath, FileObject file, ElementHandle element, boolean enclElIsCorrespondingEl) {
        this.kindPath = kindPath;
        this.position = position;
        this.file = file;
        this.enclosingElement = element;
        this.enclElIsCorrespondingEl = enclElIsCorrespondingEl;
    }

    public static TreePathHandle create(TreePath treePath, CompilationInfo info) throws IllegalArgumentException {
        Element element;
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)treePath.getCompilationUnit().getSourceFile().toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        int position = ((JCTree)treePath.getLeaf()).pos;
        CloneableEditorSupport s = TreePathHandle.findCloneableEditorSupport(file);
        PositionRef pos = s.createPositionRef(position, Position.Bias.Forward);
        TreePath current = treePath;
        boolean enclElIsCorrespondingEl = true;
        do {
            element = info.getTrees().getElement(current);
            current = current.getParentPath();
            if (element == null || TreePathHandle.isSupported(element)) continue;
            enclElIsCorrespondingEl = false;
        } while ((element == null || !TreePathHandle.isSupported(element)) && current != null);
        return new TreePathHandle(pos, new KindPath(treePath), file, ElementHandle.create(element), enclElIsCorrespondingEl);
    }

    private static boolean isSupported(Element el) {
        switch (el.getKind()) {
            case PACKAGE: 
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case METHOD: 
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case STATIC_INIT: 
            case FIELD: 
            case ANNOTATION_TYPE: 
            case ENUM_CONSTANT: {
                return true;
            }
        }
        return false;
    }

    private static CloneableEditorSupport findCloneableEditorSupport(FileObject file) {
        try {
            DataObject dob = DataObject.find((FileObject)file);
            Node.Cookie obj = dob.getCookie(OpenCookie.class);
            if (obj instanceof CloneableEditorSupport) {
                return (CloneableEditorSupport)obj;
            }
            obj = dob.getCookie(EditorCookie.class);
            if (obj instanceof CloneableEditorSupport) {
                return (CloneableEditorSupport)obj;
            }
        }
        catch (DataObjectNotFoundException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static class KindPath {
        private ArrayList<Tree.Kind> kindPath = new ArrayList();

        private KindPath(TreePath treePath) {
            while (treePath != null) {
                this.kindPath.add(treePath.getLeaf().getKind());
                treePath = treePath.getParentPath();
            }
        }

        public int hashCode() {
            return this.kindPath.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof KindPath) {
                return this.kindPath.equals(((KindPath)object).kindPath);
            }
            return false;
        }
    }
}

