/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeUtilities {
    private CompilationInfo info;
    private CommentHandler handler;

    TreeUtilities(CompilationInfo info) {
        this.info = info;
        this.handler = CommentHandlerService.instance(info.getJavacTask().getContext());
    }

    public boolean isInterface(ClassTree tree) {
        return (((JCTree.JCModifiers)tree.getModifiers()).flags & 0x200L) != 0L;
    }

    public boolean isEnum(ClassTree tree) {
        return (((JCTree.JCModifiers)tree.getModifiers()).flags & 0x4000L) != 0L;
    }

    public boolean isAnnotation(ClassTree tree) {
        return (((JCTree.JCModifiers)tree.getModifiers()).flags & 0x2000L) != 0L;
    }

    public boolean isSynthetic(TreePath path) throws NullPointerException {
        IdentifierTree it;
        MethodInvocationTree mit;
        ExpressionStatementTree est;
        Tree leaf = path.getLeaf();
        JCTree tree = (JCTree)leaf;
        if (tree.pos == -1) {
            return true;
        }
        if (leaf.getKind() == Tree.Kind.METHOD) {
            return (((JCTree.JCMethodDecl)path.getLeaf()).mods.flags & 0x1000000000L) != 0L;
        }
        if (leaf.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (est = (ExpressionStatementTree)leaf).getExpression().getKind() == Tree.Kind.METHOD_INVOCATION && (mit = (MethodInvocationTree)est.getExpression()).getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && "super".equals((it = (IdentifierTree)mit.getMethodSelect()).getName().toString())) {
            SourcePositions sp = this.info.getTrees().getSourcePositions();
            return sp.getEndPosition(path.getCompilationUnit(), leaf) == -1L;
        }
        return false;
    }

    public List<Comment> getComments(Tree tree, boolean preceding) {
        CommentSet set = this.handler.getComments(tree);
        if (set == null) {
            return Collections.emptyList();
        }
        List<Comment> comments = preceding ? set.getPrecedingComments() : set.getTrailingComments();
        return Collections.unmodifiableList(comments);
    }

    public TreePath pathFor(int pos) {
        return this.pathFor(new TreePath(this.info.getCompilationUnit()), pos);
    }

    public TreePath pathFor(TreePath path, int pos) {
        return this.pathFor(path, pos, this.info.getTrees().getSourcePositions());
    }

    public TreePath pathFor(TreePath path, int pos, SourcePositions sourcePositions) {
        class Result
        extends Error {
            TreePath path;

            Result(TreePath path) {
                this.path = path;
            }
        }
        if (this.info == null || path == null || sourcePositions == null) {
            throw new IllegalArgumentException();
        }
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class PathFinder
            extends TreePathScanner<Void, Void> {
                private int pos;
                private SourcePositions sourcePositions;

                PathFinder(int pos, SourcePositions sourcePositions) {
                    this.pos = pos;
                    this.sourcePositions = sourcePositions;
                }

                @Override
                public Void scan(Tree tree, Void p) {
                    if (tree != null && this.sourcePositions.getStartPosition(this.getCurrentPath().getCompilationUnit(), tree) < (long)this.pos && this.sourcePositions.getEndPosition(this.getCurrentPath().getCompilationUnit(), tree) >= (long)this.pos) {
                        if (tree.getKind() == Tree.Kind.ERRONEOUS) {
                            tree.accept(this, p);
                            throw new Result(this.getCurrentPath());
                        }
                        super.scan(tree, p);
                        throw new Result(new TreePath(this.getCurrentPath(), tree));
                    }
                    return null;
                }
            }
            new PathFinder(pos, sourcePositions).scan(path, null);
        }
        catch (Result result) {
            path = result.path;
        }
        if (path.getLeaf() == path.getCompilationUnit()) {
            return path;
        }
        TokenSequence<JavaTokenId> tokenList = this.tokensFor(path.getLeaf(), sourcePositions);
        tokenList.moveEnd();
        if (tokenList.movePrevious() && tokenList.offset() < pos) {
            switch ((JavaTokenId)tokenList.token().id()) {
                case GTGTGT: 
                case GTGT: 
                case GT: {
                    if (path.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT || path.getLeaf().getKind() == Tree.Kind.CLASS || path.getLeaf().getKind() == Tree.Kind.GREATER_THAN) break;
                }
                case RPAREN: {
                    if (path.getLeaf().getKind() == Tree.Kind.ENHANCED_FOR_LOOP || path.getLeaf().getKind() == Tree.Kind.FOR_LOOP || path.getLeaf().getKind() == Tree.Kind.IF || path.getLeaf().getKind() == Tree.Kind.WHILE_LOOP || path.getLeaf().getKind() == Tree.Kind.DO_WHILE_LOOP || path.getLeaf().getKind() == Tree.Kind.TYPE_CAST) break;
                }
                case SEMICOLON: {
                    if (path.getLeaf().getKind() == Tree.Kind.FOR_LOOP && (long)tokenList.offset() <= sourcePositions.getStartPosition(path.getCompilationUnit(), ((ForLoopTree)path.getLeaf()).getUpdate().get(0))) break;
                }
                case RBRACE: {
                    path = path.getParentPath();
                    switch (path.getLeaf().getKind()) {
                        case CATCH: {
                            path = path.getParentPath();
                        }
                        case METHOD: 
                        case FOR_LOOP: 
                        case ENHANCED_FOR_LOOP: 
                        case IF: 
                        case SYNCHRONIZED: 
                        case WHILE_LOOP: 
                        case TRY: {
                            path = path.getParentPath();
                        }
                    }
                }
            }
        }
        return path;
    }

    public TypeMirror parseType(String expr, TypeElement scope) {
        return this.info.getJavacTask().parseType(expr, scope);
    }

    public StatementTree parseStatement(String stmt, SourcePositions[] sourcePositions) {
        return this.info.getJavacTask().parseStatement(stmt, sourcePositions);
    }

    public ExpressionTree parseExpression(String expr, SourcePositions[] sourcePositions) {
        return this.info.getJavacTask().parseExpression(expr, sourcePositions);
    }

    public ExpressionTree parseVariableInitializer(String init, SourcePositions[] sourcePositions) {
        return this.info.getJavacTask().parseVariableInitializer(init, sourcePositions);
    }

    public BlockTree parseStaticBlock(String block, SourcePositions[] sourcePositions) {
        return this.info.getJavacTask().parseStaticBlock(block, sourcePositions);
    }

    public Scope scopeFor(int pos) {
        List<? extends StatementTree> stmts = null;
        SourcePositions sourcePositions = this.info.getTrees().getSourcePositions();
        TreePath path = this.pathFor(pos);
        CompilationUnitTree root = path.getCompilationUnit();
        switch (path.getLeaf().getKind()) {
            case BLOCK: {
                stmts = ((BlockTree)path.getLeaf()).getStatements();
                break;
            }
            case FOR_LOOP: {
                stmts = ((ForLoopTree)path.getLeaf()).getInitializer();
                break;
            }
            case ENHANCED_FOR_LOOP: {
                stmts = Collections.singletonList(((EnhancedForLoopTree)path.getLeaf()).getStatement());
                break;
            }
            case METHOD: {
                stmts = ((MethodTree)path.getLeaf()).getParameters();
            }
        }
        if (stmts != null) {
            StatementTree tree = null;
            for (StatementTree statementTree : stmts) {
                if (sourcePositions.getStartPosition(root, statementTree) >= (long)pos) continue;
                tree = statementTree;
            }
            if (tree != null) {
                path = new TreePath(path, tree);
            }
        }
        return this.info.getTrees().getScope(path);
    }

    public TypeMirror attributeTree(Tree tree, Scope scope) {
        return this.info.getJavacTask().attributeTree((JCTree)tree, ((JavacScope)scope).getEnv());
    }

    public Scope attributeTreeTo(Tree tree, Scope scope, Tree to) {
        return this.info.getJavacTask().attributeTreeTo((JCTree)tree, ((JavacScope)scope).getEnv(), (JCTree)to);
    }

    public TokenSequence<JavaTokenId> tokensFor(Tree tree) {
        return this.tokensFor(tree, this.info.getTrees().getSourcePositions());
    }

    public TokenSequence<JavaTokenId> tokensFor(Tree tree, SourcePositions sourcePositions) {
        int start = (int)sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree);
        int end = (int)sourcePositions.getEndPosition(this.info.getCompilationUnit(), tree);
        return this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language()).subSequence(start, end);
    }

    public boolean isAccessible(Scope scope, Element member, TypeMirror type) {
        if (scope instanceof JavacScope && member instanceof Symbol && type instanceof Type) {
            Resolve resolve = Resolve.instance(this.info.getJavacTask().getContext());
            return resolve.isAccessible(((JavacScope)scope).getEnv(), (Type)type, (Symbol)member);
        }
        return false;
    }

    public boolean isStaticContext(Scope scope) {
        Resolve.instance(this.info.getJavacTask().getContext());
        return Resolve.isStatic(((JavacScope)scope).getEnv());
    }

    public Set<TypeMirror> getUncaughtExceptions(TreePath path) {
        HashSet<TypeMirror> set = new HashSet<TypeMirror>();
        new UncaughtExceptionsVisitor(this.info).scan(path, set);
        return set;
    }

    public StatementTree getBreakContinueTarget(CompilationInfo info, TreePath breakOrContinue) throws IllegalArgumentException {
        if (info.getPhase().compareTo(JavaSource.Phase.RESOLVED) < 0) {
            throw new IllegalArgumentException("Not in correct Phase. Required: Phase.RESOLVED, got: Phase." + info.getPhase().toString());
        }
        Tree leaf = breakOrContinue.getLeaf();
        switch (leaf.getKind()) {
            case BREAK: {
                return (StatementTree)((Object)((JCTree.JCBreak)leaf).target);
            }
            case CONTINUE: {
                StatementTree target = (StatementTree)((Object)((JCTree.JCContinue)leaf).target);
                if (target == null) {
                    return null;
                }
                if (((JCTree.JCContinue)leaf).label == null) {
                    return target;
                }
                TreePath tp = breakOrContinue;
                while (tp.getLeaf() != target) {
                    tp = tp.getParentPath();
                }
                Tree parent = tp.getParentPath().getLeaf();
                if (parent.getKind() == Tree.Kind.LABELED_STATEMENT) {
                    return (StatementTree)parent;
                }
                return target;
            }
        }
        throw new IllegalArgumentException("Unsupported kind: " + (Object)((Object)leaf.getKind()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UncaughtExceptionsVisitor
    extends TreePathScanner<Void, Set<TypeMirror>> {
        private CompilationInfo info;

        private UncaughtExceptionsVisitor(CompilationInfo info) {
            this.info = info;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Set<TypeMirror> p) {
            super.visitMethodInvocation(node, p);
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el != null && el.getKind() == ElementKind.METHOD) {
                p.addAll(((ExecutableElement)el).getThrownTypes());
            }
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree node, Set<TypeMirror> p) {
            super.visitNewClass(node, p);
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el != null && el.getKind() == ElementKind.CONSTRUCTOR) {
                p.addAll(((ExecutableElement)el).getThrownTypes());
            }
            return null;
        }

        @Override
        public Void visitThrow(ThrowTree node, Set<TypeMirror> p) {
            super.visitThrow(node, p);
            TypeMirror tm = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getExpression()));
            if (tm != null && tm.getKind() == TypeKind.DECLARED) {
                p.add(tm);
            }
            return null;
        }

        @Override
        public Void visitTry(TryTree node, Set<TypeMirror> p) {
            HashSet s = new HashSet();
            this.scan(node.getBlock(), s);
            for (CatchTree catchTree : node.getCatches()) {
                TypeMirror t = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), catchTree.getParameter().getType()));
                Iterator it = s.iterator();
                while (it.hasNext()) {
                    if (!this.info.getTypes().isSubtype((TypeMirror)it.next(), t)) continue;
                    it.remove();
                }
            }
            p.addAll(s);
            this.scan(node.getCatches(), p);
            this.scan(node.getFinallyBlock(), p);
            return null;
        }

        @Override
        public Void visitMethod(MethodTree node, Set<TypeMirror> p) {
            HashSet s = new HashSet();
            this.scan(node.getBody(), s);
            for (ExpressionTree expressionTree : node.getThrows()) {
                TypeMirror t = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), expressionTree));
                Iterator it = s.iterator();
                while (it.hasNext()) {
                    if (!this.info.getTypes().isSubtype((TypeMirror)it.next(), t)) continue;
                    it.remove();
                }
            }
            p.addAll(s);
            return null;
        }
    }
}

