/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeMirrorHandle<T extends TypeMirror> {
    private TypeKind kind;
    private ElementHandle<? extends Element> element;
    private List<TypeMirrorHandle<? extends TypeMirror>> typeMirrors;

    private TypeMirrorHandle(TypeKind kind, ElementHandle<? extends Element> element, List<TypeMirrorHandle<? extends TypeMirror>> typeArguments) {
        this.kind = kind;
        this.element = element;
        this.typeMirrors = typeArguments;
    }

    public static <T extends TypeMirror> TypeMirrorHandle<T> create(T tm) {
        TypeKind kind = tm.getKind();
        ElementHandle<Element> element = null;
        List<TypeMirrorHandle<? extends TypeMirror>> typeMirrors = null;
        switch (kind) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NONE: 
            case NULL: 
            case SHORT: 
            case VOID: {
                break;
            }
            case DECLARED: {
                TypeParameterElement typeParameterElement;
                TypeMirror targ;
                List<? extends TypeMirror> targs;
                DeclaredType dt = (DeclaredType)tm;
                TypeElement te = (TypeElement)dt.asElement();
                element = ElementHandle.create(te);
                if (te.getTypeParameters().isEmpty() || !(targs = dt.getTypeArguments()).isEmpty() && (targ = targs.get(0)).getKind() == TypeKind.TYPEVAR && (typeParameterElement = (TypeParameterElement)((TypeVariable)targ).asElement()).getGenericElement() == dt.asElement()) break;
                typeMirrors = new ArrayList<TypeMirrorHandle<? extends TypeMirror>>(targs.size());
                for (TypeMirror typeMirror : targs) {
                    typeMirrors.add(TypeMirrorHandle.create(typeMirror));
                }
                break;
            }
            case ARRAY: {
                typeMirrors = Collections.singletonList(TypeMirrorHandle.create(((ArrayType)tm).getComponentType()));
                break;
            }
            case TYPEVAR: {
                TypeVariable tv = (TypeVariable)tm;
                element = ElementHandle.create(tv.asElement());
                typeMirrors = new ArrayList<TypeMirrorHandle<? extends TypeMirror>>();
                typeMirrors.add(tv.getLowerBound() != null ? TypeMirrorHandle.create(tv.getLowerBound()) : null);
                typeMirrors.add(tv.getUpperBound() != null ? TypeMirrorHandle.create(tv.getUpperBound()) : null);
                break;
            }
            case WILDCARD: {
                WildcardType wildcardType = (WildcardType)tm;
                typeMirrors = new ArrayList<TypeMirrorHandle<? extends TypeMirror>>();
                typeMirrors.add(wildcardType.getExtendsBound() != null ? TypeMirrorHandle.create(wildcardType.getExtendsBound()) : null);
                typeMirrors.add(wildcardType.getSuperBound() != null ? TypeMirrorHandle.create(wildcardType.getSuperBound()) : null);
                break;
            }
            case ERROR: {
                ErrorType et = (ErrorType)tm;
                element = ElementHandle.create(et.asElement());
                break;
            }
            default: {
                throw new IllegalArgumentException("Currently unsupported TypeKind: " + (Object)((Object)tm.getKind()));
            }
        }
        return new TypeMirrorHandle<T>(kind, element, typeMirrors);
    }

    public T resolve(CompilationInfo info) {
        switch (this.kind) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return (T)info.getTypes().getPrimitiveType(this.kind);
            }
            case NONE: 
            case VOID: {
                return (T)info.getTypes().getNoType(this.kind);
            }
            case NULL: {
                return (T)info.getTypes().getNullType();
            }
            case DECLARED: {
                TypeElement te = (TypeElement)this.element.resolve(info);
                if (te == null) {
                    return null;
                }
                if (this.typeMirrors == null) {
                    return (T)te.asType();
                }
                ArrayList<TypeMirror> resolvedTypeArguments = new ArrayList<TypeMirror>();
                for (TypeMirrorHandle<? extends TypeMirror> t : this.typeMirrors) {
                    TypeMirror resolved = t.resolve(info);
                    if (resolved == null) {
                        return null;
                    }
                    resolvedTypeArguments.add(resolved);
                }
                return (T)info.getTypes().getDeclaredType(te, resolvedTypeArguments.toArray(new TypeMirror[resolvedTypeArguments.size()]));
            }
            case ARRAY: {
                TypeMirror resolved = this.typeMirrors.get(0).resolve(info);
                if (resolved == null) {
                    return null;
                }
                return (T)info.getTypes().getArrayType(resolved);
            }
            case TYPEVAR: {
                Element e = this.element.resolve(info);
                if (!(e instanceof Symbol.TypeSymbol)) {
                    return null;
                }
                TypeMirrorHandle<? extends TypeMirror> lBound = this.typeMirrors.get(0);
                TypeMirror lowerBound = lBound != null ? lBound.resolve(info) : null;
                TypeMirrorHandle<? extends TypeMirror> uBound = this.typeMirrors.get(1);
                TypeMirror upperBound = uBound != null ? uBound.resolve(info) : null;
                return (T)new Type.TypeVar((Symbol.TypeSymbol)e, (Type)lowerBound, (Type)upperBound);
            }
            case WILDCARD: {
                TypeMirrorHandle<? extends TypeMirror> eBound = this.typeMirrors.get(0);
                TypeMirror extendsBound = eBound != null ? eBound.resolve(info) : null;
                TypeMirrorHandle<? extends TypeMirror> sBound = this.typeMirrors.get(1);
                TypeMirror superBound = sBound != null ? sBound.resolve(info) : null;
                return (T)info.getTypes().getWildcardType(extendsBound, superBound);
            }
            case ERROR: {
                Element e = this.element.resolve(info);
                if (!(e instanceof Symbol.ClassSymbol)) {
                    return null;
                }
                return (T)new Type.ErrorType((Symbol.ClassSymbol)e);
            }
        }
        throw new IllegalStateException("Internal error: unknown TypeHandle kind: " + (Object)((Object)this.kind));
    }

    public TypeKind getKind() {
        return this.kind;
    }
}

