/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import org.netbeans.api.java.loaders.JavaDataSupport;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.windows.CloneableOpenSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaDataObject
extends MultiDataObject {
    private JavaEditorSupport jes;

    public JavaDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.getCookieSet().assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject folder, String fileName) throws IOException {
                JavaDataObject.this.createJavaEditorSupport().saveAs(folder, fileName);
            }
        }});
    }

    public Node createNodeDelegate() {
        return JavaDataSupport.createJavaNode(this.getPrimaryFile());
    }

    public <T extends Node.Cookie> T getCookie(Class<T> type) {
        if (type.isAssignableFrom(JavaEditorSupport.class)) {
            return (T)((Node.Cookie)type.cast((Object)this.createJavaEditorSupport()));
        }
        return (T)super.getCookie(type);
    }

    protected DataObject handleCopyRename(DataFolder df, String name, String ext) throws IOException {
        FileObject fo = this.getPrimaryEntry().copyRename(df.getPrimaryFile(), name, ext);
        DataObject dob = DataObject.find((FileObject)fo);
        return dob;
    }

    private synchronized JavaEditorSupport createJavaEditorSupport() {
        if (this.jes == null) {
            this.jes = new JavaEditorSupport(this);
        }
        return this.jes;
    }

    static void renameFO(FileObject fileToUpdate, final String packageName, final String newName, final String originalName) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject(fileToUpdate);
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            @Override
            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TreeMaker make = workingCopy.getTreeMaker();
                CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                CompilationUnitTree cutCopy = make.CompilationUnit("".equals(packageName) ? null : make.Identifier(packageName), compilationUnitTree.getImports(), compilationUnitTree.getTypeDecls(), compilationUnitTree.getSourceFile());
                workingCopy.rewrite(compilationUnitTree, cutCopy);
                if (originalName != null && !originalName.equals(newName)) {
                    for (Tree tree : compilationUnitTree.getTypeDecls()) {
                        ClassTree clazz;
                        if (Tree.Kind.CLASS != tree.getKind() || !originalName.contentEquals((clazz = (ClassTree)tree).getSimpleName())) continue;
                        Tree copy = make.setLabel(tree, newName);
                        workingCopy.rewrite(tree, copy);
                    }
                }
            }

            @Override
            public void cancel() {
            }
        };
        javaSource.runModificationTask(task).commit();
    }

    private static final class JavaEditor
    extends CloneableEditor {
        private static final long serialVersionUID = -1L;

        public JavaEditor() {
        }

        public JavaEditor(JavaEditorSupport sup) {
            super((CloneableEditorSupport)sup);
        }
    }

    public static final class JavaEditorSupport
    extends DataEditorSupport
    implements OpenCookie,
    EditCookie,
    EditorCookie,
    PrintCookie,
    EditorCookie.Observable {
        public JavaEditorSupport(JavaDataObject dataObject) {
            super((DataObject)dataObject, (CloneableEditorSupport.Env)new Environment(dataObject));
            this.setMIMEType("text/x-java");
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            ((Environment)this.env).addSaveCookie();
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            ((Environment)this.env).removeSaveCookie();
        }

        protected CloneableEditor createCloneableEditor() {
            return new JavaEditor(this);
        }

        public boolean close(boolean ask) {
            return super.close(ask);
        }

        private static final class Environment
        extends DataEditorSupport.Env {
            private static final long serialVersionUID = -1L;
            private transient SaveSupport saveCookie = null;

            public Environment(JavaDataObject obj) {
                super((DataObject)obj);
            }

            protected FileObject getFile() {
                return this.getDataObject().getPrimaryFile();
            }

            protected FileLock takeLock() throws IOException {
                return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
            }

            public CloneableOpenSupport findCloneableOpenSupport() {
                return (CloneableEditorSupport)((JavaDataObject)this.getDataObject()).getCookie(EditorCookie.class);
            }

            public void addSaveCookie() {
                JavaDataObject javaData = (JavaDataObject)this.getDataObject();
                if (javaData.getCookie(SaveCookie.class) == null) {
                    if (this.saveCookie == null) {
                        this.saveCookie = new SaveSupport();
                    }
                    javaData.getCookieSet().add((Node.Cookie)this.saveCookie);
                    javaData.setModified(true);
                }
            }

            public void removeSaveCookie() {
                JavaDataObject javaData = (JavaDataObject)this.getDataObject();
                if (javaData.getCookie(SaveCookie.class) != null) {
                    javaData.getCookieSet().remove((Node.Cookie)this.saveCookie);
                    javaData.setModified(false);
                }
            }

            private final class SaveSupport
            implements SaveCookie {
                private SaveSupport() {
                }

                public void save() throws IOException {
                    ((JavaEditorSupport)Environment.this.findCloneableOpenSupport()).saveDocument();
                    Environment.this.getDataObject().setModified(false);
                }
            }
        }
    }
}

