/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.java.JavaDataObject;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.IndentEngine;
import org.openide.util.NbBundle;

public final class Util {
    static final String MAGIC_PREFIX = "//GEN-";
    private static ErrorManager errorManager;
    static final String ATTR_FILE_ENCODING = "Content-Encoding";

    static String getString(String key) {
        return NbBundle.getMessage(Util.class, (String)key);
    }

    static ErrorManager getErrorManager() {
        if (errorManager != null) {
            return errorManager;
        }
        ErrorManager main = ErrorManager.getDefault();
        if (main == null) {
            System.err.println("WARNING: can't lookup error manager");
            return null;
        }
        errorManager = main;
        return errorManager;
    }

    static void annotateThrowable(Throwable t, Throwable nested) {
        Util.getErrorManager().annotate(t, nested);
    }

    static void annotateThrowable(Throwable t, String localizedMessage, boolean user) {
        if (user) {
            Util.getErrorManager().annotate(t, 256, null, localizedMessage, null, null);
        } else {
            Util.getErrorManager().annotate(t, 4096, null, localizedMessage, null, null);
        }
    }

    static FileObject findBrother(FileObject f, String extension) {
        return FileUtil.findBrother((FileObject)f, (String)extension);
    }

    private static FileObject findSibling(FileObject base, String name, Enumeration extlist) {
        while (extlist.hasMoreElements()) {
            FileObject ret;
            String ext = (String)extlist.nextElement();
            if (ext == null || (ret = base.getFileObject(name, ext)) == null) continue;
            return ret;
        }
        return null;
    }

    private static void notifyException(Throwable t, String msg) {
        Util.getErrorManager().notify(t);
    }

    static Writer findIndentWriter(Document doc, int offset, Writer writer) {
        IndentEngine engine = IndentEngine.find((Document)doc);
        return engine.createWriter(doc, offset, writer);
    }

    public static char[] readContents(Reader r) throws IOException {
        char[] buffer;
        int read = 0;
        int total = 0;
        LinkedList<char[]> buflist = new LinkedList<char[]>();
        do {
            int offset;
            buffer = new char[2048];
            for (offset = 0; offset < buffer.length && (read = r.read(buffer, offset, buffer.length - offset)) != -1; offset += read) {
            }
            if (offset > 0) {
                buflist.add(buffer);
            }
            total += offset;
        } while (read >= 0);
        r.close();
        buffer = new char[total];
        Iterator it = buflist.iterator();
        int offset2 = 0;
        while (it.hasNext()) {
            char[] buf = (char[])it.next();
            int size = it.hasNext() ? buf.length : total - offset2;
            System.arraycopy(buf, 0, buffer, offset2, size);
            offset2 += size;
        }
        return buffer;
    }

    private static String getDocumentText(FileObject fo, boolean save) throws IOException {
        StyledDocument doc;
        DataObject obj = DataObject.find((FileObject)fo);
        EditorCookie editor = null;
        if (obj instanceof JavaDataObject) {
            editor = ((JavaDataObject)obj).getCookie(EditorCookie.class);
        }
        if (editor != null && (doc = editor.getDocument()) != null) {
            SaveCookie cookie;
            final String[] str = new String[1];
            Runnable run = new Runnable(){

                public void run() {
                    try {
                        str[0] = doc.getText(0, doc.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            };
            if (save && (cookie = (SaveCookie)obj.getCookie(SaveCookie.class)) != null) {
                cookie.save();
            }
            doc.render(run);
            return str[0];
        }
        return null;
    }

    static class ParserInputStream
    extends InputStream {
        private InputStream stream;
        private String text;
        private StringBuffer buffer;
        private boolean mode;
        private int counter;
        private int[] lines = new int[200];
        int lineCounter = 2;
        int currentLineLength = 0;

        ParserInputStream(String text) {
            this(text, null);
        }

        ParserInputStream(String text, String encoding) {
            this.text = text;
            this.counter = 0;
            this.mode = false;
            ByteArrayOutputStream outstm = new ByteArrayOutputStream(text.length());
            Writer wr = null;
            if (encoding != null) {
                try {
                    wr = new OutputStreamWriter((OutputStream)outstm, encoding);
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
            }
            if (wr == null) {
                wr = new OutputStreamWriter(outstm);
            }
            try {
                wr.write(text);
                wr.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.stream = new ByteArrayInputStream(outstm.toByteArray());
        }

        ParserInputStream(InputStream stream) {
            this.stream = stream;
            this.buffer = new StringBuffer();
            this.mode = true;
        }

        public String getString(int begin, int end) {
            return this.mode ? this.buffer.substring(begin, end) : this.text.substring(begin, end);
        }

        public String getString(int begin) {
            if (this.mode) {
                return this.buffer.substring(begin);
            }
            int end = Math.min(this.counter - 1, this.text.length());
            return this.text.substring(begin, end);
        }

        public int read() throws IOException {
            int x = this.stream.read();
            if (this.mode && x != -1) {
                this.buffer.append((char)x);
                ++this.counter;
            }
            if (x == 10) {
                if (this.lineCounter == this.lines.length - 1) {
                    int[] newLines = new int[this.lineCounter + this.lineCounter];
                    System.arraycopy(this.lines, 0, newLines, 0, this.lines.length);
                    this.lines = newLines;
                }
                this.lines[this.lineCounter] = this.lines[this.lineCounter - 1] + this.currentLineLength + 1;
                ++this.lineCounter;
                this.currentLineLength = 0;
            } else {
                ++this.currentLineLength;
            }
            return x;
        }

        public void close() throws IOException {
            this.stream.close();
        }

        int getOffset(int line, int column) {
            return this.lines[line] + column - 1;
        }
    }
}

